import HTMLgen 
import HTMLcolors 
import Database
import Dates
# $Id: LMS.py,v 1.3 1996/12/09 04:01:23 hiren Exp hiren $
# vim:ts=2:sw=2

class BookRep(Database.RTable):
	def __init__(self):
			dsn='lms2/admin/'
			self.rows = []
			Database.RTable.__init__(self,dsn)
	def books_checked_out(self):
			sqlstmt = 'select b.bookid,b.title,a.checkOutDate,a.dueDate \
						   from checkout a,book b   \
						   where a.bookId = b.bookId \
						   order by a.dueDate'
			while 1:
				rec = self.cur.fetchone()
				if not rec: break
				book = Book(rec,self.cur.description)
				self.rows.append(book.data)
	def __len__(self):
		return len(self.rows)
	def __setitem__(self,index,val):
		self.rows[index] = val
	def __getitem__(self,index):
		if index > len(self.rows):
			raise IndexError, "index too large"
		return self.rows[index]
	def checkin(self,bookids,dates):
		sqlfmt = 'update checkout\
						  set returnDate = \'%s\'\
							where bookid = %s\
							and returnDate is NULL'
		rclist = []
		for index in range(len(bookids)):
				sqlstmt = sqlfmt % ( dates[index],bookids[index])
				rc = self.cur.execute(sqlstmt)
				rc = self.conn.commit()
				rclist.append(rc)
		self.cur.close() 
		self.conn.close()
		self.cur = None
		self.conn = None
		return rclist
	def checkout(self,bookids,empids,dates):
		sqlfmt = "insert into checkout (bookid,empid,reserved,checkOutDate)\
								values (%s,%s,'0','%s')"
		rclist = []
		for index in range(len(bookids)):
				sqlstmt = sqlfmt % ( bookids[index],empids[index],dates[index])
				print sqlstmt
				rc = self.cur.execute(sqlstmt)
				rc = self.conn.commit()
				rclist.append(rc)
		self.cur.close() 
		self.conn.close()
		self.cur = None
		self.conn = None
		return rclist
	def find(self,titlepattern='UNIX',author='oreilly'):
			self.rows = []
			sqlstr = "\
	select a.bookid,a.title,b.checkOutDate,b.dueDate,b.returnDate \n\
	FROM { oj book a left outer join checkout b\n\
	       on a.bookid = b.bookid\n}\
        where a.title like '%s' \
	and (  ( b.checkOutDate >= ( select max(c.checkOutDate)  \
	           		     from checkout c \
		                     where c.bookid = b.bookid) ) \
	          or \
	       ( b.checkOutDate is NULL) \
            ) "
			titlestr =  '%' + titlepattern + '%'
			sqlstmt = sqlstr % titlestr
			self.cur.execute(sqlstmt)
			self.rows = []
			while 1:
				rec = self.cur.fetchone()
				if not rec: break
				book = Book(rec,self.cur.description)
				url='/scripts/lms/reserve.py?bookid=' + str(book.bookid)
				bookURL = HTMLgen.Href(url=url,text='Reserve')
				book.data[0] = bookURL
				self.rows.append(book.data)
	def findBook(self,bookid):
			sqlfmt = "select title from book where bookid = %s"
			sqlstmt = sqlfmt % bookid
			#print sqlstmt
			self.cur.execute(sqlstmt)
			self.rows = []
			while 1:
				rec = self.cur.fetchone()
				if not rec: break
				book = Book(rec,self.cur.description)
			return book
	def reserve(self,bookid,empid):
			sqlfmt = "insert into checkout (bookid,empid,reserved,checkOutDate)\
								values (%s,%s,'1',\'%s/%s/%s\')"
			today = Dates.today()
			sqlstmt = sqlfmt % (bookid,empid,today.month,today.day,today.year)
			print sqlstmt
			rc = self.cur.execute(sqlstmt)
			if rc != 1:
				print "Sql Error in insert", sqlstmt
			self.cur.close()
			self.cur = None
			return 1
	def status(self,book):
		pass
	
class Book(Database.RRec):
	def __init__(self,rec,description):
		Database.RRec.__init__(self,rec,description)
		self.data = self.record
	def checkin(self):
		pass
	def checkout(self):
		pass
	def reserve(self):
		pass
		
if __name__ == '__main__':
	s = BookRep()
	b = s.findBook('123')
	print b.data
#	s.find(titlepattern='perl')
#	for rec in s:
#		b = Book(rec,s.cur.description)
#		for field in b:
#			print field,
#		print
