# $Id: Database.py,v 1.1 1996/10/28 03:33:27 hiren Exp hiren $
# $Author: hiren $
# vim:ts=2:sw=2

import dbi
import odbc
import time
class RTable:
	def __init__(self,dsn):
		try:
			self.conn = odbc.odbc(dsn)
			self.cur = self.conn.cursor()
		except NameError,e:
			print 'error ', e, 'undefined'
	def execute(sql):
		self.sql = sql
		try:
			self.cur.execute(self.sql)
		except NameError,e:
			print 'error ', e, 'undefined'
	def __len__(self):
		pass
	def __setitem__(self,key,val):
		pass
	def __getitem__(self,index):
		rec = self.cur.fetchone()
		if not rec:
			raise IndexError, "index too large"
		return rec
class RRec:
	def __init__(self,rec,description):
		self.record = []
		if not rec: return 
		i = 0
		for field in rec:
			if description[i][1] == 'DATE':
				#print description[i][1],field,field.value
				if field != None and field != 'N/A':
					local = time.localtime(field.value)
					s = str(local[1]) + '/' \
						+ str(local[2]) + '/' +str(local[0])
					setattr(self,description[i][0],s)
					self.record.append(s)
				else:
					self.record.append('N/A')
			elif description[i][1] == 'RAW':
					dummy = 'RAW Not Implemented'
					setattr(self,description[i][0],dummy)
					self.record.append( dummy)
			else:
					setattr(self,description[i][0],field)
					self.record.append(field)
			i = i+1
		self.data = self.record
	def dump(self):
		for i in self:
			print i,
		print
	def __len__(self):
		return len(self.record)
	def __setitem__(self,key,val):
		self.record[key] = val
	def __getitem__(self,index):
		return self.record[index]


if __name__ == '__main__':
	print 'script as main'
	#sqlstmt = 'select * from shippers'
	#sqlstmt = 'select * from orders'
	#sqlstmt = 'select * from categories'
#	sqlstmt = '\
#	SELECT Employees.EmployeeID, Employees.LastName,\
#	Employees.FirstName, Employees.Title, Employees.TitleOfCourtesy,\
#	Employees.BirthDate, Employees.HireDate, Employees.Address,\
#	Employees.City, Employees.Region, Employees.PostalCode,\
#	Employees.Country,\
#	Employees.HomePhone, Employees.Extension, Employees.Notes,\
#	Employees.ReportsTo\
#	FROM Employees'
	sqlstmt = '\
	SELECT EmployeeID, LastName,\
	FirstName, Title, TitleOfCourtesy,\
	City, Region, PostalCode,\
	Country,\
	HireDate, Address,\
	HomePhone, Extension, Notes,\
	ReportsTo\
	FROM Employees'

	dsn='nwin/admin/'
	s = RTable(dsn,sqlstmt)
	#print s.cur.description
	for rec in s:
		b = RRec(rec,s.cur.description)
		for field in b:
			print field,
		print
