# $Id: informixdb.py,v 1.3 1997/03/11 14:40:24 bertil Exp $
# informixdb.py
#
# This is a trivial python wrapper around the C core _informixdb.so
#
# According to the DBAPI spec, a connection object is expected to supply
# the same set of functions as do a cursor object. This is fixed here by
# an implicit cursor.
#
# NYD = Not Yet Defined by DBAPI
# NYI = Not Yet Implemented
#
try:
    import _informixdb
except ImportError:
    raise ImportError, "Cannot locate C core module for informix db interface."

class informixdb:
    def __init__(self, logon):
	self.conn = _informixdb.informixdb(logon)
	self._cursor = self.conn.cursor()

    def __getattr__(self, attr):
	if attr == 'description':
	    return self._cursor.description
	elif attr == 'arraysize':
	    return self._cursor.arraysize
	elif attr == 'error':
	    return _informixdb.error
	else:
	    raise AttributeError, attr

    def commit(self):
	self.conn.commit()

    def rollback(self):
	self.conn.rollback()

    def cursor(self):
	return self.conn.cursor()

    def callproc(self, params = None):
	pass # NYD

    def execute(self, *args):
	apply(self._cursor.execute, args)

    def fetchone(self):
	return self._cursor.fetchone()

    def fetchmany(self, size = None):
	return self._cursor.fetchmany(size)

    def fetchall(self):
	return self._cursor.fetchall()

    def close(self):
	self._cursor.close()
	self.conn.close()
	self._cursor = None
	self.conn = None

    def setinputsizes(self, sizes):
	pass # NYD

    def setoutputsizes(self, sizes, col = None):
	pass # NYD
