/***********************************************************
Copyright 1991, 1992, 1993, 1994 by Stichting Mathematisch Centrum,
Amsterdam, The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

/* Dbhash module using dictionary interface */


#include "allobjects.h"
#include "modsupport.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <db.h>
#include <hash.h>
#include <page.h>
#include <extern.h>

extern long hash_accesses, hash_collisions, hash_expansions, hash_overflows;
typedef struct {
	OB_HEAD
	int di_size;	/* -1 means recompute */
	DB *di_dbhash;
} dbhashobject;

staticforward typeobject Dbhashtype;

#define is_dbhashobject(v) ((v)->ob_type == &Dbhashtype)

static object *DbhashError;

static object *
newdbhashobject(file, flags, mode,csize, bsize,ffactor,nelem,hashf)
    char *file;
    int flags;
    int mode;
    int csize, bsize,ffactor,nelem,hashf;
{
        dbhashobject *dp;

	HASHINFO info;

	info.bsize = bsize;
	info.ffactor = ffactor;
	info.nelem = nelem;
	info.cachesize = csize;
	switch (hashf){
	case 1: info.hash = __option_hash1;
	case 2: info.hash = __option_hash2;
	case 3: info.hash =  __option_hash3;
	default:info.hash = __default_hash;
	}
/*
hash_func.c:static int hash2 __P((u_char *, int));
hash_func.c:hash2(key, len)

hash_func.c:static int hash4 __P((u_char *, int));
hash_func.c:int (*__default_hash) __P((u_char *, int)) = hash4;
hash_func.c:hash4(key, len)

*/

	info.lorder = 0;
	dp = NEWOBJ(dbhashobject, &Dbhashtype);
	if (dp == NULL)
		return NULL;
	dp->di_size = -1;
	if ( (dp->di_dbhash = dbopen(file, flags, mode,DB_HASH,&info)) == 0 ) {
	    err_errno(DbhashError);
	    DECREF(dp);
	    return 0;
	}
/*	printf("csize: %i bsize: %i ffactor: %i nelem %i\n",csize, bsize,ffactor,nelem); */
	return (object *)dp;
}

static object *
dbhash_close(dp)
        dbhashobject *dp;
{
     int myerror;
        if (!(myerror = (dp->di_dbhash->close)(dp->di_dbhash))) {
                err_errno(DbhashError); /* XXX - ??? */
                return NULL;
        }
        dp->di_dbhash = NULL;
/*        printf("dbhash_close %i\n",myerror);*/
/*        printf("%li7 %li7 %li7 %li7 \n",hash_accesses, hash_collisions, hash_expansions, hash_overflows);*/
        INCREF(None);
        return None;
}


static void
dbhash_dealloc(dp)
	register dbhashobject *dp;
{
   int myerror;
/*        printf(" %7li  %7li  %7li  %7li \n",hash_accesses, hash_collisions, hash_expansions, hash_overflows);*/
        if ( dp->di_dbhash )
	  myerror = (dp->di_dbhash->close)(dp->di_dbhash);
/*        printf("dbhash_dealloc %i\n",myerror);*/
	DEL(dp);
}

static int
dbhash_length(dp)
	dbhashobject *dp;
{
  DBT data,key;
  int status;
  if ( dp->di_size < 0 ) {
    int size;
    size = 0;
    for ( status = (dp->di_dbhash->seq)(dp->di_dbhash,&key,&data,R_FIRST);
	 status == RET_SUCCESS;
	 status = (dp->di_dbhash->seq)(dp->di_dbhash,&key,&data,R_NEXT))
      size++;
    dp->di_size = size;
  }
  return dp->di_size;
}

static object *
dbhash_subscript(dp, key)
	dbhashobject *dp;
	register object *key;
{
  int status;
  object *v;
  DBT drec, krec;
  HTAB *hp;
	if (!getargs(key, "s#", &krec.data, &krec.size) )
		return NULL;

	status = (dp->di_dbhash->get)(dp->di_dbhash, &krec, &drec, 0);
	if ( status != RET_SUCCESS ) {
	    err_setstr(KeyError, GETSTRINGVALUE((stringobject *)key));
	    return 0;
	}
	hp = (HTAB *)dp->di_dbhash->internal;
	if ( hp->errno ) {
	    hp->errno =0;
	    err_setstr(DbhashError, "");
	    return 0;
	  }
  return newsizedstringobject(drec.data, drec.size);
}

static int
dbhash_ass_sub(dp, v, w)
	dbhashobject *dp;
	object *v, *w;
{
        DBT krec, drec;
	HTAB *hp;

        if ( !getargs(v, "s#", &krec.data, &krec.size) ) {
	    err_setstr(TypeError, "dbhash mappings have string indies only");
	    return -1;
	}
	dp->di_size = -1;
	if (w == NULL) {
	  
	    if ( (dp->di_dbhash->del)(dp->di_dbhash,&krec,0) ) {
		err_setstr(KeyError, GETSTRINGVALUE((stringobject *)v));
		return -1;
	    }
	} else {
	    if ( !getargs(w, "s#", &drec.data, &drec.size) ) {
		err_setstr(TypeError,
			   "dbhash mappings have string elements only");
		return -1;
	    }
	    if ((dp->di_dbhash->put)(dp->di_dbhash,&krec,&drec,0)){
		err_setstr(DbhashError, "Cannot add item to database");
		return -1;
	    }
	}
	hp = (HTAB *)dp->di_dbhash->internal;
	if ( hp->errno ) {
	    hp->errno =0;
	    err_setstr(DbhashError, "");
	    return -1;
	}
	return 0;
}

static mapping_methods dbhash_as_mapping = {
	(inquiry)dbhash_length,		/*mp_length*/
	(binaryfunc)dbhash_subscript,	/*mp_subscript*/
	(objobjargproc)dbhash_ass_sub,	/*mp_ass_subscript*/
};

static object *
dbhash_keys(dp, args)
	register dbhashobject *dp;
	object *args;
{
	register object *v, *item;
	DBT key,data;
	int status;

	if (dp == NULL || !is_dbhashobject(dp)) {
		err_badcall();
		return NULL;
	}
	if (!getnoarg(args))
		return NULL;
	v = newlistobject(0);
	if (v == NULL)
		return NULL;
	for ( status = (dp->di_dbhash->seq)(dp->di_dbhash,&key,&data,R_FIRST);
	     status == RET_SUCCESS;
	     status = (dp->di_dbhash->seq)(dp->di_dbhash,&key,&data,R_NEXT)){
	  item = newsizedstringobject(key.data, key.size);
	if ( item == 0 )
	  return NULL;
	addlistitem(v, item);
	}
	return v;
      }

static object *
dbhash_has_key(dp, args)
	register dbhashobject *dp;
	object *args;
{
	DBT krec, drec;
	int status;
	
	if (!getargs(args, "s#", &krec.data, &krec.size))
		return NULL;
	status = (dp->di_dbhash->get)(dp->di_dbhash, &krec, &drec, 0);
	return newintobject( status == RET_SUCCESS );
}

static struct methodlist dbhash_methods[] = {
	{"keys",	(method)dbhash_keys},
	{"has_key",	(method)dbhash_has_key},
	{NULL,		NULL}		/* sentinel */
};

static object *
dbhash_getattr(dp, name)
	dbhashobject *dp;
	char *name;
{
	return findmethod(dbhash_methods, (object *)dp, name);
}

static typeobject Dbhashtype = {
	OB_HEAD_INIT(&Typetype)
	0,
	"Dbhash_dictionary",
	sizeof(dbhashobject),
	0,
	(destructor)dbhash_dealloc, /*tp_dealloc*/
	0,			/*tp_print*/
	(getattrfunc)dbhash_getattr, /*tp_getattr*/
	0,			/*tp_setattr*/
	0,			/*tp_compare*/
	0,			/*tp_repr*/
	0,			/*tp_as_number*/
	0,			/*tp_as_sequence*/
	&dbhash_as_mapping,	/*tp_as_mapping*/
};

/* ----------------------------------------------------------------- */

static object *
dbhashopen(self, args)
    object *self;
    object *args;
{
    char *name, *flags;
    int iflags, mode,csize,bsize,ffactor,nelem,hashf;

        if ( !getargs(args, "(ssiiiiii)", &name, &flags, &mode, &csize, &bsize,&ffactor,&nelem,&hashf) )
	  return 0;
	if ( strcmp(flags, "r") == 0 )
	  iflags = O_RDONLY;
	else if ( strcmp(flags, "w") == 0 )
	  iflags = O_WRONLY|O_CREAT;
	else if ( strcmp(flags, "rw") == 0 )
	  iflags = O_RDWR|O_CREAT;
	else {
	    err_setstr(DbhashError,
		       "Flags should be one of 'r', 'w' or 'rw'");
	    return 0;
	}
        return newdbhashobject(name, iflags, mode,csize,bsize,ffactor,nelem,hashf);
}

static struct methodlist dbhashmodule_methods[] = {
    { "open", (method)dbhashopen },
    { "close", (method)dbhash_close },
    { 0, 0 },
};

void
initdbhash() {
    object *m, *d;

    m = initmodule("dbhash", dbhashmodule_methods);
    d = getmoduledict(m);
    DbhashError = newstringobject("dbhash.error");
    if ( DbhashError == NULL || dictinsert(d, "error", DbhashError) )
      fatal("can't define dbhash.error");
}

	

















