#
# Copyright (C) by Michael Lausch, G.A.M.S. edv Dienstleistungen GmbH
# 
# $Id$
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the Free
# Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.




import soliddb
import sys
import string

db = soliddb.soliddb('TCP/IP localhost 1313', 'test', 'testpwd');
cursor = db.cursor();
try:
	cursor.execute('drop table longtest')
except soliddb.error,e:
	print 'Soliderror', e, 'caught';

db.commit();
cursor.execute('create table longtest (k integer, vbin varbinary(200), vbinlarge long varbinary, vcharlarge long varchar)');

db.commit();

try:
	cursor.execute('drop table parmtest')
except soliddb.error,e:
	print 'Soliderror', e, 'caught';

db.commit();

#print 'Before executing';
#sys.stdin.readline();

cursor.execute('create table parmtest (i integer, s char(80), vs varchar(200), f float)');
db.commit();

tuple = [(1, 'aaaaa', 'bbbbb', 3.4),
	 (2, 'cccccccccc', 'ddddddddddd', 3),
	 (3, 'eeeeeeeeeee', 'ffffffffffff', '4.56'),
	 (4, 'ggggggg', 'hhhhhhh', 5L)]


cursor.execute('insert into parmtest values (?, ?, ?, ?)', tuple);

db.commit();

cursor.execute('select * from parmtest');

x = cursor.fetchmany(20);
print x;


vbin='';
vchar='';
for idx in range(0, 2048):
	c = chr(idx % 256);
	if c == "'":
		c = '@';
	vbin = vbin + c;
	c = idx % 96;
	c = c + 32;
	if (chr(c) == "'"):
		c = ord('@');
	vchar = vchar + chr(c);
		

for i in range (1,100):
	tuple = (i, vbin[0:200], vbin, vchar);
	cursor.execute("insert into longtest values ( ?, ?, ?, ?)", tuple);
	print 'Inserted ', `i`, 'record';

db.commit();

cursor.close();
cursor.execute('select k, vbin, vbinlarge, vcharlarge from longtest');
print `cursor.description`;

while 1:
	x = cursor.fetchone();
	if not x:
		break;
	rvbinshort = x[1];
	rvbinlong  = x[2];
	rvchar     = x[3];

	if rvbinshort != vbin[0:200]:
		print 'Error: varbinary(200) differs';
		print 'Original  = ',`vbin[0:200]`;
		print 'Retrieved = ',`rvbinshort`;
		sys.exit(0);
	if rvbinlong != vbin:
		print 'Error: varbinary differs';
		print 'Original  = ',`vbin`;
		print 'Retrieved = ',`rvbinlong`;
		sys.exit(0);
	if rvchar != vchar:
		print 'Error: varchar differs';
		print 'Original = ', `vchar`;
		print 'Retrieved = ',`vchar`;
		sys.exit(0);
	
