#
# Copyright (c) 1991, 1992, 1993, 1994 Xerox Corporation.  All Rights Reserved.
#
# Unlimited use, reproduction, and distribution of this software is
# permitted.  Any copy of this software must include both the above
# copyright notice of Xerox Corporation and this paragraph.  Any
# distribution of this software must comply with all applicable United
# States export control laws.  This software is made available AS IS,
# and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
# INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
# PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
# THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
# CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
# XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
#
# $Id: iluRt.py,v 1.6 1995/04/21 04:00:20 janssen Exp $
#

from iluPr import *

class IluObject:

    def IluSBH(self):
	return SBHOfObject(self)

    def IluObjectID(self):
	sbh = self.IluSBH()
	oid, serverHandle = ParseSBH(sbh)
	return oid

    def IluTypeName(self):
	return self._IluClass.name()

    def IluTypeID(self):
	return self._IluClass.id()

    def IluPublish(self):
	PublishObject(self)

    def IluWithdraw(self):
	WithdrawObject(self)

class IluObjSurr(IluObject):

    def IluTrueP(self):
        return 0

    def IluPing(self):
        return PingObject(self)

    def __str__(self):
	    return "<%s: %s>" % (self.IluTypeName(), self.IluObjectID())
	    
    __repr__ = __str__

class IluObjTrue(IluObject):

    def IluTrueP(self):
        return 1

    def IluPing(self):
        return 1

    def __str__(self):
	    return "<%s= %s>" % (self.IluTypeName(), self.IluObjectID())
	    
    __repr__ = __str__
