package jphase;

import jphase.DenseContPhaseVar;
import junit.framework.TestCase;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;

/**
 * Set of Tests for the probability methods of the 
 * DenseContPhaseVar class
 * @author Juan F. Prez
 */
public class DenseContProbTest extends TestCase {
	
	/**
	 * First Dense Continuous Distribution
	 */
	DenseContPhaseVar var1;
	
	/**
	 * Second Dense Continuous Distribution
	 */
	DenseContPhaseVar var2;
	
	/**
	 * Third Dense Continuous Distribution
	 */
	DenseContPhaseVar var3;
	
	/**
	 * First Matrix of the Dense Continuous Distribution
	 */
	double[][] matrix1= {{-2,	2},
						{2,	-5}};
	
	/**
	 * First Vector of the Dense Continuous Distribution
	 */
	double vector1[] = {0.2, 0.4};
	
	/**
	 * Second Matrix of the Dense Continuous Distribution
	 */
	double[][] matrix2= {
			{-6,	2,	1,	2,	0,	0,	1,	0,	0,	0,	0},
			{ 1,	-5,	1,	0,	2,	0,	1,	0,	0,	0,	0},
			{ 2,	1,	-7,	0,	0,	2,	2,	0,	0,	0,	0},
			{ 2,	0,	0,	-9,	2,	1,	0,	1,	3,	0,	0},
			{ 0,	2,	0,	1,	-8,	1,	0,	1,	0,	3,	0},
			{ 0,	0,	2,	2,	1,-10,	2,	0,	0,	3,	0},
			{ 0,	0,	0,	0,	0,	0,	-2,	2,	0,	0,	0},
			{ 0,	0,	0,	0,	0,	0,	2,	-5,	0,	0,	0},
			{ 0,	0,	0,	0,	0,	0,	0,	0,	-4,	2,	1},
			{ 0,	0,	0,	0,	0,	0,	0,	0,	1,	-3,	1},
			{ 0,	0,	0,	0,	0,	0,	0,	0,	2,	1,	-5}
	};
	
	/**
	 * Second Vector of the Dense Continuous Distribution
	 */
	double vector2[] = {0.2, 0.3, 0.1, 0, 0, 0.1, 0, 0.1, 0, 0, 0};

	/**
	 * Third Vector of the Dense Continuous Distribution
	 */
	double vector3[] = {1,	0,	0,	0};
	
	/**
	 * Third Matrix of the Dense Continuous Distribution
	 */
	double[][] matrix3= {
			{-0.1,	0.09,	0,	  0},
			{0,	  -0.01, 	0.01, 0},
			{0,	0,	-0.01,	0.01},
			{0,	0,	0,	-0.01}};
	
	/**
	 * 
	 * @param args Not used
	 */
	public static void main(String[] args) {
		//junit.swingui.TestRunner.run(DenseContProbTest.class);
		junit.textui.TestRunner.run(DenseContProbTest.class);
	}
	@Override
	protected void setUp() throws Exception {
		var1 = new DenseContPhaseVar(vector1, matrix1);
		var2 = new DenseContPhaseVar(vector2, matrix2);
		var3 = new DenseContPhaseVar(vector3, matrix3); 
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
		
	}

	/**
	 * Test for the method jphase.DenseContPhaseVar.pdf and
	 * jphase.DenseContPhaseVar.cdf
	 */
	public void testProb1() {
		double[] realPDF = {1.2	, 0.829464582, 0.609842441,	0.474606218, 0.38706825, 0.326978987, 0.283100439,
				0.249155877, 0.221601814, 0.198404217,	0.178365969, 0.160756955, 0.145110311, 0.131109949	,
		0.118528223, 0.107191176, 0.096958718, 0.087714601, 0.079357984, 0.071800884, 0.064965284, 0.058781354,
		0.053186743, 0.048124907, 0.043544973, 0.039400989, 0.03565138, 0.032258674, 0.029188842, 0.026411149, 0.023897774,
		0.021623604, 0.019565849, 0.017703914, 0.016019156, 0.014494735, 0.013115381, 0.011867282, 0.010737964,
		0.009716113, 0.008791504, 0.007954879, 0.007197874, 0.006512906, 0.00589312, 0.005332316, 0.00482488,
		0.004365732, 0.003950277, 0.003574359, 0.003234214, 0.002926437, 0.00264795, 0.002395965, 0.002167958,
		0.00196165, 0.001774974, 0.001606063, 0.001453226, 0.001314933, 0.001189801, 0.001076576, 0.000974127,
		0.000881426, 0.000797547, 0.000721651, 0.000652977, 0.000590838, 0.000534612, 0.000483737, 0.000437703,
		0.00039605, 0.000358361, 0.000324259, 0.000293401, 0.00026548, 0.000240217, 0.000217357, 0.000196673,
		0.000177957, 0.000161022, 0.000145699, 0.000131834, 0.000119288, 0.000107936, 9.76648E-05, 8.83708E-05,
		7.99612E-05, 7.23519E-05, 6.54667E-05, 5.92367E-05, 5.35996E-05, 4.84989E-05, 4.38836E-05, 3.97076E-05,
		3.59289E-05, 3.25098E-05, 2.94161E-05, 2.66168E-05, 2.40838E-05, 2.1792E-05, 1.97182E-05, 1.78418E-05,
		1.61439E-05, 1.46076E-05, 1.32175E-05, 1.19597E-05, 1.08216E-05, 9.79176E-06, 8.85995E-06, 8.01682E-06,
		7.25392E-06, 6.56361E-06, 5.939E-06, 5.37383E-06, 4.86244E-06, 4.39972E-06, 3.98103E-06, 3.60219E-06,
		3.25939E-06, 2.94922E-06, 2.66857E-06, 2.41462E-06, 2.18484E-06, 1.97692E-06, 1.78879E-06, 1.61857E-06,
		1.46454E-06, 1.32517E-06, 1.19906E-06, 1.08496E-06, 9.81711E-07, 8.88289E-07, 8.03757E-07, 7.27269E-07,
		6.5806E-07, 5.95438E-07, 5.38774E-07,  4.87503E-07, 4.41111E-07, 3.99134E-07, 3.61151E-07, 3.26783E-07, 2.95686E-07,
		2.67547E-07, 2.42087E-07, 2.19049E-07, 1.98204E-07, 1.79342E-07, 1.62276E-07, 1.46833E-07};
	
		double[] realCDF={0.4, 0.499822399, 0.570874086, 0.624573115, 0.667362522, 0.702893254, 0.733293795,
			0.759841469, 0.783336035, 0.804305731, 0.823121282, 0.840059266, 0.85533764, 0.869135892,
			0.881606698, 0.89288287, 0.903081919, 0.912307701, 0.920654256, 0.928205833, 0.935038403,
			0.94122067, 0.946814367, 0.951875703, 0.956455361, 0.960599194, 0.96434872, 0.967741381,
			0.970811189, 0.973588867, 0.976102235, 0.978376401, 0.980434154, 0.982296088, 0.983980845,
			0.985505265, 0.986884619, 0.988132718, 	0.989262036,0.990283887, 0.991208496, 0.992045121,
			0.992802126, 0.993487094, 0.99410688, 0.994667684, 0.99517512, 0.995634268,	0.996049723,
			0.996425641, 0.996765786, 0.997073563, 0.99735205, 0.997604035,  0.997832042, 0.99803835,
			0.998225026, 0.998393937, 0.998546774, 0.998685067, 0.998810199, 0.998923424, 0.999025873,
			0.999118574, 0.999202453, 0.999278349, 0.999347023, 0.999409162, 0.999465388, 0.999516263,
			0.999562297, 0.99960395, 0.999641639, 0.999675741, 0.999706599, 0.99973452, 0.999759783,
			0.999782643, 0.999803327, 0.999822043, 0.999838978, 0.999854301, 0.999868166, 0.999880712,
			0.999892064, 0.999902335, 0.999911629, 0.999920039, 0.999927648, 0.999934533, 0.999940763,
			0.9999464, 0.999951501, 0.999956116, 0.999960292, 0.999964071, 0.99996749, 0.999970584,
			0.999973383, 0.999975916, 0.999978208, 0.999980282, 0.999982158, 0.999983856, 0.999985392,
			0.999986783, 0.99998804, 0.999989178, 0.999990208, 0.99999114, 0.999991983, 0.999992746,
			0.999993436, 0.999994061, 0.999994626, 0.999995138, 0.9999956, 0.999996019, 0.999996398,
			0.999996741, 0.999997051, 0.999997331, 0.999997585, 0.999997815, 0.999998023, 0.999998211,
			0.999998381, 0.999998535, 0.999998675, 0.999998801, 0.999998915, 0.999999018, 0.999999112,
			0.999999196, 0.999999273, 0.999999342, 0.999999405, 0.999999461, 0.999999512, 0.999999559,
			0.999999601, 0.999999639, 0.999999673, 0.999999704, 0.999999732, 0.999999758, 0.999999781,
			0.999999802, 0.999999821, 0.999999838, 0.999999853};
		double x = 0;
		for(int i = 0; x <= 15; i++ ){
			double calcPDF = var1.pdf(x);
			double calcCDF = var1.cdf(x);
			assertEquals("Probability Density Function non equal", realPDF[i], calcPDF, 1.0E-5);
			assertEquals("Cumulative Probability Function non equal", realCDF[i], calcCDF, 1.0E-5);
			x += 0.1;
		}
		
		assertTrue("Matrix changed", ((new DenseMatrix(matrix1)).add(-1, var1.getMatrix())).norm(Matrix.Norm.Maxvalue)<1.0E-5);
		assertTrue("Vector changed", ((new DenseVector(vector1)).add(-1, var1.getVector())).norm(Vector.Norm.Infinity)<1.0E-5  );
		}
	
	
	/**
	 * Test for the method jphase.DenseContPhaseVar.pdf and
	 * jphase.DenseContPhaseVar.cdf
	 */
	public void testProb2() {
		double[] realPDF = {
				0.3	, 0.251426945, 0.276247761, 0.318824335, 0.357498359, 0.38512447,
				0.400651826, 0.405405616, 0.401446658, 0.390870529, 0.375535397,
				0.356982245, 0.336438961, 0.314856259, 0.292952697, 0.271258273,
				0.250153212	,
				0.229900557	,
				0.210672769	,
				0.192573304	,
				0.175653611	,
				0.15992663	,
				0.145377317	,
				0.131970774	,
				0.119658568	,
				0.10838351	,
				0.098083312	,
				0.088693283	,
				0.080148346	,
				0.072384474	,
				0.065339715	,
				0.058954874	,
				0.053173951	,
				0.047944391	,
				0.043217189	,
				0.038946894	,
				0.035091542	,
				0.031612527	,
				0.028474451	,
				0.02564494	,
				0.023094456	,
				0.020796105	,
				0.018725434	,
				0.016860252	,
				0.015180437	,
				0.013667773	,
				0.012305775	,
				0.011079546	,
				0.009975629	,
				0.008981874	,
				0.008087322	,
				0.00728209	,
				0.006557268	,
				0.005904827	,
				0.005317535	,
				0.004788879	,
				0.004312995	,
				0.003884601	,
				0.003498947	,
				0.003151753	,
				0.002839173	,
				0.002557741	,
				0.002304342	,
				0.002076171	,
				0.001870705	,
				0.001685675	,
				0.001519039	,
				0.001368959	,
				0.001233781	,
				0.00111202	,
				0.001002336	,
				0.000903525	,
				0.000814504	,
				0.000734298	,
				0.000662029	,
				0.000596908	,
				0.000538224	,
				0.000485338	,
				0.000437674	,
				0.000394713	,
				0.000355989	,
				0.000321081	,
				0.000289613	,
				0.000261243	,
				0.000235665	,
				0.000212602	,
				0.000191807	,
				0.000173054	,
				0.000156143	,
				0.000140891	,
				0.000127135	,
				0.000114728	,
				0.000103537	,
				9.34421E-05	,
				8.43352E-05	,
				7.61193E-05	,
				6.8707E-05	,
				6.20192E-05	,
				5.59848E-05	,
				5.05398E-05	,
				4.56263E-05	,
				4.11922E-05	,
				3.71905E-05	,
				3.3579E-05	,
				3.03194E-05	,
				2.73772E-05	,
				2.47216E-05	,
				2.23243E-05	,
				2.01603E-05	,
				1.82068E-05	,
				1.64431E-05	,
				1.48508E-05	,
				1.34132E-05	,
				1.21151E-05	,
				1.0943E-05	,
				9.88469E-06	,
				8.92899E-06	,
				8.06595E-06	,
				7.28656E-06	,
				6.58268E-06	,
				5.94697E-06	,
				5.37282E-06	,
				4.85424E-06	,
				4.38584E-06	,
				3.96275E-06	,
				3.58058E-06	,
				3.23535E-06	,
				2.92348E-06	,
				2.64175E-06	,
				2.38723E-06	,
				2.15728E-06	,
				1.94953E-06	,
				1.76184E-06	,
				1.59225E-06	,
				1.43902E-06	,
				1.30056E-06	,
				1.17545E-06	,
				1.06241E-06	,
				9.60252E-07	,
				8.67938E-07	,
				7.84516E-07	,
				7.09126E-07	,
				6.40994E-07	,
				5.7942E-07	,
				5.23771E-07	,
				4.73475E-07	,
				4.28018E-07	,
				3.86931E-07	,
				3.49795E-07	,
				3.16229E-07	,
				2.85889E-07	
		};
	
	double[] realCDF={
			0.2	,
			0.226571413	,
			0.25265034	,
			0.282378355	,
			0.316270297	,
			0.353503441	,
			0.392889519	,
			0.433273978	,
			0.473680218	,
			0.513343061	,
			0.551696079	,
			0.588343193	,
			0.623026478	,
			0.655596602	,
			0.685987249	,
			0.714194263	,
			0.74025868	,
			0.76425342	,
			0.786273029	,
			0.806425643	,
			0.824827051	,
			0.841596152	,
			0.856851654	,
			0.870709722	,
			0.883282297	,
			0.894676013	,
			0.904991496	,
			0.914323014	,
			0.922758321	,
			0.930378716	,
			0.937259184	,
			0.943468652	,
			0.949070285	,
			0.954121817	,
			0.958675905	,
			0.962780482	,
			0.966479111	,
			0.969811331	,
			0.972812978	,
			0.975516503	,
			0.977951264	,
			0.980143796	,
			0.982118071	,
			0.98389573	,
			0.985496299	,
			0.986937387	,
			0.988234874	,
			0.989403066	,
			0.990454858	,
			0.991401863	,
			0.992254539	,
			0.993022304	,
			0.993713636	,
			0.994336169	,
			0.994896772	,
			0.99540163	,
			0.995856307	,
			0.996265811	,
			0.996634651	,
			0.996966882	,
			0.997266155	,
			0.997535755	,
			0.997778637	,
			0.997997464	,
			0.998194628	,
			0.998372286	,
			0.998532376	,
			0.998676645	,
			0.998806664	,
			0.998923848	,
			0.999029471	,
			0.999124678	,
			0.999210502	,
			0.999287872	,
			0.999357626	,
			0.999420516	,
			0.999477222	,
			0.999528354	,
			0.999574464	,
			0.999616046	,
			0.999653547	,
			0.999687371	,
			0.999717878	,
			0.999745397	,
			0.99977022	,
			0.999792613	,
			0.999812816	,
			0.999831043	,
			0.999847488	,
			0.999862327	,
			0.999875716	,
			0.999887799	,
			0.999898702	,
			0.999908543	,
			0.999917424	,
			0.999925439	,
			0.999932674	,
			0.999939205	,
			0.9999451	,
			0.999950422	,
			0.999955226	,
			0.999959563	,
			0.999963478	,
			0.999967014	,
			0.999970206	,
			0.999973088	,
			0.999975691	,
			0.999978041	,
			0.999980164	,
			0.99998208	,
			0.999983811	,
			0.999985375	,
			0.999986787	,
			0.999988062	,
			0.999989214	,
			0.999990254	,
			0.999991194	,
			0.999992043	,
			0.99999281	,
			0.999993503	,
			0.999994129	,
			0.999994694	,
			0.999995205	,
			0.999995667	,
			0.999996084	,
			0.999996461	,
			0.999996801	,
			0.999997109	,
			0.999997387	,
			0.999997638	,
			0.999997865	,
			0.999998071	,
			0.999998256	,
			0.999998424	,
			0.999998575	,
			0.999998712	,
			0.999998836	,
			0.999998947	,
			0.999999048	,
			0.99999914	,
			0.999999222	,
			0.999999297	,
			0.999999364	,
			0.999999425	,
			0.99999948	,
			0.99999953	,
			0.999999575	,
			0.999999616	,
			0.999999653	,
			0.999999686	,
			0.999999716	,
			};
		double x = 0;
		for(int i = 0; x <= 1; i++ ){
			double calcPDF = var2.pdf(x);
			double calcCDF = var2.cdf(x);
			assertEquals("Probability Density Function non equal", realPDF[i], calcPDF, 1.0E-5);
			assertEquals("Cumulative Probability Function non equal", realCDF[i], calcCDF, 1.0E-5);
			x += 0.1;
		}
		
		assertTrue("Matrix changed", ((new DenseMatrix(matrix2)).add(-1, var2.getMatrix())).norm(Matrix.Norm.Maxvalue)<1.0E-5);
		assertTrue("Vector changed", ((new DenseVector(vector2)).add(-1, var2.getVector())).norm(Vector.Norm.Infinity)<1.0E-5  );
		}
	
	/**
	 * Test for the method jphase.DenseContPhaseVar.pdf and
	 * jphase.DenseContPhaseVar.cdf
	 */
	public void testProb3() {
		double[] realPDF = {0.01, 0.009753099, 0.009512296, 0.009277441, 0.009048389, 0.008824997, 0.008607128,
				0.008394646, 0.00818742, 0.007985321, 0.007788224, 0.007596007, 0.00740855, 0.007225738,
				0.007047456, 0.006873594, 0.006704045, 0.006538703, 0.006377466, 0.006220232, 0.006066906,
				0.005917391, 0.005771594, 0.005629426, 0.005490796, 0.00535562, 0.005223813, 0.005095293,
				0.00496998, 0.004847796, 0.004728666, 0.004612513, 0.004499267, 0.004388856, 0.004281211,
				0.004176266, 0.004073954, 0.003974212, 0.003876978, 0.00378219, 0.00368979, 0.003599718,
				0.003511919, 0.003426337, 0.003342919, 0.003261613, 0.003182366, 0.00310513, 0.003029855,
				0.002956495,
				0.002885002	,
				0.002815332	,
				0.002747442	,
				0.002681286	,
				0.002616823	,
				0.002554014	,
				0.002492817	,
				0.002433194	,
				0.002375107	,
				0.002318518	,
				0.002263392	,
				0.002209694	,
				0.002157388	,
				0.002106442	,
				0.002056825	,
				0.0020085	,
				0.001961439	,
				0.001915612	,
				0.001870988	,
				0.001827539	,
				0.001785236	,
				0.001744052	,
				0.00170396	,
				0.001664934	,
				0.001626949	,
				0.001589978	,
				0.001553999	,
				0.001518987	,
				0.001484921	,
				0.001451775	,
				0.001419528	,
				0.00138816	,
				0.001357648	,
				0.001327973	,
				0.001299115	,
				0.001271054	,
				0.001243771	,
				0.001217248	,
				0.001191466	,
				0.001166408	,
				0.001142056	,
				0.001118394	,
				0.001095406	,
				0.001073077	,
				0.001051388	,
				0.001030326	,
				0.001009875	,
				0.000990022	,
				0.000970751	,
				0.00095205	,
				0.000933905	,
				0.000916302	,
				0.00089923	,
				0.000882674	,
				0.000866623	,
				0.000851066	,
				0.00083599	,
				0.000821385	,
				0.00080724	,
				0.000793542	,
				0.000780282	,
				0.000767449	,
				0.000755034	,
				0.000743026	,
				0.000731416	,
				0.000720195	,
				0.000709354	,
				0.000698883	,
				0.000688775	,
				0.00067902	,
				0.00066961	,
				0.000660538	,
				0.000651795	,
				0.000643374	,
				0.000635267	,
				0.000627468	,
				0.000619968	,
				0.000612761	,
				0.000605839	,
				0.000599197	,
				0.000592827	,
				0.000586724	,
				0.000580882	,
				0.000575293	,
				0.000569954	,
				0.000564856	,
				0.000559996	,
				0.000555367	,
				0.000550965	,
				0.000546784	,
				0.000542818	,
				0.000539065	,
				0.000535517	,
				0.00053217	,
				0.00052902	,
				0.000526062	,
				0.000523291	,
				0.000520705	,
				0.000518297	,
				0.000516064	,
				0.000514003	,
				0.000512109	,
				0.000510378	,
				0.000508807	,
				0.000507392	,
				0.000506129	,
				0.000505016	,
				0.000504048	,
				0.000503222	,
				0.000502537	,
				0.000501986	,
				0.000501568	,
				0.00050128	,
				0.000501118	,
				0.00050108	,
				0.000501164	,
				0.000501366	,
				0.000501683	,
				0.000502114	,
				0.000502654	,
				0.000503303	,
				0.000504058	,
				0.000504915	,
				0.000505874	,
				0.000506931	,
				0.000508084	,
				0.000509331	,
				0.000510672	,
				0.000512101	,
				0.000513619	,
				0.000515222	,
				0.000516909	,
				0.000518678	,
				0.000520527	,
				0.000522455	,
				0.000524459	,
				0.000526538	,
				0.00052869	,
				0.000530914	,
				0.000533208	,
				0.00053557	,
				0.000537999	,
				0.000540493	,
				0.000543051	,
				0.000545671	,
				0.000548353	,
				0.000551096	,
				0.000553895	,
				0.000556751	,
				0.000559663	,
				0.000562629	,
				0.000565648	,
				0.000568719	,
				0.000571841	,
				0.000575013	,
				0.000578232	,
				0.0005815	,
				0.000584813	,
				0.000588172	,
				0.000591574	,
				0.00059502	,
				0.000598508	,
				0.000602038	,
				0.000605607	,
				0.000609216	,
				0.000612865	,
				0.00061655	,
				0.000620271	,
				0.000624028	,
				0.00062782	,
				0.000631647	,
				0.000635506	,
				0.000639398	,
				0.000643322	,
				0.000647277	,
				0.000651263	,
				0.000655277	,
				0.000659321	,
				0.000663393	,
				0.000667492	,
				0.000671618	,
				0.000675771	,
				0.000679948	,
				0.000684151	,
				0.000688378	,
				0.000692631	,
				0.000696905	,
				0.000701202	,
				0.000705521	,
				0.000709861	,
				0.000714222	,
				0.000718603	,
				0.000723004	,
				0.000727425	,
				0.000731864	,
				0.000736322	,
				0.000740797	,
				0.00074529	,
				0.0007498	,
				0.000754327	,
				0.000758869	,
				0.000763427	,
				0.000768	,
				0.000772588	,
				0.000777191	,
				0.000781809	,
				0.000786439	,
				0.000791082	,
				0.000795738	,
				0.000800406	,
				0.000805087	,
				0.000809779	,
				0.000814482	,
				0.000819196	,
				0.000823921	,
				0.000828656	,
				0.000833402	,
				0.000838156	,
				0.000842921	,
				0.000847694	,
				0.000852476	,
				0.000857266	,
				0.000862065	,
				0.000866871	,
				0.000871685	,
				0.000876508	,
				0.000881336	,
				0.000886171	,
				0.000891012	,
				0.00089586	,
				0.000900713	,
				0.000905572	,
				0.000910437	,
				0.000915307	,
				0.000920181	,
				0.000925061	,
				0.000929945	,
				0.000934833	,
				0.000939725	,
				0.000944621	,
				0.000949521	,
				0.000954424	,
				0.00095933	,
				0.000964239	,
				0.000969151	,
				0.000974065	,
				0.000978984	,
				0.000983903	,
				0.000988824	,
				0.000993746	,
				0.000998671	,
				0.001003596	,
				0.001008523	,
				0.001013452	,
				0.00101838	,
				0.00102331	,
				0.00102824	,
				0.001033171	,
				0.001038102	,
				0.001043033	,
				0.001047964	,
				0.001052894	,
				0.001057824	,
				0.001062754	,
				0.001067683	,
				0.00107261	,
				0.001077537	,
				0.001082463	,
				0.001087389	,
				0.001092313	,
				0.001097234	,
				0.001102154	,
				0.001107072	,
				0.001111988	,
				0.001116902	,
				0.001121814	,
				0.001126723	,
				0.00113163	,
				0.001136535	,
				0.001141436	,
				0.001146335	,
				0.001151231	,
				0.001156124	,
				0.001161013	,
				0.001165899	,
				0.001170782	,
				0.001175661	,
				0.001180537	,
				0.001185409	,
				0.001190279	,
				0.001195143	,
				0.001200003	,
				0.001204859	,
				0.001209711	,
				0.001214558	,
				0.001219401	,
				0.001224239	,
				0.001229073	,
				0.001233902	,
				0.001238726	,
				0.001243546	,
				0.00124836	,
				0.001253169	,
				0.001257973	,
				0.001262772	,
				0.001267565	,
				0.001272353	,
				0.001277135	,
				0.001281912	,
				0.001286683	,
				0.001291448	,
				0.001296209	,
				0.001300962	,
				0.00130571	,
				0.001310451	,
				0.001315186	,
				0.001319915	,
				0.001324638	,
				0.001329354	,
				0.001334064	,
				0.001338767	,
				0.001343464	,
				0.001348154	,
				0.001352837	,
				0.001357514	,
				0.001362183	,
				0.001366846	,
				0.001371501	,
				0.00137615	,
				0.001380791	,
				0.001385425	,
				0.001390052	,
				0.001394672	,
				0.001399285	,
				0.00140389	,
				0.001408488	,
				0.001413077	,
				0.001417659	,
				0.001422234	,
				0.0014268	,
				0.001431359	,
				0.00143591	,
				0.001440453	,
				0.001444988	,
				0.001449515	,
				0.001454034	,
				0.001458545	,
				0.001463048	,
				0.001467542	,
				0.001472028	,
				0.001476506	,
				0.001480976	,
				0.001485437	,
				0.001489889	,
				0.001494333	,
				0.001498769	,
				0.001503197	,
				0.001507615	,
				0.001512025	,
				0.001516426	,
				0.001520818	,
				0.001525201	,
				0.001529575	,
				0.00153394	,
				0.001538297	,
				0.001542644	,
				0.001546982	,
				0.001551311	,
				0.001555631	,
				0.001559942	,
				0.001564244	,
				0.001568536	,
				0.001572819	,
				0.001577093	,
				0.001581357	,
				0.001585612	,
				0.001589858	,
				0.001594094	,
				0.001598321	,
				0.001602539	,
				0.001606746	,
				0.001610944	,
				0.001615133	,
				0.001619311	,
				0.00162348	,
				0.001627639	,
				0.001631788	,
				0.001635928	,
				0.001640057	,
				0.001644177	,
				0.001648287	,
				0.001652386	,
				0.001656476	,
				0.001660556	,
				0.001664626	,
				0.001668686	,
				0.001672736	,
				0.001676775	,
				0.001680805	,
				0.001684824	,
				0.001688833	,
				0.001692832	,
				0.001696822	,
				0.0017008	,
				0.001704768	,
				0.001708726	,
				0.001712673	,
				0.001716611	,
				0.001720537	,
				0.001724453	,
				0.001728359	,
				0.001732255	,
				0.001736139	,
				0.001740014	,
				0.001743878	,
				0.001747731	,
				0.001751573	,
				0.001755405	,
				0.001759227	,
				0.001763038	,
				0.001766838	,
				0.001770627	,
				0.001774406	,
				0.001778174	,
				0.001781931	,
				0.001785679	,
				0.001789415	,
				0.00179314	,
				0.001796854	,
				0.001800558	,
				0.00180425	,
				0.001807932	,
				0.001811603	,
				0.001815263	,
				0.001818912	,
				0.00182255	,
				0.001826177	,
				0.001829793	,
				0.001833399	,
				0.001836993	,
				0.001840576	,
				0.001844149	,
				0.00184771	,
				0.00185126	,
				0.001854799	,
				0.001858327	,
				0.001861844	,
				0.00186535	,
				0.001868845	,
				0.00187233	,
				0.001875802	,
				0.001879264	,
				0.001882714	,
				0.001886154	,
				0.001889582	,
				0.001892998	,
				0.001896404	,
				0.001899798	,
				0.001903182	,
				0.001906554	,
				0.001909915	,
				0.001913264	,
				0.001916602	,
				0.00191993	,
				0.001923245	,
				0.00192655	,
				0.001929843	,
				0.001933125	,
				0.001936396	,
				0.001939655	,
				0.001942903	,
				0.00194614	,
				0.001949365	,
				0.001952581	,
				0.001955784	,
				0.001958975	,
				0.001962155	,
				0.001965324	,
				0.001968481	,
				0.001971628	,
				0.001974762	,
				0.001977886	,
				0.001980998	,
				0.001984098	,
				0.001987187	,
				0.001990265	,
				0.001993332	,
				0.001996387	,
				0.001999431	,
				0.002002463	,
				0.002005484	,
				0.002008493	,
				0.002011491	,
				0.002014478	,
				0.002017453	,
				0.002020417	,
				0.002023369	,
				0.002026312	,
				0.002029241	,
				0.002032159	,
				0.002035066	,
				0.002037962	,
				0.002040846	,
				0.002043718	,
				0.002046579	,
				0.002049429	,
				0.002052267	,
				0.002055094	,
				0.00205791	,
				0.002060714	,
				0.002063506	,
				0.002066287	,
				0.002069057	,
				0.002071816	,
				0.002074563	,
				0.002077298	,
				0.002080022	,
				0.002082735	,
				0.002085436	,
				0.002088126	,
				0.002090805	,
				0.002093473	,
				0.002096129	,
				0.002098773	,
				0.002101406	,
				0.002104028	,
				0.002106638	,
				0.002109237	,
				0.002111824	,
				0.0021144	,
				0.002116965	,
				0.002119518	,
				0.00212206	,
				0.002124591	,
				0.00212711	,
				0.002129618	,
				0.002132115	,
				0.0021346	,
				0.002137074	,
				0.002139536	,
				0.002141988	,
				0.002144428	,
				0.002146856	,
				0.002149274	,
				0.00215168	,
				0.002154074	,
				0.002156459	,
				0.002158831	,
				0.002161192	,
				0.002163542	,
				0.00216588	,
				0.002168207	,
				0.002170523	,
				0.002172828	,
				0.002175121	,
				0.002177403	,
				0.002179674	,
				0.002181934	,
				0.002184183	,
				0.00218642	,
				0.002188646	,
				0.002190861	,
				0.002193065	,
				0.002195258	,
				0.002197439	,
				0.00219961	,
				0.002201769	,
				0.002203917	,
				0.002206054	,
				0.00220818	,
				0.002210294	,
				0.002212399	,
				0.002214492	,
				0.002216573	,
				0.002218644	,
				0.002220703	,
				0.002222751	,
				0.002224789	,
				0.002226815	,
				0.00222883	,
				0.002230834	,
				0.002232828	,
				0.00223481	,
				0.002236781	,
				0.002238742	,
				0.002240691	,
				0.002242629	,
				0.002244557	,
				0.002246473	,
				0.002248379	,
				0.002250274	,
				0.002252158	,
				0.002254031	,
				0.002255893	,
				0.002257744	,
				0.002259584	,
				0.002261415	,
				0.002263233	,
				0.002265041	,
				0.002266838	,
				0.002268625	,
				0.0022704	,
				0.002272165	,
				0.002273919	,
				0.002275663	,
				0.002277395	,
				0.002279117	,
				0.002280828	,
				0.002282529	,
				0.002284218	,
				0.002285898	,
				0.002287566	,
				0.002289224	,
				0.002290871	,
				0.002292508	,
				0.002294134	,
				0.002295749	,
				0.002297354	,
				0.002298948	,
				0.002300532	,
				0.002302105	,
				0.002303668	,
				0.002305221	,
				0.002306762	,
				0.002308293	,
				0.002309814	,
				0.002311324	,
				0.002312824	,
				0.002314314	,
				0.002315793	,
				0.002317261	,
				0.002318719	,
				0.002320167	,
				0.002321605	,
				0.002323032	,
				0.002324449	,
				0.002325855	,
				0.002327252	,
				0.002328637	,
				0.002330013	,
				0.002331379	,
				0.002332734	,
				0.002334079	,
				0.002335413	,
				0.002336738	,
				0.002338052	,
				0.002339357	,
				0.002340651	,
				0.002341935	,
				0.002343209	,
				0.002344473	,
				0.002345727	,
				0.00234697	,
				0.002348204	,
				0.002349427	,
				0.002350641	,
				0.002351844	,
				0.002353038	,
				0.002354221	,
				0.002355395	,
				0.002356558	,
				0.002357712	,
				0.002358856	,
				0.002359989	,
				0.002361113	,
				0.002362227	,
				0.002363332	,
				0.002364426	,
				0.002365511	,
				0.002366585	,
				0.00236765	,
				0.002368706	,
				0.002369752	,
				0.002370788	,
				0.002371814	,
				0.00237283	,
				0.002373837	,
				0.002374834	,
				0.002375821	,
				0.002376799	,
				0.002377767	,
				0.002378725	,
				0.002379674	,
				0.002380614	,
				0.002381543	,
				0.002382464	,
				0.002383374	,
				0.002384276	,
				0.002385167	,
				0.00238605	,
				0.002386922	,
				0.002387786	,
				0.00238864	,
				0.002389484	,
				0.00239032	,
				0.002391145	,
				0.002391962	,
				0.00239277	,
				0.002393568	,
				0.002394356	,
				0.002395136	,
				0.002395906	,
				0.002396666	,
				0.002397418	,
				0.00239816	,
				0.002398894	,
				0.002399618	,
				0.002400332	,
				0.002401038	,
				0.002401735	,
				0.002402422	,
				0.002403101	,
				0.00240377	,
				0.00240443	,
				0.002405082	,
				0.002405724	,
				0.002406357	,
				0.002406981	,
				0.002407597	,
				0.002408203	,
				0.002408801	,
				0.002409389	,
				0.002409969	,
				0.00241054	,
				0.002411102	,
				0.002411656	,
				0.0024122	,
				0.002412735	,
				0.002413262	,
				0.00241378	,
				0.002414289	,
				0.00241479	,
				0.002415282	,
				0.002415765	,
				0.00241624	,
				0.002416705	,
				0.002417163	,
				0.002417611	,
				0.002418051	,
				0.002418483	,
				0.002418906	,
				0.00241932	,
				0.002419726	,
				0.002420123	,
				0.002420512	,
				0.002420892	,
				0.002421264	,
				0.002421628	,
				0.002421983	,
				0.00242233	,
				0.002422668	,
				0.002422998	,
				0.00242332	,
				0.002423633	,
				0.002423938	,
				0.002424235	,
				0.002424523	,
				0.002424804	,
				0.002425076	,
				0.002425339	,
				0.002425595	,
				0.002425843	,
				0.002426082	,
				0.002426313	,
				0.002426536	,
				0.002426751	,
				0.002426958	,
				0.002427157	,
				0.002427348	,
				0.00242753	,
				0.002427705	,
				0.002427872	,
				0.002428031	,
				0.002428182	,
				0.002428325	,
				0.00242846	,
				0.002428587	,
				0.002428707	,
				0.002428818	,
				0.002428922	,
				0.002429017	,
				0.002429106	,
				0.002429186	,
				0.002429258	,
				0.002429323	,
				0.00242938	,
				0.002429429	,
				0.002429471	,
				0.002429505	,
				0.002429531	,
				0.00242955	,
				0.002429561	,
				0.002429565	,
				0.002429561	,
				0.002429549	,
				0.00242953	,
				0.002429503	,
				0.002429469	,
				0.002429428	,
				0.002429378	,
				0.002429322	,
				0.002429259	,
				0.002429187	,
				0.002429109	,
				0.002429023	,
				0.002428929	,
				0.002428828	,
				0.00242872	,
				0.002428605	,
				0.002428482	,
				0.002428353	,
				0.002428216	,
				0.002428071	,
				0.00242792	,
				0.002427761	,
				0.002427595	,
				0.002427423	,
				0.002427243	,
				0.002427055	,
				0.002426861	,
				0.00242666	,
				0.002426452	,
				0.002426236	,
				0.002426014	,
				0.002425784	,
				0.002425548	,
				0.002425305	,
				0.002425055	,
				0.002424798	,
				0.002424534	,
				0.002424263	,
				0.002423986	,
				0.002423701	,
				0.00242341	,
				0.002423112	,
				0.002422807	,
				0.002422495	,
				0.002422176	,
				0.002421851	,
				0.002421519	,
				0.002421181	,
				0.002420836	,
				0.002420484	,
				0.002420125	,
				0.00241976	,
				0.002419388	,
				0.00241901	,
				0.002418625	,
				0.002418234	,
				0.002417836	,
				0.002417431	,
				0.00241702	,
				0.002416603	,
				0.002416179	,
				0.002415749	,
				0.002415313	,
				0.00241487	,
				0.00241442	,
				0.002413965	,
				0.002413503	,
				0.002413034	,
				0.002412559	,
				0.002412078	,
				0.002411591	,
				0.002411098	,
				0.002410598	,
				0.002410092	,
				0.00240958	,
				0.002409062	,
				0.002408537	,
				0.002408006	,
				0.00240747	,
				0.002406927	,
				0.002406378	,
				0.002405823	,
				0.002405262	,
				0.002404695	,
				0.002404122	,
				0.002403543	,
				0.002402958	,
				0.002402367	,
				0.002401771	,
				0.002401168	,
				0.002400559	,
				0.002399945	,
				0.002399324	,
				0.002398698	,
				0.002398066	,
				0.002397428	,
				0.002396785	,
				0.002396135	,
				0.00239548	,
				0.002394819	,
				0.002394152	,
				0.00239348	,
				0.002392802	,
				0.002392118	,
				0.002391429	,
				0.002390734	,
				0.002390033	,
				0.002389327	,
				0.002388615	,
				0.002387898	,
				0.002387175	,
				0.002386447	,
				0.002385713	,
				0.002384974	,
				0.002384229	,
				0.002383479	,
				0.002382723	,
				0.002381962	,
				0.002381195	,
				0.002380424	,
				0.002379646	,
				0.002378864	,
				0.002378076	,
				0.002377282	,
				0.002376484	,
				0.00237568	,
				0.002374871	,
				0.002374057	,
				0.002373237	,
				0.002372412	,
				0.002371582	,
				0.002370747	,
				0.002369907	,
				0.002369062	,
				0.002368211	,
				0.002367355	,
				0.002366495	,
				0.002365629	,
				0.002364758	,
				0.002363882	,
				0.002363001	,
				0.002362116	,
				0.002361225	,
				0.002360329	,
				0.002359428	,
				0.002358523	,
				0.002357612	,
				0.002356697	,
				0.002355776	,
				0.002354851	,
				0.002353921	,
				0.002352986	,
				0.002352046	,
				0.002351102	,
				0.002350152	,
				0.002349198	,
				0.002348239	,
				0.002347276	,
				0.002346308	,
				0.002345335	,
				0.002344357	,
				0.002343375	,
				0.002342388	,
				0.002341396	,
				0.0023404	,
				0.002339399	,
				0.002338394	,
				0.002337384	,
				0.00233637	,
				0.002335351	,
				0.002334327	,
				0.002333299	,
				0.002332267	,
				0.00233123	,
				0.002330189	,
				0.002329143	,
				0.002328093	,
				0.002327038	,
				0.002325979	,
				0.002324916	,
				0.002323848	,
				0.002322776	,
				0.0023217	,
				0.002320619	,
				0.002319534	,
				0.002318445	,
				0.002317352	,
				0.002316254	,
				0.002315152	,
				0.002314046	,
				0.002312936	,
				0.002311821	,
				0.002310703	,
				0.00230958	,
				0.002308453	,
				0.002307322	,
				0.002306187	,
				0.002305048	,
				0.002303905	,
				0.002302758	,
				0.002301606	,
				0.002300451	,
				0.002299292	,
				0.002298129	,
				0.002296961	,
				0.00229579	,
				0.002294615	,
				0.002293436	,
				0.002292253	,
				0.002291067	,
				0.002289876	,
				0.002288681	,
				0.002287483	,
				0.002286281	,
				0.002285075	,
				0.002283865	,
				0.002282651	,
				0.002281434	,
				0.002280213	,
				0.002278988	,
				0.00227776	,
				0.002276527	,
				0.002275292	,
				0.002274052	,
				0.002272809	,
				0.002271562	,
				0.002270312	,
				0.002269057	,
				0.0022678	,
				0.002266538	,
				0.002265274	,
				0.002264005	,
				0.002262733	,
				0.002261458	,
				0.002260179	,
				0.002258896	,
				0.00225761	,
				0.002256321	,
				0.002255028	,
				0.002253732	,
				0.002252432	,
				0.002251129	,
				0.002249823	,
				0.002248513	,
				0.0022472	,
				0.002245883	,
				0.002244563	,
				0.00224324	,
				0.002241913	,
				0.002240584	,
				0.002239251	,
				0.002237915	,
				0.002236575	,
				0.002235232	,
				0.002233886	,
				0.002232537	,
				0.002231185	,
				0.002229829	,
				0.00222847	,
				0.002227109	,
				0.002225744	,
				0.002224376	,
				0.002223004	,
				0.00222163	,
				0.002220253	,
				0.002218872	,
				0.002217489	,
				0.002216103	,
				0.002214713	,
				0.002213321	,
				0.002211925	,
				0.002210527	,
				0.002209125	,
				0.002207721	,
				0.002206314	,
				0.002204904	,
				0.002203491	,
				0.002202075	,
				0.002200656	,
				0.002199234	,
				0.00219781	,
				0.002196382	,
				0.002194952	,
				0.002193519	,
				0.002192083	,
				0.002190645	,
				0.002189203	,
				0.002187759	,
				0.002186312	,
				0.002184863	,
				0.002183411	,
				0.002181956	,
				0.002180498	,
				0.002179038	,
				0.002177575	,
				0.002176109	,
				0.002174641	,
				0.00217317	,
				0.002171696	,
				0.00217022	,
				0.002168741	,
				0.00216726	,
				0.002165776	,
				0.00216429	,
				0.002162801	,
				0.00216131	,
				0.002159816	,
				0.00215832	,
				0.002156821	,
				0.00215532	,
				0.002153816	,
				0.00215231	,
				0.002150801	,
				0.00214929	,
				0.002147777	,
				0.002146261	,
				0.002144743	,
				0.002143222	,
				0.002141699	,
				0.002140174	,
				0.002138646	,
				0.002137117	,
				0.002135584	,
				0.00213405	,
				0.002132513	,
				0.002130974	,
				0.002129433	,
				0.00212789	,
				0.002126344	,
				0.002124796	,
				0.002123246	,
				0.002121694	,
				0.002120139	,
				0.002118583	,
				0.002117024	,
				0.002115463	,
				0.0021139	,
				0.002112335	,
				0.002110768	,
				0.002109198	,
				0.002107627	,
				0.002106054	,
				0.002104478	,
				0.002102901	,
				0.002101321	,
				0.002099739	,
				0.002098156	,
				0.00209657	,
				0.002094983	,
				0.002093393	,
				0.002091802	,
				0.002090208	,
				0.002088613	,
				0.002087016	,
				0.002085416	,
				0.002083815	,
				0.002082212	,
				0.002080607	,
				0.002079001	,
				0.002077392	,
				0.002075782	,
				0.00207417	,
				0.002072556	,
				0.00207094	,
				0.002069322	,
				0.002067703	,
				0.002066081	,
				0.002064458	,
				0.002062834	,
				0.002061207	,
				0.002059579	,
				0.002057949	,
				0.002056318	,
				0.002054684	,
				0.002053049	,
				0.002051413	,
				0.002049774	,
				0.002048134	,
				0.002046493	,
				0.00204485	,
				0.002043205	,
				0.002041558	,
				0.00203991	,
				0.002038261	,
				0.002036609	,
				0.002034957	,
				0.002033302	,
				0.002031647	,
				0.002029989	,
				0.00202833	,
				0.00202667	,
				0.002025008	,
				0.002023345	,
				0.00202168	,
				0.002020014	,
				0.002018346	,
				0.002016677	,
				0.002015006	,
				0.002013334	,
				0.002011661	,
				0.002009986	,
				0.00200831	,
				0.002006632	,
				0.002004953	,
				0.002003272	,
				0.002001591	,
				0.001999908	,
				0.001998223	,
				0.001996538	,
				0.001994851	,
				0.001993162	,
				0.001991473	,
				0.001989782	,
				0.00198809	,
				0.001986396	,
				0.001984702	,
				0.001983006	,
				0.001981309	,
				0.001979611	,
				0.001977911	,
				0.00197621	,
				0.001974508	,
				0.001972805	,
				0.001971101	,
				0.001969396	,
				0.001967689	,
				0.001965982	,
				0.001964273	,
				0.001962563	,
				0.001960852	,
				0.00195914	,
				0.001957426	,
				0.001955712	,
				0.001953997	,
				0.00195228	,
				0.001950563	,
				0.001948844	,
				0.001947125	,
				0.001945404	,
				0.001943683	,
				0.00194196	,
				0.001940236	,
				0.001938512	,
				0.001936786	,
				0.00193506	,
				0.001933332	,
				0.001931604	,
				0.001929875	,
				0.001928144	,
				0.001926413	,
				0.001924681	,
				0.001922948	,
				0.001921214	,
				0.001919479	,
				0.001917744	,
				0.001916007	,
				0.00191427	,
				0.001912532	,
				0.001910793	,
				0.001909053	,
				0.001907312	,
				0.00190557	,
				0.001903828	,
				0.001902085	,
				0.001900341	,
				0.001898597	,
				0.001896851	,
				0.001895105	,
				0.001893358	,
				0.00189161	,
				0.001889862	,
				0.001888113	,
				0.001886363	,
				0.001884613	,
				0.001882861	,
				0.001881109	,
				0.001879357	,
				0.001877604	,
				0.00187585	,
				0.001874095	,
				0.00187234	,
				0.001870584	,
				0.001868827	,
				0.00186707	,
				0.001865313	,
				0.001863554	,
				0.001861795	,
				0.001860036	,
				0.001858276	,
				0.001856515	,
				0.001854754	,
				0.001852992	,
				0.00185123	,
				0.001849467	,
				0.001847703	,
				0.00184594	,
				0.001844175	,
				0.00184241	,
				0.001840645	,
				0.001838879	,
				0.001837113	,
				0.001835346	,
				0.001833578	,
				0.001831811	,
				0.001830042	,
				0.001828274	,
				0.001826505	,
				0.001824735	,
				0.001822965	,
				0.001821195	,
				0.001819424	,
				0.001817653	,
				0.001815881	,
				0.001814109	,
				0.001812337	,
				0.001810565	,
				0.001808792	,
				0.001807018	,
				0.001805244	,
				0.00180347	,
				0.001801696	,
				0.001799921	,
				0.001798146	,
				0.001796371	,
				0.001794596	,
				0.00179282	,
				0.001791044	,
				0.001789267	,
				0.00178749	,
				0.001785714	,
				0.001783936	,
				0.001782159	,
				0.001780381	,
				0.001778603	,
				0.001776825	,
				0.001775047	,
				0.001773268	,
				0.00177149	,
				0.001769711	,
				0.001767932	,
				0.001766152	,
				0.001764373	,
				0.001762593	,
				0.001760813	,
				0.001759033	,
				0.001757253	,
				0.001755473	,
				0.001753693	,
				0.001751912	,
				0.001750132	,
				0.001748351	,
				0.00174657	,
				0.001744789	,
				0.001743008	,
				0.001741227	,
				0.001739446	,
				0.001737665	,
				0.001735883	,
				0.001734102	,
				0.001732321	,
				0.001730539	,
				0.001728758	,
				0.001726976	,
				0.001725195	,
				0.001723413	,
				0.001721632	,
				0.00171985	,
				0.001718069	,
				0.001716287	,
				0.001714505	,
				0.001712724	,
				0.001710943	,
				0.001709161	,
				0.00170738	,
				0.001705598	,
				0.001703817	,
				0.001702036	,
				0.001700255	,
				0.001698474	,
				0.001696693	,
				0.001694912	,
				0.001693131	,
				0.00169135	,
				0.00168957	,
				0.001687789	,
				0.001686009	,
				0.001684228	,
				0.001682448	,
				0.001680668	,
				0.001678889	,
				0.001677109	,
				0.001675329	,
				0.00167355	,
				0.001671771	,
				0.001669992	,
				0.001668213	,
				0.001666434	,
				0.001664656	,
				0.001662877	,
				0.001661099	,
				0.001659321	,
				0.001657544	,
				0.001655766	,
				0.001653989	,
				0.001652212	,
				0.001650435	,
				0.001648658	,
				0.001646882	,
				0.001645106	,
				0.00164333	,
				0.001641555	,
				0.00163978	,
				0.001638005	,
				0.00163623	,
				0.001634456	,
				0.001632682	,
				0.001630908	,
				0.001629134	,
				0.001627361	,
				0.001625588	,
				0.001623816	,
				0.001622043	,
				0.001620272	,
				0.0016185	,
				0.001616729	,
				0.001614958	,
				0.001613187	,
				0.001611417	,
				0.001609647	,
				0.001607878	,
				0.001606109	,
				0.00160434	,
				0.001602572	,
				0.001600804	,
				0.001599036	,
				0.001597269	,
				0.001595503	,
				0.001593736	,
				0.00159197	,
				0.001590205	,
				0.00158844	,
				0.001586675	,
				0.001584911	,
				0.001583147	,
				0.001581384	,
				0.001579621	,
				0.001577859	,
				0.001576097	,
				0.001574336	,
				0.001572575	,
				0.001570814	,
				0.001569054	,
				0.001567295	,
				0.001565535	,
				0.001563777	,
				0.001562019	,
				0.001560261	,
				0.001558504	,
				0.001556748	,
				0.001554992	,
				0.001553236	,
				0.001551481	,
				0.001549727	,
				0.001547973	,
				0.001546219	,
				0.001544467	,
				0.001542714	,
				0.001540963	,
				0.001539211	,
				0.001537461	,
				0.001535711	,
				0.001533961	,
				0.001532213	,
				0.001530464	,
				0.001528717	,
				0.00152697	,
				0.001525223	,
				0.001523477	,
				0.001521732	,
				0.001519987	,
				0.001518243	,
				0.0015165	,
				0.001514757	,
				0.001513014	,
				0.001511273	,
				0.001509532	,
				0.001507792	,
				0.001506052	,
				0.001504313	,
				0.001502575	,
				0.001500837	,
				0.0014991	,
				0.001497363	,
				0.001495628	,
				0.001493893	,
				0.001492158	,
				0.001490424	,
				0.001488691	,
				0.001486959	,
				0.001485228	,
				0.001483497	,
				0.001481766	,
				0.001480037	,
				0.001478308	,
				0.00147658	,
				0.001474853	,
				0.001473126	,
				0.0014714	,
				0.001469675	,
				0.00146795	,
				0.001466227	,
				0.001464504	,
				0.001462781	,
				0.00146106	,
				0.001459339	,
				0.001457619	,
				0.0014559	,
				0.001454181	,
				0.001452464	,
				0.001450747	,
				0.00144903	,
				0.001447315	,
				0.0014456	,
				0.001443887	,
				0.001442174	,
				0.001440461	,
				0.00143875	,
				0.001437039	,
				0.001435329	,
				0.00143362	,
				0.001431912	,
				0.001430205	,
				0.001428498	,
				0.001426793	,
				0.001425088	,
				0.001423383	,
				0.00142168	,
				0.001419978	,
				0.001418276	,
				0.001416575	,
				0.001414875	,
				0.001413176	,
				0.001411478	,
				0.001409781	,
				0.001408084	,
				0.001406389	,
				0.001404694	,
				0.001403	,
				0.001401307	,
				0.001399615	,
				0.001397923	,
				0.001396233	,
				0.001394544	,
				0.001392855	,
				0.001391167	,
				0.00138948	,
				0.001387794	,
				0.001386109	,
				0.001384425	,
				0.001382742	,
				0.00138106	,
				0.001379378	,
				0.001377698	,
				0.001376018	,
				0.00137434	,
				0.001372662	,
				0.001370985	,
				0.001369309	,
				0.001367634	,
				0.00136596	,
				0.001364287	,
				0.001362615	,
				0.001360944	,
				0.001359274	,
				0.001357605	,
				0.001355936	,
				0.001354269	,
				0.001352603	,
				0.001350937	,
				0.001349273	,
				0.001347609	,
				0.001345947	,
				0.001344285	,
				0.001342625	,
				0.001340965	,
				0.001339307	,
				0.001337649	,
				0.001335992	,
				0.001334337	,
				0.001332682	,
				0.001331029	,
				0.001329376	,
				0.001327724	,
				0.001326074	,
				0.001324424	,
				0.001322776	,
				0.001321128	,
				0.001319482	,
				0.001317836	,
				0.001316192	,
				0.001314548	,
				0.001312906	,
				0.001311264	,
				0.001309624	,
				0.001307984	,
				0.001306346	,
				0.001304709	,
				0.001303073	,
				0.001301437	,
				0.001299803	,
				0.00129817	,
				0.001296538	,
				0.001294907	,
				0.001293277	,
				0.001291648	,
				0.00129002	,
				0.001288394	,
				0.001286768	,
				0.001285143	,
				0.00128352	,
				0.001281897	,
				0.001280276	,
				0.001278656	,
				0.001277036	,
				0.001275418	,
				0.001273801	,
				0.001272185	,
				0.00127057	,
				0.001268956	,
				0.001267344	,
				0.001265732	,
				0.001264122	,
				0.001262512	,
				0.001260904	,
				0.001259297	,
				0.001257691	,
				0.001256086	,
				0.001254482	,
				0.001252879	,
				0.001251277	,
				0.001249677	,
				0.001248077	,
				0.001246479	,
				0.001244882	,
				0.001243286	,
				0.001241691	,
				0.001240097	,
				0.001238505	,
				0.001236913	,
				0.001235323	,
				0.001233733	,
				0.001232145	,
				0.001230558	,
				0.001228973	,
				0.001227388	,
				0.001225804	,
				0.001224222	,
				0.001222641	,
				0.001221061	,
				0.001219482	,
				0.001217904	,
				0.001216327	,
				0.001214752	,
				0.001213178	,
				0.001211605	,
				0.001210033	,
				0.001208462	,
				0.001206892	,
				0.001205324	,
				0.001203756	,
				0.00120219	,
				0.001200625	,
				0.001199062	,
				0.001197499	,
				0.001195938	,
				0.001194378	,
				0.001192819	,
				0.001191261	,
				0.001189704	,
				0.001188149	,
				0.001186594	,
				0.001185041	,
				0.00118349	,
				0.001181939	,
				0.001180389	,
				0.001178841	,
				0.001177294	,
				0.001175748	,
				0.001174204	,
				0.00117266	,
				0.001171118	,
				0.001169577	,
				0.001168037	,
				0.001166499	,
				0.001164961	,
				0.001163425	,
				0.00116189	,
				0.001160356	,
				0.001158824	,
				0.001157292	,
				0.001155762	,
				0.001154234	,
				0.001152706	,
				0.001151179	,
				0.001149654	,
				0.00114813	,
				0.001146608	,
				0.001145086	,
				0.001143566	,
				0.001142047	,
				0.001140529	,
				0.001139013	,
				0.001137497	,
				0.001135983	,
				0.001134471	,
				0.001132959	,
				0.001131449	,
				0.00112994	,
				0.001128432	,
				0.001126925	,
				0.00112542	,
				0.001123916	,
				0.001122413	,
				0.001120911	,
				0.001119411	,
				0.001117912	,
				0.001116414	,
				0.001114918	,
				0.001113422	,
				0.001111928	,
				0.001110436	,
				0.001108944	,
				0.001107454	,
				0.001105965	,
				0.001104477	,
				0.001102991	,
				0.001101506	,
				0.001100022	,
				0.001098539	,
				0.001097058	,
				0.001095578	,
				0.001094099	,
				0.001092621	,
				0.001091145	,
				0.00108967	,
				0.001088197	,
				0.001086724	,
				0.001085253	,
				0.001083783	,
				0.001082315	,
				0.001080847	,
				0.001079381	,
				0.001077917	,
				0.001076453	,
				0.001074991	,
				0.00107353	,
				0.001072071	,
				0.001070612	,
				0.001069155	,
				0.0010677	,
				0.001066245	,
				0.001064792	,
				0.00106334	,
				0.00106189	,
				0.001060441	,
				0.001058993	,
				0.001057546	,
				0.001056101	,
				0.001054657	,
				0.001053214	,
				0.001051773	,
				0.001050333	,
				0.001048894	,
				0.001047456	,
				0.00104602	,
				0.001044585	,
				0.001043151	,
				0.001041719	,
				0.001040288	,
				0.001038859	,
				0.00103743	,
				0.001036003	,
				0.001034577	,
				0.001033153	,
				0.00103173	,
				0.001030308	,
				0.001028888	,
				0.001027468	,
				0.001026051	,
				0.001024634	,
				0.001023219	,
				0.001021805	,
				0.001020392	,
				0.001018981	,
				0.001017571	,
				0.001016162	,
				0.001014755	,
				0.001013349	,
				0.001011944	,
				0.001010541	,
				0.001009139	,
				0.001007738	,
				0.001006339	,
				0.001004941	,
				0.001003544	,
				0.001002149	,
				0.001000755	,
				0.000999362	,
				0.000997971	,
				0.00099658	,
				0.000995192	,
				0.000993804	,
				0.000992418	,
				0.000991033	,
				0.00098965	,
				0.000988268	,
				0.000986887	,
				0.000985507	,
				0.000984129	,
				0.000982753	,
				0.000981377	,
				0.000980003	,
				0.00097863	,
				0.000977259	,
				0.000975889	,
				0.00097452	,
				0.000973152	,
				0.000971786	,
				0.000970421	,
				0.000969058	,
				0.000967696	,
				0.000966335	,
				0.000964976	,
				0.000963618	,
				0.000962261	,
				0.000960905	,
				0.000959551	,
				0.000958199	,
				0.000956847	,
				0.000955497	,
				0.000954148	,
				0.000952801	,
				0.000951455	,
				0.00095011	,
				0.000948767	,
				0.000947425	,
				0.000946084	,
				0.000944745	,
				0.000943407	,
				0.00094207	,
				0.000940735	,
				0.000939401	,
				0.000938069	,
				0.000936737	,
				0.000935407	,
				0.000934079	,
				0.000932752	,
				0.000931426	,
				0.000930101	,
				0.000928778	,
				0.000927456	,
				0.000926136	,
				0.000924816	,
				0.000923499	,
				0.000922182	,
				0.000920867	,
				0.000919553	,
				0.000918241	,
				0.00091693	,
				0.00091562	,
				0.000914312	,
				0.000913005	,
				0.000911699	,
				0.000910395	,
				0.000909092	,
				0.00090779	,
				0.00090649	,
				0.000905191	,
				0.000903893	,
				0.000902597	,
				0.000901302	,
				0.000900009	,
				0.000898716	,
				0.000897426	,
				0.000896136	,
				0.000894848	,
				0.000893561	,
				0.000892276	,
				0.000890992	,
				0.000889709	,
				0.000888427	,
				0.000887147	,
				0.000885869	,
				0.000884591	,
				0.000883315	,
				0.000882041	,
				0.000880767	,
				0.000879495	,
				0.000878225	,
				0.000876955	,
				0.000875687	,
				0.000874421	,
				0.000873156	,
				0.000871892	,
				0.000870629	,
				0.000869368	,
				0.000868108	,
				0.00086685	,
				0.000865593	,
				0.000864337	,
				0.000863082	,
				0.000861829	,
				0.000860578	,
				0.000859327	,
				0.000858078	,
				0.00085683	,
				0.000855584	,
				0.000854339	,
				0.000853095	,
				0.000851853	,
				0.000850612	,
				0.000849373	,
				0.000848134	,
				0.000846897	,
				0.000845662	,
				0.000844428	,
				0.000843195	,
				0.000841963	,
				0.000840733	,
				0.000839504	,
				0.000838277	,
				0.000837051	,
				0.000835826	,
				0.000834602	,
				0.00083338	,
				0.000832159	,
				0.00083094	,
				0.000829722	,
				0.000828505	,
				0.00082729	,
				0.000826076	,
				0.000824863	,
				0.000823652	,
				0.000822442	,
				0.000821233	,
				0.000820026	,
				0.00081882	,
				0.000817615	,
				0.000816412	,
				0.00081521	,
				0.000814009	,
				0.00081281	,
				0.000811612	,
				0.000810415	,
				0.00080922	,
				0.000808026	,
				0.000806833	,
				0.000805642	,
				0.000804452	,
				0.000803264	,
				0.000802076	,
				0.000800891	,
				0.000799706	,
				0.000798523	,
				0.000797341	,
				0.00079616	,
				0.000794981	,
				0.000793803	,
				0.000792627	,
				0.000791451	,
				0.000790278	,
				0.000789105	,
				0.000787934	,
				0.000786764	,
				0.000785596	,
				0.000784428	,
				0.000783262	,
				0.000782098	,
				0.000780935	,
				0.000779773	,
				0.000778612	,
				0.000777453	,
				0.000776295	,
				0.000775139	,
				0.000773983	,
				0.00077283	,
				0.000771677	,
				0.000770526	,
				0.000769376	,
				0.000768227	,
				0.00076708	,
				0.000765934	,
				0.000764789	,
				0.000763646	,
				0.000762504	,
				0.000761364	,
				0.000760224	,
				0.000759086	,
				0.00075795	,
				0.000756814	,
				0.00075568	,
				0.000754548	,
				0.000753416	,
				0.000752286	,
				0.000751158	,
				0.00075003	,
				0.000748904	,
				0.000747779	,
				0.000746656	,
				0.000745534	,
				0.000744413	,
				0.000743293	,
				0.000742175	,
				0.000741058	,
				0.000739943	,
				0.000738829	,
				0.000737716	,
				0.000736604	,
				0.000735494	,
				0.000734385	,
				0.000733277	,
				0.000732171	,
				0.000731066	,
				0.000729962	,
				0.00072886	,
				0.000727758	,
				0.000726659	,
				0.00072556	,
				0.000724463	,
				0.000723367	,
				0.000722273	,
				0.000721179	,
				0.000720087	,
				0.000718997	,
				0.000717907	,
				0.000716819	,
				0.000715733	,
				0.000714647	,
				0.000713563	,
				0.00071248	,
				0.000711399	,
				0.000710318	,
				0.000709239	,
				0.000708162	,
				0.000707085	,
				0.00070601	,
				0.000704937	,
				0.000703864	,
				0.000702793	,
				0.000701723	,
				0.000700655	,
				0.000699587	,
				0.000698521	,
				0.000697457	,
				0.000696393	,
				0.000695331	,
				0.00069427	,
				0.000693211	,
				0.000692153	,
				0.000691096	,
				0.00069004	,
				0.000688986	,
				0.000687933	,
				0.000686881	,
				0.00068583	,
				0.000684781	,
				0.000683733	,
				0.000682687	,
				0.000681641	,
				0.000680597	,
				0.000679554	,
				0.000678513	,
				0.000677473	,
				0.000676434	,
				0.000675396	,
				0.00067436	,
				0.000673324	,
				0.000672291	,
				0.000671258	,
				0.000670227	,
				0.000669197	,
				0.000668168	,
				0.000667141	,
				0.000666114	,
				0.000665089	,
				0.000664066	,
				0.000663043	,
				0.000662022	,
				0.000661002	,
				0.000659984	,
				0.000658967	,
				0.00065795	,
				0.000656936	,
				0.000655922	,
				0.00065491	,
				0.000653899	,
				0.000652889	,
				0.000651881	,
				0.000650874	,
				0.000649868	,
				0.000648863	,
				0.00064786	,
				0.000646857	,
				0.000645857	,
				0.000644857	,
				0.000643859	,
				0.000642861	,
				0.000641866	,
				0.000640871	,
				0.000639878	,
				0.000638885	,
				0.000637895	,
				0.000636905	,
				0.000635917	,
				0.000634929	,
				0.000633944	,
				0.000632959	,
				0.000631976	,
				0.000630993	,
				0.000630013	,
				0.000629033	,
				0.000628055	,
				0.000627077	,
				0.000626102	,
				0.000625127	,
				0.000624153	,
				0.000623181	,
				0.00062221	,
				0.000621241	,
				0.000620272	,
				0.000619305	,
				0.000618339	,
				0.000617374	,
				0.000616411	,
				0.000615448	,
				0.000614487	,
				0.000613527	,
				0.000612569	,
				0.000611611	,
				0.000610655	,
				0.0006097	,
				0.000608747	,
				0.000607794	,
				0.000606843	,
				0.000605893	,
				0.000604944	,
				0.000603997	,
				0.00060305	,
				0.000602105	,
				0.000601161	,
				0.000600219	,
				0.000599277	,
				0.000598337	,
				0.000597398	,
				0.00059646	,
				0.000595524	,
				0.000594588	,
				0.000593654	,
				0.000592721	,
				0.000591789	,
				0.000590859	,
				0.000589929	,
				0.000589001	,
				0.000588074	,
				0.000587149	,
				0.000586224	,
				0.000585301	,
				0.000584379	,
				0.000583458	,
				0.000582538	,
				0.00058162	,
				0.000580703	,
				0.000579787	,
				0.000578872	,
				0.000577958	,
				0.000577046	,
				0.000576134	,
				0.000575224	,
				0.000574315	,
				0.000573408	,
				0.000572501	,
				0.000571596	,
				0.000570692	,
				0.000569789	,
				0.000568887	,
				0.000567987	,
				0.000567087	,
				0.000566189	,
				0.000565292	,
				0.000564396	,
				0.000563502	,
				0.000562608	,
				0.000561716	,
				0.000560825	,
				0.000559935	,
				0.000559046	,
				0.000558159	,
				0.000557273	,
				0.000556387	,
				0.000555503	,
				0.000554621	,
				0.000553739	,
				0.000552859	,
				0.000551979	,
				0.000551101	,
				0.000550224	,
				0.000549348	,
				0.000548474	,
				0.0005476	,
				0.000546728	,
				0.000545857	,
				0.000544987	,
				0.000544118	,
				0.000543251	,
				0.000542384	,
				0.000541519	,
				0.000540655	,
				0.000539792	,
				0.00053893	,
				0.000538069	,
				0.00053721	,
				0.000536351	,
				0.000535494	,
				0.000534638	,
				0.000533783	,
				0.000532929	,
				0.000532077	,
				0.000531225	,
				0.000530375	,
				0.000529526	,
				0.000528678	,
				0.000527831	,
				0.000526985	,
				0.000526141	,
				0.000525297	,
				0.000524455	,
				0.000523614	,
				0.000522774	,
				0.000521935	,
				0.000521097	,
				0.000520261	,
				0.000519425	,
				0.000518591	,
				0.000517758	,
				0.000516926	,
				0.000516095	,
				0.000515265	,
				0.000514437	,
				0.000513609	,
				0.000512783	,
				0.000511957	,
				0.000511133	,
				0.00051031	,
				0.000509488	,
				0.000508668	,
				0.000507848	,
				0.000507029	,
				0.000506212	,
				0.000505396	,
				0.00050458	,
				0.000503766	,
				0.000502953	,
				0.000502142	,
				0.000501331	,
				0.000500521	,
				0.000499713	,
				0.000498906	,
				0.000498099	,
				0.000497294	,
				0.00049649	,
				0.000495687	,
				0.000494885	,
				0.000494085	,
				0.000493285	,
				0.000492486	,
				0.000491689	,
				0.000490893	,
				0.000490098	,
				0.000489303	,
				0.00048851	,
				0.000487719	,
				0.000486928	,
				0.000486138	,
				0.000485349	,
				0.000484562	,
				0.000483775	,
				0.00048299	,
				0.000482206	,
				0.000481423	,
				0.000480641	,
				0.00047986	,
				0.00047908	,
				0.000478301	,
				0.000477523	,
				0.000476746	,
				0.000475971	,
				0.000475196	,
				0.000474423	,
				0.000473651	,
				0.000472879	,
				0.000472109	,
				0.00047134	,
				0.000470572	,
				0.000469805	,
				0.000469039	,
				0.000468274	,
				0.000467511	,
				0.000466748	,
				0.000465986	,
				0.000465226	,
				0.000464466	,
				0.000463708	,
				0.000462951	,
				0.000462194	,
				0.000461439	,
				0.000460685	,
				0.000459932	,
				0.00045918	,
				0.000458429	,
				0.000457679	,
				0.00045693	,
				0.000456182	,
				0.000455436	,
				0.00045469	,
				0.000453945	,
				0.000453202	,
				0.000452459	,
				0.000451718	,
				0.000450977	,
				0.000450238	,
				0.0004495	,
				0.000448762	,
				0.000448026	,
				0.000447291	,
				0.000446557	,
				0.000445824	,
				0.000445092	,
				0.000444361	,
				0.000443631	,
				0.000442902	,
				0.000442174	,
				0.000441447	,
				0.000440721	,
				0.000439996	,
				0.000439272	,
				0.00043855	,
				0.000437828	,
				0.000437107	,
				0.000436387	,
				0.000435669	,
				0.000434951	,
				0.000434235	,
				0.000433519	,
				0.000432804	,
				0.000432091	,
				0.000431378	,
				0.000430667	,
				0.000429956	,
				0.000429247	,
				0.000428538	,
				0.000427831	,
				0.000427125	,
				0.000426419	,
				0.000425715	,
				0.000425012	,
				0.000424309	,
				0.000423608	,
				0.000422907	,
				0.000422208	,
				0.00042151	,
				0.000420812	,
				0.000420116	,
				0.000419421	,
				0.000418727	,
				0.000418033	,
				0.000417341	,
				0.00041665	,
				0.000415959	,
				0.00041527	,
				0.000414582	,
				0.000413894	,
				0.000413208	,
				0.000412523	,
				0.000411838	,
				0.000411155	,
				0.000410472	,
				0.000409791	,
				0.000409111	,
				0.000408431	,
				0.000407753	,
				0.000407075	,
				0.000406399	,
				0.000405723	,
				0.000405049	,
				0.000404375	,
				0.000403703	,
				0.000403031	,
				0.000402361	,
				0.000401691	,
				0.000401023	,
				0.000400355	,
				0.000399688	,
				0.000399022	,
				0.000398358	,
				0.000397694	,
				0.000397031	,
				0.000396369	,
				0.000395708	,
				0.000395049	,
				0.00039439	,
				0.000393732	,
				0.000393075	,
				0.000392419	,
				0.000391763	,
				0.000391109	,
				0.000390456	,
				0.000389804	,
				0.000389153	,
				0.000388502	,
				0.000387853	,
				0.000387205	,
				0.000386557	,
				0.000385911	,
				0.000385265	,
				0.000384621	,
				0.000383977	,
				0.000383334	,
				0.000382692	,
				0.000382052	,
				0.000381412	,
				0.000380773	,
				0.000380135	,
				0.000379498	,
				0.000378862	,
				0.000378226	,
				0.000377592	,
				0.000376959	,
				0.000376327	,
				0.000375695	,
				0.000375065	,
				0.000374435	,
				0.000373806	,
				0.000373179	,
				0.000372552	,
				0.000371926	,
				0.000371301	,
				0.000370677	,
				0.000370054	,
				0.000369432	,
				0.000368811	,
				0.000368191	,
				0.000367571	,
				0.000366953	,
				0.000366335	,
				0.000365719	,
				0.000365103	,
				0.000364488	,
				0.000363874	,
				0.000363261	,
				0.000362649	,
				0.000362038	,
				0.000361428	,
				0.000360819	,
				0.00036021	,
				0.000359603	,
				0.000358996	,
				0.00035839	,
				0.000357786	,
				0.000357182	,
				0.000356579	,
				0.000355977	,
				0.000355375	,
				0.000354775	,
				0.000354176	,
				0.000353577	,
				0.00035298	,
				0.000352383	,
				0.000351787	,
				0.000351192	,
				0.000350598	,
				0.000350005	,
				0.000349413	,
				0.000348822	,
				0.000348231	,
				0.000347642	,
				0.000347053	,
				0.000346465	,
				0.000345878	,
				0.000345292	,
				0.000344707	,
				0.000344123	,
				0.000343539	,
				0.000342957	,
				0.000342375	,
				0.000341794	,
				0.000341215	,
				0.000340636	,
				0.000340057	,
				0.00033948	,
				0.000338904	,
				0.000338328	,
				0.000337754	,
				0.00033718	,
				0.000336607	,
				0.000336035	,
				0.000335464	,
				0.000334893	,
				0.000334324	,
				0.000333755	,
				0.000333188	,
				0.000332621	,
				0.000332055	,
				0.000331489	,
				0.000330925	,
				0.000330362	,
				0.000329799	,
				0.000329237	,
				0.000328677	,
				0.000328117	,
				0.000327557	,
				0.000326999	,
				0.000326442	,
				0.000325885	,
				0.000325329	,
				0.000324774	,
				0.00032422	,
				0.000323667	,
				0.000323114	,
				0.000322563	,
				0.000322012	,
				0.000321462	,
				0.000320913	,
				0.000320365	,
				0.000319818	,
				0.000319271	,
				0.000318725	,
				0.00031818	,
				0.000317636	,
				0.000317093	,
				0.000316551	,
				0.000316009	,
				0.000315469	,
				0.000314929	,
				0.00031439	,
				0.000313851	,
				0.000313314	,
				0.000312777	,
				0.000312242	,
				0.000311707	,
				0.000311173	,
				0.000310639	,
				0.000310107	,
				0.000309575	,
				0.000309044	,
				0.000308514	,
				0.000307985	,
				0.000307457	,
				0.000306929	,
				0.000306402	,
				0.000305876	,
				0.000305351	,
				0.000304827	,
				0.000304303	,
				0.00030378	,
				0.000303258	,
				0.000302737	,
				0.000302217	,
				0.000301697	,
				0.000301179	,
				0.000300661	,
				0.000300144	,
				0.000299627	,
				0.000299112	,
				0.000298597	,
				0.000298083	,
				0.00029757	,
				0.000297058	,
				0.000296546	,
				0.000296035	,
				0.000295525	,
				0.000295016	,
				0.000294508	,
				0.000294	,
				0.000293493	,
				0.000292987	,
				0.000292482	,
				0.000291978	,
				0.000291474	,
				0.000290971	,
				0.000290469	,
				0.000289968	,
				0.000289467	,
				0.000288967	,
				0.000288468	,
				0.00028797	,
				0.000287473	,
				0.000286976	,
				0.00028648	,
				0.000285985	,
				0.000285491	,
				0.000284997	,
				0.000284504	,
				0.000284012	,
				0.000283521	,
				0.00028303	,
				0.000282541	,
				0.000282052	,
				0.000281563	,
				0.000281076	,
				0.000280589	,
				0.000280103	,
				0.000279618	,
				0.000279134	,
				0.00027865	,
				0.000278167	,
				0.000277685	,
				0.000277203	,
				0.000276723	,
				0.000276243	,
				0.000275764	,
				0.000275285	,
				0.000274808	,
				0.000274331	,
				0.000273855	,
				0.000273379	,
				0.000272905	,
				0.000272431	,
				0.000271958	,
				0.000271485	,
				0.000271014	,
				0.000270543	,
				0.000270072	,
				0.000269603	,
				0.000269134	,
				0.000268666	,
				0.000268199	,
				0.000267732	,
				0.000267267	,
				0.000266802	,
				0.000266337	,
				0.000265874	,
				0.000265411	,
				0.000264949	,
				0.000264487	,
				0.000264027	,
				0.000263567	,
				0.000263108	,
				0.000262649	,
				0.000262191	,
				0.000261734	,
				0.000261278	,
				0.000260822	,
				0.000260368	,
				0.000259913	,
				0.00025946	,
				0.000259007	,
				0.000258555	,
				0.000258104	,
				0.000257653	,
				0.000257204	,
				0.000256754	,
				0.000256306	,
				0.000255858	,
				0.000255411	,
				0.000254965	,
				0.000254519	,
				0.000254074	,
				0.00025363	,
				0.000253187	,
				0.000252744	,
				0.000252302	,
				0.000251861	,
				0.00025142	,
				0.00025098	,
				0.000250541	,
				0.000250102	,
				0.000249664	,
				0.000249227	,
				0.000248791	,
				0.000248355	,
				0.00024792	,
				0.000247485	,
				0.000247052	,
				0.000246619	,
				0.000246186	,
				0.000245755	,
				0.000245324	,
				0.000244894	,
				0.000244464	,
				0.000244035	,
				0.000243607	,
				0.000243179	,
				0.000242753	,
				0.000242326	,
				0.000241901	,
				0.000241476	,
				0.000241052	,
				0.000240629	,
				0.000240206	,
				0.000239784	,
				0.000239363	,
				0.000238942	,
				0.000238522	,
				0.000238102	,
				0.000237684	,
				0.000237266	,
				0.000236848	,
				0.000236432	,
				0.000236016	,
				0.0002356	,
				0.000235186	,
				0.000234772	,
				0.000234358	,
				0.000233946	,
				0.000233533	,
				0.000233122	,
				0.000232711	,
				0.000232301	,
				0.000231892	,
				0.000231483	,
				0.000231075	,
				0.000230668	,
				0.000230261	,
				0.000229855	,
				0.00022945	,
				0.000229045	,
				0.000228641	,
				0.000228237	,
				0.000227834	,
				0.000227432	,
				0.000227031	,
				0.00022663	,
				0.000226229	,
				0.00022583	,
				0.000225431	,
				0.000225033	,
				0.000224635	,
				0.000224238	,
				0.000223842	,
				0.000223446	,
				0.000223051	,
				0.000222656	,
				0.000222262	,
				0.000221869	,
				0.000221477	,
				0.000221085	,
				0.000220694	,
				0.000220303	,
				0.000219913	,
				0.000219524	,
				0.000219135	,
				0.000218747	,
				0.000218359	,
				0.000217972	,
				0.000217586	,
				0.000217201	,
				0.000216816	,
				0.000216431	,
				0.000216048	,
				0.000215664	,
				0.000215282	,
				0.0002149	,
				0.000214519	,
				0.000214138	,
				0.000213758	,
				0.000213379	,
				0.000213	,
				0.000212622	,
				0.000212244	,
				0.000211868	,
				0.000211491	,
				0.000211116	,
				0.000210741	,
				0.000210366	,
				0.000209992	,
				0.000209619	,
				0.000209246	,
				0.000208874	,
				0.000208503	,
				0.000208132	,
				0.000207762	,
				0.000207392	,
				0.000207023	,
				0.000206655	,
				0.000206287	,
				0.00020592	,
				0.000205553	,
				0.000205187	,
				0.000204822	,
				0.000204457	,
				0.000204093	,
				0.000203729	,
				0.000203366	,
				0.000203004	,
				0.000202642	,
				0.000202281	,
				0.00020192	,
				0.00020156	,
				0.000201201	,
				0.000200842	,
				0.000200484	,
				0.000200126	,
				0.000199769	,
				0.000199413	,
				0.000199057	,
				0.000198701	,
				0.000198347	,
				0.000197992	,
				0.000197639	,
				0.000197286	,
				0.000196933	,
				0.000196582	,
				0.00019623	,
				0.00019588	,
				0.00019553	,
				0.00019518	,
				0.000194831	,
				0.000194483	,
				0.000194135	,
				0.000193788	,
				0.000193441	,
				0.000193095	,
				0.000192749	,
				0.000192404	,
				0.00019206	,
				0.000191716	,
				0.000191373	,
				0.00019103	,
				0.000190688	,
				0.000190347	,
				0.000190006	,
				0.000189665	,
				0.000189325	,
				0.000188986	,
				0.000188647	,
				0.000188309	,
				0.000187972	,
				0.000187635	,
				0.000187298	,
				0.000186962	,
				0.000186627	,
				0.000186292	,
				0.000185958	,
				0.000185624	,
				0.000185291	,
				0.000184958	,
				0.000184626	,
				0.000184295	,
				0.000183964	,
				0.000183633	,
				0.000183303	,
				0.000182974	,
				0.000182645	,
				0.000182317	,
				0.000181989	,
				0.000181662	,
				0.000181336	,
				0.00018101	,
				0.000180684	,
				0.000180359	,
				0.000180035	,
				0.000179711	,
				0.000179387	,
				0.000179065	,
				0.000178742	,
				0.000178421	,
				0.000178099	,
				0.000177779	,
				0.000177459	,
				0.000177139	,
				0.00017682	,
				0.000176501	,
				0.000176183	,
				0.000175866	,
				0.000175549	,
				0.000175233	,
				0.000174917	,
				0.000174601	,
				0.000174287	,
				0.000173972	,
				0.000173658	,
				0.000173345	,
				0.000173032	,
				0.00017272	,
				0.000172409	,
				0.000172097	,
				0.000171787	,
				0.000171477	,
				0.000171167	,
				0.000170858	,
				0.000170549	,
				0.000170241	,
				0.000169934	,
				0.000169627	,
				0.00016932	,
				0.000169014	,
				0.000168709	,
				0.000168404	,
				0.000168099	,
				0.000167795	,
				0.000167492	,
				0.000167189	,
				0.000166887	,
				0.000166585	,
				0.000166283	,
				0.000165982	,
				0.000165682	,
				0.000165382	,
				0.000165083	,
				0.000164784	,
				0.000164485	,
				0.000164187	,
				0.00016389	,
				0.000163593	,
				0.000163297	,
				0.000163001	,
				0.000162706	,
				0.000162411	,
				0.000162116	,
				0.000161822	,
				0.000161529	,
				0.000161236	,
				0.000160944	,
				0.000160652	,
				0.00016036	,
				0.000160069	,
				0.000159779	,
				0.000159489	,
				0.000159199	,
				0.00015891	,
				0.000158622	,
				0.000158334	,
				0.000158046	,
				0.000157759	,
				0.000157473	,
				0.000157187	,
				0.000156901	,
				0.000156616	,
				0.000156331	,
				0.000156047	,
				0.000155764	,
				0.00015548	,
				0.000155198	,
				0.000154916	,
				0.000154634	,
				0.000154353	,
				0.000154072	,
				0.000153791	,
				0.000153512	,
				0.000153232	,
				0.000152953	,
				0.000152675	,
				0.000152397	,
				0.000152119	,
				0.000151842	,
				0.000151566	,
				0.00015129	,
				0.000151014	,
				0.000150739	,
				0.000150464	,
				0.00015019	,
				0.000149916	,
				0.000149643	,
				0.00014937	,
				0.000149098	,
				0.000148826	,
				0.000148555	,
				0.000148284	,
				0.000148013	,
				0.000147743	,
				0.000147474	,
				0.000147205	,
				0.000146936	,
				0.000146668	,
				0.0001464	,
				0.000146133	,
				0.000145866	,
				0.000145599	,
				0.000145334	,
				0.000145068	,
				0.000144803	,
				0.000144538	,
				0.000144274	,
				0.000144011	,
				0.000143747	,
				0.000143485	,
				0.000143222	,
				0.00014296	,
				0.000142699	,
				0.000142438	,
				0.000142177	,
				0.000141917	,
				0.000141658	,
				0.000141399	,
				0.00014114	,
				0.000140881	,
				0.000140624	,
				0.000140366	,
				0.000140109	,
				0.000139853	,
				0.000139596	,
				0.000139341	,
				0.000139086	,
				0.000138831	,
				0.000138576	,
				0.000138322	,
				0.000138069	,
				0.000137816	,
				0.000137563	,
				0.000137311	,
				0.000137059	,
				0.000136808	,
				0.000136557	,
				0.000136306	,
				0.000136056	,
				0.000135807	,
				0.000135558	,
				0.000135309	,
				0.000135061	,
				0.000134813	,
				0.000134565	,
				0.000134318	,
				0.000134071	,
				0.000133825	,
				0.000133579	,
				0.000133334	,
				0.000133089	,
				0.000132845	,
				0.0001326	,
				0.000132357	,
				0.000132114	,
				0.000131871	,
				0.000131628	,
				0.000131386	,
				0.000131145	,
				0.000130903	,
				0.000130663	,
				0.000130422	,
				0.000130182	,
				0.000129943	,
				0.000129704	,
				0.000129465	,
				0.000129227	,
				0.000128989	,
				0.000128751	,
				0.000128514	,
				0.000128278	,
				0.000128041	,
				0.000127806	,
				0.00012757	,
				0.000127335	,
				0.000127101	,
				0.000126866	,
				0.000126633	,
				0.000126399	,
				0.000126166	,
				0.000125934	,
				0.000125701	,
				0.00012547	,
				0.000125238	,
				0.000125007	,
				0.000124777	,
				0.000124546	,
				0.000124317	,
				0.000124087	,
				0.000123858	,
				0.00012363	,
				0.000123401	,
				0.000123174	,
				0.000122946	,
				0.000122719	,
				0.000122493	,
				0.000122266	,
				0.00012204	,
				0.000121815	,
				0.00012159	,
				0.000121365	,
				0.000121141	,
				0.000120917	,
				0.000120694	,
				0.00012047	,
				0.000120248	,
				0.000120025	,
				0.000119803	,
				0.000119582	,
				0.000119361	,
				0.00011914	,
				0.000118919	,
				0.000118699	,
				0.00011848	,
				0.00011826	,
				0.000118041	,
				0.000117823	,
				0.000117605	,
				0.000117387	,
				0.00011717	,
				0.000116953	,
				0.000116736	,
				0.00011652	,
				0.000116304	,
				0.000116088	,
				0.000115873	,
				0.000115659	,
				0.000115444	,
				0.00011523	,
				0.000115017	,
				0.000114803	,
				0.00011459	,
				0.000114378	,
				0.000114166	,
				0.000113954	,
				0.000113743	,
				0.000113532	,
				0.000113321	,
				0.000113111	,
				0.000112901	,
				0.000112691	,
				0.000112482	,
				0.000112273	,
				0.000112065	,
				0.000111857	,
				0.000111649	,
				0.000111441	,
				0.000111234	,
				0.000111028	,
				0.000110822	,
				0.000110616	,
				0.00011041	,
				0.000110205	,
				0.00011	,
				0.000109795	,
				0.000109591	,
				0.000109388	,
				0.000109184	,
				0.000108981	,
				0.000108778	,
				0.000108576	,
				0.000108374	,
				0.000108172	,
				0.000107971	,
				0.00010777	,
				0.00010757	,
				0.000107369	,
				0.000107169	,
				0.00010697	,
				0.000106771	,
				0.000106572	,
				0.000106373	,
				0.000106175	,
				0.000105977	,
				0.00010578	,
				0.000105583	,
				0.000105386	,
				0.00010519	,
				0.000104994	,
				0.000104798	,
				0.000104603	,
				0.000104408	,
				0.000104213	,
				0.000104019	,
				0.000103825	,
				0.000103631	,
				0.000103438	,
				0.000103245	,
				0.000103052	,
				0.00010286	,
				0.000102668	,
				0.000102476	,
				0.000102285	,
				0.000102094	,
				0.000101903	,
				0.000101713	,
				0.000101523	,
				0.000101333	,
				0.000101144	,
				0.000100955	,
				0.000100766	,
				0.000100578	,
				0.00010039	,
				0.000100203	,
				0.000100015	,
				9.98284E-05	,
				9.96418E-05	,
				9.94555E-05	,
				9.92695E-05	,
				9.90839E-05	,
				9.88986E-05	,
				9.87136E-05	,
				9.85289E-05	,
				9.83446E-05	,
				9.81606E-05	,
				9.79769E-05	,
				9.77936E-05	,
				9.76105E-05	,
				9.74278E-05	,
				9.72454E-05	,
				9.70634E-05	,
				9.68816E-05	,
				9.67002E-05	,
				9.65191E-05	,
				9.63383E-05	,
				9.61579E-05	,
				9.59777E-05	,
				9.57979E-05	,
				9.56184E-05	,
				9.54392E-05	,
				9.52604E-05	,
				9.50818E-05	,
				9.49036E-05	,
				9.47257E-05	,
				9.45481E-05	,
				9.43708E-05	,
				9.41938E-05	,
				9.40171E-05	,
				9.38408E-05	,
				9.36647E-05	,
				9.3489E-05	,
				9.33136E-05	,
				9.31385E-05	,
				9.29637E-05	,
				9.27892E-05	,
				9.26151E-05	,
				9.24412E-05	,
				9.22677E-05	,
				9.20944E-05	,
				9.19215E-05	,
				9.17488E-05	,
				9.15765E-05	,
				9.14045E-05	,
				9.12328E-05	,
				9.10614E-05	,
				9.08903E-05	,
				9.07195E-05	,
				9.0549E-05	,
				9.03788E-05	,
				9.02089E-05	,
				9.00393E-05	,
				8.987E-05	,
				8.97011E-05	,
				8.95324E-05	,
				8.9364E-05	,
				8.91959E-05	,
				8.90281E-05	,
				8.88606E-05	,
				8.86934E-05	,
				8.85266E-05	,
				8.836E-05	,
				8.81937E-05	,
				8.80277E-05	,
				8.7862E-05	,
				8.76966E-05	,
				8.75315E-05	,
				8.73666E-05	,
				8.72021E-05	,
				8.70379E-05	,
				8.68739E-05	,
				8.67103E-05	,
				8.65469E-05	,
				8.63839E-05	,
				8.62211E-05	,
				8.60586E-05	,
				8.58964E-05	,
				8.57345E-05	,
				8.55729E-05	,
				8.54116E-05	,
				8.52506E-05	,
				8.50898E-05	,
				8.49293E-05	,
				8.47692E-05	,
				8.46093E-05	,
				8.44497E-05	,
				8.42904E-05	,
				8.41313E-05	,
				8.39726E-05	,
				8.38141E-05	,
				8.36559E-05	,
				8.3498E-05	,
				8.33404E-05	,
				8.31831E-05	,
				8.3026E-05	,
				8.28693E-05	,
				8.27128E-05	,
				8.25566E-05	,
				8.24006E-05	,
				8.2245E-05	,
				8.20896E-05	,
				8.19345E-05	,
				8.17797E-05	,
				8.16252E-05	,
				8.14709E-05	,
				8.13169E-05	,
				8.11632E-05	,
				8.10098E-05	,
				8.08566E-05	,
				8.07037E-05	,
				8.05511E-05	,
				8.03988E-05	,
				8.02467E-05	,
				8.00949E-05	,
				7.99434E-05	,
				7.97922E-05	,
				7.96412E-05	,
				7.94905E-05	,
				7.93401E-05	,
				7.91899E-05	,
				7.904E-05	,
				7.88904E-05	,
				7.8741E-05	,
				7.8592E-05	,
				7.84431E-05	,
				7.82946E-05	,
				7.81463E-05	,
				7.79983E-05	,
				7.78505E-05	,
				7.77031E-05	,
				7.75558E-05	,
				7.74089E-05	,
				7.72622E-05	,
				7.71158E-05	,
				7.69696E-05	,
				7.68237E-05	,
				7.66781E-05	,
				7.65327E-05	,
				7.63876E-05	,
				7.62427E-05	,
				7.60981E-05	,
				7.59538E-05	,
				7.58097E-05	,
				7.56659E-05	,
				7.55224E-05	,
				7.53791E-05	,
				7.5236E-05	,
				7.50933E-05	,
				7.49508E-05	,
				7.48085E-05	,
				7.46665E-05	,
				7.45247E-05	,
				7.43832E-05	,
				7.4242E-05	,
				7.4101E-05	,
				7.39603E-05	,
				7.38198E-05	,
				7.36796E-05	,
				7.35396E-05	,
				7.33999E-05	,
				7.32604E-05	,
				7.31212E-05	,
				7.29823E-05	,
				7.28436E-05	,
				7.27051E-05	,
				7.25669E-05	,
				7.24289E-05	,
				7.22912E-05	,
				7.21538E-05	,
				7.20166E-05	,
				7.18796E-05	,
				7.17429E-05	,
				7.16064E-05	,
				7.14702E-05	,
				7.13342E-05	,
				7.11985E-05	,
				7.1063E-05	,
				7.09278E-05	,
				7.07928E-05	,
				7.0658E-05	,
				7.05235E-05	,
				7.03893E-05	,
				7.02553E-05	,
				7.01215E-05	,
				6.99879E-05	,
				6.98547E-05	,
				6.97216E-05	,
				6.95888E-05	,
				6.94562E-05	,
				6.93239E-05	,
				6.91918E-05	,
				6.906E-05	,
				6.89284E-05	,
				6.8797E-05	,
				6.86659E-05	,
				6.8535E-05	,
				6.84043E-05	,
				6.82739E-05	,
				6.81437E-05	,
				6.80138E-05	,
				6.78841E-05	,
				6.77546E-05	,
				6.76254E-05	,
				6.74964E-05	,
				6.73676E-05	,
				6.7239E-05	,
				6.71107E-05	,
				6.69827E-05	,
				6.68548E-05	,
				6.67272E-05	,
				6.65999E-05	,
				6.64727E-05	,
				6.63458E-05	,
				6.62191E-05	,
				6.60927E-05	,
				6.59665E-05	,
				6.58405E-05	,
				6.57147E-05	,
				6.55892E-05	,
				6.54639E-05	,
				6.53388E-05	,
				6.5214E-05	,
				6.50894E-05	,
				6.4965E-05	,
				6.48408E-05	,
				6.47169E-05	,
				6.45932E-05	,
				6.44697E-05	,
				6.43464E-05	,
				6.42234E-05	,
				6.41006E-05	,
				6.3978E-05	,
				6.38556E-05	,
				6.37335E-05	,
				6.36115E-05	,
				6.34898E-05	,
				6.33684E-05	,
				6.32471E-05	,
				6.31261E-05	,
				6.30053E-05	,
				6.28847E-05	,
				6.27643E-05	,
				6.26441E-05	,
				6.25242E-05	,
				6.24045E-05	,
				6.2285E-05	,
				6.21657E-05	,
				6.20467E-05	,
				6.19278E-05	,
				6.18092E-05	,
				6.16908E-05	,
				6.15726E-05	,
				6.14546E-05	,
				6.13369E-05	,
				6.12193E-05	,
				6.1102E-05	,
				6.09849E-05	,
				6.0868E-05	,
				6.07513E-05	,
				6.06348E-05	,
				6.05186E-05	,
				6.04025E-05	,
				6.02867E-05	,
				6.01711E-05	,
				6.00557E-05	,
				5.99405E-05	,
				5.98255E-05	,
				5.97107E-05	,
				5.95961E-05	,
				5.94818E-05	,
				5.93676E-05	,
				5.92537E-05	,
				5.91399E-05	,
				5.90264E-05	,
				5.89131E-05	,
				5.88E-05	,
				5.86871E-05	,
				5.85744E-05	,
				5.84619E-05	,
				5.83496E-05	,
				5.82376E-05	,
				5.81257E-05	,
				5.8014E-05	,
				5.79026E-05	,
				5.77913E-05	,
				5.76803E-05	,
				5.75694E-05	,
				5.74588E-05	,
				5.73484E-05	,
				5.72381E-05	,
				5.71281E-05	,
				5.70183E-05	,
				5.69086E-05	,
				5.67992E-05	,
				5.669E-05	,
				5.65809E-05	,
				5.64721E-05	,
				5.63635E-05	,
				5.62551E-05	,
				5.61468E-05	,
				5.60388E-05	,
				5.5931E-05	,
				5.58233E-05	,
				5.57159E-05	,
				5.56087E-05	,
				5.55016E-05	,
				5.53948E-05	,
				5.52881E-05	,
				5.51817E-05	,
				5.50754E-05	,
				5.49694E-05	,
				5.48635E-05	,
				5.47579E-05	,
				5.46524E-05	,
				5.45471E-05	,
				5.4442E-05	,
				5.43371E-05	,
				5.42324E-05	,
				5.41279E-05	,
				5.40236E-05	,
				5.39195E-05	,
				5.38156E-05	,
				5.37118E-05	,
				5.36083E-05	,
				5.35049E-05	,
				5.34018E-05	,
				5.32988E-05	,
				5.3196E-05	,
				5.30934E-05	,
				5.2991E-05	,
				5.28888E-05	,
				5.27868E-05	,
				5.26849E-05	,
				5.25833E-05	,
				5.24818E-05	,
				5.23805E-05	,
				5.22795E-05	,
				5.21786E-05	,
				5.20778E-05	,
				5.19773E-05	,
				5.1877E-05	,
				5.17768E-05	,
				5.16768E-05	,
				5.1577E-05	,
				5.14774E-05	,
				5.1378E-05	,
				5.12788E-05	,
				5.11797E-05	,
				5.10809E-05	,
				5.09822E-05	,
				5.08837E-05	,
				5.07853E-05	,
				5.06872E-05	,
				5.05892E-05	,
				5.04915E-05	,
				5.03939E-05	,
				5.02965E-05	,
				5.01992E-05	,
				5.01022E-05	,
				5.00053E-05	,
				4.99086E-05	,
				4.98121E-05	,
				4.97157E-05	,
				4.96196E-05	,
				4.95236E-05	,
				4.94278E-05	,
				4.93322E-05	,
				4.92367E-05	,
				4.91414E-05	,
				4.90463E-05	,
				4.89514E-05	,
				4.88567E-05	,
				4.87621E-05	,
				4.86677E-05	,
				4.85735E-05	,
				4.84795E-05	,
				4.83856E-05	,
				4.82919E-05	,
				4.81984E-05	,
				4.8105E-05	,
				4.80118E-05	,
				4.79188E-05	,
				4.7826E-05	,
				4.77334E-05	,
				4.76409E-05	,
				4.75486E-05	,
				4.74564E-05	,
				4.73645E-05	,
				4.72727E-05	,
				4.7181E-05	,
				4.70896E-05	,
				4.69983E-05	,
				4.69072E-05	,
				4.68162E-05	,
				4.67254E-05	,
				4.66348E-05	,
				4.65444E-05	,
				4.64541E-05	,
				4.6364E-05	,
				4.6274E-05	,
				4.61843E-05	,
				4.60947E-05	,
				4.60052E-05	,
				4.5916E-05	,
				4.58269E-05	,
				4.57379E-05	,
				4.56491E-05	,
				4.55605E-05	,
				4.54721E-05	,
				4.53838E-05	,
				4.52957E-05	,
				4.52077E-05	,
				4.51199E-05	,
				4.50323E-05	,
				4.49449E-05	,
				4.48576E-05	,
				4.47704E-05	,
				4.46835E-05	,
				4.45966E-05	,
				4.451E-05	,
				4.44235E-05	,
				4.43372E-05	,
				4.4251E-05	,
				4.4165E-05	,
				4.40792E-05	,
				4.39935E-05	,
				4.3908E-05	,
				4.38226E-05	,
				4.37374E-05	,
				4.36523E-05	,
				4.35675E-05	,
				4.34827E-05	,
				4.33981E-05	,
				4.33137E-05	,
				4.32295E-05	,
				4.31454E-05	,
				4.30614E-05	,
				4.29777E-05	,
				4.2894E-05	,
				4.28106E-05	,
				4.27272E-05	,
				4.26441E-05	,
				4.25611E-05	,
				4.24782E-05	,
				4.23955E-05	,
				4.2313E-05	,
				4.22306E-05	,
				4.21484E-05	,
				4.20663E-05	,
				4.19844E-05	,
				4.19026E-05	,
				4.1821E-05	,
				4.17395E-05	,
				4.16582E-05	,
				4.1577E-05	,
				4.1496E-05	,
				4.14152E-05	,
				4.13344E-05	,
				4.12539E-05	,
				4.11735E-05	,
				4.10932E-05	,
				4.10131E-05	,
				4.09332E-05	,
				4.08534E-05	,
				4.07737E-05	,
				4.06942E-05	,
				4.06148E-05	,
				4.05356E-05	,
				4.04566E-05	,
				4.03777E-05	,
				4.02989E-05	,
				4.02203E-05	,
				4.01418E-05	,
				4.00635E-05	,
				3.99853E-05	,
				3.99073E-05	,
				3.98294E-05	,
				3.97517E-05	,
				3.96741E-05	,
				3.95966E-05	,
				3.95193E-05	,
				3.94422E-05	,
				3.93652E-05	,
				3.92883E-05	,
				3.92116E-05	,
				3.9135E-05	,
				3.90586E-05	,
				3.89823E-05	,
				3.89061E-05	,
				3.88301E-05	,
				3.87543E-05	,
				3.86786E-05	,
				3.8603E-05	,
				3.85275E-05	,
				3.84523E-05	,
				3.83771E-05	,
				3.83021E-05	,
				3.82272E-05	,
				3.81525E-05	,
				3.80779E-05	,
				3.80035E-05	,
				3.79292E-05	,
				3.7855E-05	,
				3.7781E-05	,
				3.77071E-05	,
				3.76333E-05	,
				3.75597E-05	,
				3.74862E-05	,
				3.74129E-05	,
				3.73397E-05	,
				3.72666E-05	,
				3.71937E-05	,
				3.71209E-05	,
				3.70483E-05	,
				3.69758E-05	,
				3.69034E-05	,
				3.68312E-05	,
				3.67591E-05	,
				3.66871E-05	,
				3.66153E-05	,
				3.65436E-05	,
				3.6472E-05	,
				3.64006E-05	,
				3.63293E-05	,
				3.62581E-05	,
				3.61871E-05	,
				3.61162E-05	,
				3.60455E-05	,
				3.59749E-05	,
				3.59044E-05	,
				3.5834E-05	,
				3.57638E-05	,
				3.56937E-05	,
				3.56237E-05	,
				3.55539E-05	,
				3.54842E-05	,
				3.54147E-05	,
				3.53452E-05	,
				3.52759E-05	,
				3.52068E-05	,
				3.51377E-05	,
				3.50688E-05	,
				3.5E-05	,
				3.49314E-05	,
				3.48629E-05	,
				3.47945E-05	,
				3.47262E-05	,
				3.46581E-05	,
				3.45901E-05	,
				3.45222E-05	,
				3.44545E-05	,
				3.43868E-05	,
				3.43193E-05	,
				3.4252E-05	,
				3.41848E-05	,
				3.41176E-05	,
				3.40507E-05	,
				3.39838E-05	,
				3.39171E-05	,
				3.38505E-05	,
				3.3784E-05	,
				3.37176E-05	,
				3.36514E-05	,
				3.35853E-05	,
				3.35193E-05	,
				3.34535E-05	,
				3.33878E-05	,
				3.33222E-05	,
				3.32567E-05	,
				3.31913E-05	,
				3.31261E-05	,
				3.3061E-05	,
				3.2996E-05	,
				3.29312E-05	,
				3.28664E-05	,
				3.28018E-05	,
				3.27373E-05	,
				3.2673E-05	,
				3.26087E-05	,
				3.25446E-05	,
				3.24806E-05	,
				3.24167E-05	,
				3.23529E-05	,
				3.22893E-05	,
				3.22258E-05	,
				3.21624E-05	,
				3.20991E-05	,
				3.20359E-05	,
				3.19729E-05	,
				3.191E-05	,
				3.18472E-05	,
				3.17845E-05	,
				3.17219E-05	,
				3.16595E-05	,
				3.15972E-05	,
				3.1535E-05	,
				3.14729E-05	,
				3.14109E-05	,
				3.1349E-05	,
				3.12873E-05	,
				3.12257E-05	,
				3.11642E-05	,
				3.11028E-05	,
				3.10415E-05	,
				3.09804E-05	,
				3.09193E-05	,
				3.08584E-05	,
				3.07976E-05	,
				3.07369E-05	,
				3.06764E-05	,
				3.06159E-05	,
				3.05556E-05	,
				3.04953E-05	,
				3.04352E-05	,
				3.03752E-05	,
				3.03153E-05	,
				3.02556E-05	,
				3.01959E-05	,
				3.01363E-05	,
				3.00769E-05	,
				3.00176E-05	,
				2.99584E-05	,
				2.98993E-05	,
				2.98403E-05	,
				2.97814E-05	,
				2.97227E-05	,
				2.9664E-05	,
				2.96055E-05	,
				2.95471E-05	,
				2.94888E-05	,
				2.94306E-05	,
				2.93725E-05	,
				2.93145E-05	,
				2.92567E-05	,
				2.91989E-05	,
				2.91412E-05	,
				2.90837E-05	,
				2.90263E-05	,
				2.8969E-05	,
				2.89118E-05	,
				2.88547E-05	,
				2.87977E-05	,
				2.87408E-05	,
				2.8684E-05	,
				2.86273E-05	,
				2.85708E-05	,
				2.85143E-05	,
				2.8458E-05	,
				2.84018E-05	,
				2.83456E-05	,
				2.82896E-05	,
				2.82337E-05	,
				2.81779E-05	,
				2.81222E-05	,
				2.80666E-05	,
				2.80111E-05	,
				2.79557E-05	,
				2.79004E-05	,
				2.78453E-05	,
				2.77902E-05	,
				2.77352E-05	,
				2.76804E-05	,
				2.76256E-05	,
				2.7571E-05	,
				2.75165E-05	,
				2.7462E-05	,
				2.74077E-05	,
				2.73535E-05	,
				2.72993E-05	,
				2.72453E-05	,
				2.71914E-05	,
				2.71376E-05	,
				2.70839E-05	,
				2.70302E-05	,
				2.69767E-05	,
				2.69233E-05	,
				2.687E-05	,
				2.68168E-05	,
				2.67637E-05	,
				2.67107E-05	,
				2.66578E-05	,
				2.6605E-05	,
				2.65523E-05	,
				2.64997E-05	,
				2.64472E-05	,
				2.63949E-05	,
				2.63426E-05	,
				2.62904E-05	,
				2.62383E-05	,
				2.61863E-05	,
				2.61344E-05	,
				2.60826E-05	,
				2.60309E-05	,
				2.59793E-05	,
				2.59278E-05	,
				2.58764E-05	,
				2.58251E-05	,
				2.57739E-05	,
				2.57228E-05	,
				2.56718E-05	,
				2.56209E-05	,
				2.55701E-05	,
				2.55194E-05	,
				2.54687E-05	,
				2.54182E-05	,
				2.53678E-05	,
				2.53175E-05	,
				2.52672E-05	,
				2.52171E-05	,
				2.51671E-05	,
				2.51171E-05	,
				2.50673E-05	,
				2.50175E-05	,
				2.49679E-05	,
				2.49183E-05	,
				2.48689E-05	,
				2.48195E-05	,
				2.47702E-05	,
				2.4721E-05	,
				2.4672E-05	,
				2.4623E-05	,
				2.45741E-05	,
				2.45253E-05	,
				2.44766E-05	,
				2.4428E-05	,
				2.43794E-05	,
				2.4331E-05	,
				2.42827E-05	,
				2.42344E-05	,
				2.41863E-05	,
				2.41382E-05	,
				2.40902E-05	,
				2.40424E-05	,
				2.39946E-05	,
				2.39469E-05	,
				2.38993E-05	,
				2.38518E-05	,
				2.38044E-05	,
				2.37571E-05	,
				2.37098E-05	,
				2.36627E-05	,
				2.36156E-05	,
				2.35687E-05	,
				2.35218E-05	,
				2.3475E-05	,
				2.34283E-05	,
				2.33817E-05	,
				2.33352E-05	,
				2.32888E-05	,
				2.32425E-05	,
				2.31962E-05	,
				2.31501E-05	,
				2.3104E-05	,
				2.3058E-05	,
				2.30121E-05	,
				2.29663E-05	,
				2.29206E-05	,
				2.2875E-05	,
				2.28295E-05	,
				2.2784E-05	,
				2.27387E-05	,
				2.26934E-05	,
				2.26482E-05	,
				2.26031E-05	,
				2.25581E-05	,
				2.25132E-05	,
				2.24683E-05	,
				2.24236E-05	,
				2.23789E-05	,
				2.23343E-05	,
				2.22899E-05	,
				2.22454E-05	,
				2.22011E-05	
			};
		
	
	double[] realCDF={0	,
			0.002469023	,
			0.004877283	,
			0.007225669	,
			0.009516331	,
			0.011750524	,
			0.013929721	,
			0.016054362	,
			0.018127049	,
			0.020148601	,
			0.022120303	,
			0.024043411	,
			0.025919158	,
			0.0277477	,
			0.029531789	,
			0.031271878	,
			0.032969065	,
			0.034624423	,
			0.036238999	,
			0.037813819	,
			0.039349052	,
			0.040847035	,
			0.042308115	,
			0.043733212	,
			0.045123226	,
			0.046479033	,
			0.047801491	,
			0.049091438	,
			0.05034969	,
			0.051577047	,
			0.05277326	,
			0.053940875	,
			0.055079824	,
			0.056190826	,
			0.057274584	,
			0.058331782	,
			0.059363091	,
			0.060369163	,
			0.061350635	,
			0.062308132	,
			0.063241384	,
			0.064152548	,
			0.065041485	,
			0.065908756	,
			0.066754911	,
			0.067580484	,
			0.068385999	,
			0.069171966	,
			0.069938883	,
			0.070687237	,
			0.071417501	,
			0.072130141	,
			0.072824726	,
			0.073503305	,
			0.074165561	,
			0.074811915	,
			0.075442773	,
			0.076058537	,
			0.076659594	,
			0.077246326	,
			0.077819104	,
			0.07837829	,
			0.078924238	,
			0.079457294	,
			0.07997705	,
			0.080485209	,
			0.080981448	,
			0.08146608	,
			0.08193941	,
			0.082401736	,
			0.082853349	,
			0.083294532	,
			0.083725562	,
			0.08414671	,
			0.08455824	,
			0.08496041	,
			0.085353471	,
			0.085737669	,
			0.086112509	,
			0.086479596	,
			0.086838512	,
			0.08718948	,
			0.087532716	,
			0.087868433	,
			0.088196838	,
			0.088518132	,
			0.088832514	,
			0.089140176	,
			0.089441306	,
			0.089736088	,
			0.090024702	,
			0.090307322	,
			0.090584121	,
			0.090854535	,
			0.091120099	,
			0.091380321	,
			0.091635357	,
			0.091885358	,
			0.092130472	,
			0.092370843	,
			0.092606613	,
			0.092837918	,
			0.093064893	,
			0.09328767	,
			0.093506377	,
			0.093721138	,
			0.093932078	,
			0.094139314	,
			0.094342306	,
			0.094542411	,
			0.094739149	,
			0.094932627	,
			0.095122952	,
			0.095310226	,
			0.095494551	,
			0.095676025	,
			0.095854745	,
			0.096030804	,
			0.096204295	,
			0.096375307	,
			0.096543929	,
			0.096710244	,
			0.096874338	,
			0.097036293	,
			0.097196187	,
			0.097353426	,
			0.097509367	,
			0.097663471	,
			0.09781581	,
			0.097966457	,
			0.098115479	,
			0.098262945	,
			0.09840892	,
			0.098553469	,
			0.098696655	,
			0.09883854	,
			0.098979184	,
			0.099118645	,
			0.099256982	,
			0.09939425	,
			0.099530505	,
			0.099665213	,
			0.099799546	,
			0.099933019	,
			0.100065681	,
			0.100197582	,
			0.100328768	,
			0.100459287	,
			0.100589183	,
			0.100718502	,
			0.100847286	,
			0.100975578	,
			0.10110342	,
			0.101230853	,
			0.101357915	,
			0.101484646	,
			0.101611083	,
			0.101737264	,
			0.101863225	,
			0.101988422	,
			0.102113999	,
			0.102239457	,
			0.102364827	,
			0.102490143	,
			0.102615435	,
			0.102740735	,
			0.102866072	,
			0.102991476	,
			0.103116976	,
			0.103242599	,
			0.103368374	,
			0.103494326	,
			0.103620483	,
			0.103746869	,
			0.10387351	,
			0.104000431	,
			0.104127656	,
			0.104254665	,
			0.104382523	,
			0.104510751	,
			0.10463937	,
			0.104768402	,
			0.104897867	,
			0.105027785	,
			0.105158178	,
			0.105289063	,
			0.105420461	,
			0.105552389	,
			0.105684867	,
			0.105817911	,
			0.105951539	,
			0.106085769	,
			0.106220617	,
			0.106356099	,
			0.106492231	,
			0.106629029	,
			0.106765982	,
			0.106904118	,
			0.107042961	,
			0.107182527	,
			0.107322829	,
			0.10746388	,
			0.107605693	,
			0.107748282	,
			0.107891659	,
			0.108035837	,
			0.108180827	,
			0.108326641	,
			0.108473291	,
			0.108620788	,
			0.108769144	,
			0.108918368	,
			0.109068472	,
			0.109219465	,
			0.109371359	,
			0.109523672	,
			0.109677361	,
			0.109831975	,
			0.109987526	,
			0.110144021	,
			0.11030147	,
			0.11045988	,
			0.110619261	,
			0.11077962	,
			0.110940964	,
			0.111103303	,
			0.111266644	,
			0.111430993	,
			0.111596358	,
			0.111762746	,
			0.111930165	,
			0.11209862	,
			0.112268119	,
			0.112438667	,
			0.112610271	,
			0.112782465	,
			0.112956168	,
			0.113130944	,
			0.113306797	,
			0.113483733	,
			0.113661758	,
			0.113840877	,
			0.114021094	,
			0.114202416	,
			0.114384846	,
			0.114568389	,
			0.11475305	,
			0.114938834	,
			0.115125745	,
			0.115313786	,
			0.115502963	,
			0.115693279	,
			0.115884738	,
			0.116077345	,
			0.116271102	,
			0.116465571	,
			0.116661613	,
			0.116858814	,
			0.117057179	,
			0.11725671	,
			0.11745741	,
			0.117659282	,
			0.11786233	,
			0.118066557	,
			0.118271964	,
			0.118478554	,
			0.118686331	,
			0.118895296	,
			0.119105453	,
			0.119316803	,
			0.119529349	,
			0.119743093	,
			0.119958037	,
			0.120174183	,
			0.120391533	,
			0.120609686	,
			0.120829427	,
			0.121050375	,
			0.121272534	,
			0.121495905	,
			0.121720489	,
			0.121946288	,
			0.122173303	,
			0.122401535	,
			0.122630987	,
			0.122861659	,
			0.123093552	,
			0.123326667	,
			0.123561007	,
			0.12379657	,
			0.12403336	,
			0.124271376	,
			0.124510619	,
			0.124751091	,
			0.124992792	,
			0.125235722	,
			0.125479502	,
			0.125724872	,
			0.125971472	,
			0.126219304	,
			0.126468367	,
			0.126718662	,
			0.126970189	,
			0.127222949	,
			0.127476942	,
			0.127732168	,
			0.127988627	,
			0.12824632	,
			0.128505246	,
			0.128765405	,
			0.129026799	,
			0.129289426	,
			0.129553287	,
			0.129818381	,
			0.130084709	,
			0.13035227	,
			0.130621065	,
			0.130891092	,
			0.131161979	,
			0.131434451	,
			0.131708154	,
			0.131983088	,
			0.132259252	,
			0.132536645	,
			0.132815269	,
			0.133095121	,
			0.133376201	,
			0.133658509	,
			0.133942045	,
			0.134226806	,
			0.134512794	,
			0.134800007	,
			0.135088444	,
			0.135378105	,
			0.135668989	,
			0.135961095	,
			0.136254422	,
			0.13654897	,
			0.136844738	,
			0.137141385	,
			0.137439571	,
			0.137738973	,
			0.13803959	,
			0.138341421	,
			0.138644465	,
			0.138948721	,
			0.139254187	,
			0.139560863	,
			0.139868747	,
			0.140177839	,
			0.140488137	,
			0.14079964	,
			0.141112346	,
			0.141426255	,
			0.141741364	,
			0.142057674	,
			0.142375182	,
			0.142693887	,
			0.143013789	,
			0.143334884	,
			0.143657173	,
			0.143980335	,
			0.144304989	,
			0.144630831	,
			0.14495786	,
			0.145286074	,
			0.145615471	,
			0.14594605	,
			0.14627781	,
			0.146610748	,
			0.146944864	,
			0.147280155	,
			0.14761662	,
			0.147954257	,
			0.148293065	,
			0.148633042	,
			0.148974186	,
			0.149316495	,
			0.149659969	,
			0.150004604	,
			0.150350399	,
			0.150697354	,
			0.151045464	,
			0.151394436	,
			0.15174484	,
			0.152096395	,
			0.152449098	,
			0.152802949	,
			0.153157944	,
			0.153514083	,
			0.153871362	,
			0.154229781	,
			0.154589337	,
			0.154950028	,
			0.155311853	,
			0.155674809	,
			0.156038894	,
			0.156404106	,
			0.156770444	,
			0.157137905	,
			0.157506487	,
			0.157876188	,
			0.158247006	,
			0.158618939	,
			0.158991985	,
			0.159366142	,
			0.159741126	,
			0.160117484	,
			0.160494947	,
			0.160873511	,
			0.161253174	,
			0.161633935	,
			0.162015791	,
			0.162398739	,
			0.162782778	,
			0.163167906	,
			0.16355412	,
			0.163941417	,
			0.164329797	,
			0.164719255	,
			0.165109791	,
			0.165501401	,
			0.165894084	,
			0.166287838	,
			0.166682659	,
			0.167078546	,
			0.167475496	,
			0.167873506	,
			0.168272576	,
			0.168672436	,
			0.169073604	,
			0.169475822	,
			0.169879089	,
			0.170283402	,
			0.170688759	,
			0.171095157	,
			0.171502593	,
			0.171911067	,
			0.172320574	,
			0.172731113	,
			0.173142681	,
			0.173555276	,
			0.173968895	,
			0.174383536	,
			0.174799195	,
			0.175215872	,
			0.175633563	,
			0.176052265	,
			0.176471977	,
			0.176892695	,
			0.177314418	,
			0.177737142	,
			0.178160619	,
			0.178585328	,
			0.17901103	,
			0.179437724	,
			0.179865406	,
			0.180294074	,
			0.180723725	,
			0.181154356	,
			0.181585966	,
			0.182018551	,
			0.18245211	,
			0.182886638	,
			0.183322134	,
			0.183758595	,
			0.184196019	,
			0.184634402	,
			0.185073743	,
			0.185514038	,
			0.185955285	,
			0.186397481	,
			0.186840623	,
			0.18728471	,
			0.187729738	,
			0.188175478	,
			0.18862237	,
			0.189070196	,
			0.189518951	,
			0.189968634	,
			0.190419242	,
			0.190870771	,
			0.191323221	,
			0.191776586	,
			0.192230866	,
			0.192686057	,
			0.193142156	,
			0.193599161	,
			0.19405707	,
			0.194515878	,
			0.194975584	,
			0.195436185	,
			0.195897678	,
			0.196360061	,
			0.19682333	,
			0.197287483	,
			0.197752517	,
			0.198218429	,
			0.198685217	,
			0.199152663	,
			0.199621185	,
			0.200090574	,
			0.200560827	,
			0.201031942	,
			0.201503915	,
			0.201976744	,
			0.202450426	,
			0.202924959	,
			0.203400339	,
			0.203876563	,
			0.20435363	,
			0.204831535	,
			0.205310277	,
			0.205789853	,
			0.206270259	,
			0.206751493	,
			0.207233552	,
			0.207716433	,
			0.208200134	,
			0.208684652	,
			0.209169983	,
			0.209656126	,
			0.210143077	,
			0.210630632	,
			0.211119182	,
			0.211608532	,
			0.212098679	,
			0.21258962	,
			0.213081351	,
			0.213573871	,
			0.214067176	,
			0.214561264	,
			0.215056131	,
			0.215551775	,
			0.216048193	,
			0.216545383	,
			0.21704334	,
			0.217542063	,
			0.218041549	,
			0.218541795	,
			0.219042797	,
			0.219544554	,
			0.220047062	,
			0.220550318	,
			0.221054321	,
			0.221559065	,
			0.22206455	,
			0.222570586	,
			0.223077534	,
			0.223585214	,
			0.224093623	,
			0.224602756	,
			0.225112613	,
			0.225623189	,
			0.226134482	,
			0.226646489	,
			0.227159207	,
			0.227672634	,
			0.228186766	,
			0.228701601	,
			0.229217136	,
			0.229733368	,
			0.230250294	,
			0.230767911	,
			0.231286217	,
			0.231805208	,
			0.232324882	,
			0.232845236	,
			0.233366267	,
			0.233887973	,
			0.23441035	,
			0.234933223	,
			0.235456928	,
			0.235981295	,
			0.236506322	,
			0.237032006	,
			0.237558344	,
			0.238085334	,
			0.238612972	,
			0.239141255	,
			0.239670182	,
			0.240199748	,
			0.240729952	,
			0.24126079	,
			0.241792259	,
			0.242324357	,
			0.24285708	,
			0.243390427	,
			0.243924394	,
			0.244458978	,
			0.244994177	,
			0.245529987	,
			0.246066407	,
			0.246603432	,
			0.247141061	,
			0.24767929	,
			0.248217954	,
			0.248757369	,
			0.249297376	,
			0.249837972	,
			0.250379155	,
			0.25092092	,
			0.251463266	,
			0.25200619	,
			0.252549689	,
			0.25309376	,
			0.253638401	,
			0.254183607	,
			0.254729378	,
			0.25527571	,
			0.255822599	,
			0.256370045	,
			0.256918042	,
			0.25746659	,
			0.258015684	,
			0.258565323	,
			0.259115503	,
			0.259666222	,
			0.260217477	,
			0.260769265	,
			0.261321584	,
			0.261874277	,
			0.262427642	,
			0.262981529	,
			0.263535935	,
			0.264090858	,
			0.264646294	,
			0.265202241	,
			0.265758696	,
			0.266315657	,
			0.26687312	,
			0.267431083	,
			0.267989543	,
			0.268548498	,
			0.269107944	,
			0.269667879	,
			0.2702283	,
			0.270789205	,
			0.271350591	,
			0.271912454	,
			0.272474793	,
			0.273037604	,
			0.273600885	,
			0.274164633	,
			0.274728846	,
			0.275293521	,
			0.275858511	,
			0.276424096	,
			0.276990134	,
			0.277556623	,
			0.27812356	,
			0.278690942	,
			0.279258767	,
			0.279827032	,
			0.280395734	,
			0.280964871	,
			0.28153444	,
			0.282104438	,
			0.282674863	,
			0.283245712	,
			0.283816982	,
			0.284388671	,
			0.284960775	,
			0.285533293	,
			0.286106222	,
			0.286679559	,
			0.287253301	,
			0.287827446	,
			0.288401991	,
			0.288976933	,
			0.28955227	,
			0.290127868	,
			0.290703982	,
			0.291280484	,
			0.291857369	,
			0.292434636	,
			0.293012283	,
			0.293590305	,
			0.294168701	,
			0.294747469	,
			0.295326605	,
			0.295906107	,
			0.296485973	,
			0.297066199	,
			0.297646783	,
			0.298227724	,
			0.298809017	,
			0.299390661	,
			0.299972652	,
			0.30055499	,
			0.30113767	,
			0.30172069	,
			0.302304048	,
			0.302887741	,
			0.303471767	,
			0.304056122	,
			0.304640684	,
			0.305225689	,
			0.305811015	,
			0.306396662	,
			0.306982625	,
			0.307568904	,
			0.308155494	,
			0.308742395	,
			0.309329603	,
			0.309917115	,
			0.31050493	,
			0.311093044	,
			0.311681456	,
			0.312270163	,
			0.312859161	,
			0.31344845	,
			0.314038026	,
			0.314627887	,
			0.31521803	,
			0.315808453	,
			0.316399153	,
			0.316990129	,
			0.317581377	,
			0.318172895	,
			0.318764681	,
			0.319356621	,
			0.319948931	,
			0.320541502	,
			0.32113433	,
			0.321727413	,
			0.32232075	,
			0.322914337	,
			0.323508172	,
			0.324102253	,
			0.324696578	,
			0.325291143	,
			0.325885947	,
			0.326480987	,
			0.327076261	,
			0.327671766	,
			0.3282675	,
			0.328863461	,
			0.329459646	,
			0.330056053	,
			0.330652679	,
			0.331249523	,
			0.331846581	,
			0.332443852	,
			0.333041333	,
			0.333639022	,
			0.334236916	,
			0.33483491	,
			0.335433205	,
			0.336031698	,
			0.336630387	,
			0.33722927	,
			0.337828345	,
			0.338427608	,
			0.339027059	,
			0.339626694	,
			0.340226511	,
			0.340826508	,
			0.341426683	,
			0.342027034	,
			0.342627557	,
			0.343228251	,
			0.343829114	,
			0.344430143	,
			0.345031337	,
			0.345632692	,
			0.346234206	,
			0.346835879	,
			0.347437706	,
			0.348039686	,
			0.348641816	,
			0.349244095	,
			0.349846521	,
			0.350448993	,
			0.3510517	,
			0.351654548	,
			0.352257532	,
			0.352860652	,
			0.353463904	,
			0.354067288	,
			0.354670799	,
			0.355274437	,
			0.355878199	,
			0.356482084	,
			0.357086088	,
			0.357690209	,
			0.358294446	,
			0.358898796	,
			0.359503258	,
			0.360107829	,
			0.360712506	,
			0.361317288	,
			0.361922173	,
			0.362527159	,
			0.363132243	,
			0.363737423	,
			0.364342697	,
			0.364948063	,
			0.36555352	,
			0.366158974	,
			0.366764601	,
			0.367370311	,
			0.367976104	,
			0.368581975	,
			0.369187924	,
			0.369793949	,
			0.370400046	,
			0.371006215	,
			0.371612453	,
			0.372218758	,
			0.372825127	,
			0.37343156	,
			0.374038054	,
			0.374644607	,
			0.375251216	,
			0.375857881	,
			0.376464598	,
			0.377071366	,
			0.377678183	,
			0.378285047	,
			0.378891955	,
			0.379498907	,
			0.380105899	,
			0.38071293	,
			0.381319998	,
			0.381927017	,
			0.38253415	,
			0.383141314	,
			0.383748507	,
			0.384355727	,
			0.384962972	,
			0.38557024	,
			0.386177529	,
			0.386784837	,
			0.387392162	,
			0.387999503	,
			0.388606857	,
			0.389214222	,
			0.389821597	,
			0.39042898	,
			0.391036368	,
			0.39164376	,
			0.392251154	,
			0.392858548	,
			0.393465941	,
			0.394073329	,
			0.394680712	,
			0.395288087	,
			0.395895453	,
			0.396502808	,
			0.39711015	,
			0.3977174	,
			0.398324708	,
			0.398931997	,
			0.399539266	,
			0.400146512	,
			0.400753734	,
			0.401360929	,
			0.401968097	,
			0.402575236	,
			0.403182343	,
			0.403789416	,
			0.404396455	,
			0.405003456	,
			0.405610419	,
			0.406217341	,
			0.406824222	,
			0.407431058	,
			0.408037848	,
			0.408644591	,
			0.409251284	,
			0.409857926	,
			0.410464516	,
			0.41107105	,
			0.411677529	,
			0.412283949	,
			0.41289031	,
			0.413496539	,
			0.414102772	,
			0.41470894	,
			0.415315042	,
			0.415921075	,
			0.416527038	,
			0.417132929	,
			0.417738746	,
			0.418344488	,
			0.418950153	,
			0.419555739	,
			0.420161245	,
			0.420766669	,
			0.421372009	,
			0.421977263	,
			0.422582431	,
			0.42318751	,
			0.423792498	,
			0.424397394	,
			0.425002197	,
			0.425606904	,
			0.426211515	,
			0.426816027	,
			0.427420438	,
			0.428024748	,
			0.428628955	,
			0.429233056	,
			0.429836985	,
			0.43044087	,
			0.431044644	,
			0.431648307	,
			0.432251857	,
			0.432855292	,
			0.433458611	,
			0.434061813	,
			0.434664894	,
			0.435267855	,
			0.435870693	,
			0.436473407	,
			0.437075996	,
			0.437678457	,
			0.43828079	,
			0.438882992	,
			0.439485063	,
			0.440087	,
			0.440688802	,
			0.441290468	,
			0.441891996	,
			0.442493384	,
			0.443094632	,
			0.443695737	,
			0.444296698	,
			0.444897514	,
			0.445498183	,
			0.446098642	,
			0.446699011	,
			0.447299229	,
			0.447899294	,
			0.448499204	,
			0.449098958	,
			0.449698556	,
			0.450297994	,
			0.450897273	,
			0.45149639	,
			0.452095344	,
			0.452694133	,
			0.453292757	,
			0.453891213	,
			0.4544895	,
			0.455087617	,
			0.455685563	,
			0.456283336	,
			0.456880934	,
			0.457478357	,
			0.458075602	,
			0.458672669	,
			0.459269556	,
			0.459866261	,
			0.460462784	,
			0.461059123	,
			0.461655221	,
			0.462251186	,
			0.462846962	,
			0.46344255	,
			0.464037946	,
			0.46463315	,
			0.46522816	,
			0.465822975	,
			0.466417595	,
			0.467012016	,
			0.467606239	,
			0.468200261	,
			0.468794082	,
			0.4693877	,
			0.469981113	,
			0.470574322	,
			0.471167323	,
			0.471760116	,
			0.4723527	,
			0.472945074	,
			0.473537235	,
			0.474129183	,
			0.474720917	,
			0.475312435	,
			0.475903736	,
			0.476494818	,
			0.477085682	,
			0.477676273	,
			0.478266692	,
			0.478856887	,
			0.479446858	,
			0.480036604	,
			0.480626122	,
			0.481215412	,
			0.481804473	,
			0.482393303	,
			0.482981901	,
			0.483570266	,
			0.484158396	,
			0.484746291	,
			0.48533395	,
			0.485921371	,
			0.486508552	,
			0.487095494	,
			0.487682193	,
			0.488268651	,
			0.488854864	,
			0.489440833	,
			0.490026555	,
			0.490612031	,
			0.491197257	,
			0.491782235	,
			0.492366961	,
			0.492951436	,
			0.49353561	,
			0.494119577	,
			0.494703288	,
			0.495286742	,
			0.49586994	,
			0.496452878	,
			0.497035557	,
			0.497617975	,
			0.498200131	,
			0.498782023	,
			0.499363652	,
			0.499945015	,
			0.500526113	,
			0.501106942	,
			0.501687503	,
			0.502267795	,
			0.502847816	,
			0.503427565	,
			0.504007042	,
			0.504586244	,
			0.505165172	,
			0.505743824	,
			0.506322198	,
			0.506900295	,
			0.507478113	,
			0.50805565	,
			0.508632906	,
			0.509209837	,
			0.509786527	,
			0.510362933	,
			0.510939053	,
			0.511514887	,
			0.512090434	,
			0.512665692	,
			0.513240661	,
			0.51381534	,
			0.514389728	,
			0.514963823	,
			0.515537625	,
			0.516111133	,
			0.516684346	,
			0.517257262	,
			0.517829882	,
			0.518402203	,
			0.518974225	,
			0.519545947	,
			0.520117369	,
			0.520688488	,
			0.521259304	,
			0.521829817	,
			0.522400024	,
			0.522969927	,
			0.523539522	,
			0.52410881	,
			0.524677789	,
			0.525246419	,
			0.525814777	,
			0.526382825	,
			0.52695056	,
			0.527517982	,
			0.528085091	,
			0.528651884	,
			0.529218362	,
			0.529784523	,
			0.530350366	,
			0.530915892	,
			0.531481098	,
			0.532045983	,
			0.532610548	,
			0.533174791	,
			0.533738711	,
			0.534302308	,
			0.53486558	,
			0.535428526	,
			0.535991147	,
			0.53655344	,
			0.537115406	,
			0.537677043	,
			0.538238351	,
			0.538799328	,
			0.539359974	,
			0.539920288	,
			0.540480232	,
			0.541039879	,
			0.541599191	,
			0.542158168	,
			0.542716809	,
			0.543275113	,
			0.543833079	,
			0.544390707	,
			0.544947995	,
			0.545504944	,
			0.546061552	,
			0.546617818	,
			0.547173741	,
			0.547729322	,
			0.548284559	,
			0.548839451	,
			0.549393997	,
			0.549948198	,
			0.550502051	,
			0.551055557	,
			0.551608714	,
			0.552161522	,
			0.55271398	,
			0.553266087	,
			0.553817843	,
			0.554369247	,
			0.554920298	,
			0.555470962	,
			0.556021304	,
			0.556571291	,
			0.557120922	,
			0.557670197	,
			0.558219115	,
			0.558767675	,
			0.559315876	,
			0.559863718	,
			0.5604112	,
			0.560958322	,
			0.561505082	,
			0.56205148	,
			0.562597515	,
			0.563143187	,
			0.563688495	,
			0.564233438	,
			0.564778016	,
			0.565322228	,
			0.565866073	,
			0.56640955	,
			0.56695266	,
			0.567495401	,
			0.568037772	,
			0.568579774	,
			0.569121405	,
			0.569662665	,
			0.570203553	,
			0.570744037	,
			0.571284179	,
			0.571823946	,
			0.57236334	,
			0.572902358	,
			0.573441001	,
			0.573979268	,
			0.574517157	,
			0.57505467	,
			0.575591804	,
			0.57612856	,
			0.576664936	,
			0.577200933	,
			0.577736549	,
			0.578271784	,
			0.578806638	,
			0.579341109	,
			0.579875198	,
			0.580408904	,
			0.580942225	,
			0.581475162	,
			0.582007715	,
			0.582539881	,
			0.583071662	,
			0.583603056	,
			0.584134062	,
			0.584664681	,
			0.585194912	,
			0.585724724	,
			0.586254176	,
			0.586783237	,
			0.587311908	,
			0.587840189	,
			0.588368077	,
			0.588895574	,
			0.589422678	,
			0.589949389	,
			0.590475706	,
			0.59100163	,
			0.591527158	,
			0.592052292	,
			0.59257703	,
			0.593101371	,
			0.593625316	,
			0.594148864	,
			0.594672015	,
			0.595194767	,
			0.595717121	,
			0.596239076	,
			0.596760631	,
			0.597281786	,
			0.597802541	,
			0.598322894	,
			0.598842847	,
			0.599362397	,
			0.599881545	,
			0.600400263	,
			0.600918605	,
			0.601436542	,
			0.601954076	,
			0.602471204	,
			0.602987928	,
			0.603504246	,
			0.604020159	,
			0.604535665	,
			0.605050764	,
			0.605565455	,
			0.60607974	,
			0.606593616	,
			0.607107083	,
			0.607620142	,
			0.608132791	,
			0.608645031	,
			0.60915686	,
			0.609668279	,
			0.610179287	,
			0.610689883	,
			0.611200068	,
			0.61170984	,
			0.6122192	,
			0.612728147	,
			0.613236681	,
			0.6137448	,
			0.614252482	,
			0.614759772	,
			0.615266648	,
			0.615773108	,
			0.616279153	,
			0.616784782	,
			0.617289994	,
			0.61779479	,
			0.618299169	,
			0.61880313	,
			0.619306673	,
			0.619809798	,
			0.620312505	,
			0.620814792	,
			0.621316661	,
			0.62181811	,
			0.622319139	,
			0.622819748	,
			0.623319936	,
			0.623819703	,
			0.624319049	,
			0.624817974	,
			0.625316476	,
			0.625814557	,
			0.626312214	,
			0.626809449	,
			0.627306261	,
			0.62780265	,
			0.628298592	,
			0.628794132	,
			0.629289247	,
			0.629783938	,
			0.630278204	,
			0.630772044	,
			0.631265459	,
			0.631758448	,
			0.632251011	,
			0.632743147	,
			0.633234857	,
			0.633726139	,
			0.634216994	,
			0.634707422	,
			0.635197421	,
			0.635686993	,
			0.636176136	,
			0.63666485	,
			0.637153136	,
			0.637640992	,
			0.638128419	,
			0.638615416	,
			0.639101983	,
			0.63958812	,
			0.640073826	,
			0.640559101	,
			0.641043946	,
			0.641528359	,
			0.64201232	,
			0.64249587	,
			0.642978987	,
			0.643461673	,
			0.643943925	,
			0.644425746	,
			0.644907133	,
			0.645388087	,
			0.645868608	,
			0.646348695	,
			0.646828349	,
			0.647307568	,
			0.647786354	,
			0.648264705	,
			0.648742621	,
			0.649220102	,
			0.649697148	,
			0.650173759	,
			0.650649935	,
			0.651125675	,
			0.651600979	,
			0.652075847	,
			0.652550279	,
			0.653024274	,
			0.653497833	,
			0.653970955	,
			0.65444364	,
			0.654915887	,
			0.655387698	,
			0.655859051	,
			0.656329986	,
			0.656800483	,
			0.657270542	,
			0.657740162	,
			0.658209344	,
			0.658678088	,
			0.659146393	,
			0.659614259	,
			0.660081686	,
			0.660548673	,
			0.661015222	,
			0.661481331	,
			0.661947	,
			0.66241223	,
			0.662877019	,
			0.663341369	,
			0.663805278	,
			0.664268747	,
			0.664731775	,
			0.665194363	,
			0.66565651	,
			0.666118216	,
			0.666579481	,
			0.667040305	,
			0.667500688	,
			0.667960629	,
			0.668420129	,
			0.66887917	,
			0.669337785	,
			0.66979596	,
			0.670253692	,
			0.670710982	,
			0.671167829	,
			0.671624235	,
			0.672080198	,
			0.672535718	,
			0.672990796	,
			0.673445431	,
			0.673899624	,
			0.674353373	,
			0.67480668	,
			0.675259543	,
			0.675711963	,
			0.67616394	,
			0.676615473	,
			0.677066563	,
			0.67751721	,
			0.677967412	,
			0.678417172	,
			0.678866487	,
			0.679315358	,
			0.679763786	,
			0.68021177	,
			0.680659309	,
			0.681106405	,
			0.68155304	,
			0.681999247	,
			0.682445009	,
			0.682890327	,
			0.6833352	,
			0.683779629	,
			0.684223614	,
			0.684667154	,
			0.685110249	,
			0.685552899	,
			0.685995105	,
			0.686436866	,
			0.686878182	,
			0.687319053	,
			0.68775948	,
			0.688199461	,
			0.688638998	,
			0.689078089	,
			0.689516735	,
			0.689954936	,
			0.690392692	,
			0.690830003	,
			0.691266869	,
			0.69170329	,
			0.692139265	,
			0.692574795	,
			0.69300988	,
			0.693444519	,
			0.693878713	,
			0.694312447	,
			0.69474575	,
			0.695178608	,
			0.695611021	,
			0.696042988	,
			0.69647451	,
			0.696905586	,
			0.697336217	,
			0.697766403	,
			0.698196143	,
			0.698625438	,
			0.699054287	,
			0.699482691	,
			0.69991065	,
			0.700338164	,
			0.700765232	,
			0.701191854	,
			0.701618032	,
			0.702043764	,
			0.702469051	,
			0.702893892	,
			0.703318289	,
			0.70374224	,
			0.704165746	,
			0.704588806	,
			0.705011422	,
			0.705433592	,
			0.705855318	,
			0.706276584	,
			0.706697419	,
			0.707117809	,
			0.707537754	,
			0.707957254	,
			0.708376309	,
			0.70879492	,
			0.709213085	,
			0.709630806	,
			0.710048082	,
			0.710464913	,
			0.710881299	,
			0.711297241	,
			0.711712739	,
			0.712127792	,
			0.7125424	,
			0.712956564	,
			0.713370284	,
			0.71378356	,
			0.714196391	,
			0.714608778	,
			0.715020721	,
			0.71543222	,
			0.715843275	,
			0.716253887	,
			0.716664054	,
			0.717073778	,
			0.717483057	,
			0.717891894	,
			0.718300274	,
			0.718708223	,
			0.719115728	,
			0.719522791	,
			0.719929409	,
			0.720335585	,
			0.720741318	,
			0.721146608	,
			0.721551454	,
			0.721955858	,
			0.72235982	,
			0.722763338	,
			0.723166414	,
			0.723569047	,
			0.723971239	,
			0.724372987	,
			0.724774294	,
			0.725175158	,
			0.725575581	,
			0.725975561	,
			0.7263751	,
			0.726774197	,
			0.727172852	,
			0.727571066	,
			0.727968838	,
			0.728366169	,
			0.728763059	,
			0.729159508	,
			0.729555516	,
			0.729951071	,
			0.730346197	,
			0.730740883	,
			0.731135127	,
			0.731528932	,
			0.731922296	,
			0.73231522	,
			0.732707704	,
			0.733099748	,
			0.733491352	,
			0.733882516	,
			0.734273241	,
			0.734663526	,
			0.735053372	,
			0.735442779	,
			0.735831747	,
			0.736220276	,
			0.736608366	,
			0.736996017	,
			0.73738323	,
			0.737770004	,
			0.73815634	,
			0.738542238	,
			0.738927698	,
			0.739312721	,
			0.739697305	,
			0.740081452	,
			0.740465162	,
			0.740848423	,
			0.741231258	,
			0.741613656	,
			0.741995617	,
			0.742377141	,
			0.742758229	,
			0.74313888	,
			0.743519096	,
			0.743898875	,
			0.744278218	,
			0.744657125	,
			0.745035597	,
			0.745413633	,
			0.745791234	,
			0.7461684	,
			0.74654513	,
			0.746921426	,
			0.747297288	,
			0.747672714	,
			0.748047707	,
			0.748422265	,
			0.748796389	,
			0.74917008	,
			0.749543336	,
			0.74991616	,
			0.750288549	,
			0.750660506	,
			0.75103203	,
			0.751403121	,
			0.751773769	,
			0.752143995	,
			0.752513788	,
			0.75288315	,
			0.753252079	,
			0.753620577	,
			0.753988642	,
			0.754356277	,
			0.75472348	,
			0.755090253	,
			0.755456594	,
			0.755822505	,
			0.756187986	,
			0.756553036	,
			0.756917656	,
			0.757281846	,
			0.757645606	,
			0.758008937	,
			0.758371839	,
			0.758734311	,
			0.759096355	,
			0.75945797	,
			0.759819156	,
			0.760179914	,
			0.760540244	,
			0.760900145	,
			0.761259619	,
			0.761618666	,
			0.761977285	,
			0.762335468	,
			0.762693233	,
			0.763050571	,
			0.763407482	,
			0.763763968	,
			0.764120027	,
			0.76447566	,
			0.764830867	,
			0.765185649	,
			0.765540006	,
			0.765893938	,
			0.766247444	,
			0.766600526	,
			0.766953184	,
			0.767305417	,
			0.767657227	,
			0.768008612	,
			0.768359574	,
			0.768710113	,
			0.769060228	,
			0.769409921	,
			0.769759191	,
			0.770108038	,
			0.770456463	,
			0.770804466	,
			0.771152048	,
			0.771499207	,
			0.771845946	,
			0.772192263	,
			0.772538151	,
			0.772883626	,
			0.773228681	,
			0.773573316	,
			0.773917531	,
			0.774261326	,
			0.774604701	,
			0.774947657	,
			0.775290194	,
			0.775632312	,
			0.775974012	,
			0.776315293	,
			0.776656156	,
			0.776996601	,
			0.777336628	,
			0.777676239	,
			0.778015431	,
			0.778354207	,
			0.778692567	,
			0.779030509	,
			0.779368036	,
			0.779705146	,
			0.780041841	,
			0.78037812	,
			0.780713984	,
			0.781049433	,
			0.781384468	,
			0.781719088	,
			0.782053293	,
			0.782387077	,
			0.782720455	,
			0.783053419	,
			0.783385969	,
			0.783718107	,
			0.784049832	,
			0.784381144	,
			0.784712045	,
			0.785042533	,
			0.785372609	,
			0.785702274	,
			0.786031528	,
			0.78636037	,
			0.786688802	,
			0.787016824	,
			0.787344435	,
			0.787671636	,
			0.787998428	,
			0.78832481	,
			0.788650783	,
			0.788976347	,
			0.789301502	,
			0.789626249	,
			0.789950588	,
			0.790274518	,
			0.790598042	,
			0.790921158	,
			0.791243867	,
			0.791566169	,
			0.791888057	,
			0.792209546	,
			0.792530629	,
			0.792851307	,
			0.793171578	,
			0.793491445	,
			0.793810907	,
			0.794129964	,
			0.794448616	,
			0.794766865	,
			0.795084709	,
			0.79540215	,
			0.795719188	,
			0.796035823	,
			0.796352055	,
			0.796667884	,
			0.796983311	,
			0.797298337	,
			0.79761296	,
			0.797927182	,
			0.798241004	,
			0.798554424	,
			0.798867444	,
			0.799180063	,
			0.799492283	,
			0.799804102	,
			0.800115523	,
			0.800426544	,
			0.800737166	,
			0.801047384	,
			0.801357209	,
			0.801666637	,
			0.801975666	,
			0.802284298	,
			0.802592533	,
			0.802900371	,
			0.803207813	,
			0.803514858	,
			0.803821507	,
			0.804127761	,
			0.804433619	,
			0.804739081	,
			0.805044149	,
			0.805348823	,
			0.805653102	,
			0.805956987	,
			0.806260478	,
			0.806563576	,
			0.806866281	,
			0.807168593	,
			0.807470512	,
			0.80777204	,
			0.808073175	,
			0.808373918	,
			0.808674271	,
			0.808974232	,
			0.809273802	,
			0.809572982	,
			0.809871772	,
			0.810170166	,
			0.810468176	,
			0.810765796	,
			0.811063028	,
			0.811359871	,
			0.811656326	,
			0.811952392	,
			0.812248071	,
			0.812543362	,
			0.812838266	,
			0.813132783	,
			0.813426913	,
			0.813720658	,
			0.814014016	,
			0.814306988	,
			0.814599575	,
			0.814891777	,
			0.815183594	,
			0.815475027	,
			0.815766075	,
			0.81605674	,
			0.816347021	,
			0.816636918	,
			0.816926433	,
			0.817215565	,
			0.817504315	,
			0.817792682	,
			0.818080668	,
			0.818368273	,
			0.818655491	,
			0.818942333	,
			0.819228795	,
			0.819514877	,
			0.819800578	,
			0.8200859	,
			0.820370843	,
			0.820655407	,
			0.820939592	,
			0.821223399	,
			0.821506828	,
			0.821789879	,
			0.822072553	,
			0.822354849	,
			0.822636769	,
			0.822918312	,
			0.82319948	,
			0.823480271	,
			0.823760686	,
			0.824040727	,
			0.824320392	,
			0.824599683	,
			0.8248786	,
			0.825157143	,
			0.825435312	,
			0.825713108	,
			0.82599053	,
			0.82626758	,
			0.826544258	,
			0.826820558	,
			0.827096492	,
			0.827372054	,
			0.827647245	,
			0.827922065	,
			0.828196515	,
			0.828470595	,
			0.828744304	,
			0.829017645	,
			0.829290615	,
			0.829563218	,
			0.829835451	,
			0.830107316	,
			0.830378813	,
			0.830649943	,
			0.830920705	,
			0.831191101	,
			0.831461129	,
			0.831730792	,
			0.832000088	,
			0.832269019	,
			0.832537584	,
			0.832805784	,
			0.83307362	,
			0.833341091	,
			0.833608198	,
			0.833874941	,
			0.834141321	,
			0.834407338	,
			0.834672992	,
			0.834938279	,
			0.835203208	,
			0.835467776	,
			0.835731981	,
			0.835995826	,
			0.83625931	,
			0.836522434	,
			0.836785197	,
			0.8370476	,
			0.837309644	,
			0.837571329	,
			0.837832654	,
			0.838093622	,
			0.838354231	,
			0.838614482	,
			0.838874375	,
			0.839133911	,
			0.83939309	,
			0.839651913	,
			0.83991038	,
			0.84016849	,
			0.840426245	,
			0.840683645	,
			0.840940689	,
			0.841197379	,
			0.841453715	,
			0.841709697	,
			0.841965325	,
			0.842220599	,
			0.842475521	,
			0.842730086	,
			0.842984303	,
			0.843238168	,
			0.843491681	,
			0.843744843	,
			0.843997653	,
			0.844250114	,
			0.844502223	,
			0.844753983	,
			0.845005393	,
			0.845256454	,
			0.845507166	,
			0.845757529	,
			0.846007543	,
			0.84625721	,
			0.846506529	,
			0.8467555	,
			0.847004125	,
			0.847252403	,
			0.847500334	,
			0.84774792	,
			0.84799516	,
			0.848242054	,
			0.848488604	,
			0.848734808	,
			0.848980669	,
			0.849226185	,
			0.849471358	,
			0.849716187	,
			0.849960669	,
			0.850204813	,
			0.850448614	,
			0.850692073	,
			0.850935191	,
			0.851177967	,
			0.851420402	,
			0.851662496	,
			0.85190425	,
			0.852145664	,
			0.852386738	,
			0.852627473	,
			0.852867869	,
			0.853107926	,
			0.853347645	,
			0.853587026	,
			0.853826069	,
			0.854064775	,
			0.854303143	,
			0.854541175	,
			0.854778871	,
			0.855016231	,
			0.855253255	,
			0.855489944	,
			0.855726298	,
			0.855962317	,
			0.856198001	,
			0.856433352	,
			0.856668369	,
			0.856903053	,
			0.857137401	,
			0.857371419	,
			0.857605105	,
			0.857838459	,
			0.858071481	,
			0.858304172	,
			0.858536532	,
			0.858768561	,
			0.85900026	,
			0.859231629	,
			0.859462669	,
			0.859693379	,
			0.85992376	,
			0.860153813	,
			0.860383537	,
			0.860612933	,
			0.860842002	,
			0.861070744	,
			0.861299158	,
			0.861527246	,
			0.861755008	,
			0.861982444	,
			0.862209554	,
			0.86243634	,
			0.8626628	,
			0.862888935	,
			0.863114747	,
			0.863340234	,
			0.863565398	,
			0.863790236	,
			0.864014754	,
			0.864238949	,
			0.864462822	,
			0.864686373	,
			0.864909603	,
			0.865132511	,
			0.865355099	,
			0.865577366	,
			0.865799313	,
			0.86602094	,
			0.866242247	,
			0.866463236	,
			0.866683905	,
			0.866904256	,
			0.867124289	,
			0.867344004	,
			0.867563402	,
			0.867782482	,
			0.868001246	,
			0.868219693	,
			0.868437824	,
			0.868655639	,
			0.868873139	,
			0.869090323	,
			0.869307193	,
			0.869523748	,
			0.86973999	,
			0.869955917	,
			0.870171531	,
			0.870386829	,
			0.870601818	,
			0.870816493	,
			0.871030857	,
			0.871244909	,
			0.871458649	,
			0.871672079	,
			0.871885197	,
			0.872098005	,
			0.872310503	,
			0.872522692	,
			0.872734571	,
			0.872946141	,
			0.873157402	,
			0.873368355	,
			0.873579	,
			0.873789337	,
			0.873999367	,
			0.874209089	,
			0.874418505	,
			0.874627615	,
			0.874836418	,
			0.875044916	,
			0.875253109	,
			0.875460996	,
			0.875668579	,
			0.875875857	,
			0.876082832	,
			0.876289503	,
			0.87649587	,
			0.876701932	,
			0.876907693	,
			0.877113153	,
			0.87731831	,
			0.877523166	,
			0.87772772	,
			0.877931974	,
			0.878135926	,
			0.878339579	,
			0.878542931	,
			0.878745984	,
			0.878948737	,
			0.879151192	,
			0.879353347	,
			0.879555205	,
			0.879756764	,
			0.879958026	,
			0.880158991	,
			0.880359658	,
			0.880560029	,
			0.880760104	,
			0.880959882	,
			0.881159366	,
			0.881358553	,
			0.881557446	,
			0.881756044	,
			0.881954348	,
			0.882152358	,
			0.882350074	,
			0.882547497	,
			0.882744624	,
			0.882941462	,
			0.883138007	,
			0.88333426	,
			0.883530221	,
			0.883725891	,
			0.88392127	,
			0.884116359	,
			0.884311157	,
			0.884505665	,
			0.884699884	,
			0.884893813	,
			0.885087453	,
			0.885280805	,
			0.885473868	,
			0.885666644	,
			0.885859131	,
			0.886051332	,
			0.886243245	,
			0.886434872	,
			0.886626213	,
			0.886817267	,
			0.887008036	,
			0.887198519	,
			0.887388718	,
			0.887578632	,
			0.887768261	,
			0.887957607	,
			0.888146669	,
			0.888335447	,
			0.888523941	,
			0.888712154	,
			0.888900084	,
			0.889087733	,
			0.889275099	,
			0.889462185	,
			0.889648989	,
			0.889835513	,
			0.890021756	,
			0.89020772	,
			0.890393403	,
			0.890578807	,
			0.890763933	,
			0.890948779	,
			0.891133347	,
			0.891317637	,
			0.891501649	,
			0.891685384	,
			0.891868842	,
			0.892052023	,
			0.892234928	,
			0.892417556	,
			0.892599909	,
			0.892781986	,
			0.892963788	,
			0.893145316	,
			0.893326569	,
			0.893507547	,
			0.893688252	,
			0.893868684	,
			0.89404884	,
			0.894228726	,
			0.894408339	,
			0.89458768	,
			0.894766749	,
			0.894945546	,
			0.895124072	,
			0.895302328	,
			0.895480313	,
			0.895658027	,
			0.895835472	,
			0.896012647	,
			0.896189553	,
			0.89636619	,
			0.896542559	,
			0.896718659	,
			0.896894491	,
			0.897070055	,
			0.897245353	,
			0.897420383	,
			0.897595147	,
			0.897769644	,
			0.897943875	,
			0.898117841	,
			0.898291541	,
			0.898464976	,
			0.898638147	,
			0.898811053	,
			0.898983695	,
			0.899156073	,
			0.899328186	,
			0.899500038	,
			0.899671627	,
			0.899842953	,
			0.900014018	,
			0.90018482	,
			0.900355361	,
			0.900525641	,
			0.90069566	,
			0.900865418	,
			0.901034917	,
			0.901204155	,
			0.901373134	,
			0.901541853	,
			0.901710314	,
			0.901878516	,
			0.902046459	,
			0.902214145	,
			0.902381573	,
			0.902548744	,
			0.902715657	,
			0.902882314	,
			0.903048715	,
			0.903214859	,
			0.903380748	,
			0.903546381	,
			0.903711759	,
			0.903876882	,
			0.904041751	,
			0.904206366	,
			0.904370725	,
			0.904534832	,
			0.904698686	,
			0.904862287	,
			0.905025636	,
			0.905188732	,
			0.905351577	,
			0.905514169	,
			0.905676511	,
			0.905838601	,
			0.906000441	,
			0.90616203	,
			0.906323369	,
			0.906484459	,
			0.906645299	,
			0.906805889	,
			0.906966232	,
			0.907126325	,
			0.907286171	,
			0.907445768	,
			0.907605118	,
			0.907764221	,
			0.907923076	,
			0.908081686	,
			0.908240048	,
			0.908398165	,
			0.908556037	,
			0.908713662	,
			0.908871043	,
			0.909028179	,
			0.909185069	,
			0.909341716	,
			0.90949812	,
			0.90965428	,
			0.909810197	,
			0.909965871	,
			0.910121302	,
			0.910276491	,
			0.910431438	,
			0.910586144	,
			0.910740608	,
			0.910894831	,
			0.911048814	,
			0.911202556	,
			0.911356057	,
			0.911509319	,
			0.911662342	,
			0.911815125	,
			0.91196767	,
			0.912119976	,
			0.912272043	,
			0.912423873	,
			0.912575465	,
			0.91272682	,
			0.912877937	,
			0.913028818	,
			0.913179463	,
			0.913329871	,
			0.913480044	,
			0.913629981	,
			0.913779683	,
			0.913929148	,
			0.91407838	,
			0.914227378	,
			0.914376142	,
			0.914524672	,
			0.914672969	,
			0.914821033	,
			0.914968864	,
			0.915116463	,
			0.915263829	,
			0.915410964	,
			0.915557867	,
			0.915704538	,
			0.915850979	,
			0.915997189	,
			0.916143168	,
			0.916288918	,
			0.916434438	,
			0.916579728	,
			0.916724789	,
			0.916869622	,
			0.917014225	,
			0.917158601	,
			0.917302748	,
			0.917446668	,
			0.917590361	,
			0.917733826	,
			0.917877065	,
			0.918020077	,
			0.918162863	,
			0.918305422	,
			0.918447756	,
			0.918589866	,
			0.91873175	,
			0.918873409	,
			0.919014845	,
			0.919156056	,
			0.919297043	,
			0.919437807	,
			0.919578347	,
			0.919718665	,
			0.91985876	,
			0.919998633	,
			0.920138283	,
			0.920277712	,
			0.92041692	,
			0.920555906	,
			0.920694672	,
			0.920833217	,
			0.920971541	,
			0.921109646	,
			0.921247531	,
			0.921385197	,
			0.921522643	,
			0.921659871	,
			0.921796881	,
			0.921933672	,
			0.922070245	,
			0.9222066	,
			0.922342738	,
			0.922478658	,
			0.922614363	,
			0.922749851	,
			0.922885122	,
			0.923020178	,
			0.923155018	,
			0.923289643	,
			0.923424053	,
			0.923558248	,
			0.923692229	,
			0.923825995	,
			0.923959548	,
			0.924092887	,
			0.924226013	,
			0.924358926	,
			0.924491626	,
			0.924624114	,
			0.924756389	,
			0.924888453	,
			0.925020305	,
			0.925151946	,
			0.925283375	,
			0.925414595	,
			0.925545603	,
			0.925676402	,
			0.92580699	,
			0.92593737	,
			0.926067539	,
			0.9261975	,
			0.926327252	,
			0.926456796	,
			0.92658613	,
			0.926715258	,
			0.926844178	,
			0.926972891	,
			0.927101396	,
			0.927229695	,
			0.927357788	,
			0.927485674	,
			0.927613355	,
			0.927740829	,
			0.927868099	,
			0.927995163	,
			0.928122023	,
			0.928248678	,
			0.928375129	,
			0.928501376	,
			0.928627419	,
			0.928753259	,
			0.928878896	,
			0.92900433	,
			0.929129562	,
			0.929254591	,
			0.929379419	,
			0.929504044	,
			0.929628468	,
			0.929752691	,
			0.929876714	,
			0.930000535	,
			0.930124156	,
			0.930247578	,
			0.930370798	,
			0.93049382	,
			0.930616643	,
			0.930739267	,
			0.930861692	,
			0.930983919	,
			0.931105947	,
			0.931227778	,
			0.931349411	,
			0.931470847	,
			0.931592086	,
			0.931713128	,
			0.931833974	,
			0.931954623	,
			0.932075077	,
			0.932195335	,
			0.932315397	,
			0.932435265	,
			0.932554937	,
			0.932674415	,
			0.932793699	,
			0.932912789	,
			0.933031684	,
			0.933150387	,
			0.933268896	,
			0.933387212	,
			0.933505336	,
			0.933623267	,
			0.933741006	,
			0.933858553	,
			0.933975908	,
			0.934093072	,
			0.934210045	,
			0.934326828	,
			0.934443419	,
			0.934559821	,
			0.934676032	,
			0.934792054	,
			0.934907887	,
			0.93502353	,
			0.935138984	,
			0.93525425	,
			0.935369327	,
			0.935484216	,
			0.935598917	,
			0.93571343	,
			0.935827756	,
			0.935941896	,
			0.936055848	,
			0.936169614	,
			0.936283193	,
			0.936396586	,
			0.936509794	,
			0.936622816	,
			0.936735653	,
			0.936848305	,
			0.936960772	,
			0.937073055	,
			0.937185154	,
			0.937297068	,
			0.937408799	,
			0.937520346	,
			0.93763171	,
			0.937742892	,
			0.937853891	,
			0.937964707	,
			0.938075342	,
			0.938185794	,
			0.938296065	,
			0.938406155	,
			0.938516063	,
			0.938625791	,
			0.938735338	,
			0.938844705	,
			0.938953892	,
			0.939062899	,
			0.939171726	,
			0.939280375	,
			0.939388844	,
			0.939497134	,
			0.939605246	,
			0.93971318	,
			0.939820936	,
			0.939928513	,
			0.940035914	,
			0.940143137	,
			0.940250183	,
			0.940357053	,
			0.940463746	,
			0.940570262	,
			0.940676603	,
			0.940782768	,
			0.940888757	,
			0.940994572	,
			0.941100211	,
			0.941205676	,
			0.941310966	,
			0.941416082	,
			0.941521024	,
			0.941625793	,
			0.941730388	,
			0.941834809	,
			0.941939058	,
			0.942043134	,
			0.942147038	,
			0.942250769	,
			0.942354329	,
			0.942457717	,
			0.942560933	,
			0.942663978	,
			0.942766852	,
			0.942869556	,
			0.942972089	,
			0.943074451	,
			0.943176644	,
			0.943278667	,
			0.943380521	,
			0.943482205	,
			0.94358372	,
			0.943685067	,
			0.943786245	,
			0.943887255	,
			0.943988096	,
			0.94408877	,
			0.944189276	,
			0.944289615	,
			0.944389788	,
			0.944489793	,
			0.944589632	,
			0.944689304	,
			0.944788811	,
			0.944888151	,
			0.944987327	,
			0.945086336	,
			0.945185181	,
			0.945283861	,
			0.945382376	,
			0.945480727	,
			0.945578913	,
			0.945676936	,
			0.945774795	,
			0.945872491	,
			0.945970023	,
			0.946067393	,
			0.9461646	,
			0.946261644	,
			0.946358526	,
			0.946455247	,
			0.946551805	,
			0.946648202	,
			0.946744438	,
			0.946840512	,
			0.946936426	,
			0.947032179	,
			0.947127772	,
			0.947223205	,
			0.947318478	,
			0.947413591	,
			0.947508545	,
			0.94760334	,
			0.947697976	,
			0.947792454	,
			0.947886773	,
			0.947980933	,
			0.948074936	,
			0.948168781	,
			0.948262468	,
			0.948355999	,
			0.948449372	,
			0.948542588	,
			0.948635648	,
			0.948728551	,
			0.948821299	,
			0.94891389	,
			0.949006326	,
			0.949098606	,
			0.949190731	,
			0.949282702	,
			0.949374517	,
			0.949466178	,
			0.949557685	,
			0.949649037	,
			0.949740236	,
			0.949831281	,
			0.949922173	,
			0.950012912	,
			0.950103498	,
			0.950193931	,
			0.950284212	,
			0.95037434	,
			0.950464317	,
			0.950554142	,
			0.950643815	,
			0.950733337	,
			0.950822708	,
			0.950911928	,
			0.951000997	,
			0.951089916	,
			0.951178685	,
			0.951267304	,
			0.951355773	,
			0.951444093	,
			0.951532263	,
			0.951620285	,
			0.951708157	,
			0.951795881	,
			0.951883456	,
			0.951970884	,
			0.952058163	,
			0.952145294	,
			0.952232279	,
			0.952319115	,
			0.952405805	,
			0.952492348	,
			0.952578744	,
			0.952664994	,
			0.952751097	,
			0.952837055	,
			0.952922867	,
			0.953008534	,
			0.953094055	,
			0.953179431	,
			0.953264662	,
			0.953349749	,
			0.953434691	,
			0.953519489	,
			0.953604143	,
			0.953688653	,
			0.95377302	,
			0.953857243	,
			0.953941324	,
			0.954025261	,
			0.954109055	,
			0.954192708	,
			0.954276218	,
			0.954359585	,
			0.954442811	,
			0.954525896	,
			0.954608839	,
			0.954691641	,
			0.954774302	,
			0.954856822	,
			0.954939201	,
			0.95502144	,
			0.95510354	,
			0.955185498	,
			0.955267318	,
			0.955348998	,
			0.955430539	,
			0.95551194	,
			0.955593203	,
			0.955674328	,
			0.955755313	,
			0.955836161	,
			0.955916871	,
			0.955997443	,
			0.956077877	,
			0.956158174	,
			0.956238334	,
			0.956318356	,
			0.956398242	,
			0.956477992	,
			0.956557605	,
			0.956637082	,
			0.956716424	,
			0.956795629	,
			0.956874699	,
			0.956953634	,
			0.957032433	,
			0.957111098	,
			0.957189628	,
			0.957268024	,
			0.957346285	,
			0.957424413	,
			0.957502406	,
			0.957580266	,
			0.957657992	,
			0.957735586	,
			0.957813046	,
			0.957890373	,
			0.957967568	,
			0.95804463	,
			0.958121561	,
			0.958198359	,
			0.958275025	,
			0.95835156	,
			0.958427963	,
			0.958504235	,
			0.958580377	,
			0.958656387	,
			0.958732267	,
			0.958808016	,
			0.958883636	,
			0.958959125	,
			0.959034485	,
			0.959109715	,
			0.959184815	,
			0.959259786	,
			0.959334629	,
			0.959409342	,
			0.959483928	,
			0.959558384	,
			0.959632713	,
			0.959706913	,
			0.959780986	,
			0.959854931	,
			0.959928749	,
			0.960002439	,
			0.960076002	,
			0.960149439	,
			0.960222749	,
			0.960295933	,
			0.96036899	,
			0.960441922	,
			0.960514727	,
			0.960587407	,
			0.960659962	,
			0.960732391	,
			0.960804696	,
			0.960876875	,
			0.96094893	,
			0.96102086	,
			0.961092666	,
			0.961164348	,
			0.961235906	,
			0.961307341	,
			0.961378652	,
			0.961449839	,
			0.961520904	,
			0.961591846	,
			0.961662664	,
			0.961733361	,
			0.961803935	,
			0.961874387	,
			0.961944717	,
			0.962014925	,
			0.962085011	,
			0.962154976	,
			0.96222482	,
			0.962294543	,
			0.962364145	,
			0.962433626	,
			0.962502988	,
			0.962572228	,
			0.962641349	,
			0.96271035	,
			0.962779231	,
			0.962847993	,
			0.962916635	,
			0.962985158	,
			0.963053562	,
			0.963121848	,
			0.963190015	,
			0.963258063	,
			0.963325994	,
			0.963393806	,
			0.963461501	,
			0.963529077	,
			0.963596537	,
			0.963663879	,
			0.963731104	,
			0.963798212	,
			0.963865204	,
			0.963932078	,
			0.963998837	,
			0.964065479	,
			0.964132006	,
			0.964198416	,
			0.964264711	,
			0.96433089	,
			0.964396955	,
			0.964462904	,
			0.964528738	,
			0.964594458	,
			0.964660063	,
			0.964725554	,
			0.96479093	,
			0.964856193	,
			0.964921341	,
			0.964986376	,
			0.965051298	,
			0.965116107	,
			0.965180802	,
			0.965245384	,
			0.965309854	,
			0.965374211	,
			0.965438456	,
			0.965502588	,
			0.965566609	,
			0.965630517	,
			0.965694314	,
			0.965758	,
			0.965821574	,
			0.965885037	,
			0.965948389	,
			0.966011631	,
			0.966074762	,
			0.966137782	,
			0.966200692	,
			0.966263492	,
			0.966326182	,
			0.966388762	,
			0.966451233	,
			0.966513594	,
			0.966575847	,
			0.96663799	,
			0.966700024	,
			0.96676195	,
			0.966823767	,
			0.966885476	,
			0.966947076	,
			0.967008569	,
			0.967069954	,
			0.967131231	,
			0.967192401	,
			0.967253463	,
			0.967314418	,
			0.967375266	,
			0.967436008	,
			0.967496643	,
			0.967557171	,
			0.967617593	,
			0.967677909	,
			0.96773812	,
			0.967798224	,
			0.967858223	,
			0.967918116	,
			0.967977904	,
			0.968037587	,
			0.968097165	,
			0.968156638	,
			0.968216007	,
			0.968275271	,
			0.968334431	,
			0.968393487	,
			0.968452439	,
			0.968511287	,
			0.968570031	,
			0.968628673	,
			0.968687211	,
			0.968745646	,
			0.968803977	,
			0.968862207	,
			0.968920333	,
			0.968978357	,
			0.969036279	,
			0.969094099	,
			0.969151817	,
			0.969209433	,
			0.969266948	,
			0.969324361	,
			0.969381672	,
			0.969438883	,
			0.969495993	,
			0.969553002	,
			0.96960991	,
			0.969666718	,
			0.969723425	,
			0.969780033	,
			0.96983654	,
			0.969892948	,
			0.969949256	,
			0.970005464	,
			0.970061573	,
			0.970117583	,
			0.970173494	,
			0.970229306	,
			0.970285019	,
			0.970340634	,
			0.970396151	,
			0.970451569	,
			0.970506889	,
			0.970562111	,
			0.970617236	,
			0.970672263	,
			0.970727192	,
			0.970782025	,
			0.97083676	,
			0.970891398	,
			0.970945939	,
			0.971000384	,
			0.971054733	,
			0.971108985	,
			0.97116314	,
			0.9712172	,
			0.971271164	,
			0.971325033	,
			0.971378805	,
			0.971432483	,
			0.971486065	,
			0.971539552	,
			0.971592944	,
			0.971646241	,
			0.971699444	,
			0.971752552	,
			0.971805566	,
			0.971858486	,
			0.971911312	,
			0.971964044	,
			0.972016682	,
			0.972069227	,
			0.972121678	,
			0.972174037	,
			0.972226302	,
			0.972278474	,
			0.972330553	,
			0.97238254	,
			0.972434434	,
			0.972486236	,
			0.972537946	,
			0.972589564	,
			0.97264109	,
			0.972692524	,
			0.972743866	,
			0.972795118	,
			0.972846278	,
			0.972897346	,
			0.972948324	,
			0.972999211	,
			0.973050007	,
			0.973100713	,
			0.973151329	,
			0.973201854	,
			0.973252289	,
			0.973302634	,
			0.973352889	,
			0.973403055	,
			0.973453131	,
			0.973503118	,
			0.973553016	,
			0.973602824	,
			0.973652544	,
			0.973702175	,
			0.973751718	,
			0.973801171	,
			0.973850537	,
			0.973899814	,
			0.973949004	,
			0.973998105	,
			0.974047119	,
			0.974096045	,
			0.974144884	,
			0.974193635	,
			0.974242299	,
			0.974290877	,
			0.974339367	,
			0.97438777	,
			0.974436087	,
			0.974484318	,
			0.974532462	,
			0.97458052	,
			0.974628492	,
			0.974676378	,
			0.974724179	,
			0.974771894	,
			0.974819523	,
			0.974867067	,
			0.974914526	,
			0.974961899	,
			0.975009188	,
			0.975056393	,
			0.975103512	,
			0.975150547	,
			0.975197498	,
			0.975244365	,
			0.975291147	,
			0.975337846	,
			0.97538446	,
			0.975430992	,
			0.975477439	,
			0.975523804	,
			0.975570085	,
			0.975616283	,
			0.975662398	,
			0.97570843	,
			0.97575438	,
			0.975800247	,
			0.975846031	,
			0.975891734	,
			0.975937354	,
			0.975982892	,
			0.976028349	,
			0.976073723	,
			0.976119017	,
			0.976164228	,
			0.976209359	,
			0.976254408	,
			0.976299376	,
			0.976344263	,
			0.97638907	,
			0.976433795	,
			0.976478441	,
			0.976523006	,
			0.976567491	,
			0.976611895	,
			0.97665622	,
			0.976700465	,
			0.97674463	,
			0.976788716	,
			0.976832722	,
			0.976876649	,
			0.976920496	,
			0.976964265	,
			0.977007955	,
			0.977051566	,
			0.977095098	,
			0.977138552	,
			0.977181927	,
			0.977225224	,
			0.977268443	,
			0.977311585	,
			0.977354648	,
			0.977397633	,
			0.977440541	,
			0.977483372	,
			0.977526125	,
			0.977568801	,
			0.977611399	,
			0.977653921	,
			0.977696366	,
			0.977738735	,
			0.977781026	,
			0.977823242	,
			0.977865381	,
			0.977907444	,
			0.97794943	,
			0.977991341	,
			0.978033176	,
			0.978074936	,
			0.97811662	,
			0.978158228	,
			0.978199761	,
			0.978241219	,
			0.978282602	,
			0.97832391	,
			0.978365144	,
			0.978406302	,
			0.978447386	,
			0.978488396	,
			0.978529332	,
			0.978570193	,
			0.97861098	,
			0.978651693	,
			0.978692333	,
			0.978732899	,
			0.978773391	,
			0.97881381	,
			0.978854155	,
			0.978894428	,
			0.978934627	,
			0.978974754	,
			0.979014807	,
			0.979054788	,
			0.979094697	,
			0.979134533	,
			0.979174296	,
			0.979213988	,
			0.979253608	,
			0.979293155	,
			0.979332631	,
			0.979372035	,
			0.979411367	,
			0.979450628	,
			0.979489818	,
			0.979528936	,
			0.979567984	,
			0.97960696	,
			0.979645865	,
			0.9796847	,
			0.979723464	,
			0.979762158	,
			0.979800781	,
			0.979839334	,
			0.979877817	,
			0.97991623	,
			0.979954573	,
			0.979992846	,
			0.98003105	,
			0.980069184	,
			0.980107248	,
			0.980145243	,
			0.980183169	,
			0.980221026	,
			0.980258814	,
			0.980296534	,
			0.980334184	,
			0.980371766	,
			0.980409279	,
			0.980446724	,
			0.980484101	,
			0.980521409	,
			0.98055865	,
			0.980595822	,
			0.980632927	,
			0.980669964	,
			0.980706934	,
			0.980743836	,
			0.980780671	,
			0.980817438	,
			0.980854139	,
			0.980890772	,
			0.980927339	,
			0.980963839	,
			0.981000272	,
			0.981036638	,
			0.981072939	,
			0.981109172	,
			0.98114534	,
			0.981181442	,
			0.981217477	,
			0.981253447	,
			0.981289351	,
			0.981325189	,
			0.981360962	,
			0.98139667	,
			0.981432312	,
			0.981467889	,
			0.981503401	,
			0.981538847	,
			0.981574229	,
			0.981609547	,
			0.981644799	,
			0.981679987	,
			0.981715111	,
			0.981750171	,
			0.981785166	,
			0.981820097	,
			0.981854964	,
			0.981889767	,
			0.981924507	,
			0.981959183	,
			0.981993795	,
			0.982028344	,
			0.98206283	,
			0.982097252	,
			0.982131611	,
			0.982165907	,
			0.982200141	,
			0.982234311	,
			0.982268419	,
			0.982302465	,
			0.982336448	,
			0.982370368	,
			0.982404226	,
			0.982438023	,
			0.982471757	,
			0.982505429	,
			0.982539039	,
			0.982572588	,
			0.982606075	,
			0.982639501	,
			0.982672865	,
			0.982706168	,
			0.982739409	,
			0.98277259	,
			0.98280571	,
			0.982838768	,
			0.982871766	,
			0.982904704	,
			0.982937581	,
			0.982970397	,
			0.983003153	,
			0.983035849	,
			0.983068484	,
			0.98310106	,
			0.983133576	,
			0.983166031	,
			0.983198428	,
			0.983230764	,
			0.983263041	,
			0.983295258	,
			0.983327417	,
			0.983359516	,
			0.983391556	,
			0.983423536	,
			0.983455458	,
			0.983487322	,
			0.983519126	,
			0.983550872	,
			0.983582559	,
			0.983614188	,
			0.983645759	,
			0.983677271	,
			0.983708726	,
			0.983740122	,
			0.98377146	,
			0.983802741	,
			0.983833964	,
			0.983865129	,
			0.983896237	,
			0.983927288	,
			0.983958281	,
			0.983989217	,
			0.984020096	,
			0.984050918	,
			0.984081683	,
			0.984112391	,
			0.984143042	,
			0.984173637	,
			0.984204175	,
			0.984234657	,
			0.984265083	,
			0.984295452	,
			0.984325766	,
			0.984356023	,
			0.984386224	,
			0.98441637	,
			0.984446459	,
			0.984476493	,
			0.984506472	,
			0.984536395	,
			0.984566263	,
			0.984596075	,
			0.984625833	,
			0.984655535	,
			0.984685183	,
			0.984714775	,
			0.984744313	,
			0.984773796	,
			0.984803224	,
			0.984832598	,
			0.984861918	,
			0.984891183	,
			0.984920394	,
			0.984949551	,
			0.984978654	,
			0.985007703	,
			0.985036698	,
			0.98506564	,
			0.985094528	,
			0.985123362	,
			0.985152143	,
			0.98518087	,
			0.985209545	,
			0.985238166	,
			0.985266734	,
			0.985295249	,
			0.985323711	,
			0.98535212	,
			0.985380477	,
			0.98540878	,
			0.985437032	,
			0.985465231	,
			0.985493378	,
			0.985521472	,
			0.985549514	,
			0.985577504	,
			0.985605442	,
			0.985633329	,
			0.985661163	,
			0.985688946	,
			0.985716677	,
			0.985744357	,
			0.985771985	,
			0.985799562	,
			0.985827087	,
			0.985854562	,
			0.985881985	,
			0.985909358	,
			0.985936679	,
			0.98596395	,
			0.98599117	,
			0.986018339	,
			0.986045458	,
			0.986072526	,
			0.986099544	,
			0.986126511	,
			0.986153429	,
			0.986180296	,
			0.986207114	,
			0.986233881	,
			0.986260599	,
			0.986287266	,
			0.986313884	,
			0.986340453	,
			0.986366972	,
			0.986393442	,
			0.986419862	,
			0.986446233	,
			0.986472555	,
			0.986498828	,
			0.986525052	,
			0.986551227	,
			0.986577353	,
			0.986603431	,
			0.98662946	,
			0.98665544	,
			0.986681372	,
			0.986707256	,
			0.986733091	,
			0.986758878	,
			0.986784617	,
			0.986810308	,
			0.986835951	,
			0.986861546	,
			0.986887093	,
			0.986912593	,
			0.986938045	,
			0.986963449	,
			0.986988806	,
			0.987014116	,
			0.987039378	,
			0.987064594	,
			0.987089762	,
			0.987114883	,
			0.987139957	,
			0.987164984	,
			0.987189965	,
			0.987214898	,
			0.987239786	,
			0.987264626	,
			0.98728942	,
			0.987314168	,
			0.98733887	,
			0.987363525	,
			0.987388134	,
			0.987412697	,
			0.987437214	,
			0.987461686	,
			0.987486111	,
			0.987510491	,
			0.987534825	,
			0.987559114	,
			0.987583357	,
			0.987607555	,
			0.987631707	,
			0.987655814	,
			0.987679876	,
			0.987703893	,
			0.987727865	,
			0.987751792	,
			0.987775674	,
			0.987799512	,
			0.987823305	,
			0.987847053	,
			0.987870756	,
			0.987894416	,
			0.98791803	,
			0.987941601	,
			0.987965127	,
			0.98798861	,
			0.988012048	,
			0.988035442	,
			0.988058792	,
			0.988082099	,
			0.988105362	,
			0.988128581	,
			0.988151756	,
			0.988174888	,
			0.988197977	,
			0.988221022	,
			0.988244024	,
			0.988266983	,
			0.988289899	,
			0.988312771	,
			0.988335601	,
			0.988358388	,
			0.988381132	,
			0.988403833	,
			0.988426491	,
			0.988449107	,
			0.988471681	,
			0.988494212	,
			0.9885167	,
			0.988539147	,
			0.988561551	,
			0.988583913	,
			0.988606233	,
			0.988628511	,
			0.988650747	,
			0.988672941	,
			0.988695094	,
			0.988717205	,
			0.988739274	,
			0.988761301	,
			0.988783288	,
			0.988805233	,
			0.988827136	,
			0.988848998	,
			0.988870819	,
			0.988892599	,
			0.988914338	,
			0.988936036	,
			0.988957693	,
			0.98897931	,
			0.989000885	,
			0.98902242	,
			0.989043915	,
			0.989065369	,
			0.989086782	,
			0.989108155	,
			0.989129488	,
			0.98915078	,
			0.989172033	,
			0.989193245	,
			0.989214417	,
			0.98923555	,
			0.989256642	,
			0.989277695	,
			0.989298708	,
			0.989319681	,
			0.989340615	,
			0.989361509	,
			0.989382364	,
			0.98940318	,
			0.989423956	,
			0.989444693	,
			0.98946539	,
			0.989486049	,
			0.989506669	,
			0.989527249	,
			0.989547791	,
			0.989568294	,
			0.989588758	,
			0.989609184	,
			0.989629571	,
			0.98964992	,
			0.98967023	,
			0.989690501	,
			0.989710734	,
			0.989730929	,
			0.989751086	,
			0.989771205	,
			0.989791286	,
			0.989811328	,
			0.989831333	,
			0.9898513	,
			0.989871229	,
			0.989891121	,
			0.989910975	,
			0.989930791	,
			0.98995057	,
			0.989970311	,
			0.989990015	,
			0.990009681	,
			0.990029311	,
			0.990048903	,
			0.990068458	,
			0.990087976	,
			0.990107457	,
			0.990126901	,
			0.990146309	,
			0.990165679	,
			0.990185013	,
			0.990204311	,
			0.990223571	,
			0.990242795	,
			0.990261983	,
			0.990281134	,
			0.990300249	,
			0.990319328	,
			0.990338371	,
			0.990357377	,
			0.990376348	,
			0.990395282	,
			0.990414181	,
			0.990433043	,
			0.99045187	,
			0.990470662	,
			0.990489417	,
			0.990508137	,
			0.990526821	,
			0.99054547	,
			0.990564084	,
			0.990582662	,
			0.990601205	,
			0.990619712	,
			0.990638185	,
			0.990656622	,
			0.990675025	,
			0.990693392	,
			0.990711725	,
			0.990730022	,
			0.990748285	,
			0.990766513	,
			0.990784707	,
			0.990802866	,
			0.990820991	,
			0.990839081	,
			0.990857136	,
			0.990875157	,
			0.990893144	,
			0.990911097	,
			0.990929016	,
			0.990946901	,
			0.990964751	,
			0.990982568	,
			0.99100035	,
			0.991018099	,
			0.991035814	,
			0.991053496	,
			0.991071143	,
			0.991088757	,
			0.991106338	,
			0.991123885	,
			0.991141399	,
			0.991158879	,
			0.991176326	,
			0.99119374	,
			0.99121112	,
			0.991228468	,
			0.991245782	,
			0.991263064	,
			0.991280312	,
			0.991297528	,
			0.991314711	,
			0.991331861	,
			0.991348978	,
			0.991366063	,
			0.991383115	,
			0.991400135	,
			0.991417122	,
			0.991434077	,
			0.991451	,
			0.99146789	,
			0.991484748	,
			0.991501574	,
			0.991518367	,
			0.991535129	,
			0.991551859	,
			0.991568557	,
			0.991585222	,
			0.991601856	,
			0.991618459	,
			0.991635029	,
			0.991651568	,
			0.991668076	,
			0.991684552	,
			0.991700996	,
			0.991717409	,
			0.991733791	,
			0.991750141	,
			0.99176646	,
			0.991782748	,
			0.991799005	,
			0.991815231	,
			0.991831425	,
			0.991847589	,
			0.991863722	,
			0.991879824	,
			0.991895895	,
			0.991911936	,
			0.991927945	,
			0.991943925	,
			0.991959873	,
			0.991975791	,
			0.991991679	,
			0.992007536	,
			0.992023363	,
			0.99203916	,
			0.992054926	,
			0.992070662	,
			0.992086369	,
			0.992102045	,
			0.992117691	,
			0.992133307	,
			0.992148893	,
			0.992164449	,
			0.992179976	,
			0.992195473	,
			0.99221094	,
			0.992226377	,
			0.992241785	,
			0.992257164	,
			0.992272512	,
			0.992287832	,
			0.992303122	,
			0.992318383	,
			0.992333615	,
			0.992348817	,
			0.99236399	,
			0.992379134	,
			0.99239425	,
			0.992409336	,
			0.992424393	,
			0.992439421	,
			0.992454421	,
			0.992469392	,
			0.992484334	,
			0.992499247	,
			0.992514132	,
			0.992528988	,
			0.992543815	,
			0.992558615	,
			0.992573385	,
			0.992588128	,
			0.992602842	,
			0.992617528	,
			0.992632186	,
			0.992646815	,
			0.992661417	,
			0.99267599	,
			0.992690535	,
			0.992705053	,
			0.992719542	,
			0.992734004	,
			0.992748438	,
			0.992762844	,
			0.992777223	,
			0.992791574	,
			0.992805897	,
			0.992820193	,
			0.992834461	,
			0.992848702	,
			0.992862915	,
			0.992877102	,
			0.99289126	,
			0.992905392	,
			0.992919496	,
			0.992933574	,
			0.992947624	,
			0.992961647	,
			0.992975643	,
			0.992989613	,
			0.993003555	,
			0.993017471	,
			0.993031359	,
			0.993045222	,
			0.993059057	,
			0.993072866	,
			0.993086648	,
			0.993100403	,
			0.993114132	,
			0.993127835	,
			0.993141511	,
			0.993155161	,
			0.993168785	,
			0.993182382	,
			0.993195954	,
			0.993209499	,
			0.993223018	,
			0.99323651	,
			0.993249977	,
			0.993263418	,
			0.993276833	,
			0.993290222	,
			0.993303586	,
			0.993316923	,
			0.993330235	,
			0.993343521	,
			0.993356782	,
			0.993370017	,
			0.993383226	,
			0.99339641	,
			0.993409569	,
			0.993422702	,
			0.99343581	,
			0.993448892	,
			0.993461949	,
			0.993474981	,
			0.993487988	,
			0.99350097	,
			0.993513927	,
			0.993526859	,
			0.993539765	,
			0.993552647	,
			0.993565504	,
			0.993578336	,
			0.993591143	,
			0.993603926	,
			0.993616684	,
			0.993629417	,
			0.993642126	,
			0.99365481	,
			0.993667469	,
			0.993680104	,
			0.993692715	,
			0.993705301	,
			0.993717863	,
			0.993730401	,
			0.993742914	,
			0.993755404	,
			0.993767869	,
			0.99378031	,
			0.993792727	,
			0.99380512	,
			0.993817488	,
			0.993829833	,
			0.993842155	,
			0.993854452	,
			0.993866725	,
			0.993878975	,
			0.993891201	,
			0.993903403	,
			0.993915582	,
			0.993927737	,
			0.993939869	,
			0.993951977	,
			0.993964062	,
			0.993976123	,
			0.993988161	,
			0.994000175	,
			0.994012167	,
			0.994024135	,
			0.99403608	,
			0.994048002	,
			0.9940599	,
			0.994071776	,
			0.994083628	,
			0.994095458	,
			0.994107265	,
			0.994119049	,
			0.99413081	,
			0.994142548	,
			0.994154263	,
			0.994165956	,
			0.994177626	,
			0.994189273	,
			0.994200898	,
			0.9942125	,
			0.99422408	,
			0.994235637	,
			0.994247172	,
			0.994258685	,
			0.994270175	,
			0.994281643	,
			0.994293088	,
			0.994304512	,
			0.994315913	,
			0.994327292	,
			0.994338649	,
			0.994349984	,
			0.994361297	,
			0.994372588	,
			0.994383857	,
			0.994395104	,
			0.994406329	,
			0.994417533	,
			0.994428715	,
			0.994439875	,
			0.994451013	,
			0.99446213	,
			0.994473225	,
			0.994484298	,
			0.99449535	,
			0.994506381	,
			0.99451739	,
			0.994528377	,
			0.994539344	,
			0.994550289	,
			0.994561212	,
			0.994572115	,
			0.994582996	,
			0.994593856	,
			0.994604695	,
			0.994615513	,
			0.99462631	,
			0.994637086	,
			0.994647841	,
			0.994658575	,
			0.994669288	,
			0.99467998	,
			0.994690651	,
			0.994701302	,
			0.994711932	,
			0.994722541	,
			0.99473313	,
			0.994743698	,
			0.994754245	,
			0.994764772	,
			0.994775278	,
			0.994785764	,
			0.99479623	,
			0.994806675	,
			0.994817099	,
			0.994827504	,
			0.994837888	,
			0.994848252	,
			0.994858595	,
			0.994868919	,
			0.994879222	,
			0.994889506	,
			0.994899769	,
			0.994910012	,
			0.994920236	,
			0.994930439	,
			0.994940622	,
			0.994950786	,
			0.99496093	,
			0.994971054	,
			0.994981158	,
			0.994991243	,
			0.995001308	,
			0.995011353	,
			0.995021379	,
			0.995031385	,
			0.995041371	,
			0.995051338	,
			0.995061286	,
			0.995071214	,
			0.995081123	,
			0.995091013	,
			0.995100883	,
			0.995110734	,
			0.995120565	,
			0.995130378	,
			0.995140171	,
			0.995149945	,
			0.9951597	,
			0.995169436	,
			0.995179153	,
			0.995188852	,
			0.995198531	,
			0.995208191	,
			0.995217832	,
			0.995227455	,
			0.995237058	,
			0.995246643	,
			0.995256209	,
			0.995265757	,
			0.995275286	,
			0.995284796	,
			0.995294287	,
			0.99530376	,
			0.995313215	,
			0.995322651	,
			0.995332068	,
			0.995341467	,
			0.995350848	,
			0.995360211	,
			0.995369555	,
			0.99537888	,
			0.995388188	,
			0.995397477	,
			0.995406748	,
			0.995416002	,
			0.995425236	,
			0.995434453	,
			0.995443652	,
			0.995452833	,
			0.995461996	,
			0.99547114	,
			0.995480267	,
			0.995489376	,
			0.995498468	,
			0.995507541	,
			0.995516597	,
			0.995525635	,
			0.995534655	,
			0.995543657	,
			0.995552642	,
			0.99556161	,
			0.995570559	,
			0.995579491	,
			0.995588406	,
			0.995597303	,
			0.995606183	,
			0.995615045	,
			0.99562389	,
			0.995632718	,
			0.995641528	,
			0.995650322	,
			0.995659097	,
			0.995667856	,
			0.995676597	,
			0.995685322	,
			0.995694029	,
			0.995702719	,
			0.995711392	,
			0.995720048	,
			0.995728687	,
			0.995737309	,
			0.995745914	,
			0.995754502	,
			0.995763074	,
			0.995771628	,
			0.995780166	,
			0.995788687	,
			0.995797192	,
			0.995805679	,
			0.99581415	,
			0.995822604	,
			0.995831042	,
			0.995839463	,
			0.995847868	,
			0.995856256	,
			0.995864628	,
			0.995872983	,
			0.995881321	,
			0.995889644	,
			0.99589795	,
			0.99590624	,
			0.995914513	,
			0.99592277	,
			0.995931011	,
			0.995939236	,
			0.995947444	,
			0.995955637	,
			0.995963813	,
			0.995971973	,
			0.995980117	,
			0.995988245	,
			0.995996357	,
			0.996004454	,
			0.996012534	,
			0.996020598	,
			0.996028647	,
			0.99603668	,
			0.996044696	,
			0.996052698	,
			0.996060683	,
			0.996068653	,
			0.996076606	,
			0.996084545	,
			0.996092467	,
			0.996100375	,
			0.996108266	,
			0.996116142	,
			0.996124002	,
			0.996131847	,
			0.996139677	,
			0.996147491	,
			0.99615529	,
			0.996163073	,
			0.996170841	,
			0.996178594	,
			0.996186331	,
			0.996194054	,
			0.996201761	,
			0.996209453	,
			0.996217129	,
			0.996224791	,
			0.996232437	,
			0.996240068	,
			0.996247685	,
			0.996255286	,
			0.996262872	,
			0.996270444	,
			0.996278	,
			0.996285542	,
			0.996293068	,
			0.99630058	,
			0.996308077	,
			0.996315559	,
			0.996323027	,
			0.99633048	,
			0.996337918	,
			0.996345341	,
			0.99635275	,
			0.996360144	,
			0.996367523	,
			0.996374888	,
			0.996382238	,
			0.996389574	,
			0.996396896	,
			0.996404203	,
			0.996411495	,
			0.996418773	,
			0.996426037	,
			0.996433286	,
			0.996440522	,
			0.996447742	,
			0.996454949	,
			0.996462141	,
			0.996469319	,
			0.996476483	,
			0.996483633	,
			0.996490769	,
			0.99649789	,
			0.996504998	,
			0.996512091	,
			0.99651917	,
			0.996526236	,
			0.996533287	,
			0.996540325	,
			0.996547348	,
			0.996554358	,
			0.996561354	,
			0.996568336	,
			0.996575304	,
			0.996582259	,
			0.996589199	,
			0.996596126	,
			0.996603039	,
			0.996609939	,
			0.996616825	,
			0.996623697	,
			0.996630556	,
			0.996637401	,
			0.996644233	,
			0.996651051	,
			0.996657855	,
			0.996664647	,
			0.996671424	,
			0.996678188	,
			0.996684939	,
			0.996691677	,
			0.996698401	,
			0.996705112	,
			0.996711809	,
			0.996718494	,
			0.996725165	,
			0.996731823	,
			0.996738467	,
			0.996745099	,
			0.996751717	,
			0.996758322	,
			0.996764915	,
			0.996771494	,
			0.99677806	,
			0.996784613	,
			0.996791153	,
			0.99679768	,
			0.996804194	,
			0.996810696	,
			0.996817184	,
			0.996823659	,
			0.996830122	,
			0.996836572	,
			0.996843009	,
			0.996849433	,
			0.996855845	,
			0.996862244	,
			0.99686863	,
			0.996875004	,
			0.996881364	,
			0.996887713	,
			0.996894048	,
			0.996900371	,
			0.996906682	,
			0.99691298	,
			0.996919266	,
			0.996925539	,
			0.996931799	,
			0.996938047	,
			0.996944283	,
			0.996950507	,
			0.996956718	,
			0.996962916	,
			0.996969103	,
			0.996975277	,
			0.996981439	,
			0.996987588	,
			0.996993726	,
			0.996999851	,
			0.997005964	,
			0.997012065	,
			0.997018154	,
			0.99702423	,
			0.997030295	,
			0.997036348	,
			0.997042388	,
			0.997048417	,
			0.997054433	,
			0.997060438	,
			0.997066431	,
			0.997072411	,
			0.99707838	,
			0.997084337	,
			0.997090283	,
			0.997096216	,
			0.997102137	,
			0.997108047	,
			0.997113945	,
			0.997119832	,
			0.997125706	,
			0.997131569	,
			0.99713742	,
			0.99714326	,
			0.997149088	,
			0.997154904	,
			0.997160709	,
			0.997166503	,
			0.997172284	,
			0.997178055	,
			0.997183813	,
			0.997189561	,
			0.997195296	,
			0.997201021	,
			0.997206734	,
			0.997212436	,
			0.997218126	,
			0.997223805	,
			0.997229473	,
			0.997235129	,
			0.997240774	,
			0.997246408	,
			0.997252031	,
			0.997257642	,
			0.997263243	,
			0.997268832	,
			0.99727441	,
			0.997279977	,
			0.997285533	};
	
		double x = 0;
		for(int i = 0; x <= 1; i++ ){
			double calcPDF = var3.pdf(x);
			double calcCDF = var3.cdf(x);
			assertEquals("Probability Density Function non equal", realPDF[i], calcPDF, 1.0E-5);
			assertEquals("Cumulative Probability Function  non equal", realCDF[i], calcCDF, 1.0E-5);
			x += 0.25;
		}
		
		assertTrue("Matrix changed", ((new DenseMatrix(matrix3)).add(-1, var3.getMatrix())).norm(Matrix.Norm.Maxvalue)<1.0E-5);
		assertTrue("Vector changed", ((new DenseVector(vector3)).add(-1, var3.getVector())).norm(Vector.Norm.Infinity)<1.0E-5  );
		}

}