/*
 * Decompiled with CFR 0.152.
 */
package jphase.generator;

import java.util.Random;
import jphase.AbstractContPhaseVar;
import jphase.generator.GeneratorUtils;
import jphase.generator.PhaseGenerator;

public class NeutsContPHGenerator
extends PhaseGenerator {
    double[] alphaDist;
    int[] alphaAlias;
    double[] alphaCutoff;
    double[] rates;
    double[][] matrixDist;
    int[][] matrixAlias;
    double[][] matrixCutoff;
    Random rand;

    public NeutsContPHGenerator(AbstractContPhaseVar var) {
        super(var);
    }

    @Override
    public double getRandom() {
        boolean absorbed = false;
        double x = 0.0;
        int n = this.var.getNumPhases();
        int[] k = new int[n + 1];
        int estado = GeneratorUtils.getNumber(this.alphaDist, this.alphaAlias, this.alphaCutoff, this.rand);
        if (estado == 0) {
            absorbed = true;
        }
        while (!absorbed) {
            int n2 = estado;
            k[n2] = k[n2] + 1;
            if ((estado = GeneratorUtils.getNumber(this.matrixDist[estado - 1], this.matrixAlias[estado - 1], this.matrixCutoff[estado - 1], this.rand)) != 0) continue;
            absorbed = true;
        }
        int i = 0;
        while (i < n) {
            if (k[i + 1] > 0) {
                x += GeneratorUtils.erlang(this.rates[i], k[i + 1], this.rand);
            }
            ++i;
        }
        return x;
    }

    @Override
    public double[] getRandom(int num) {
        double[] numbers = new double[num];
        int i = 0;
        while (i < num) {
            numbers[i] = this.getRandom();
            ++i;
        }
        return numbers;
    }

    @Override
    protected void initialize() {
        this.rand = new Random();
        int n = this.var.getNumPhases();
        this.alphaDist = new double[n + 1];
        this.alphaAlias = new int[n + 1];
        this.alphaCutoff = new double[n + 1];
        this.rates = new double[n];
        this.matrixDist = new double[n][n + 1];
        this.matrixAlias = new int[n][n + 1];
        this.matrixCutoff = new double[n][n + 1];
        int i = 0;
        while (i < n) {
            this.alphaDist[i + 1] = this.var.getVector().get(i);
            ++i;
        }
        this.alphaDist[0] = 1.0 - Math.min(GeneratorUtils.sum(this.alphaDist), 1.0);
        GeneratorUtils.aliasCut(this.alphaDist, this.alphaAlias, this.alphaCutoff);
        int j = 0;
        while (j < n) {
            this.rates[j] = -this.var.getMatrix().get(j, j);
            int i2 = 0;
            while (i2 < n) {
                this.matrixDist[j][i2 + 1] = this.var.getMatrix().get(j, i2) / this.rates[j];
                ++i2;
            }
            this.matrixDist[j][j + 1] = 0.0;
            this.matrixDist[j][0] = 1.0 - Math.min(GeneratorUtils.sum(this.matrixDist[j]), 1.0);
            GeneratorUtils.aliasCut(this.matrixDist[j], this.matrixAlias[j], this.matrixCutoff[j]);
            ++j;
        }
    }
}

