/*
 * Decompiled with CFR 0.152.
 */
package jphase.distributions;

import cern.colt.list.DoubleArrayList;
import java.util.ArrayList;
import jphase.distributions.EDistribution;
import jphase.distributions.IDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.randvar.NormalACRGen;
import umontreal.iro.lecuyer.randvar.NormalBoxMullerGen;
import umontreal.iro.lecuyer.randvar.NormalKindermannRamageGen;
import umontreal.iro.lecuyer.randvar.NormalPolarGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

class Normal
extends EDistribution
implements IDistribution {
    public Normal(ArrayList<Double> paramatros) {
        double media = 0.0;
        double desv = 1.0;
        if (paramatros != null) {
            media = paramatros.get(0);
            desv = paramatros.get(1);
        }
        this.generadores = new ArrayList();
        this.generadores.add("KindermannRamage(Default)");
        this.generadores.add("Polar");
        this.generadores.add("BoxMuller");
        this.generadores.add("NormalACR");
        this.parametros = new ArrayList();
        this.parametros.add("Media");
        this.parametros.add("Desviacion");
        this.distribucion = new NormalDist(media, desv);
    }

    @Override
    public RandomVariateGen darGenerador(RandomStream s, String nombre, ArrayList<Double> paramatros) {
        double media = 0.0;
        double desv = 1.0;
        if (paramatros != null) {
            media = paramatros.get(0);
            desv = paramatros.get(1);
        }
        this.generador = nombre.equals("Polar") ? new NormalPolarGen(s, media, desv) : (nombre.equals("KindermannRamage(Default)") ? new NormalKindermannRamageGen(s, media, desv) : (nombre.equals("BoxMuller") ? new NormalBoxMullerGen(s, media, desv) : new NormalACRGen(s, media, desv)));
        return this.generador;
    }

    @Override
    public RandomVariateGen darGenerador(RandomStream s, String d) {
        this.generador = d == null || d.equals("KindermannRamage(Default)") ? new NormalKindermannRamageGen(s, (NormalDist)this.darDistribucion()) : (d.equals("Polar") ? new NormalPolarGen(s, (NormalDist)this.darDistribucion()) : (d.equals("BoxMuller") ? new NormalBoxMullerGen(s, (NormalDist)this.darDistribucion()) : new NormalACRGen(s, (NormalDist)this.darDistribucion())));
        return this.generador;
    }

    @Override
    public void ajustarParametros(DoubleArrayList data) {
        double[] para = NormalDist.getMLE((double[])data.elements(), (int)data.size());
        this.distribucion = new NormalDist(para[0], para[1]);
    }

    @Override
    public double[] getMoments() {
        double[] mom = new double[]{this.distribucion.getMean(), this.distribucion.getStandardDeviation(), 0.0};
        return mom;
    }

    @Override
    public String aString() {
        NormalDist dis = (NormalDist)this.distribucion;
        return "Normal with mu: " + this.nSig(dis.getMean(), 3) + ", sigma:  " + this.nSig(dis.getSigma(), 3);
    }

    @Override
    public String getName() {
        return "Normal";
    }
}

