/*
 * Decompiled with CFR 0.152.
 */
package jphase.distributions;

import cern.colt.list.DoubleArrayList;
import java.util.ArrayList;
import jphase.distributions.EDistribution;
import jphase.distributions.IDistribution;
import umontreal.iro.lecuyer.probdist.ErlangDist;
import umontreal.iro.lecuyer.randvar.ErlangGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

class Erlang
extends EDistribution
implements IDistribution {
    public Erlang(ArrayList<Double> paramatros) {
        double k = 1.0;
        double lambda = 1.0;
        if (paramatros != null) {
            k = paramatros.get(0);
            lambda = paramatros.get(1);
        }
        this.generadores = new ArrayList();
        this.generadores.add("ErlangGen");
        this.parametros = new ArrayList();
        this.parametros.add("k");
        this.parametros.add("lambda");
        this.distribucion = new ErlangDist((int)k, lambda);
    }

    @Override
    public RandomVariateGen darGenerador(RandomStream s, String nombre, ArrayList<Double> paramatros) {
        double k = 1.0;
        double lambda = 1.0;
        if (paramatros != null) {
            k = paramatros.get(0);
            lambda = paramatros.get(1);
        }
        if (nombre.equals("ErlangGen")) {
            this.generador = new ErlangGen(s, (int)k, lambda);
        }
        return this.generador;
    }

    @Override
    public RandomVariateGen darGenerador(RandomStream s, String d) {
        this.generador = new ErlangGen(s, (ErlangDist)this.darDistribucion());
        return this.generador;
    }

    @Override
    public void ajustarParametros(DoubleArrayList data) {
        double[] para = ErlangDist.getMLE((double[])data.elements(), (int)data.size());
        this.distribucion = new ErlangDist((int)para[0], para[1]);
    }

    @Override
    public double[] getMoments() {
        double[] mom = new double[]{this.distribucion.getMean(), this.distribucion.getStandardDeviation(), 2.0 / Math.sqrt(((ErlangDist)this.distribucion).getK())};
        return mom;
    }

    @Override
    public String aString() {
        ErlangDist dis = (ErlangDist)this.distribucion;
        return "Erlang with k: " + this.nSig(dis.getK(), 3) + ", lambda:  " + this.nSig(dis.getLambda(), 3);
    }

    @Override
    public String getName() {
        return "Erlang";
    }
}

