/*
 * Decompiled with CFR 0.152.
 */
package jphase;

import java.util.ArrayList;
import jphase.Utils;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.BiCG;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;

public class MatrixUtils {
    static double Epsilon = 1.0E-10;
    private static double[] a = new double[101];
    private static double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    private static double[] fac = new double[33];
    private static int topN = 0;

    public static Matrix kroneckerSum(Matrix A, Matrix B) {
        int rows1 = A.numRows();
        int rows2 = B.numRows();
        return MatrixUtils.kronecker(A, (Matrix)Matrices.identity((int)rows2)).add(MatrixUtils.kronecker((Matrix)Matrices.identity((int)rows1), B));
    }

    public static Matrix kroneckerSum(Matrix A, Matrix B, Matrix res) {
        int r1 = A.numRows();
        int r2 = B.numRows();
        res = MatrixUtils.kronecker(A, (Matrix)Matrices.identity((int)r2), res.copy()).add(MatrixUtils.kronecker((Matrix)Matrices.identity((int)r1), B, res.copy()));
        return res;
    }

    public static Matrix kronecker(Matrix A, Matrix B) {
        int r1 = A.numRows();
        int c1 = A.numColumns();
        int r2 = B.numRows();
        int c2 = B.numColumns();
        DenseMatrix result = new DenseMatrix(r1 * r2, c1 * c2);
        int i1 = 0;
        while (i1 < r1) {
            int j1 = 0;
            while (j1 < c1) {
                int i2 = 0;
                while (i2 < r2) {
                    int j2 = 0;
                    while (j2 < c2) {
                        result.set(i1 * r2 + i2, j1 * c2 + j2, A.get(i1, j1) * B.get(i2, j2));
                        ++j2;
                    }
                    ++i2;
                }
                ++j1;
            }
            ++i1;
        }
        return result;
    }

    public static Matrix kronecker(Matrix A, Matrix B, Matrix res) {
        int r1 = A.numRows();
        int c1 = A.numColumns();
        int r2 = B.numRows();
        int c2 = B.numColumns();
        int r3 = res.numRows();
        int c3 = res.numColumns();
        if (r1 * r2 != r3 || c1 * c2 != c3) {
            throw new IndexOutOfBoundsException("Matrices cannot be Kronecker multiplied: (" + r1 + " * " + r2 + " != " + r3 + "  or  " + c1 + " * " + c2 + " != " + c3 + ")");
        }
        int i1 = 0;
        while (i1 < r1) {
            int j1 = 0;
            while (j1 < c1) {
                int i2 = 0;
                while (i2 < r2) {
                    int j2 = 0;
                    while (j2 < c2) {
                        res.set(i1 * r2 + i2, j1 * c2 + j2, A.get(i1, j1) * B.get(i2, j2));
                        ++j2;
                    }
                    ++i2;
                }
                ++j1;
            }
            ++i1;
        }
        return res;
    }

    public static Matrix kronecker(Matrix A, Vector B, Matrix res) {
        int r1 = A.numRows();
        int c1 = A.numColumns();
        int n2 = B.size();
        int r3 = res.numRows();
        int c3 = res.numColumns();
        if (r1 * n2 != r3 || c1 != c3) {
            throw new IndexOutOfBoundsException("Matrices cannot be Kronecker multiplied: \nA.numRows * B.size != res.numRows  or  A.numCols  != res.numCols\n (" + r1 + "*" + n2 + " != " + r3 + "   or   " + c1 + " != " + c3 + ")");
        }
        int i1 = 0;
        while (i1 < r1) {
            int j1 = 0;
            while (j1 < c1) {
                int i2 = 0;
                while (i2 < n2) {
                    res.set(i1 * n2 + i2, j1, A.get(i1, j1) * B.get(i2));
                    ++i2;
                }
                ++j1;
            }
            ++i1;
        }
        return res;
    }

    public static Matrix kroneckerMxRowVector(Matrix A, Vector B, Matrix res) {
        int r1 = A.numRows();
        int c1 = A.numColumns();
        int n2 = B.size();
        int r3 = res.numRows();
        int c3 = res.numColumns();
        if (r1 != r3 || c1 * n2 != c3) {
            throw new IndexOutOfBoundsException("Matrices cannot be Kronecker multiplied: \nA.numRows != res.numRows  or  A.numCols* B.size  != res.numCols\n (" + r1 + " != " + r3 + "   or   " + c1 + "*" + n2 + " != " + c3 + ")");
        }
        int i1 = 0;
        while (i1 < r1) {
            int j1 = 0;
            while (j1 < c1) {
                int i2 = 0;
                while (i2 < n2) {
                    res.set(i1, j1 * c1 + i2, A.get(i1, j1) * B.get(i2));
                    ++i2;
                }
                ++j1;
            }
            ++i1;
        }
        return res;
    }

    public static Matrix kronecker(Vector A, Matrix B, Matrix res) {
        int n1 = A.size();
        int r2 = B.numRows();
        int c2 = B.numColumns();
        int r3 = res.numRows();
        int c3 = res.numColumns();
        if (n1 * r2 != r3 || c2 != c3) {
            throw new IndexOutOfBoundsException("Matrices cannot be Kronecker multiplied: \nA.size * B.numRows != res.numRows   or   B.numCols != res.numCols (" + n1 + " * " + r2 + " != " + r3 + "   or   " + c2 + " != " + c3 + ")");
        }
        int i1 = 0;
        while (i1 < n1) {
            int i2 = 0;
            while (i2 < r2) {
                int j2 = 0;
                while (j2 < c2) {
                    res.set(i1 * r2 + i2, j2, A.get(i1) * B.get(i2, j2));
                    ++j2;
                }
                ++i2;
            }
            ++i1;
        }
        return res;
    }

    public static DenseVector kroneckerVectors(DenseVector A, DenseVector B) {
        int n1 = A.size();
        int n2 = B.size();
        DenseVector result = new DenseVector(n1 * n2);
        int i1 = 0;
        while (i1 < n1) {
            int i2 = 0;
            while (i2 < n2) {
                result.set(i1 * n2 + i2, A.get(i1) * B.get(i2));
                ++i2;
            }
            ++i1;
        }
        return result;
    }

    public static Vector kroneckerVectors(Vector A, Vector B, Vector res) {
        int n2;
        int n1 = A.size();
        if (n1 * (n2 = B.size()) != res.size()) {
            throw new IndexOutOfBoundsException("Vectors cannot be Kronecker multiplied: (" + n1 + "*" + n2 + " != " + res.size() + ")");
        }
        int i1 = 0;
        while (i1 < n1) {
            int i2 = 0;
            while (i2 < n2) {
                res.set(i1 * n2 + i2, A.get(i1) * B.get(i2));
                ++i2;
            }
            ++i1;
        }
        return res;
    }

    public static DenseMatrix OnesRow(int m) {
        DenseMatrix vec = new DenseMatrix(1, m);
        int i = 0;
        while (i < m) {
            vec.set(0, i, 1.0);
            ++i;
        }
        return vec;
    }

    public static DenseMatrix OnesCol(int m) {
        DenseMatrix vec = new DenseMatrix(m, 1);
        int i = 0;
        while (i < m) {
            vec.set(i, 0, 1.0);
            ++i;
        }
        return vec;
    }

    public static DenseVector OnesVector(int m) {
        DenseVector vec = new DenseVector(m);
        int i = 0;
        while (i < m) {
            vec.set(i, 1.0);
            ++i;
        }
        return vec;
    }

    public static Vector OnesVector(Vector vec) {
        int i = 0;
        while (i < vec.size()) {
            vec.set(i, 1.0);
            ++i;
        }
        return vec;
    }

    public static double pow(double x, int n) {
        double mult = 1.0;
        if (n < 0) {
            n = -n;
            x = 1.0 / x;
        }
        int i = 1;
        while (i <= n) {
            mult *= x;
            ++i;
        }
        return mult;
    }

    public static double distance(double[] v1, double[] v2) {
        int n = v1.length;
        if (n != v2.length) {
            return -1.0;
        }
        double maxi = -1.0;
        int i = 0;
        while (i < n) {
            double del2 = v1[i] - v2[i];
            double del = v1[i] > 0.0 ? del2 / v1[i] : del2;
            maxi = Math.max(maxi, del * del);
            ++i;
        }
        return Math.sqrt(maxi);
    }

    public static Matrix expTimesOnes(Matrix A, double x) {
        int n = A.numColumns();
        return MatrixUtils.exp(A, x, (Matrix)Matrices.identity((int)n), (Matrix)MatrixUtils.OnesRow(n));
    }

    public static Matrix expTimesOnes(Matrix A, double x, Matrix leftMat) {
        int n = A.numColumns();
        return MatrixUtils.exp(A, x, leftMat, (Matrix)MatrixUtils.OnesCol(n));
    }

    public static double expTimesOnes(Matrix A, double x, Vector leftVec) {
        return MatrixUtils.exp(A, x, leftVec, MatrixUtils.OnesVector(leftVec.copy()));
    }

    public static Matrix[] expTimesOnes(Matrix A, int n, double delta, Matrix leftMat) {
        int m = A.numColumns();
        return MatrixUtils.exp(A, n, delta, leftMat, (Matrix)MatrixUtils.OnesCol(m), true);
    }

    public static double[] expTimesOnes(Matrix A, int n, double delta, Vector leftVec) {
        return MatrixUtils.exp(A, n, delta, leftVec, MatrixUtils.OnesVector(leftVec.copy()), true);
    }

    public static double scalar(Matrix A) {
        if (A.numColumns() == 1) {
            return A.get(0, 0);
        }
        throw new NumberFormatException("Max iterations reached computing exp()");
    }

    public static Matrix exp(Matrix A, double x, Matrix leftMat, Matrix rightMat) {
        Matrix[] result = MatrixUtils.exp(A, 2, x, leftMat, rightMat, true);
        return result[1];
    }

    public static double exp(Matrix A, double x, Vector leftVec, Vector rightVec) {
        double[] result = MatrixUtils.exp(A, 2, x, leftVec, rightVec, true);
        return result[1];
    }

    public static Matrix exp(Matrix A, double x) {
        int n = A.numColumns();
        Matrix[] result = MatrixUtils.exp(A, 2, x, (Matrix)Matrices.identity((int)n), (Matrix)Matrices.identity((int)n), true);
        return result[1];
    }

    public static Matrix exp(Matrix A, double x, Matrix leftMat, Matrix rightMat, boolean useUniformization) {
        Matrix[] result = MatrixUtils.exp(A, 2, x, leftMat, rightMat, useUniformization);
        return result[1];
    }

    public static Matrix[] exp(Matrix A, int n, double delta, Matrix leftMat, Matrix rightMat, boolean useUniformization) {
        if (useUniformization) {
            return MatrixUtils.expUnif(A, n, delta, leftMat, rightMat);
        }
        return MatrixUtils.expRunge(A, n, delta, leftMat, rightMat);
    }

    public static double[] exp(Matrix A, int n, double delta, Vector leftVec, Vector rightVec, boolean useUniformization) {
        if (useUniformization) {
            return MatrixUtils.expUnif(A, n, delta, leftVec, rightVec);
        }
        return null;
    }

    public static Matrix[] expRunge(Matrix A, int n, double delta, Matrix leftMat, Matrix rightMat) {
        Matrix[] result = new Matrix[n];
        Matrix y = leftMat.copy();
        double bigStep = delta;
        double ldaMax = -1.0;
        ldaMax = MatrixUtils.computeLdaMax(A);
        double k = Math.ceil(ldaMax * bigStep);
        double step = bigStep / k;
        double xVal = 0.0;
        int i = 0;
        while (i < n) {
            result[i] = y.mult(rightMat, y.copy());
            int j = 0;
            while ((double)j < k) {
                y = MatrixUtils.runge4(A, y, step);
                xVal += step;
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static Matrix runge4(Matrix A, Matrix y, double step) {
        Matrix k4 = null;
        Matrix k3 = null;
        Matrix k2 = null;
        Matrix k1 = null;
        Matrix t3 = null;
        Matrix t2 = null;
        Matrix t1 = null;
        k1 = y.multAdd(step, A, k1).scale(0.5);
        t1 = y.add(k1);
        k2 = t1.multAdd(step, A, k2).scale(0.5);
        t1 = y.add(k2);
        k3 = t2.mult(step, A, k3);
        t3 = y.add(k3);
        k4 = t3.mult(step, A, k4);
        k2 = k2.scale(2.0);
        k1 = k1.scale(2.0);
        y = y.add(0.16666666666666666, k1.add(k2).add(k3).add(k4));
        return y;
    }

    private static double computeLdaMax(Matrix A) {
        double ldaMax = 0.0;
        int n = A.numRows();
        int i = 0;
        while (i < n) {
            ldaMax = Math.max(ldaMax, -A.get(i, i));
            ++i;
        }
        return ldaMax;
    }

    public static Matrix[] expUnif(Matrix A, double x, Matrix leftMat, Matrix rightMat) {
        return MatrixUtils.expUnif(A, new double[]{x}, leftMat, rightMat, Integer.MAX_VALUE);
    }

    public static Matrix[] expUnif(Matrix A, int n, double delta, Matrix leftMat, Matrix rightMat) {
        return MatrixUtils.expUnif(A, n, delta, leftMat, rightMat, Integer.MAX_VALUE);
    }

    public static double[] expUnif(Matrix A, int n, double delta, Vector leftVec, Vector rightVec) {
        return MatrixUtils.expUnif(A, n, delta, leftVec, rightVec, Integer.MAX_VALUE);
    }

    public static Matrix[] expUnif(Matrix A, double[] times, Matrix leftMat, Matrix rightMat) {
        return MatrixUtils.expUnif(A, times, leftMat, rightMat, Integer.MAX_VALUE);
    }

    public static Matrix[] expUnif(Matrix A, int n, double delta, Matrix leftMat, Matrix rightMat, int truncate) {
        double[] times = new double[n];
        int i = 0;
        while (i < n) {
            times[i] = delta * (double)i;
            ++i;
        }
        return MatrixUtils.expUnif(A, times, leftMat, rightMat, truncate);
    }

    public static double[] expUnif(Matrix A, int n, double delta, Vector leftVec, Vector rightVec, int truncate) {
        double[] times = new double[n];
        int i = 0;
        while (i < n) {
            times[i] = delta * (double)i;
            ++i;
        }
        return MatrixUtils.expUnif(A, times, leftVec, rightVec, truncate);
    }

    public static Matrix[] expUnif(Matrix A, double[] times, Matrix leftMat, Matrix rightMat, int truncate) {
        DenseMatrix difMat;
        double dif;
        ArrayList<Matrix> Avec = new ArrayList<Matrix>();
        double ldaMax = MatrixUtils.computeLdaMax(A);
        Matrix matP = MatrixUtils.getNormalized(A, ldaMax);
        int n = times.length;
        long MaxIterations = Math.max(200, (int)(4.0 * ldaMax * times[n - 1]));
        DenseMatrix M = new DenseMatrix(leftMat.numRows(), rightMat.numColumns());
        DenseMatrix M1 = new DenseMatrix(leftMat.numRows(), A.numColumns());
        Matrix temp = Matrices.identity((int)A.numRows()).add(-1.0, matP);
        DenseMatrix tempInv = new DenseMatrix(A.numRows(), A.numColumns());
        tempInv = temp.solve((Matrix)Matrices.identity((int)temp.numRows()), (Matrix)tempInv);
        M1 = leftMat.mult((Matrix)tempInv, (Matrix)M1);
        M = M1.mult(rightMat, (Matrix)M);
        DenseMatrix Ak = new DenseMatrix(leftMat.numRows(), rightMat.numColumns());
        Ak = leftMat.mult(rightMat, (Matrix)Ak);
        Avec.add(Ak.copy());
        DenseMatrix sumA = (DenseMatrix)Ak.copy();
        int k = 0;
        DenseMatrix V = new DenseMatrix(matP.numRows(), rightMat.numColumns());
        V = matP.mult(rightMat, (Matrix)V);
        do {
            ++k;
            Ak = leftMat.mult((Matrix)V, (Matrix)Ak);
            Avec.add(Ak.copy());
            sumA = (DenseMatrix)sumA.add((Matrix)Ak);
            V = matP.mult((Matrix)V, (Matrix)new DenseMatrix(matP.numRows(), rightMat.numColumns()));
            difMat = new DenseMatrix(sumA.numRows(), sumA.numColumns());
            difMat = sumA.copy();
        } while ((dif = Math.abs((difMat = difMat.add(-1.0, (Matrix)M)).norm(Matrix.Norm.Infinity))) > Epsilon && (long)k < MaxIterations && k < truncate);
        if ((long)k == MaxIterations && truncate == Integer.MAX_VALUE) {
            System.err.println("Max iterations reached (" + MaxIterations + ")");
        }
        int maxK = k;
        Matrix[] As = new Matrix[maxK + 1];
        k = 0;
        while (k <= maxK) {
            As[k] = (Matrix)Avec.get(k);
            ++k;
        }
        Matrix[] result = new Matrix[n];
        int i = 0;
        while (i < n) {
            double ldaX = ldaMax * times[i];
            double pk = Math.exp(-ldaX);
            if (pk < Double.MIN_VALUE) {
                System.out.println("pk menor que Double.MIN_VALUE");
                result[i] = MatrixUtils.resultFromMedian(As, ldaX);
            } else {
                double sumPk = pk;
                result[i] = As[0].copy();
                result[i].scale(pk);
                k = 1;
                while (k <= maxK) {
                    sumPk += (pk *= ldaX / (double)k);
                    result[i] = result[i].add(pk, As[k]);
                    ++k;
                }
            }
            ++i;
        }
        Matrix[] GrmResult = new Matrix[n];
        int i2 = 0;
        while (i2 < n) {
            GrmResult[i2] = result[i2].copy();
            ++i2;
        }
        return GrmResult;
    }

    public static double[] expUnif(Matrix A, double[] times, Vector leftVec, Vector rightVec, int truncate) {
        double dif;
        ArrayList<Double> Avec = new ArrayList<Double>();
        double ldaMax = MatrixUtils.computeLdaMax(A);
        Matrix matP = MatrixUtils.getNormalized(A, ldaMax);
        int n = times.length;
        long MaxIterations = Math.max(200, (int)(4.0 * ldaMax * times[n - 1]));
        double m = 0.0;
        Vector M1 = rightVec.copy();
        Matrix temp = matP.copy().scale(-1.0).add((Matrix)Matrices.identity((int)A.numRows()));
        BiCG solver = new BiCG(M1);
        try {
            solver.solve(temp, rightVec, M1);
        }
        catch (IterativeSolverNotConvergedException e) {
            e.printStackTrace();
        }
        m = leftVec.dot(M1);
        double ak = 0.0;
        ak = leftVec.dot(rightVec);
        Avec.add(new Double(ak));
        double sumA = ak;
        int k = 0;
        Vector V = leftVec.copy().zero();
        V = matP.mult(rightVec, V);
        do {
            ++k;
            ak = leftVec.dot(V);
            Avec.add(new Double(ak));
            V = matP.mult(V, V.copy());
            double difMat = sumA += ak;
        } while ((dif = Math.abs(difMat -= m)) > Epsilon && (long)k < MaxIterations && k < truncate);
        if ((long)k == MaxIterations) {
            // empty if block
        }
        int maxK = k;
        double[] As = new double[maxK + 1];
        k = 0;
        while (k <= maxK) {
            As[k] = (Double)Avec.get(k);
            ++k;
        }
        double[] result = new double[n];
        int i = 0;
        while (i < n) {
            double ldaX = ldaMax * times[i];
            double pk = Math.exp(-ldaX);
            if (pk < Double.MIN_VALUE) {
                System.out.println("pk menor que Double.MIN_VALUE");
                result[i] = MatrixUtils.resultFromMedian(As, ldaX);
            } else {
                double sumPk = pk;
                result[i] = As[0];
                int n2 = i;
                result[n2] = result[n2] * pk;
                k = 1;
                while (k <= maxK) {
                    sumPk += (pk *= ldaX / (double)k);
                    result[i] = result[i] + pk * As[k];
                    ++k;
                }
            }
            ++i;
        }
        double[] GrmResult = new double[n];
        int i2 = 0;
        while (i2 < n) {
            GrmResult[i2] = result[i2];
            ++i2;
        }
        return GrmResult;
    }

    private static Matrix resultFromMedian(Matrix[] A, double ldaX) {
        double p_plus;
        if (ldaX == 0.0) {
            return A[0];
        }
        int median = (int)Math.floor(ldaX);
        double p_minus = p_plus = Math.exp(-ldaX + (double)median * Math.log(ldaX) - Utils.lnFactorial(median));
        double sumPk = p_plus;
        Matrix result = median < A.length ? A[median].scale(p_plus) : A[median].zero();
        int k_minus = median;
        int k_plus = median;
        int maxK = Math.max(median, A.length - median + 1);
        int k = 1;
        while (k < maxK && sumPk < 0.999) {
            p_minus = p_minus * (double)(--k_minus + 1) / ldaX;
            sumPk += (p_plus *= ldaX / (double)(++k_plus)) + p_minus;
            if (k_plus < A.length) {
                result = result.add(p_plus, A[k_plus]);
            }
            if (k_minus < A.length && k_minus >= 0) {
                result = result.add(p_minus, A[k_minus]);
            }
            ++k;
        }
        return result;
    }

    private static double resultFromMedian(double[] A, double ldaX) {
        double p_plus;
        if (ldaX == 0.0) {
            return A[0];
        }
        int median = (int)Math.floor(ldaX);
        double p_minus = p_plus = Math.exp(-ldaX + (double)median * Math.log(ldaX) - Utils.lnFactorial(median));
        double sumPk = p_plus;
        double result = median < A.length ? A[median] * p_plus : 0.0;
        int k_minus = median;
        int k_plus = median;
        int maxK = Math.max(median, A.length - median + 1);
        int k = 1;
        while (k < maxK && sumPk < 0.999) {
            p_minus = p_minus * (double)(--k_minus + 1) / ldaX;
            sumPk += (p_plus *= ldaX / (double)(++k_plus)) + p_minus;
            if (k_plus < A.length) {
                result += p_plus * A[k_plus];
            }
            if (k_minus < A.length && k_minus >= 0) {
                result += p_minus * A[k_minus];
            }
            ++k;
        }
        return result;
    }

    private static Matrix getNormalized(Matrix A) {
        Matrix normal = null;
        double ldaMax = MatrixUtils.computeLdaMax(A);
        normal = MatrixUtils.getNormalized(A, ldaMax);
        return normal;
    }

    private static Matrix getNormalized(Matrix A, double ldaMax) {
        Matrix normal = null;
        int n = A.numRows();
        normal = A.copy().scale(1.0 / ldaMax).add((Matrix)Matrices.identity((int)n));
        return normal;
    }

    public static double average(double[] datos) {
        double media = 0.0;
        int i = 0;
        while (i < datos.length) {
            media += datos[i];
            ++i;
        }
        return media / (double)datos.length;
    }

    public static double average2(double[] data) {
        double media2 = 0.0;
        int i = 0;
        while (i < data.length) {
            media2 += data[i] * data[i];
            ++i;
        }
        return media2 / (double)data.length;
    }

    public static double variance(double[] data) {
        double media = MatrixUtils.average(data);
        return MatrixUtils.average2(data) - media * media;
    }

    public static double CV(double[] data) {
        double media = MatrixUtils.average(data);
        return MatrixUtils.variance(data) / (media * media);
    }

    public static DenseMatrix concatCols(DenseMatrix A, DenseMatrix B) {
        int j;
        int r1 = A.numRows();
        int c1 = A.numColumns();
        int r2 = B.numRows();
        int c2 = B.numColumns();
        if (r1 != r2) {
            throw new IndexOutOfBoundsException("Matrices cannot be concatenated: (" + r1 + "," + c1 + ")|(" + r2 + "," + c2 + ")");
        }
        DenseMatrix C = new DenseMatrix(r1, c1 + c2);
        int i = 0;
        while (i < r1) {
            j = 0;
            while (j < c1) {
                C.set(i, j, A.get(i, j));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < r1) {
            j = c1;
            while (j < c1 + c2) {
                C.set(i, j, B.get(i, j - c1));
                ++j;
            }
            ++i;
        }
        return C;
    }

    public static Matrix concatCols(Matrix A, Matrix B, Matrix res) {
        int j;
        int r1 = A.numRows();
        int c1 = A.numColumns();
        int r2 = B.numRows();
        int c2 = B.numColumns();
        int r3 = res.numRows();
        int c3 = res.numColumns();
        if (r1 != r2 || r1 != r3 || c1 + c2 != c3) {
            throw new IndexOutOfBoundsException("Matrices cannot be concatenated: (" + r1 + "," + c1 + ")|(" + r2 + "," + c2 + ") in (" + r3 + "," + c3 + ")");
        }
        int i = 0;
        while (i < r1) {
            j = 0;
            while (j < c1) {
                res.set(i, j, A.get(i, j));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < r1) {
            j = c1;
            while (j < c1 + c2) {
                res.set(i, j, B.get(i, j - c1));
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static DenseMatrix concatRows(DenseMatrix A, DenseMatrix B) {
        int j;
        int r1 = A.numRows();
        int c1 = A.numColumns();
        int r2 = B.numRows();
        int c2 = B.numColumns();
        if (c1 != c2) {
            throw new IndexOutOfBoundsException("Matrices cannot be concatenated: (" + r1 + "," + c1 + ")\n--\n(" + r2 + "," + c2 + ")");
        }
        DenseMatrix C = new DenseMatrix(r1 + r2, c1);
        int i = 0;
        while (i < r1) {
            j = 0;
            while (j < c1) {
                C.set(i, j, A.get(i, j));
                ++j;
            }
            ++i;
        }
        i = r1;
        while (i < r1 + r2) {
            j = 0;
            while (j < c1) {
                C.set(i, j, B.get(i - r1, j));
                ++j;
            }
            ++i;
        }
        return C;
    }

    public static Matrix concatRows(Matrix A, Matrix B, Matrix res) {
        int j;
        int r1 = A.numRows();
        int c1 = A.numColumns();
        int r2 = B.numRows();
        int c2 = B.numColumns();
        int r3 = res.numRows();
        int c3 = res.numColumns();
        if (c1 != c2 || c1 != c3 || r1 + r2 != r3) {
            throw new IndexOutOfBoundsException("Matrices cannot be concatenated: (" + r1 + "," + c1 + ")\n--\n(" + r2 + "," + c2 + ")in (" + r3 + "," + c3 + ")");
        }
        int i = 0;
        while (i < r1) {
            j = 0;
            while (j < c1) {
                res.set(i, j, A.get(i, j));
                ++j;
            }
            ++i;
        }
        i = r1;
        while (i < r1 + r2) {
            j = 0;
            while (j < c1) {
                res.set(i, j, B.get(i - r1, j));
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static Matrix concatQuad(Matrix leftUp, Matrix rightUp, Matrix leftDown, Matrix rightDown, Matrix res) {
        int j;
        int r1 = leftUp.numRows();
        int c1 = leftUp.numColumns();
        int r2 = rightUp.numRows();
        int c2 = rightUp.numColumns();
        int r3 = leftDown.numRows();
        int c3 = leftDown.numColumns();
        int r4 = rightDown.numRows();
        int c4 = rightDown.numColumns();
        int r5 = res.numRows();
        int c5 = res.numColumns();
        if (r1 != r2 || r3 != r4 || r1 + r3 != r5 || c1 != c3 || c2 != c4 || c1 + c2 != c5) {
            throw new IndexOutOfBoundsException("Matrices cannot be concatenated: (" + r1 + "," + c1 + ")|(" + r2 + "," + c2 + ")\n--\n" + r3 + "," + c3 + ")|(" + r4 + "," + c4 + ") in (" + r5 + "," + c5 + ")");
        }
        int i = 0;
        while (i < r1) {
            j = 0;
            while (j < c1) {
                res.set(i, j, leftUp.get(i, j));
                ++j;
            }
            j = 0;
            while (j < c2) {
                res.set(i, c1 + j, rightUp.get(i, j));
                ++j;
            }
            ++i;
        }
        i = r1;
        while (i < r1 + r3) {
            j = 0;
            while (j < c1) {
                res.set(i, j, leftDown.get(i - r1, j));
                ++j;
            }
            j = 0;
            while (j < c2) {
                res.set(i, c1 + j, rightDown.get(i - r1, j));
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static DenseVector concatVectors(DenseVector A, DenseVector B) {
        int c1 = A.size();
        int c2 = B.size();
        DenseVector C = new DenseVector(c1 + c2);
        int i = 0;
        while (i < c1) {
            C.set(i, A.get(i));
            ++i;
        }
        i = c1;
        while (i < c1 + c2) {
            C.set(i, B.get(i - c1));
            ++i;
        }
        return C;
    }

    public static Vector concatVectors(Vector A, Vector B, Vector res) {
        int n1 = A.size();
        int n2 = B.size();
        if (res.size() != n1 + n2) {
            throw new IndexOutOfBoundsException("res.size() != A.size() + B.size() (" + res.size() + " != " + (A.size() + B.size()) + ")");
        }
        int i = 0;
        while (i < n1) {
            res.set(i, A.get(i));
            ++i;
        }
        i = n1;
        while (i < n1 + n2) {
            res.set(i, B.get(i - n1));
            ++i;
        }
        return res;
    }

    public static Matrix multVector(Vector A, Vector B, Matrix res) {
        int n = res.numRows();
        int m = res.numColumns();
        if (A.size() != n) {
            throw new IndexOutOfBoundsException("A.size() != res.numRows() (" + A.size() + " != " + n + ")");
        }
        if (B.size() != m) {
            throw new IndexOutOfBoundsException("B.size() != res.numColumns() (" + B.size() + " != " + m + ")");
        }
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                res.set(i, j, A.get(i) * B.get(j));
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static Matrix matPower(Matrix A, int k) {
        int n = A.numColumns();
        if (k < 0) {
            throw new IllegalArgumentException("The moments are defined for k >= 0");
        }
        if (k == 0) {
            return Matrices.identity((int)n);
        }
        Matrix result = A.copy();
        int i = 1;
        while (i < k) {
            result = result.mult(A, A.copy());
            ++i;
        }
        return result;
    }

    public static double matPower(Matrix A, int k, Vector leftVec, Vector rightVec) {
        if (k == 0) {
            return leftVec.dot(rightVec);
        }
        if (k == 1) {
            return leftVec.dot(A.mult(rightVec, rightVec.copy().zero()));
        }
        return leftVec.dot(MatrixUtils.matPower(A, k).mult(rightVec, rightVec.copy().zero()));
    }

    public static double sumMatPower(Matrix A, int k, Vector leftVec, Vector rightVec) {
        if (k < 1) {
            System.out.println("Sum of Matrix Power less than one");
            return 0.0;
        }
        DenseMatrix temp = Matrices.identity((int)A.numRows());
        Matrix sum = temp.copy();
        int i = 1;
        while (i < k) {
            temp.mult(A, temp.copy());
            sum.add((Matrix)temp);
            ++i;
        }
        return leftVec.dot(sum.mult(rightVec, rightVec.copy().zero()));
    }
}

