/*
 * Decompiled with CFR 0.152.
 */
package jphase;

import jphase.AbstractContPhaseVar;
import jphase.ContPhaseVar;
import jphase.PhaseVar;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;

public class HypoExponentialVar
extends AbstractContPhaseVar
implements PhaseVar {
    private int N;
    private double[] lambdas;

    public HypoExponentialVar() {
        this.N = 1;
        this.lambdas = new double[1];
        this.lambdas[0] = 1.0;
    }

    public HypoExponentialVar(int n) {
        this.N = n;
    }

    public HypoExponentialVar(double[] lambdas) {
        this.N = lambdas.length;
        this.lambdas = lambdas;
    }

    public double[] getLambdas() {
        return this.lambdas;
    }

    public void setLambdas(double[] lambdas) {
        this.lambdas = lambdas;
    }

    @Override
    public Matrix getMatrix() {
        return new DenseMatrix(this.getDMatrix());
    }

    public double[][] getDMatrix() {
        double[][] matriz = new double[this.N][this.N];
        int i = 0;
        while (i < this.N) {
            double lambda = this.lambdas[i];
            matriz[i][i] = -lambda;
            if (i < this.N - 1) {
                matriz[i][i + 1] = lambda;
            }
            ++i;
        }
        return matriz;
    }

    @Override
    public void setMatrix(Matrix A) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Vector getVector() {
        return new DenseVector(this.getDVector());
    }

    public double[] getDVector() {
        double[] vector = new double[this.N];
        vector[0] = 1.0;
        return vector;
    }

    @Override
    public void setVector(Vector alpha) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ContPhaseVar copy() {
        return new HypoExponentialVar(this.lambdas);
    }

    @Override
    public ContPhaseVar newVar(int n) {
        return new HypoExponentialVar(n);
    }

    @Override
    public int getNumPhases() {
        return this.N;
    }

    @Override
    public double expectedValue() {
        double suma = 0.0;
        int i = 0;
        while (i != this.lambdas.length) {
            suma += 1.0 / this.lambdas[i];
            ++i;
        }
        return suma;
    }
}

