/*
 * Decompiled with CFR 0.152.
 */
package jphase.GUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jphase.FittingLEcuyer;
import jphase.GUI.MainFrame;
import jphase.GUI.PhaseFitResultDialog;
import jphase.GUI.PhaseVarInfo;
import jphase.values.FitResult;

public class PhaseGOF
extends JDialog
implements ItemListener,
ActionListener {
    private final String SELECT = "Select";
    public final String ACEPT = "Acept";
    public final String CANCEL = "Close";
    public JLabel sizeV;
    public JTextField cantF;
    public JLabel percentage;
    public JTextField perc;
    public JLabel save;
    public JButton saveB;
    public JButton ACEPTB;
    public JButton CANCELB;
    private FittingLEcuyer fitting;
    private String ruta;
    public ArrayList<PhaseVarInfo> variables;
    public JComboBox varCombo;

    public PhaseGOF(MainFrame window) {
        this.variables = window.getVariables();
        this.setTitle("JPhase - GOF for a Phase Type Variable");
        this.setSize(400, 190);
        this.setLocationRelativeTo(null);
        this.ACEPTB = new JButton("Acept");
        this.ACEPTB.setActionCommand("Acept");
        this.ACEPTB.addActionListener(this);
        this.CANCELB = new JButton("Close");
        this.CANCELB.setActionCommand("Close");
        this.CANCELB.addActionListener(this);
        this.fitting = new FittingLEcuyer();
        JPanel izq = new JPanel();
        JPanel der = new JPanel();
        this.sizeV = new JLabel("Number of groups for the Chi-Sqare test");
        this.cantF = new JTextField("10");
        this.percentage = new JLabel("Percentaje of data shown in the graph");
        this.perc = new JTextField("90");
        this.save = new JLabel("Select the file with the data");
        this.saveB = new JButton("Select");
        this.saveB.setActionCommand("Select");
        this.saveB.addActionListener(this);
        JLabel change = new JLabel("Select a Phase Variable");
        this.varCombo = new JComboBox<Object>(this.getNames(this.variables).toArray());
        this.varCombo.setSelectedIndex(0);
        this.varCombo.addItemListener(this);
        this.setLayout(new BorderLayout());
        izq.setLayout(new GridLayout(4, 1));
        der.setLayout(new GridLayout(4, 1));
        izq.add(this.sizeV);
        der.add(this.cantF);
        izq.add(this.percentage);
        der.add(this.perc);
        izq.add(this.save);
        der.add(this.saveB);
        izq.add(change);
        der.add(this.varCombo);
        JPanel norte = new JPanel();
        norte.setLayout(new BorderLayout());
        JPanel sur = new JPanel();
        sur.add((Component)this.CANCELB, "West");
        sur.add((Component)this.ACEPTB, "East");
        norte.add((Component)izq, "West");
        norte.add((Component)der, "East");
        this.add((Component)sur, "South");
        this.add((Component)norte, "North");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String evento = e.getActionCommand();
        if (evento.equals("Acept")) {
            int serv = this.varCombo.getSelectedIndex();
            PhaseVarInfo variable = this.variables.get(serv);
            int n = 0;
            double p = 95.0;
            try {
                n = Integer.parseInt(this.cantF.getText());
                p = Double.parseDouble(this.perc.getText());
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "Wrong number of groups", "Error", 0);
            }
            if (n <= 0 || p <= 0.0 || p > 100.0) {
                JOptionPane.showMessageDialog(this, "Wrong number of groups", "Error", 0);
            } else {
                FitResult results = this.fitting.fitPhases(variable, this.ruta, n, p);
                PhaseFitResultDialog res = new PhaseFitResultDialog(results);
                res.setVisible(true);
            }
        } else if (evento.equals("Close")) {
            this.dispose();
        } else if (evento.equals("Select")) {
            this.selectFile();
        }
    }

    private void selectFile() {
        JFileChooser selector = new JFileChooser();
        selector.setDialogTitle("Select a File");
        selector.setFileSelectionMode(0);
        selector.setAcceptAllFileFilterUsed(false);
        if (selector.showOpenDialog(this) == 0) {
            this.ruta = selector.getSelectedFile().toString();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
    }

    public ArrayList<String> getNames(ArrayList<PhaseVarInfo> vars) {
        ArrayList<String> names = new ArrayList<String>();
        for (PhaseVarInfo var : vars) {
            names.add(var.varName);
        }
        return names;
    }
}

