/*
 * Decompiled with CFR 0.152.
 */
package jphase.GUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jphase.GUI.InputFrame;

public class ParamFrame
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel principalPanel;
    JLabel alertLabel;
    JLabel[] paramNames;
    JTextField[] paramValues;
    JButton yesButton;
    JButton noButton;
    public boolean res = false;
    private int width = 360;
    private int height = 220;
    private int minWidth = 360;

    public ParamFrame(String varType) {
        int n;
        this.setTitle("JPhase - New Variable Parameters");
        this.setResizable(false);
        this.setModal(true);
        this.principalPanel = new JPanel();
        this.principalPanel.setLayout(null);
        this.principalPanel.setPreferredSize(new Dimension(this.width, this.height));
        this.principalPanel.setOpaque(true);
        if (varType.equals("Expo")) {
            this.alertLabel = new JLabel("Parameters of the " + varType + " Variable");
            this.alertLabel.setBounds(new Rectangle(this.width / 2 - 110, 10, 260, 20));
            this.alertLabel.setFont(new Font("@Arial Unicode MS", 1, 12));
            this.alertLabel.setOpaque(true);
            this.principalPanel.add((Component)this.alertLabel, null);
            this.paramNames = new JLabel[1];
            this.paramNames[0] = new JLabel("lambda");
            this.paramValues = new JTextField[1];
            this.paramValues[0] = new JTextField();
            int i = 0;
            while (i < this.paramNames.length) {
                this.paramNames[i].setBounds(new Rectangle(this.width / 2 - 100, 40 * (i + 1), 80, 20));
                this.principalPanel.add((Component)this.paramNames[i], null);
                this.paramValues[i].setBackground(Color.WHITE);
                this.paramValues[i].setBounds(new Rectangle(this.width / 2 + 20, 40 * (i + 1), 80, 20));
                this.principalPanel.add((Component)this.paramValues[i], null);
                ++i;
            }
        } else if (varType.equals("Erlang")) {
            this.alertLabel = new JLabel("Parameters of the " + varType + " Variable");
            this.alertLabel.setBounds(new Rectangle(this.width / 2 - 110, 10, 260, 20));
            this.alertLabel.setFont(new Font("@Arial Unicode MS", 1, 12));
            this.alertLabel.setOpaque(true);
            this.principalPanel.add((Component)this.alertLabel, null);
            this.paramNames = new JLabel[2];
            this.paramNames[0] = new JLabel("lambda");
            this.paramNames[1] = new JLabel("n");
            this.paramValues = new JTextField[2];
            this.paramValues[0] = new JTextField();
            this.paramValues[1] = new JTextField();
            int i = 0;
            while (i < this.paramNames.length) {
                this.paramNames[i].setBounds(new Rectangle(this.width / 2 - 100, 40 * (i + 1), 80, 20));
                this.principalPanel.add((Component)this.paramNames[i], null);
                this.paramValues[i].setBackground(Color.WHITE);
                this.paramValues[i].setBounds(new Rectangle(this.width / 2 + 20, 40 * (i + 1), 80, 20));
                this.principalPanel.add((Component)this.paramValues[i], null);
                ++i;
            }
        } else if (varType.equals("HyperExponential")) {
            InputFrame newHypExFrame = new InputFrame("New HyperExponential Variable", "Enter the number of phases");
            newHypExFrame.setVisible(true);
            newHypExFrame.setFocusable(true);
            if (newHypExFrame.getRes()) {
                n = Integer.parseInt(newHypExFrame.getValue());
                this.width = this.minWidth;
                this.height = 120 + 25 * (n + 1);
                this.principalPanel.setPreferredSize(new Dimension(this.width, this.height));
                this.paramNames = new JLabel[4 + n];
                this.paramNames[0] = new JLabel("Number Of Phases");
                this.paramNames[0].setBounds(new Rectangle(this.width / 2 - 70, 40, 60, 20));
                this.paramNames[1] = new JLabel("Phase");
                this.paramNames[1].setBounds(new Rectangle(this.width / 2 - 140, 70, 40, 20));
                this.paramNames[2] = new JLabel("Rate");
                this.paramNames[2].setBounds(new Rectangle(this.width / 2 - 80, 70, 80, 20));
                this.paramNames[3] = new JLabel("Initial probability");
                this.paramNames[3].setBounds(new Rectangle(this.width / 2 + 20, 70, 120, 20));
                this.principalPanel.add((Component)this.paramNames[0], null);
                this.principalPanel.add((Component)this.paramNames[1], null);
                this.principalPanel.add((Component)this.paramNames[2], null);
                this.principalPanel.add((Component)this.paramNames[3], null);
                int i = 0;
                while (i < n) {
                    this.paramNames[4 + i] = new JLabel("" + i);
                    this.paramNames[4 + i].setBounds(new Rectangle(this.width / 2 - 140, 70 + 25 * (i + 1), 40, 20));
                    this.principalPanel.add((Component)this.paramNames[4 + i], null);
                    ++i;
                }
                this.paramValues = new JTextField[2 * n + 1];
                this.paramValues[0] = new JTextField("" + n);
                this.paramValues[0].setEditable(false);
                this.paramValues[0].setBounds(new Rectangle(this.width / 2 + 10, 40, 60, 20));
                this.principalPanel.add((Component)this.paramValues[0], null);
                i = 0;
                while (i < n) {
                    this.paramValues[i + 1] = new JTextField("");
                    this.paramValues[i + 1].setBounds(new Rectangle(this.width / 2 - 80, 70 + 25 * (i + 1), 80, 20));
                    this.principalPanel.add((Component)this.paramValues[i + 1], null);
                    this.paramValues[n + i + 1] = new JTextField("");
                    this.paramValues[n + i + 1].setBounds(new Rectangle(this.width / 2 + 20, 70 + 25 * (i + 1), 80, 20));
                    this.principalPanel.add((Component)this.paramValues[n + i + 1], null);
                    ++i;
                }
            }
        } else if (varType.equals("Coxian")) {
            InputFrame newCoxFrame = new InputFrame("JPhase: New Coxian Variable", "Enter the number of phases in the Coxian");
            newCoxFrame.setVisible(true);
            newCoxFrame.setFocusable(true);
            if (newCoxFrame.getRes()) {
                n = Integer.parseInt(newCoxFrame.getValue());
                this.width = this.minWidth;
                this.height = 120 + 25 * (n + 1);
                this.principalPanel.setPreferredSize(new Dimension(this.width, this.height));
                this.paramNames = new JLabel[4 + n];
                this.paramNames[0] = new JLabel("n");
                this.paramNames[0].setBounds(new Rectangle(this.width / 2 - 70, 40, 60, 20));
                this.paramNames[1] = new JLabel("Phase");
                this.paramNames[1].setBounds(new Rectangle(this.width / 2 - 140, 70, 40, 20));
                this.paramNames[2] = new JLabel("Rate");
                this.paramNames[2].setBounds(new Rectangle(this.width / 2 - 80, 70, 80, 20));
                this.paramNames[3] = new JLabel("Non-Absorption Prob");
                this.paramNames[3].setBounds(new Rectangle(this.width / 2 + 20, 70, 120, 20));
                this.principalPanel.add((Component)this.paramNames[0], null);
                this.principalPanel.add((Component)this.paramNames[1], null);
                this.principalPanel.add((Component)this.paramNames[2], null);
                this.principalPanel.add((Component)this.paramNames[3], null);
                int i = 0;
                while (i < n) {
                    this.paramNames[4 + i] = new JLabel("" + i);
                    this.paramNames[4 + i].setBounds(new Rectangle(this.width / 2 - 140, 70 + 25 * (i + 1), 40, 20));
                    this.principalPanel.add((Component)this.paramNames[4 + i], null);
                    ++i;
                }
                this.paramValues = new JTextField[2 * n];
                this.paramValues[0] = new JTextField("" + n);
                this.paramValues[0].setEditable(false);
                this.paramValues[0].setBounds(new Rectangle(this.width / 2 + 10, 40, 60, 20));
                this.principalPanel.add((Component)this.paramValues[0], null);
                i = 0;
                while (i < n) {
                    this.paramValues[i + 1] = new JTextField("");
                    this.paramValues[i + 1].setBounds(new Rectangle(this.width / 2 - 80, 70 + 25 * (i + 1), 80, 20));
                    this.principalPanel.add((Component)this.paramValues[i + 1], null);
                    if (i < n - 1) {
                        this.paramValues[n + i + 1] = new JTextField("");
                        this.paramValues[n + i + 1].setBounds(new Rectangle(this.width / 2 + 20, 70 + 25 * (i + 1), 80, 20));
                        this.principalPanel.add((Component)this.paramValues[n + i + 1], null);
                    }
                    ++i;
                }
            }
        } else if (!varType.equals("General Phase")) {
            if (varType.equals("HyperErlang")) {
                InputFrame newHypExFrame = new InputFrame("New HyperErlang Variable", "Enter the number of branches");
                newHypExFrame.setVisible(true);
                newHypExFrame.setFocusable(true);
                if (newHypExFrame.getRes()) {
                    n = Integer.parseInt(newHypExFrame.getValue());
                    this.width = this.minWidth + 80;
                    this.height = 120 + 25 * (n + 1);
                    this.principalPanel.setPreferredSize(new Dimension(this.width, this.height));
                    this.paramNames = new JLabel[5 + n];
                    this.paramNames[0] = new JLabel("Number Of Branches");
                    this.paramNames[0].setBounds(new Rectangle(this.width / 2 - 70, 40, 60, 20));
                    this.paramNames[1] = new JLabel("Phase");
                    this.paramNames[1].setBounds(new Rectangle(this.width / 2 - 140, 70, 40, 20));
                    this.paramNames[2] = new JLabel("Rate");
                    this.paramNames[2].setBounds(new Rectangle(this.width / 2 - 80, 70, 80, 20));
                    this.paramNames[3] = new JLabel("Initial probability");
                    this.paramNames[3].setBounds(new Rectangle(this.width / 2 + 20, 70, 120, 20));
                    this.paramNames[4] = new JLabel("Phases");
                    this.paramNames[4].setBounds(new Rectangle(this.width / 2 + 120, 70, 40, 20));
                    this.principalPanel.add((Component)this.paramNames[0], null);
                    this.principalPanel.add((Component)this.paramNames[1], null);
                    this.principalPanel.add((Component)this.paramNames[2], null);
                    this.principalPanel.add((Component)this.paramNames[3], null);
                    this.principalPanel.add((Component)this.paramNames[4], null);
                    int i = 0;
                    while (i < n) {
                        this.paramNames[5 + i] = new JLabel("" + i);
                        this.paramNames[5 + i].setBounds(new Rectangle(this.width / 2 - 140, 70 + 25 * (i + 1), 40, 20));
                        this.principalPanel.add((Component)this.paramNames[5 + i], null);
                        ++i;
                    }
                    this.paramValues = new JTextField[3 * n + 1];
                    this.paramValues[0] = new JTextField("" + n);
                    this.paramValues[0].setEditable(false);
                    this.paramValues[0].setBounds(new Rectangle(this.width / 2 + 10, 40, 60, 20));
                    this.principalPanel.add((Component)this.paramValues[0], null);
                    i = 0;
                    while (i < n) {
                        this.paramValues[i + 1] = new JTextField("");
                        this.paramValues[i + 1].setBounds(new Rectangle(this.width / 2 - 80, 70 + 25 * (i + 1), 80, 20));
                        this.principalPanel.add((Component)this.paramValues[i + 1], null);
                        this.paramValues[n + i + 1] = new JTextField("");
                        this.paramValues[n + i + 1].setBounds(new Rectangle(this.width / 2 + 20, 70 + 25 * (i + 1), 80, 20));
                        this.principalPanel.add((Component)this.paramValues[n + i + 1], null);
                        this.paramValues[2 * n + i + 1] = new JTextField("");
                        this.paramValues[2 * n + i + 1].setBounds(new Rectangle(this.width / 2 + 120, 70 + 25 * (i + 1), 80, 20));
                        this.principalPanel.add((Component)this.paramValues[2 * n + i + 1], null);
                        ++i;
                    }
                }
            } else {
                System.out.println("Non-known distribution");
            }
        }
        this.yesButton = new JButton("Enter");
        this.yesButton.setBounds(new Rectangle(this.width / 2 - 100, this.height - 40, 80, 25));
        this.yesButton.addActionListener(new ParamFrame_yesButton_actionAdapter(this));
        this.yesButton.setOpaque(true);
        this.principalPanel.add((Component)this.yesButton, null);
        this.noButton = new JButton("Cancel");
        this.noButton.setBounds(new Rectangle(this.width / 2 + 20, this.height - 40, 80, 25));
        this.noButton.addActionListener(new ParamFrame_noButton_actionAdapter(this));
        this.principalPanel.add((Component)this.noButton, null);
        this.getContentPane().add((Component)this.principalPanel, "Center");
        this.centrarFrame();
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public boolean getRes() {
        return this.res;
    }

    void yesButton_actionPerformed(ActionEvent e) {
        if (this.paramValues != null) {
            int i = 0;
            while (i < this.paramValues.length) {
                if (this.paramValues[i].getText().equals("")) {
                    JOptionPane.showMessageDialog(null, "You must enter ALL the Parameters", "JPhase Alert", 1);
                } else {
                    this.res = true;
                    this.setVisible(false);
                }
                ++i;
            }
        }
    }

    void noButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void centrarFrame() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - this.width) / 2, (screenSize.height - this.height) / 2);
    }

    class ParamFrame_noButton_actionAdapter
    implements ActionListener {
        ParamFrame adaptee;

        ParamFrame_noButton_actionAdapter(ParamFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.noButton_actionPerformed(e);
        }
    }

    class ParamFrame_yesButton_actionAdapter
    implements ActionListener {
        ParamFrame adaptee;

        ParamFrame_yesButton_actionAdapter(ParamFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.yesButton_actionPerformed(e);
        }
    }
}

