/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.solvers;

import jmarkov.GeomProcess;
import jmarkov.basic.exceptions.NotUnichainException;
import jmarkov.solvers.GeometricSolver;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;

public class MtjLogRedSolver
extends GeometricSolver {
    private Matrix R = null;
    private GeomProcess mp = null;

    public MtjLogRedSolver(GeomProcess mp) {
        super(mp);
        this.mp = mp;
    }

    @Override
    public double[][] getRmatrix() throws NotUnichainException {
        double epsilon = 1.0E-8;
        Matrix[] A = this.mp.getAMatrices();
        Matrix MA0 = A[0];
        Matrix MA1 = A[1];
        Matrix MA2 = A[2];
        int dimen = MA1.numRows();
        DenseMatrix I = new DenseMatrix((Matrix)Matrices.identity((int)dimen));
        DenseMatrix mA1 = new DenseMatrix(dimen, dimen);
        DenseMatrix mA1I = new DenseMatrix(dimen, dimen);
        MA1.mult(-1.0, (Matrix)I, (Matrix)mA1);
        mA1.solve((Matrix)I, (Matrix)mA1I);
        DenseMatrix H = new DenseMatrix(dimen, dimen);
        DenseMatrix L = new DenseMatrix(dimen, dimen);
        DenseMatrix G = new DenseMatrix(dimen, dimen);
        DenseMatrix T = new DenseMatrix(dimen, dimen);
        DenseMatrix U = new DenseMatrix(dimen, dimen);
        DenseMatrix UA = new DenseMatrix(dimen, dimen);
        DenseMatrix M = new DenseMatrix(dimen, dimen);
        DenseMatrix TA = new DenseMatrix(dimen, dimen);
        this.R = new DenseMatrix(dimen, dimen);
        mA1I.mult(MA0, (Matrix)H);
        mA1I.mult(MA2, (Matrix)L);
        G.set((Matrix)L);
        T.set((Matrix)H);
        double compare = 1.0;
        while (compare > epsilon) {
            H.mult((Matrix)L, (Matrix)U);
            L.multAdd((Matrix)H, (Matrix)U);
            H.mult((Matrix)H, (Matrix)M);
            H = new DenseMatrix(dimen, dimen);
            mA1I = new DenseMatrix(dimen, dimen);
            H = (DenseMatrix)I.copy().add(-1.0, (Matrix)U);
            H.solve((Matrix)I, (Matrix)mA1I);
            H = new DenseMatrix(dimen, dimen);
            mA1I.mult((Matrix)M, (Matrix)H);
            M = new DenseMatrix(dimen, dimen);
            L.mult((Matrix)L, (Matrix)M);
            L = new DenseMatrix(dimen, dimen);
            mA1I.mult((Matrix)M, (Matrix)L);
            T.multAdd((Matrix)L, (Matrix)G);
            TA.set((Matrix)T);
            T = new DenseMatrix(dimen, dimen);
            TA.mult((Matrix)H, (Matrix)T);
            U = new DenseMatrix(dimen, dimen);
            double[][] ones = new double[G.numRows()][1];
            int i = 0;
            while (i < G.numRows()) {
                ones[i][0] = 1.0;
                ++i;
            }
            DenseMatrix one = new DenseMatrix(ones);
            DenseMatrix check = new DenseMatrix(G.numRows(), 1);
            G.mult(-1.0, (Matrix)one, (Matrix)check);
            check.add((Matrix)one);
            compare = Math.abs(check.get(0, 0));
            int i2 = 1;
            while (i2 < check.numRows()) {
                compare = Math.max(compare, Math.abs(check.get(i2, 0)));
                ++i2;
            }
        }
        U = new DenseMatrix(dimen, dimen);
        U = (DenseMatrix)MA0.multAdd((Matrix)G, MA1.copy());
        mA1I = new DenseMatrix(dimen, dimen);
        U.mult(-1.0, (Matrix)I, (Matrix)UA);
        UA.solve((Matrix)I, (Matrix)mA1I);
        MA0.mult((Matrix)mA1I, this.R);
        return Matrices.getArray((Matrix)this.R);
    }

    @Override
    public String label() {
        return "MTJ Logarithmic reduction solver";
    }

    @Override
    public String description() {
        return "MTJ Logarithmic reduction solver. This solver uses the MTJ package to handle matrices.";
    }
}

