/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jqbd.solvers;

import jmarkov.jqbd.solvers.QBDPhaseSolver;
import jphase.PhaseVar;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;

public class MtjLogRedSolverFromMatrix
extends QBDPhaseSolver {
    public MtjLogRedSolverFromMatrix(PhaseVar arrivals, PhaseVar service) {
        this.initilicePHPH1(arrivals, service);
    }

    public MtjLogRedSolverFromMatrix(double[][] xMB0, double[][] xMB1, double[][] xMB2, double[][] xMA0, double[][] xMA1, double[][] xMA2) {
        this.MA0 = new DenseMatrix(xMA0);
        this.MA1 = new DenseMatrix(xMA1);
        this.MA2 = new DenseMatrix(xMA2);
        this.MB0 = new DenseMatrix(xMB0);
        this.MB1 = new DenseMatrix(xMB1);
        this.MB2 = new DenseMatrix(xMB2);
    }

    @Override
    public double[][] getRmatrix() {
        double epsilon = 1.0E-8;
        int dimen = this.MA1.numRows();
        DenseMatrix I = new DenseMatrix((Matrix)Matrices.identity((int)dimen));
        DenseMatrix mA1 = new DenseMatrix(dimen, dimen);
        DenseMatrix mA1I = new DenseMatrix(dimen, dimen);
        this.MA1.mult(-1.0, (Matrix)I, (Matrix)mA1);
        mA1.solve((Matrix)I, (Matrix)mA1I);
        DenseMatrix H = new DenseMatrix(dimen, dimen);
        DenseMatrix L = new DenseMatrix(dimen, dimen);
        this.G = new DenseMatrix(dimen, dimen);
        DenseMatrix T = new DenseMatrix(dimen, dimen);
        this.U = new DenseMatrix(dimen, dimen);
        this.N = new DenseMatrix(dimen, dimen);
        DenseMatrix UA = new DenseMatrix(dimen, dimen);
        DenseMatrix M = new DenseMatrix(dimen, dimen);
        DenseMatrix TA = new DenseMatrix(dimen, dimen);
        this.R = new DenseMatrix(dimen, dimen);
        mA1I.mult(this.MA0, (Matrix)H);
        mA1I.mult(this.MA2, (Matrix)L);
        this.G.set((Matrix)L);
        T.set((Matrix)H);
        double compare = 1.0;
        while (compare > epsilon) {
            H.mult((Matrix)L, (Matrix)this.U);
            L.multAdd((Matrix)H, (Matrix)this.U);
            H.mult((Matrix)H, (Matrix)M);
            H = new DenseMatrix(dimen, dimen);
            mA1I = new DenseMatrix(dimen, dimen);
            H = (DenseMatrix)I.copy().add(-1.0, (Matrix)this.U);
            H.solve((Matrix)I, (Matrix)mA1I);
            H = new DenseMatrix(dimen, dimen);
            mA1I.mult((Matrix)M, (Matrix)H);
            M = new DenseMatrix(dimen, dimen);
            L.mult((Matrix)L, (Matrix)M);
            L = new DenseMatrix(dimen, dimen);
            mA1I.mult((Matrix)M, (Matrix)L);
            T.multAdd((Matrix)L, (Matrix)this.G);
            TA.set((Matrix)T);
            T = new DenseMatrix(dimen, dimen);
            TA.mult((Matrix)H, (Matrix)T);
            this.U = new DenseMatrix(dimen, dimen);
            double[][] ones = new double[this.G.numRows()][1];
            int i = 0;
            while (i < this.G.numRows()) {
                ones[i][0] = 1.0;
                ++i;
            }
            DenseMatrix one = new DenseMatrix(ones);
            DenseMatrix check = new DenseMatrix(this.G.numRows(), 1);
            this.G.mult(-1.0, (Matrix)one, (Matrix)check);
            check.add((Matrix)one);
            compare = Math.abs(check.get(0, 0));
            int i2 = 1;
            while (i2 < check.numRows()) {
                compare = Math.max(compare, Math.abs(check.get(i2, 0)));
                ++i2;
            }
        }
        this.U = new DenseMatrix(dimen, dimen);
        this.U = (DenseMatrix)this.MA0.multAdd((Matrix)this.G, this.MA1.copy());
        mA1I = new DenseMatrix(dimen, dimen);
        this.U.mult(-1.0, (Matrix)I, (Matrix)UA);
        UA.solve((Matrix)I, (Matrix)mA1I);
        this.N.set((Matrix)mA1I);
        this.MA0.mult((Matrix)mA1I, (Matrix)this.R);
        return Matrices.getArray((Matrix)this.R);
    }

    public String label() {
        return "MTJ Logarithmic reduction solver. This solver uses the MTJ package to handle matrices from a phase ditribution.";
    }
}

