/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp.solvers;

import java.util.ArrayList;
import jmarkov.basic.Action;
import jmarkov.basic.Actions;
import jmarkov.basic.Solution;
import jmarkov.basic.StateC;
import jmarkov.basic.States;
import jmarkov.basic.exceptions.StructureException;
import jmarkov.jmdp.DTMDP;
import jmarkov.jmdp.StochasticShortestPath;
import jmarkov.jmdp.solvers.AbstractTotalSolver;
import jmarkov.jmdp.solvers.ValueIterationSolver;

public class StochasticShortestPathSolver<S extends StateC, A extends Action>
extends AbstractTotalSolver<S, A> {
    private ValueIterationSolver<S, A> valueSolver;

    public StochasticShortestPathSolver(StochasticShortestPath<S, A> problem) {
        super(problem);
        this.valueSolver = new ValueIterationSolver<S, A>(problem, 1.0);
    }

    @Override
    public StochasticShortestPath<S, A> getProblem() {
        return (StochasticShortestPath)this.problem;
    }

    public final double future(S i, A a) throws StructureException {
        double sum = 0.0;
        States<S> reachableStates = ((DTMDP)this.getProblem()).reachable(i, a);
        for (StateC j : reachableStates) {
            sum += ((StochasticShortestPath)this.getProblem()).modifiedProb(i, j, a) * this.valueFunction.get(j);
        }
        return sum;
    }

    @Override
    public Solution<S, A> solve() throws StructureException {
        this.valueSolver.init();
        long i = 0L;
        double beforeDifference = Double.MAX_VALUE;
        double actualDifference = Double.MAX_VALUE;
        ArrayList<Double> l = new ArrayList<Double>();
        long initialTime = 0L;
        int maxIteartions = 100 * this.getProblem().getAllStates().size();
        if (this.printProcessTime) {
            initialTime = System.currentTimeMillis();
        }
        while (actualDifference > this.valueSolver.getEpsilon()) {
            if (beforeDifference + this.valueSolver.getEpsilon() < actualDifference) {
                String msg = "\t Error: The problem solution won't be reached in a finite number of iterations";
                msg = String.valueOf(msg) + "\t The optimal policy must be acyclic for finite termination";
                msg = String.valueOf(msg) + "\t Possible solution: Verify the problem structure";
                throw new StructureException(msg);
            }
            if (i > (long)maxIteartions) {
                StructureException ex = new StructureException("The value iteration method won't yield the optimal cost vector in a finite number of iterations");
                throw ex;
            }
            beforeDifference = actualDifference;
            actualDifference = this.valueSolver.usesErrorBounds() ? this.valueSolver.computeWithErrorBounds() : this.valueSolver.computeNoErrorBounds();
            l.add(new Double(actualDifference));
            ++i;
        }
        if (this.printProcessTime) {
            this.valueSolver.processTime = System.currentTimeMillis() - initialTime;
        }
        return new Solution(this.valueFunction, this.policy);
    }

    protected double bestAction(S i) throws StructureException {
        Actions act = this.getProblem().feasibleActions(i);
        double val = 0.0;
        double maxSoFar = -1.7976931348623157E308;
        for (Action a : act) {
            double immediateRewardT = ((StateC)i).isTerminal() ? ((DTMDP)this.getProblem()).immediateCost(i, a) : ((DTMDP)this.getProblem()).immediateCost(i, a) + ((DTMDP)this.getProblem()).immediateCost(i, a) * ((DTMDP)this.getProblem()).prob(i, i, a) / (1.0 - ((DTMDP)this.getProblem()).prob(i, i, a));
            val = this.getProblem().operation(immediateRewardT, this.future(i, a));
            if (!(val > maxSoFar)) continue;
            maxSoFar = val;
            this.valueSolver.bestAction = a;
        }
        return maxSoFar;
    }

    @Override
    public String description() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n\t ***Stochastic Shortest Path Solver***\n____________________________________________________________");
        if (this.valueSolver.usesGaussSeidel()) {
            buf.append("using Gauss-Seidel modification\n");
        }
        if (this.valueSolver.usesErrorBounds()) {
            buf.append("using Error Bounds convergence\n");
        }
        return buf.toString();
    }

    @Override
    public String label() {
        StringBuffer buf = new StringBuffer();
        buf.append("Stochastic Shortest Path Solver");
        if (this.valueSolver.usesGaussSeidel()) {
            buf.append(", using Gauss-Seidel modification");
        }
        if (this.valueSolver.usesErrorBounds()) {
            buf.append(", using Error Bounds convergence");
        }
        buf.append(".");
        return buf.toString();
    }

    @Override
    public final long getProcessTime() {
        return this.valueSolver.getProcessTime();
    }

    @Override
    public final long getIterations() {
        return this.valueSolver.getIterations();
    }
}

