/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jmarkov.gui.DenseRatesPanel;
import jmarkov.gui.InfoPanel;
import jmarkov.gui.SparseMatrixPanel;

public class MatrixPanel
extends InfoPanel
implements ItemListener {
    private static final long serialVersionUID = 1969L;
    private JRadioButton jRadioButtonDense = null;
    private JRadioButton jRadioButtonSparseRow = null;
    private JRadioButton jRadioButtonSparseRowsEvents = null;
    private JPanel jMatrixCardPanel = null;
    private JPanel ratioSelPanel = null;
    private DenseRatesPanel denseRatesPanel = null;
    private SparseMatrixPanel sparseRatesPanelRows = null;
    private SparseMatrixPanel sparseRatesPanelRowsEvents = null;
    static final String DENSE = "Dense Matrix";
    static final String SPARSEROW = "Sparse by rows";
    static final String SPARSEROWEVENTS = "Sparse by rows with events";

    public MatrixPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJMatrixCardPanel(), "Center");
        this.add((Component)this.getRatioSelPanel(), "North");
    }

    private JRadioButton getJRadioButtonDense() {
        if (this.jRadioButtonDense == null) {
            this.jRadioButtonDense = new JRadioButton();
            this.jRadioButtonDense.setText(DENSE);
            this.jRadioButtonDense.setSelected(true);
            this.jRadioButtonDense.setToolTipText("Shows the matrix in dense format");
            this.jRadioButtonDense.addItemListener(this);
        }
        return this.jRadioButtonDense;
    }

    private JRadioButton getJRadioButtonSparseRow() {
        if (this.jRadioButtonSparseRow == null) {
            this.jRadioButtonSparseRow = new JRadioButton();
            this.jRadioButtonSparseRow.setText(SPARSEROW);
            this.jRadioButtonSparseRow.setToolTipText("Shows the matrix in sparse format by rows");
            this.jRadioButtonSparseRow.addItemListener(this);
        }
        return this.jRadioButtonSparseRow;
    }

    private JRadioButton getJRadioButtonSparseRowsEvents() {
        if (this.jRadioButtonSparseRowsEvents == null) {
            this.jRadioButtonSparseRowsEvents = new JRadioButton();
            this.jRadioButtonSparseRowsEvents.setText(SPARSEROWEVENTS);
            this.jRadioButtonSparseRowsEvents.setToolTipText("Shows the matrix in sparse format by rows, with Events");
            this.jRadioButtonSparseRowsEvents.setActionCommand("Sparse by rows, with events");
            this.jRadioButtonSparseRowsEvents.addItemListener(this);
        }
        return this.jRadioButtonSparseRowsEvents;
    }

    private JPanel getJMatrixCardPanel() {
        if (this.jMatrixCardPanel == null) {
            this.jMatrixCardPanel = new JPanel();
            this.jMatrixCardPanel.setLayout(new CardLayout());
            this.denseRatesPanel = new DenseRatesPanel();
            this.sparseRatesPanelRows = new SparseMatrixPanel();
            this.sparseRatesPanelRowsEvents = new SparseMatrixPanel(true);
            this.jMatrixCardPanel.add((Component)this.denseRatesPanel, DENSE);
            this.jMatrixCardPanel.add((Component)this.sparseRatesPanelRows, SPARSEROW);
            this.jMatrixCardPanel.add((Component)this.sparseRatesPanelRowsEvents, SPARSEROWEVENTS);
        }
        return this.jMatrixCardPanel;
    }

    private JPanel getRatioSelPanel() {
        if (this.ratioSelPanel == null) {
            this.ratioSelPanel = new JPanel();
            this.ratioSelPanel.add((Component)this.getJRadioButtonDense(), null);
            this.ratioSelPanel.add((Component)this.getJRadioButtonSparseRow(), null);
            this.ratioSelPanel.add((Component)this.getJRadioButtonSparseRowsEvents(), null);
            this.ratioSelPanel.setSize(100, 100);
            ButtonGroup group = new ButtonGroup();
            group.add(this.jRadioButtonDense);
            group.add(this.jRadioButtonSparseRow);
            group.add(this.jRadioButtonSparseRowsEvents);
        }
        return this.ratioSelPanel;
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        CardLayout cl = (CardLayout)this.jMatrixCardPanel.getLayout();
        cl.show(this.jMatrixCardPanel, ((JRadioButton)evt.getItem()).getText());
    }

    public static void main(String[] args) {
        JFrame test = new JFrame();
        test.setContentPane(new MatrixPanel());
        test.setSize(850, 750);
        test.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        test.setVisible(true);
    }

    @Override
    public void updateMP() {
        this.denseRatesPanel.setMP(this.mp);
        this.sparseRatesPanelRows.setMP(this.mp);
        this.sparseRatesPanelRowsEvents.setMP(this.mp);
    }
}

