/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.basic;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jmarkov.basic.Action;
import jmarkov.basic.JMarkovElement;
import jmarkov.basic.State;

public final class DecisionRule<S extends State, A extends Action>
implements JMarkovElement,
Iterable<Map.Entry<S, A>> {
    private Map<S, A> decisionRule = new TreeMap<S, A>();
    private boolean isStationary = true;

    public DecisionRule() {
    }

    public DecisionRule(DecisionRule<S, A> dr) {
        for (Map.Entry<S, A> entry : dr) {
            this.decisionRule.put((State)entry.getKey(), (Action)entry.getValue());
        }
    }

    public void set(S s, A a) {
        this.decisionRule.put(s, a);
    }

    public A getAction(S s) {
        if (this.decisionRule.containsKey(s)) {
            return (A)((Action)this.decisionRule.get(s));
        }
        return null;
    }

    public int size() {
        return this.decisionRule.size();
    }

    @Override
    public Iterator<Map.Entry<S, A>> iterator() {
        return this.decisionRule.entrySet().iterator();
    }

    @Override
    public String toString() {
        return this.label();
    }

    @Override
    public String label() {
        if (this.size() <= 30) {
            return this.decisionRule.toString();
        }
        return "Decision Rule with " + this.size() + " states.";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DecisionRule)) {
            return false;
        }
        DecisionRule dr = (DecisionRule)o;
        return this.decisionRule.equals(dr.decisionRule);
    }

    @Override
    public String description() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.print(pw);
        return sw.toString();
    }

    public void print() {
        this.print(new PrintWriter(System.out, true));
    }

    public void print(PrintWriter pw) {
        this.print(pw, "%-10S", "%-10S");
    }

    public void print(PrintWriter pw, String statesFormat, String actionFormat) {
        pw.printf(String.valueOf(statesFormat) + " ------> " + actionFormat, "State", "Action");
        pw.println();
        Set<Map.Entry<S, A>> entries = this.decisionRule.entrySet();
        for (Map.Entry<S, A> e : entries) {
            pw.printf(String.valueOf(statesFormat) + " ------> " + actionFormat, ((State)e.getKey()).toString(), ((Action)e.getValue()).toString());
            pw.println();
        }
    }
}

