/*
 * Decompiled with CFR 0.152.
 */
package jmarkov;

import Jama.Matrix;
import examples.jmarkov.DriveThru;
import examples.jmarkov.Jackson;
import examples.jmarkov.Kanban;
import examples.jmarkov.QueueMM1N;
import examples.jmarkov.QueueMM2dN;
import java.io.PrintWriter;
import jmarkov.MarkovProcess;
import jmarkov.SimpleMarkovProcess;
import jmarkov.Utils;
import jmarkov.basic.exceptions.NotUnichainException;
import jmarkov.solvers.JamaSolver;
import jmarkov.solvers.MtjSolver;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SolversTest
extends TestCase {
    public static void main(String[] args) {
        try {
            TestRunner.runAndWait((Test)SolversTest.suite());
        }
        catch (Exception e) {
            System.out.println("Exception found");
            e.printStackTrace();
        }
    }

    public static Test suite() throws Exception {
        SimpleMarkovProcess[] mps;
        TestSuite suite = new TestSuite("Test for jmarkov.tests");
        SimpleMarkovProcess[] simpleMarkovProcessArray = mps = new SimpleMarkovProcess[]{new DriveThru(), new Jackson(), new Kanban(), new QueueMM1N(), new QueueMM2dN()};
        int n = mps.length;
        int n2 = 0;
        while (n2 < n) {
            final SimpleMarkovProcess mp = simpleMarkovProcessArray[n2];
            mp.setDebugLevel(0);
            mp.generate();
            mp.setDebugLevel(1);
            mp.setSteadyStateSolver(new JamaSolver(mp));
            final double[] pi0 = mp.getSteadyState();
            MtjSolver.EnumSolver[] enumSolverArray = MtjSolver.EnumSolver.values();
            int n3 = enumSolverArray.length;
            int n4 = 0;
            while (n4 < n3) {
                final MtjSolver.EnumSolver is = enumSolverArray[n4];
                String testName = String.valueOf(mp.getClass().getSimpleName()) + " -- " + is.toString();
                suite.addTest((Test)new TestCase(testName){
                    private MarkovProcess<?, ?> locMp;
                    {
                        super($anonymous0);
                        this.locMp = null;
                    }

                    protected void setUp() throws Exception {
                        this.locMp = mp;
                        mp.setDebugLevel(0);
                    }

                    protected void runTest() throws Throwable {
                        MtjSolver solver = new MtjSolver(this.locMp, is, false);
                        try {
                            this.locMp.setSteadyStateSolver(solver);
                            double[] pi = solver.getSteadyState();
                            Utils.assertArrayEquals("Solver test with " + (Object)((Object)is) + ". Result is not equal to Jama's", pi, pi0, 0.01);
                            System.out.printf("Solver %s with " + this.locMp.label() + ". Process Time: %d milliseconds\n", new Object[]{is, solver.getProcessTime()});
                        }
                        catch (NotUnichainException e) {
                            System.out.printf("Solver %s with " + this.locMp.label() + " did not converged!. Process Time: %d milliseconds\n", new Object[]{is, solver.getProcessTime()});
                        }
                    }
                });
                ++n4;
            }
            ++n2;
        }
        return suite;
    }

    static void test(SimpleMarkovProcess mp) throws NotUnichainException {
        SolversTest.test(mp, false);
    }

    static void test(SimpleMarkovProcess<?, ?> mp, boolean showRes) throws NotUnichainException {
        mp.setMaxStates(Integer.MAX_VALUE);
        mp.setDebugLevel(0);
        mp.generate();
        PrintWriter pw = new PrintWriter(System.out, true);
        mp.setSteadyStateSolver(new JamaSolver(mp));
        if (showRes) {
            pw.println("JAMA REWSULTS: ");
            mp.printStates(pw);
        }
        double[] pi0 = mp.getSteadyState();
        MtjSolver mtjs = new MtjSolver(mp);
        MtjSolver.EnumSolver[] enumSolverArray = MtjSolver.EnumSolver.values();
        int n = enumSolverArray.length;
        int n2 = 0;
        while (n2 < n) {
            MtjSolver.EnumSolver s = enumSolverArray[n2];
            mtjs.setCurrentIterSolver(s);
            mp.setSteadyStateSolver(mtjs);
            double[] pi = mp.getSteadyState();
            Utils.assertArrayEquals("SOLVER: " + (Object)((Object)s) + " result is NOT equal to JAMA's", pi, pi0, 0.001);
            if (showRes) {
                Matrix piM = new Matrix((double[][])new double[][]{pi});
                pw.print("Result = ");
                piM.print(pw, 10, 10);
            }
            ++n2;
        }
    }
}

