/*
 * Decompiled with CFR 0.152.
 */
package jmarkov;

import jmarkov.MarkovProcess;
import jmarkov.basic.State;

public final class GeomState<Sub extends State>
extends State {
    protected int level;
    protected Sub subState;

    public GeomState(Sub subState, int level) {
        this.level = level;
        this.subState = subState;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isBoundary() {
        return this.getLevel() == 0;
    }

    public Sub getSubState() {
        return this.subState;
    }

    @Override
    public int compareTo(State s) {
        GeomState gs = (GeomState)s;
        if (this.level < gs.getLevel()) {
            return -1;
        }
        if (this.level > gs.getLevel()) {
            return 1;
        }
        return ((State)this.getSubState()).compareTo((State)gs.getSubState());
    }

    public void computeMOPs(MarkovProcess mp) {
        ((State)this.subState).computeMOPs(mp);
    }

    @Override
    public double getMOP(int index) {
        return ((State)this.subState).getMOP(index);
    }

    @Override
    public String label() {
        return "L:" + this.level + "(" + ((State)this.subState).label() + ")";
    }

    public int setMOP(MarkovProcess mp, String mopName, double value) {
        return ((State)this.subState).setMOP(mp, mopName, value);
    }

    @Override
    public String description() {
        return "Level: " + this.level + ", sub-State: " + ((State)this.subState).description();
    }

    @Override
    public boolean isConsistent() {
        return this.level >= 0 && ((State)this.subState).isConsistent();
    }
}

