/*
 * Decompiled with CFR 0.152.
 */
package jmarkov;

import jmarkov.MarkovProcess;
import jmarkov.basic.State;

public final class GeomRelState<Sub extends State>
extends State {
    protected int rLevel;
    protected boolean boundary = false;
    protected Sub subState;

    public GeomRelState(Sub subState, int rLevel) {
        this.rLevel = rLevel;
        this.boundary = false;
        this.subState = subState;
    }

    public GeomRelState(Sub subState) {
        this.rLevel = Integer.MIN_VALUE;
        this.boundary = true;
        this.subState = subState;
    }

    public int getRelLevel() {
        return this.rLevel;
    }

    public boolean isBoundary() {
        return this.boundary;
    }

    public Sub getSubState() {
        return this.subState;
    }

    @Override
    public int compareTo(State s) {
        GeomRelState gs = (GeomRelState)s;
        if (this.rLevel < gs.getRelLevel()) {
            return -1;
        }
        if (this.rLevel > gs.getRelLevel()) {
            return 1;
        }
        return ((State)this.getSubState()).compareTo((State)gs.getSubState());
    }

    public void computeMOPs(MarkovProcess mp) {
        ((State)this.subState).computeMOPs(mp);
    }

    @Override
    public String label() {
        return ((State)this.subState).label();
    }

    @Override
    public boolean isConsistent() {
        return -1 <= this.rLevel && this.rLevel <= 1 && ((State)this.subState).isConsistent();
    }
}

