/*
 * Decompiled with CFR 0.152.
 */
package jmarkov;

import examples.jmarkov.DriveThru;
import jmarkov.MarkovProcess;
import jmarkov.Utils;
import jmarkov.basic.exceptions.NotUnichainException;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class DriveThruTest
extends TestCase {
    private DriveThru theDT = null;

    public static void main(String[] args) {
        TestRunner.run(DriveThruTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.theDT = new DriveThru(80.0, 12.0, 30.0, 4, 2, 1);
        this.theDT.setDebugLevel(0);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.theDT = null;
    }

    public final void testGenerate() {
        this.theDT.generate();
        DriveThruTest.assertTrue((String)"Drive Thru not generated correctly", (this.theDT.getStatus() == MarkovProcess.Status.GENERATED ? 1 : 0) != 0);
    }

    public final void testGetMOPsAvg() throws NotUnichainException {
        double[] mops = this.theDT.getMOPsAvg();
        double[] expMops = new double[]{1.8535673938908643, 0.9085921200048781, 0.36343683564258694, 1.272028955647465, 0.0, 0.04537381806445134, 0.04537381806445134, 1.8989412119553157, 3.17097016760278};
        Utils.assertArrayEquals("MOPS incorrect in DriveThru", expMops, mops, 1.0E-5);
    }
}

