/*
 * Decompiled with CFR 0.152.
 */
package examples.jmdp;

import Jama.Matrix;
import examples.jmdp.AnimalActions;
import examples.jmdp.AnimalWeight;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import jmarkov.basic.Actions;
import jmarkov.basic.ActionsSet;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.ValueFunction;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.FiniteMDP;
import jmarkov.jmdp.solvers.FiniteSolver;

public class CattleGrowth
extends FiniteMDP<AnimalWeight, AnimalActions> {
    private double[][][] keep = null;
    private double[][][] forage = null;
    private double[] preciomx = null;
    private double forageCost = 0.0;
    private ActionsSet<AnimalActions> actions = new ActionsSet();

    private CattleGrowth(States<AnimalWeight> initial, int horizon, double[][][] keep, double[][][] forage, double[] preciomx, double forageCost) {
        super(initial, horizon);
        this.keep = keep;
        this.forage = forage;
        this.preciomx = preciomx;
        this.forageCost = forageCost;
        this.actions.add(AnimalActions.SELL);
        this.actions.add(AnimalActions.KEEP);
        this.actions.add(AnimalActions.FORAGE);
    }

    public CattleGrowth(int[] initialWeight, int horizon, double[][][] keep, double[][][] forage, double[] preciomx, double forageCost) {
        this(CattleGrowth.initStates(initialWeight), horizon, keep, forage, preciomx, forageCost);
    }

    public CattleGrowth(int[] initialWeight, int horizon, String keepFile, String forageFile, double[] preciomx, double forageCost) throws FileNotFoundException, IOException {
        this(CattleGrowth.initStates(initialWeight), horizon, CattleGrowth.initMatricesFromFile(keepFile, horizon), CattleGrowth.initMatricesFromFile(forageFile, horizon), preciomx, forageCost);
    }

    private static States<AnimalWeight> initStates(int[] weights) {
        StatesSet<AnimalWeight> stts = new StatesSet<AnimalWeight>();
        int[] nArray = weights;
        int n = weights.length;
        int n2 = 0;
        while (n2 < n) {
            int weight = nArray[n2];
            stts.add(new AnimalWeight(weight));
            ++n2;
        }
        return stts;
    }

    private static double[][][] initMatricesFromFile(String filePattern, int horizon) throws IOException {
        double[][][] result = new double[horizon][][];
        int t = 0;
        while (t < horizon) {
            Matrix mat = CattleGrowth.loadJamaMatrix(String.valueOf(filePattern) + t + ".txt");
            result[t] = mat.getArray();
            ++t;
        }
        return result;
    }

    @Override
    public double finalCost(AnimalWeight i) {
        return 0.0;
    }

    public double getValue(int initWeight) throws SolverException {
        ValueFunction<AnimalWeight> vf = this.getOptimalValueFunction();
        AnimalWeight state = new AnimalWeight(initWeight);
        return vf.get(state);
    }

    @Override
    public double immediateCost(AnimalWeight i, AnimalActions a, int t) {
        if (a == AnimalActions.FORAGE) {
            return this.forageCost;
        }
        if (a == AnimalActions.SELL) {
            return -800000.0;
        }
        return 0.0;
    }

    @Override
    public Actions<AnimalActions> feasibleActions(AnimalWeight st, int t) {
        if (st.isSold() || t == 0) {
            ActionsSet<AnimalActions> act = new ActionsSet<AnimalActions>();
            act.add(AnimalActions.KEEP);
            return act;
        }
        if (st.weight >= 600) {
            ActionsSet<AnimalActions> act = new ActionsSet<AnimalActions>();
            act.add(AnimalActions.SELL);
            return act;
        }
        if (t == 4) {
            ActionsSet<AnimalActions> act = new ActionsSet<AnimalActions>();
            act.add(AnimalActions.SELL);
            return act;
        }
        return this.actions;
    }

    @Override
    public double prob(AnimalWeight pesoactual, AnimalWeight pesofuturo, AnimalActions a, int t) {
        if (a == AnimalActions.KEEP) {
            return this.keep[t][(pesoactual.weight - 160) / 20][(pesofuturo.weight - 160) / 20];
        }
        if (a == AnimalActions.SELL) {
            return pesofuturo.isSold() ? 1.0 : 0.0;
        }
        if (a == AnimalActions.FORAGE) {
            return this.forage[t][(pesoactual.weight - 160) / 20][(pesofuturo.weight - 160) / 20];
        }
        return 0.0;
    }

    @Override
    public States<AnimalWeight> reachable(AnimalWeight arg0, AnimalActions arg1, int t) {
        StatesSet<AnimalWeight> statesSet = new StatesSet<AnimalWeight>();
        int i = 0;
        while (i < 22) {
            statesSet.add(new AnimalWeight(160 + i * 20));
            ++i;
        }
        return statesSet;
    }

    public static Matrix loadJamaMatrix(String fileName) throws IOException {
        Matrix Mat = null;
        File fil = null;
        fil = new File(fileName);
        Mat = Matrix.read((BufferedReader)new BufferedReader(new FileReader(fil)));
        return Mat;
    }

    public static void main(String[] a) throws SolverException, FileNotFoundException, URISyntaxException, IOException {
        double forageCost = 200.0;
        double[] preciomx = null;
        int[] initialWeights = new int[]{160, 180, 200, 220, 240, 260, 280, 300, 320, 340};
        CattleGrowth prob = new CattleGrowth(initialWeights, 5, "FORAGE", "KEEP", preciomx, forageCost);
        FiniteSolver<AnimalWeight, AnimalActions> theSolver = new FiniteSolver<AnimalWeight, AnimalActions>(prob);
        theSolver.solve();
        prob.printSolution();
    }
}

