/*
 * Decompiled with CFR 0.152.
 */
package examples.jmdp;

import examples.jmdp.Admit;
import examples.jmdp.TandemEvent;
import examples.jmdp.TandemQueues;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.Random;
import jmarkov.basic.Actions;
import jmarkov.basic.ActionsSet;
import jmarkov.basic.DecisionRule;
import jmarkov.basic.Events;
import jmarkov.basic.EventsSet;
import jmarkov.basic.Policy;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.DTMDPEv;
import jmarkov.jmdp.solvers.PolicyIterationSolverAvg;

public class AccessControl
extends DTMDPEv<TandemQueues, Admit, TandemEvent> {
    double lambda;
    double mu1;
    double mu2;
    double c1;
    double c2;
    int b1;
    int b2;

    public AccessControl(States<TandemQueues> init, double c1, double c2, double lambda, double mu1, double mu2, int b1, int b2) {
        super(init);
        this.c1 = c1;
        this.c2 = c2;
        this.lambda = lambda;
        this.mu1 = mu1;
        this.mu2 = mu2;
        this.b1 = b1;
        this.b2 = b2;
    }

    @Override
    public Events<TandemEvent> activeEvents(TandemQueues i, Admit a) {
        EventsSet<TandemEvent> eventSet = new EventsSet<TandemEvent>();
        eventSet.add(new TandemEvent(TandemEvent.TEvent.Arrival));
        eventSet.add(new TandemEvent(TandemEvent.TEvent.Service1));
        eventSet.add(new TandemEvent(TandemEvent.TEvent.Service2));
        return eventSet;
    }

    @Override
    public States<TandemQueues> reachable(TandemQueues i, Admit a, TandemEvent e) {
        StatesSet<TandemQueues> set = new StatesSet<TandemQueues>();
        int ac = a.getAdm();
        switch (e.get()) {
            case Arrival: {
                int[] temp = new int[]{Math.min(i.getQ1() + ac, this.b1), i.getQ2()};
                set.add(new TandemQueues(temp));
                break;
            }
            case Service1: {
                int[] temp = new int[]{i.getQ1() == 0 ? 0 : i.getQ1() - 1, i.getQ1() == 0 ? i.getQ2() : Math.min(i.getQ2() + 1, this.b2)};
                set.add(new TandemQueues(temp));
                break;
            }
            case Service2: {
                int[] temp = new int[]{i.getQ1(), i.getQ2() == 0 ? 0 : i.getQ2() - 1};
                set.add(new TandemQueues(temp));
            }
        }
        return set;
    }

    @Override
    public Actions<Admit> feasibleActions(TandemQueues i) {
        ActionsSet<Admit> set = new ActionsSet<Admit>();
        if (i.getQ1() < this.b1) {
            set.add(new Admit(1));
        }
        if (i.getQ1() + i.getQ2() >= this.b2) {
            set.add(new Admit(0));
        }
        return set;
    }

    @Override
    public double immediateCost(TandemQueues i, Admit a, TandemEvent e) {
        int ac = a.getAdm();
        switch (e.get()) {
            case Arrival: {
                if (ac == 0) {
                    return this.c1;
                }
                return 0.0;
            }
            case Service1: {
                if (i.getQ2() == this.b2 && i.getQ1() > 0) {
                    return this.c2;
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    @Override
    public double prob(TandemQueues i, TandemQueues j, Admit a, TandemEvent e) {
        int ac = a.getAdm();
        switch (e.get()) {
            case Arrival: {
                if (ac == 0 && i.getQ1() == j.getQ1() && i.getQ2() == j.getQ2()) {
                    return 1.0;
                }
                if (ac == 1 && i.getQ1() + 1 == j.getQ1() && i.getQ2() == j.getQ2()) {
                    return 1.0;
                }
                return 0.0;
            }
            case Service1: {
                if (i.getQ1() == 0 && i.getQ1() == j.getQ1() && i.getQ2() == j.getQ2()) {
                    return 1.0;
                }
                if (i.getQ1() > 0 && i.getQ2() < this.b2 && i.getQ1() - 1 == j.getQ1() && i.getQ2() + 1 == j.getQ2()) {
                    return 1.0;
                }
                if (i.getQ1() > 0 && i.getQ2() == this.b2 && i.getQ1() - 1 == j.getQ1() && i.getQ2() == j.getQ2()) {
                    return 1.0;
                }
                return 0.0;
            }
        }
        if (i.getQ2() == 0 && i.getQ1() == j.getQ1() && i.getQ2() == j.getQ2()) {
            return 1.0;
        }
        if (i.getQ2() > 0 && i.getQ1() == j.getQ1() && i.getQ2() - 1 == j.getQ2()) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public double prob(TandemQueues i, TandemEvent e) {
        double d = this.lambda + this.mu1 + this.mu2;
        switch (e.get()) {
            case Arrival: {
                return this.lambda / d;
            }
            case Service1: {
                return this.mu1 / d;
            }
            case Service2: {
                return this.mu2 / d;
            }
        }
        return 0.0;
    }

    public static void main(String[] args) throws SolverException {
        boolean runOne = false;
        if (runOne) {
            int b1 = 4;
            int b2 = 4;
            double c1 = 461.995;
            double c2 = 841.059;
            double lambda = 91.524;
            double mu1 = 98.421;
            double mu2 = 98.421;
            int[] initState = new int[2];
            StatesSet<TandemQueues> init = new StatesSet<TandemQueues>(new TandemQueues(initState));
            AccessControl AC = new AccessControl(init, c1, c2, lambda, mu1, mu2, b1, b2);
            PolicyIterationSolverAvg<TandemQueues, Admit> theSolver = new PolicyIterationSolverAvg<TandemQueues, Admit>(AC);
            AC.setDebugLevel(4);
            theSolver.setPrintBias(true);
            theSolver.setPrintGain(true);
            theSolver.setPrintValueFunction(true);
            AC.setSolver(theSolver);
            AC.solve();
            AC.printSolution();
        } else {
            int b1 = 4;
            int b2 = 4;
            int[] initState = new int[2];
            int[] nArray = new int[2];
            nArray[1] = 4;
            int[] s1 = nArray;
            int[] s2 = new int[]{1, 3};
            int[] s3 = new int[]{1, 4};
            int[] s4 = new int[]{2, 2};
            int[] s5 = new int[]{2, 3};
            int[] s6 = new int[]{2, 4};
            int[] s7 = new int[]{3, 1};
            int[] s8 = new int[]{3, 2};
            int[] s9 = new int[]{3, 3};
            int[] s10 = new int[]{3, 4};
            TandemQueues S1 = new TandemQueues(s1);
            TandemQueues S2 = new TandemQueues(s2);
            TandemQueues S3 = new TandemQueues(s3);
            TandemQueues S4 = new TandemQueues(s4);
            TandemQueues S5 = new TandemQueues(s5);
            TandemQueues S6 = new TandemQueues(s6);
            TandemQueues S7 = new TandemQueues(s7);
            TandemQueues S8 = new TandemQueues(s8);
            TandemQueues S9 = new TandemQueues(s9);
            TandemQueues S10 = new TandemQueues(s10);
            StatesSet<TandemQueues> init = new StatesSet<TandemQueues>(new TandemQueues(initState));
            String stg = "Lam \t Mu1 \t Mu2 \t C1 \t C2 \t g \t (0,4) \t (1,3) \t (1,4) \t (2,2) \t (2,3) \t (2,4) \t (3,1) \t (3,2) \t (3,3) \t (3,4) \t C2 \t g \t (0,4) \t (1,3) \t (1,4) \t (2,2) \t (2,3) \t (2,4) \t (3,1) \t (3,2) \t (3,3) \t (3,4)\t C2 \t g \t (0,4) \t (1,3) \t (1,4) \t (2,2) \t (2,3) \t (2,4) \t (3,1) \t (3,2) \t (3,3) \t (3,4)\t C2 \t g \t (0,4) \t (1,3) \t (1,4) \t (2,2) \t (2,3) \t (2,4) \t (3,1) \t (3,2) \t (3,3) \t (3,4)\t C2 \t g \t (0,4) \t (1,3) \t (1,4) \t (2,2) \t (2,3) \t (2,4) \t (3,1) \t (3,2) \t (3,3) \t (3,4)\t C2 \t g \t (0,4) \t (1,3) \t (1,4) \t (2,2) \t (2,3) \t (2,4) \t (3,1) \t (3,2) \t (3,3) \t (3,4)\t C2 \t g \t (0,4) \t (1,3) \t (1,4) \t (2,2) \t (2,3) \t (2,4) \t (3,1) \t (3,2) \t (3,3) \t (3,4)\t C2 \t g \t (0,4) \t (1,3) \t (1,4) \t (2,2) \t (2,3) \t (2,4) \t (3,1) \t (3,2) \t (3,3) \t (3,4)\t C2 \t g \t (0,4) \t (1,3) \t (1,4) \t (2,2) \t (2,3) \t (2,4) \t (3,1) \t (3,2) \t (3,3) \t (3,4)\t C2 \t g \t (0,4) \t (1,3) \t (1,4) \t (2,2) \t (2,3) \t (2,4) \t (3,1) \t (3,2) \t (3,3) \t (3,4)\n";
            Random randGen = new Random(123456L);
            int i = 1;
            while (i <= 10000) {
                double c1;
                double c2 = c1 = randGen.nextDouble() * 999.0 + 1.0;
                double l = randGen.nextDouble() * 99.0 + 1.0;
                double m1 = randGen.nextDouble() * 99.0 + 1.0;
                double m2 = randGen.nextDouble() * 99.0 + 1.0;
                if (i % 100 == 0) {
                    System.out.println(String.valueOf(i) + ",");
                } else {
                    System.out.print(String.valueOf(i) + ",");
                }
                if (i != 73 && i != 2283 && i != 2375 && i != 2446 && i != 2574 && i != 3305 && i != 4021 && i != 4751 && i != 8819 && i != 4348 && i != 3412 && i != 6977) {
                    int j = 1;
                    while (j <= 10) {
                        AccessControl AC = new AccessControl(init, c1, c2 += randGen.nextDouble() * c1, l, m1, m2, b1, b2);
                        PolicyIterationSolverAvg<TandemQueues, Admit> theSolver = new PolicyIterationSolverAvg<TandemQueues, Admit>(AC);
                        AC.setDebugLevel(0);
                        AC.setSolver(theSolver);
                        AC.solve();
                        Policy pol = AC.getOptimalPolicy();
                        DecisionRule rule = pol.getDecisionRule();
                        DecimalFormat df1 = new DecimalFormat("#.###");
                        double g = theSolver.getGain();
                        int r1 = ((Admit)rule.getAction(S1)).toString() == "Admit" ? 1 : 0;
                        int r2 = ((Admit)rule.getAction(S2)).toString() == "Admit" ? 1 : 0;
                        int r3 = ((Admit)rule.getAction(S3)).toString() == "Admit" ? 1 : 0;
                        int r4 = ((Admit)rule.getAction(S4)).toString() == "Admit" ? 1 : 0;
                        int r5 = ((Admit)rule.getAction(S5)).toString() == "Admit" ? 1 : 0;
                        int r6 = ((Admit)rule.getAction(S6)).toString() == "Admit" ? 1 : 0;
                        int r7 = ((Admit)rule.getAction(S7)).toString() == "Admit" ? 1 : 0;
                        int r8 = ((Admit)rule.getAction(S8)).toString() == "Admit" ? 1 : 0;
                        int r9 = ((Admit)rule.getAction(S9)).toString() == "Admit" ? 1 : 0;
                        int r10 = ((Admit)rule.getAction(S10)).toString() == "Admit" ? 1 : 0;
                        stg = j == 1 ? String.valueOf(stg) + df1.format(l) + "\t " + df1.format(m1) + "\t " + df1.format(m2) + "\t " + df1.format(c1) + "\t " + df1.format(c2) + "\t " + df1.format(g) + "\t " + r1 + "\t " + r2 + " \t " + r3 + " \t " + r4 + " \t " + r5 + "\t " + r6 + "\t " + r7 + "\t " + r8 + "\t " + r9 + "\t " + r10 + "\t" : String.valueOf(stg) + df1.format(c2) + "\t " + df1.format(g) + "\t " + r1 + "\t " + r2 + " \t " + r3 + " \t " + r4 + " \t " + r5 + "\t " + r6 + "\t " + r7 + "\t " + r8 + "\t " + r9 + "\t " + r10 + "\t";
                        if (j == 10) {
                            stg = String.valueOf(stg) + "\n";
                        }
                        ++j;
                    }
                }
                ++i;
            }
            try {
                FileWriter outFile = new FileWriter("C:/Users/Owner/Documents/HomePC Files/Daniel Universidad/MIIND/Tesis/jMarkov2_0a/examples/jmarkov/AccessControlFiles/result2.txt");
                PrintWriter out = new PrintWriter(outFile);
                StringWriter sw = new StringWriter();
                stg = String.valueOf(stg) + sw.toString();
                out.print(stg);
                out.close();
            }
            catch (IOException EE) {
                EE.printStackTrace();
            }
        }
    }
}

