/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.MarkovProcess;
import jmarkov.basic.PropertiesState;

class QueueMMKdNState
extends PropertiesState {
    private int K;
    private double sumProb = -1.0;
    private double[] alpha;
    private double[] beta;

    QueueMMKdNState(int K, double[] alpha) {
        this(new int[K], 0, alpha);
    }

    QueueMMKdNState(int[] status, int Qsize, double[] alpha) {
        super(alpha.length + 1);
        this.K = alpha.length;
        this.alpha = alpha;
        this.beta = new double[this.K];
        int sum = 0;
        int i = 0;
        while (i < this.K) {
            this.prop[i] = status[i];
            sum += status[i];
            ++i;
        }
        this.prop[this.K] = Qsize;
    }

    @Override
    public void computeMOPs(MarkovProcess mp) {
        double sum = 0.0;
        int i = 0;
        while (i < this.K) {
            sum += (double)this.getStatus(i);
            this.setMOP(mp, "Server Status " + (i + 1), this.getStatus(i));
            ++i;
        }
        this.setMOP(mp, "Queue Length", this.getQSize());
        this.setMOP(mp, "Number in System", sum + (double)this.getQSize());
    }

    public int getStatus(int k) {
        return this.prop[k];
    }

    public int getQSize() {
        return this.prop[this.K];
    }

    public boolean allBusy() {
        boolean result = true;
        int k = 0;
        while (result && k < this.K) {
            result = result && this.getStatus(k) == 1;
            ++k;
        }
        return result;
    }

    public boolean allIdle() {
        boolean result = true;
        int k = 0;
        while (result && k < this.K) {
            result = result && this.getStatus(k) == 0;
            ++k;
        }
        return result;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    private double sum() {
        if (this.sumProb != -1.0) {
            return this.sumProb;
        }
        double res = 0.0;
        int k = 0;
        while (k < this.K) {
            res += (double)(1 - this.getStatus(k)) * this.alpha[k];
            ++k;
        }
        this.sumProb = res;
        return this.sumProb;
    }

    public double prob(int server) {
        if (this.beta[server] != 0.0) {
            return this.beta[server];
        }
        this.beta[server] = (double)(1 - this.getStatus(server)) * this.alpha[server] / this.sum();
        return this.beta[server];
    }

    @Override
    public String label() {
        String stg = "S";
        int k = 0;
        while (k < this.K) {
            stg = String.valueOf(stg) + (this.getStatus(k) == 1 ? "" + (k + 1) : "");
            ++k;
        }
        return String.valueOf(stg) + "Q" + this.getQSize();
    }

    @Override
    public String description() {
        String stg = "";
        stg = !this.allIdle() ? String.valueOf(stg) + "Busy Servers:" : String.valueOf(stg) + "No one in service";
        int k = 0;
        while (k < this.K) {
            stg = String.valueOf(stg) + (this.getStatus(k) == 1 ? k + 1 + "," : "");
            ++k;
        }
        stg = String.valueOf(stg) + " There are " + this.getQSize() + " customers waiting in queue.";
        return stg;
    }
}

