/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.MM2dNState;
import examples.jmarkov.QMM2dNEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;

public class QueueMM2dN
extends SimpleMarkovProcess<MM2dNState, QMM2dNEvent> {
    final int ARRIVAL = 0;
    final int ARRIVAL1 = 1;
    final int ARRIVAL2 = 2;
    final int DEPARTURE1 = 3;
    final int DEPARTURE2 = 4;
    private double lambda;
    private double mu1;
    private double mu2;
    private double alpha;
    private int N;

    public QueueMM2dN(double lambda, double mu1, double mu2, double alpha, int N) {
        super(new MM2dNState(0, 0, 0), QMM2dNEvent.getAllEvents());
        this.lambda = lambda;
        this.mu1 = mu1;
        this.mu2 = mu2;
        this.alpha = alpha;
        this.N = N;
    }

    public QueueMM2dN() {
        this(1.0, 2.0, 3.0, 0.3, 8);
    }

    @Override
    public boolean active(MM2dNState i, QMM2dNEvent e) {
        boolean result = false;
        switch (e.getType()) {
            case ARRIVAL: {
                result = i.getQSize() < this.N - 2 && !i.isEmpty();
                break;
            }
            case ARRIVAL1: {
                result = i.isEmpty();
                break;
            }
            case ARRIVAL2: {
                result = i.isEmpty();
                break;
            }
            case DEPARTURE1: {
                result = i.getStatus1() > 0;
                break;
            }
            case DEPARTURE2: {
                result = i.getStatus2() > 0;
            }
        }
        return result;
    }

    @Override
    public States<MM2dNState> dests(MM2dNState i, QMM2dNEvent e) {
        int newx = i.getStatus1();
        int newy = i.getStatus2();
        int newz = i.getQSize();
        switch (e.getType()) {
            case ARRIVAL: {
                if (i.getStatus1() == 0) {
                    newx = 1;
                    break;
                }
                if (i.getStatus2() == 0) {
                    newy = 1;
                    break;
                }
                newz = i.getQSize() + 1;
                break;
            }
            case ARRIVAL1: {
                newx = 1;
                break;
            }
            case ARRIVAL2: {
                newy = 1;
                break;
            }
            case DEPARTURE1: {
                if (i.getQSize() != 0) {
                    newx = 1;
                    newz = i.getQSize() - 1;
                    break;
                }
                newx = 0;
                break;
            }
            case DEPARTURE2: {
                if (i.getQSize() != 0) {
                    newy = 1;
                    newz = i.getQSize() - 1;
                    break;
                }
                newy = 0;
            }
        }
        return new StatesSet<MM2dNState>(new MM2dNState(newx, newy, newz));
    }

    @Override
    public double rate(MM2dNState i, MM2dNState j, QMM2dNEvent e) {
        double res = 0.0;
        switch (e.getType()) {
            case ARRIVAL: {
                res = this.lambda;
                break;
            }
            case ARRIVAL1: {
                res = this.lambda * this.alpha;
                break;
            }
            case ARRIVAL2: {
                res = this.lambda * (1.0 - this.alpha);
                break;
            }
            case DEPARTURE1: {
                res = this.mu1;
                break;
            }
            case DEPARTURE2: {
                res = this.mu2;
            }
        }
        return res;
    }

    @Override
    public String description() {
        return "M/M/2/N SYSTEM\nQueueing System with two servers, with rates " + this.mu1 + " and " + this.mu2 + ".\nArrivals are Poisson with rate " + this.lambda + ",\nand the maximum number in the system is " + this.N;
    }

    public static void main(String[] a) {
        BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
        try {
            System.out.println("Input rate ");
            String stg = rdr.readLine();
            double lda = Double.parseDouble(stg);
            System.out.println("Service rate 1  ");
            stg = rdr.readLine();
            double mu1 = Double.parseDouble(stg);
            System.out.println("Service rate 2  ");
            stg = rdr.readLine();
            double mu2 = Double.parseDouble(stg);
            System.out.println("Provide alpha  ");
            stg = rdr.readLine();
            double alpha = Double.parseDouble(stg);
            System.out.println("Max in the system ");
            stg = rdr.readLine();
            int N = Integer.parseInt(stg);
            QueueMM2dN theQueue = new QueueMM2dN(lda, mu1, mu2, alpha, N);
            theQueue.showGUI();
            theQueue.printAll();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

