/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.QueueMM1NEvent;
import examples.jmarkov.QueueMM1NState;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;

public class QueueMM1N
extends SimpleMarkovProcess<QueueMM1NState, QueueMM1NEvent> {
    private double lambda;
    private double mu;
    private int N;

    public QueueMM1N(double lambda, double mu, int N) {
        super(new QueueMM1NState(0), QueueMM1NEvent.getAllEvents());
        this.lambda = lambda;
        this.mu = mu;
        this.N = N;
    }

    public QueueMM1N() {
        this(4.0, 2.0, 4);
    }

    public final double getLambda() {
        return this.lambda;
    }

    public final double getMu() {
        return this.mu;
    }

    public final int getMax() {
        return this.N;
    }

    @Override
    public boolean active(QueueMM1NState i, QueueMM1NEvent e) {
        boolean result = false;
        switch (e.getType()) {
            case ARRIVAL: {
                result = i.getLevel() < this.N;
                break;
            }
            case DEPARTURE: {
                result = i.getLevel() > 0;
            }
        }
        return result;
    }

    @Override
    public States<QueueMM1NState> dests(QueueMM1NState i, QueueMM1NEvent e) {
        int newx = i.getLevel();
        switch (e.getType()) {
            case ARRIVAL: {
                ++newx;
                break;
            }
            case DEPARTURE: {
                --newx;
            }
        }
        return new StatesSet<QueueMM1NState>(new QueueMM1NState(newx));
    }

    @Override
    public double rate(QueueMM1NState i, QueueMM1NState j, QueueMM1NEvent e) {
        return e.getType() == QueueMM1NEvent.Type.ARRIVAL ? this.lambda : this.mu;
    }

    public static void main(String[] a) {
        QueueMM1N theQueue = new QueueMM1N(4.0, 2.0, 4);
        theQueue.showGUI();
        theQueue.printAll();
    }

    @Override
    public String description() {
        return "SINGLE SERVER QUEUE (M/M/1/N)\n\nArrival Rate    = " + this.lambda + "\nService Rate    = " + this.mu + "\nSystem capacity = " + this.N;
    }
}

