/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.MarkovProcess;
import jmarkov.basic.PropertiesState;

class PHLineState
extends PropertiesState {
    private static int numStat = -1;

    public PHLineState(int[] bufferSize, int[] servPahse) {
        super(bufferSize.length + servPahse.length);
        int k = servPahse.length;
        System.arraycopy(servPahse, 0, this.prop, 0, k);
        System.arraycopy(bufferSize, 0, this.prop, k, bufferSize.length);
    }

    @Override
    public void computeMOPs(MarkovProcess mp) {
        int k = this.getNumStations();
        int i = 0;
        while (i < k) {
            this.setMOP(mp, "Server " + (i + 1) + " Utilization", this.getSrvPhase(i) != 0 ? 1 : 0);
            if (i > 0) {
                this.setMOP(mp, "Number in Buffer " + (i + 1), this.getCostumersInStation(i));
            }
            ++i;
        }
    }

    public int getNumStations() {
        if (numStat == -1) {
            numStat = (this.prop.length + 1) / 2;
        }
        return numStat;
    }

    public int getSrvPhase(int station) {
        return this.prop[station];
    }

    public int[] getSrvPhase() {
        int k = this.getNumStations();
        int[] phases = new int[k];
        System.arraycopy(this.prop, 0, phases, 0, k);
        return phases;
    }

    public int[] getBufferSize() {
        int k = this.getNumStations();
        int[] buff = new int[k - 1];
        System.arraycopy(this.prop, k, buff, 0, k - 1);
        return buff;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    public int getBufferSize(int station) {
        assert (station > 0);
        return this.prop[this.getNumStations() + station - 1];
    }

    public int getCostumersInStation(int station) {
        return this.getBufferSize(station) + this.getSrvStatus(station);
    }

    public int getSrvStatus(int station) {
        return this.getSrvPhase(station) == 0 ? 0 : 1;
    }

    @Override
    public PHLineState clone() {
        return new PHLineState(this.getBufferSize(), this.getSrvPhase());
    }

    public PHLineState changePhase(int station, int j) {
        int[] bufferSize = this.getBufferSize();
        int[] srvPhase = this.getSrvPhase();
        srvPhase[station] = j;
        return new PHLineState(bufferSize, srvPhase);
    }

    public PHLineState setIdle(int station) {
        int[] bufferSize = this.getBufferSize();
        int[] srvPhase = this.getSrvPhase();
        srvPhase[station] = 0;
        return new PHLineState(bufferSize, srvPhase);
    }

    private PHLineState changeBuffer(int station, int b) {
        int[] bufferSize = this.getBufferSize();
        int[] srvPhase = this.getSrvPhase();
        bufferSize[station - 1] = b;
        return new PHLineState(bufferSize, srvPhase);
    }

    public PHLineState reduceBuffer(int station) {
        int[] bufferSize = this.getBufferSize();
        int[] srvPhase = this.getSrvPhase();
        if (station > 0) {
            int n = station - 1;
            bufferSize[n] = bufferSize[n] - 1;
        }
        return new PHLineState(bufferSize, srvPhase);
    }

    public PHLineState move(int oldStation, int newStation) {
        int[] bufferSize = this.getBufferSize();
        int[] srvPhase = this.getSrvPhase();
        if (oldStation > 0) {
            bufferSize[oldStation - 1] = bufferSize[oldStation - 1] - 1;
        }
        bufferSize[newStation - 1] = bufferSize[newStation - 1] + 1;
        return new PHLineState(bufferSize, srvPhase);
    }

    public PHLineState changePhase(int s1, int p1, int s2, int p2) {
        int[] bufferSize = this.getBufferSize();
        int[] srvPhase = this.getSrvPhase();
        srvPhase[s1] = p1;
        srvPhase[s2] = p2;
        return new PHLineState(bufferSize, srvPhase);
    }

    @Override
    public String label() {
        String stg = "";
        int k = this.getNumStations();
        int s = 0;
        while (s < k) {
            if (s > 0) {
                stg = String.valueOf(stg) + "B" + this.getBufferSize(s);
            }
            stg = String.valueOf(stg) + "F" + this.getSrvPhase(s);
            ++s;
        }
        return stg;
    }

    @Override
    public String description() {
        return this.label();
    }
}

