/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.PHLineEvent;
import examples.jmarkov.PHLineState;
import java.io.PrintWriter;
import jmarkov.GeomProcess;
import jmarkov.GeomRelState;
import jmarkov.basic.StatesSet;
import jphase.DenseContPhaseVar;
import jphase.PhaseVar;
import no.uib.cipr.matrix.Matrix;

public class PHLine
extends GeomProcess<PHLineState, PHLineEvent> {
    private double lambda;
    private PhaseVar[] servDist = null;
    private int[] capacities = null;

    public PHLine(double lambda, PhaseVar[] dists, int[] capacity) {
        super(new PHLineState(new int[dists.length - 1], new int[dists.length]), PHLineEvent.getAllEvents(dists));
        this.lambda = lambda;
        this.servDist = dists;
        this.capacities = capacity;
    }

    public PHLine() {
        super(new PHLineState(new int[2], new int[2]), PHLineEvent.getAllEvents(new PhaseVar[]{DenseContPhaseVar.expo(4.0), DenseContPhaseVar.expo(5.0)}));
        this.lambda = 3.0;
        this.capacities = new int[]{4};
    }

    public int getNumStations() {
        return this.servDist.length;
    }

    public int getCapacity(int station) {
        return this.capacities[station - 1];
    }

    void addDestsChangePhase(PHLineState i, int s, int relLevel, StatesSet<GeomRelState<PHLineState>> destStates) {
        PhaseVar v = this.servDist[s];
        double[] alpha = v.getVectorArray();
        int m = v.getNumPhases();
        int n = 1;
        while (n <= m) {
            if (alpha[n - 1] > 0.0) {
                GeomRelState<PHLineState> gs = new GeomRelState<PHLineState>(i.changePhase(s, n), relLevel);
                destStates.add(gs);
            }
            ++n;
        }
    }

    void addDestsChangePhase(PHLineState i, int s1, int s2, int relLevel, StatesSet<GeomRelState<PHLineState>> destStates) {
        PhaseVar v1 = this.servDist[s1];
        double[] alpha1 = v1.getVectorArray();
        int m1 = v1.getNumPhases();
        PhaseVar v2 = this.servDist[s1];
        double[] alpha2 = v2.getVectorArray();
        int m2 = v2.getNumPhases();
        int n1 = 1;
        while (n1 <= m1) {
            int n2 = 1;
            while (n2 <= m2) {
                if (alpha1[n1 - 1] > 0.0 && alpha2[n2 - 1] > 0.0) {
                    GeomRelState<PHLineState> gs = new GeomRelState<PHLineState>(i.changePhase(s1, n1, s2, n2), relLevel);
                    destStates.add(gs);
                }
                ++n2;
            }
            ++n1;
        }
    }

    @Override
    public boolean active(PHLineState i, int iLevel, PHLineEvent e) {
        boolean canRestart;
        boolean result = false;
        if (e.type == PHLineEvent.Type.ARRIVAL) {
            return true;
        }
        int s = e.getStation();
        boolean canFinish = i.getSrvPhase(s) == e.getCurPH();
        int bSize = s == 0 ? iLevel : i.getBufferSize(s);
        boolean bl = canRestart = bSize > 0;
        boolean canMove = s < this.getNumStations() - 1 ? i.getBufferSize(s + 1) < this.getCapacity(s + 1) : false;
        switch (e.type) {
            case ARRIVAL: {
                result = true;
                break;
            }
            case CHANGE_PHASE: {
                result = i.getSrvPhase(s) == e.getCurPH();
                break;
            }
            case FINISH_AND_IDLE: {
                result = canFinish && !canRestart && !canMove;
                break;
            }
            case FINISH_AND_RESTART: {
                result = canFinish && canRestart && !canMove;
                break;
            }
            case FINISH_AND_IDLE_MOVE: {
                result = canFinish && !canRestart && canMove;
                break;
            }
            case FINISH_AND_RESTART_MOVE: {
                result = canFinish && canRestart && canMove;
            }
        }
        return result;
    }

    @Override
    public GeomRelState<PHLineState>[] dests(PHLineState i, int absLevel, PHLineEvent e) {
        StatesSet<GeomRelState<PHLineState>> destStates = new StatesSet<GeomRelState<PHLineState>>();
        int s = e.getStation();
        int rLevel = 0;
        if (e.type == PHLineEvent.Type.ARRIVAL) {
            rLevel = 1;
        } else if (s == 0 && (e.type == PHLineEvent.Type.FINISH_AND_IDLE_MOVE || e.type == PHLineEvent.Type.FINISH_AND_RESTART_MOVE)) {
            rLevel = -1;
        }
        switch (e.type) {
            case ARRIVAL: {
                if (absLevel == 0) {
                    destStates.add(new GeomRelState<PHLineState>(i, rLevel));
                    break;
                }
                this.addDestsChangePhase(i, s, rLevel, destStates);
                break;
            }
            case CHANGE_PHASE: {
                this.addDestsChangePhase(i, s, rLevel, destStates);
                break;
            }
            case FINISH_AND_IDLE: {
                GeomRelState<PHLineState> gs = new GeomRelState<PHLineState>(i.setIdle(s), 0);
                destStates.add(gs);
                break;
            }
            case FINISH_AND_RESTART: {
                PHLineState j = i.reduceBuffer(s);
                this.addDestsChangePhase(j, s, rLevel, destStates);
                break;
            }
            case FINISH_AND_IDLE_MOVE: {
                PHLineState j = i.move(s, s + 1);
                this.addDestsChangePhase(j, s, s + 1, destStates);
                break;
            }
            case FINISH_AND_RESTART_MOVE: {
                PHLineState j = i.move(s, s + 1);
                j = j.setIdle(s);
                this.addDestsChangePhase(j, s, s + 1, destStates);
            }
        }
        return (GeomRelState[])destStates.toStateArray();
    }

    @Override
    public double rate(PHLineState i, int iLevel, PHLineState j, int jLevel, PHLineEvent e) {
        double rate = -1.0;
        int s = e.getStation();
        double[] a = this.servDist[s].getMat0Array();
        switch (e.type) {
            case ARRIVAL: {
                rate = this.lambda;
                break;
            }
            case CHANGE_PHASE: {
                int curPhase = e.getCurPH();
                int newPhase = j.getSrvPhase(s);
                Matrix A = this.servDist[s].getMatrix();
                rate = A.get(curPhase - 1, newPhase - 1);
                break;
            }
            case FINISH_AND_IDLE: {
                rate = a[e.getCurPH() - 1];
                break;
            }
            case FINISH_AND_RESTART: {
                int newPhase = j.getSrvPhase(s);
                double[] alpha = this.servDist[s].getVectorArray();
                rate = a[e.getCurPH() - 1] * alpha[newPhase - 1];
                break;
            }
            case FINISH_AND_IDLE_MOVE: {
                double[] alpha2 = this.servDist[s + 1].getVectorArray();
                rate = a[e.getCurPH() - 1] * alpha2[j.getSrvPhase(s + 1) - 1];
                break;
            }
            case FINISH_AND_RESTART_MOVE: {
                int newPhase = j.getSrvPhase(s);
                double[] alpha = this.servDist[s].getVectorArray();
                double[] alpha2 = this.servDist[s + 1].getVectorArray();
                rate = a[e.getCurPH()] * alpha[newPhase - 1] * alpha2[j.getSrvPhase(s + 1) - 1];
            }
        }
        return rate;
    }

    @Override
    public String description() {
        return "Line of PH stations";
    }

    public static void main(String[] a) {
        double lambda = 4.0;
        DenseContPhaseVar v1 = DenseContPhaseVar.expo(5.0);
        DenseContPhaseVar v2 = DenseContPhaseVar.expo(6.0);
        PhaseVar[] vars = new PhaseVar[]{v1, v2};
        int[] cap = new int[]{3};
        PHLine model = new PHLine(lambda, vars, cap);
        model.showGUI();
        model.generate();
        model.setDebugLevel(0);
        PrintWriter out = new PrintWriter(System.out, true);
        out.println();
        model.printAll(out);
    }
}

