/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.Jackson;
import jmarkov.MarkovProcess;
import jmarkov.basic.PropertiesState;

class JacksonState
extends PropertiesState {
    public JacksonState(int[] wip) {
        super(wip);
    }

    @Override
    public void computeMOPs(MarkovProcess mp) {
        int M = this.getNumStations();
        Jackson jacky = (Jackson)mp;
        int[] servers = jacky.getNumServers();
        int i = 0;
        while (i < M) {
            this.setMOP(mp, "Busy Servers at Station " + (i + 1), Math.min(this.prop[i], servers[i]));
            ++i;
        }
        i = 0;
        while (i < M) {
            this.setMOP(mp, "Average WIP at the buffer " + (i + 1), this.prop[i]);
            ++i;
        }
    }

    public int getWip(int s) {
        return this.prop[s];
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    public int getNumStations() {
        return this.prop.length;
    }

    public JacksonState Trans(int i, int j) {
        int[] newWip = this.getProperties();
        if (i != j) {
            newWip[i] = newWip[i] - 1;
            newWip[j] = newWip[j] + 1;
        }
        return new JacksonState(newWip);
    }

    @Override
    public String description() {
        int M = this.getNumStations();
        String stg = "";
        int i = 0;
        while (i < M) {
            stg = String.valueOf(stg) + this.prop[i] + " at Station " + (i + 1) + (i < M - 1 ? ", " : "");
            ++i;
        }
        return stg;
    }
}

