/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import Jama.Matrix;
import examples.jmarkov.BucketEvent;
import examples.jmarkov.BucketState;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;

public class BucketBrigades
extends SimpleMarkovProcess<BucketState, BucketEvent> {
    private int N;
    private int M;
    private double[][] mu;

    public BucketBrigades(int N, int M, double[][] mu) {
        super(new BucketState(N, M), BucketEvent.getAllEvents(M));
        this.M = M;
        this.N = N;
        this.mu = mu;
        assert (mu.length == N);
        assert (mu[0].length == M);
    }

    public BucketBrigades(int N, int M, double[] processRates, double[] velocities) {
        super(new BucketState(N, M), BucketEvent.getAllEvents(M));
        this.M = M;
        this.N = N;
        this.mu = new double[N][M];
        int i = 0;
        while (i < N) {
            int j = 0;
            while (j < M) {
                this.mu[i][j] = processRates[j] * velocities[i];
                ++j;
            }
            ++i;
        }
        assert (this.mu.length == N);
        assert (this.mu[0].length == M);
    }

    @Override
    public boolean active(BucketState i, BucketEvent e) {
        return i.getMachineStatus(e.getMachine()) == 1;
    }

    @Override
    public States<BucketState> dests(BucketState i, BucketEvent e) {
        int[] newMachines = i.getMachines();
        int[] newWorkersStatus = new int[this.N];
        int[] newMachineStatus = new int[this.M];
        int eventWorker = this.getWorkerEvent(i, e.getMachine());
        if (e.getMachine() < this.M - 1) {
            newMachines[eventWorker] = e.getMachine() + 1;
        }
        if (e.getMachine() == this.M - 1) {
            int k = this.N - 1;
            while (k > 0) {
                newMachines[k] = newMachines[k - 1];
                --k;
            }
            newMachines[0] = 0;
        }
        newWorkersStatus = this.getWorkersStatus(newMachines);
        newMachineStatus = this.gsetMachineStatus(newMachines);
        return new StatesSet<BucketState>(new BucketState(newMachines, newWorkersStatus, newMachineStatus));
    }

    @Override
    public double rate(BucketState i, BucketState j, BucketEvent e) {
        return this.mu[this.getWorkerEvent(i, e.getMachine())][e.getMachine()];
    }

    private int[] getWorkersStatus(int[] machines) {
        int[] newWorkerStatus = new int[this.N];
        newWorkerStatus[this.N - 1] = 1;
        int i = this.N - 2;
        while (i >= 0) {
            if (machines[i] != machines[i + 1]) {
                newWorkerStatus[i] = 1;
            }
            --i;
        }
        return newWorkerStatus;
    }

    private int[] gsetMachineStatus(int[] machines) {
        int[] newMachinesStatus = new int[this.M];
        int i = 0;
        while (i < this.N) {
            newMachinesStatus[machines[i]] = 1;
            ++i;
        }
        return newMachinesStatus;
    }

    int getWorkerEvent(BucketState s, int m) {
        int result = 0;
        int i = 0;
        while (i < this.N) {
            if (s.getMachine(i) == m) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        String fileMu = "./BucketFiles/Mu.txt";
        double[][] mu = BucketBrigades.loadRateMatrix(fileMu);
        Matrix x = new Matrix(mu);
        int Op = x.getRowDimension();
        int M = x.getColumnDimension();
        BucketBrigades theModel = new BucketBrigades(Op, M, mu);
        theModel.setDebugLevel(0);
        theModel.setMaxStates(2000L);
        theModel.showGUI();
        theModel.generate();
        theModel.printAll();
    }

    private static double[][] loadRateMatrix(String fileName) {
        double[][] mu = null;
        File file = new File(fileName);
        String fullName = fileName;
        try {
            fullName = file.getCanonicalPath();
            Matrix Mu = Matrix.read((BufferedReader)new BufferedReader(new FileReader(file)));
            mu = Mu.getArrayCopy();
        }
        catch (Exception e) {
            System.out.println("Unable to read " + fullName);
            System.exit(0);
        }
        return mu;
    }

    @Override
    public String description() {
        String stg = "  ";
        stg = String.valueOf(stg) + "Bucket Brigades Production System with " + this.M + " Machines and " + this.N + " Workers\n";
        stg = String.valueOf(stg) + "\nMatrix Mu: Process rate of worker w. on machine m. \n      ";
        int i = 0;
        while (i < this.M) {
            stg = String.valueOf(stg) + "M" + i + "  ";
            ++i;
        }
        stg = String.valueOf(stg) + "\n";
        i = 0;
        while (i < this.N) {
            stg = String.valueOf(stg) + "N" + i + "  ";
            int j = 0;
            while (j < this.M) {
                stg = String.valueOf(stg) + this.mu[i][j] + " ";
                ++j;
            }
            stg = String.valueOf(stg) + "\n";
            ++i;
        }
        return stg;
    }

    @Override
    public String label() {
        return String.valueOf(super.label()) + " BB Expo (" + this.N + " workers and " + this.M + " machines).";
    }
}

