/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.BBPhBuf;
import jmarkov.MarkovProcess;
import jmarkov.basic.PropertiesState;

class BBPhBufSt
extends PropertiesState {
    private static int M;
    private static int N;
    private static BBPhBuf model;

    static {
        model = null;
    }

    BBPhBufSt(int[] machines, int[] phases, int[] machBuffers) {
        super(2 * phases.length + machBuffers.length);
        N = phases.length;
        assert (N == machines.length);
        M = machBuffers.length + 1;
        System.arraycopy(machines, 0, this.prop, 0, N);
        System.arraycopy(phases, 0, this.prop, N, N);
        System.arraycopy(machBuffers, 0, this.prop, 2 * N, M - 1);
    }

    public BBPhBufSt(int numWorkers, int numMachines) {
        this(BBPhBufSt.initStateMachines(numWorkers), BBPhBufSt.initStatePhases(numWorkers), new int[numMachines - 1]);
    }

    private static int[] initStateMachines(int N) {
        int[] machines = new int[N];
        return machines;
    }

    private static int[] initStatePhases(int N) {
        int[] phases = new int[N];
        phases[N - 1] = 1;
        return phases;
    }

    public int[] getPhases() {
        int[] phases = new int[N];
        System.arraycopy(this.prop, N, phases, 0, N);
        return phases;
    }

    public int getPhase(int i) {
        assert (i >= 0 && i < N);
        return this.prop[i + N];
    }

    public int getMachine(int i) {
        assert (i >= 0 && i < N);
        return this.prop[i];
    }

    public int[] getMachines() {
        int[] machines = new int[N];
        System.arraycopy(this.prop, 0, machines, 0, N);
        return machines;
    }

    public int getBuffer(int j) {
        assert (j >= -1 && j < M - 1);
        if (j == -1) {
            return Integer.MAX_VALUE;
        }
        return this.prop[2 * N + j];
    }

    public int getBuffer(int s, int j) {
        assert (s >= -1 && s < j);
        int sum = 0;
        int t = s;
        while (t < j) {
            sum += this.getBuffer(t);
            ++t;
        }
        return sum;
    }

    public int[] getBuffers() {
        int[] machBuffer = new int[M - 1];
        System.arraycopy(this.prop, 2 * N, machBuffer, 0, M - 1);
        return machBuffer;
    }

    @Override
    public boolean isConsistent() {
        boolean isOK = true;
        int i = 1;
        while (i < N && isOK) {
            if (this.getMachine(i) == this.getMachine(i - 1)) {
                assert (isOK &= !this.isBusy(i - 1));
            } else {
                assert (this.getMachine(i - 1) < this.getMachine(i));
                assert (isOK &= this.isBusy(i - 1));
            }
            ++i;
        }
        assert (isOK &= this.isBusy(N - 1));
        int j = 0;
        while (j < M) {
            int numAtMachine = this.getNumAtAmachine(j);
            assert (isOK &= this.getMachStatus(j) <= numAtMachine);
            if (numAtMachine >= 1) {
                isOK &= this.getMachStatus(j) == 1;
            }
            assert (isOK);
            ++j;
        }
        return isOK;
    }

    @Override
    public void computeMOPs(MarkovProcess mp) {
        int j;
        int i = 0;
        while (i < N) {
            j = 0;
            while (j < M) {
                this.setMOP(mp, "Machine " + (j + 1) + " usage by worker " + (i + 1), this.getWorkAciveAtMachine(i, j + 1));
                ++j;
            }
            ++i;
        }
        int sumOp = 0;
        int i2 = 0;
        while (i2 < N) {
            this.setMOP(mp, "Worker " + (i2 + 1) + " Status  ", this.isBusy(i2) ? 1.0 : 0.0);
            sumOp += this.isBusy(i2) ? 1 : 0;
            ++i2;
        }
        this.setMOP(mp, "Number  of active workers in the production line", sumOp);
        i2 = 0;
        while (i2 < M) {
            this.setMOP(mp, "Status Machine " + (i2 + 1), this.getMachStatus(i2 + 1));
            ++i2;
        }
        j = 0;
        while (j < M - 1) {
            this.setMOP(mp, "Number of units in buffer after the machine " + (j + 1), this.getBuffer(j));
            ++j;
        }
        i2 = 0;
        while (i2 < N) {
            this.setMOP(mp, "Blocked worker " + (i2 + 1), this.getBlocked(i2));
            ++i2;
        }
    }

    public int getWorkAciveAtMachine(int i, int j) {
        return this.getMachine(i) == j && this.getPhase(i) > 0 ? 1 : 0;
    }

    public int getBlocked(int i) {
        return this.getPhase(i) == 0 ? 1 : 0;
    }

    public boolean isBusy(int i) {
        return this.getPhase(i) > 0;
    }

    public int getWorker(int j) {
        int i = N - 1;
        while (this.getMachine(i) > j) {
            --i;
        }
        return i;
    }

    public int getMachStatus(int j) {
        int result = 0;
        int i = 0;
        while (i < N && result == 0) {
            if (this.getWorkAciveAtMachine(i, j) == 1) {
                result = 1;
            }
            ++i;
        }
        return result;
    }

    public int getNumAtAmachine(int j) {
        int result = 0;
        int i = 0;
        while (i < N) {
            result += this.getMachine(i) == j ? 1 : 0;
            ++i;
        }
        return result;
    }

    public BBPhBufSt phaseChange(int curOpe, int newPhase) {
        int[] newMachines = this.getMachines();
        int[] newPhases = this.getPhases();
        int[] newBuffers = this.getBuffers();
        newPhases[curOpe] = newPhase;
        return new BBPhBufSt(newMachines, newPhases, newBuffers);
    }

    public BBPhBufSt moveToNext(int i, int k) {
        int[] newMachines = this.getMachines();
        int[] newPhases = this.getPhases();
        int[] newBuffers = this.getBuffers();
        newMachines[i] = newMachines[i] + 1;
        newPhases[i] = k;
        return new BBPhBufSt(newMachines, newPhases, newBuffers);
    }

    public BBPhBufSt block(int curOpe) {
        return this.moveToNext(curOpe, 0);
    }

    public BBPhBufSt reset(int i, int w, int s) {
        int[] newBuffers = this.getBuffers();
        int j = this.getMachine(i);
        if (j < M - 1) {
            int n = j;
            newBuffers[n] = newBuffers[n] + 1;
        }
        int[] newMachines = this.shift(w, i, this.getMachines(), s);
        int[] newPhases = this.shift(w, i, this.getPhases(), 0);
        if (s > 0) {
            int n = s - 1;
            newBuffers[n] = newBuffers[n] - 1;
        }
        return new BBPhBufSt(newMachines, newPhases, newBuffers);
    }

    private int[] shift(int low, int high, int[] vec, int value) {
        assert (vec.length == N);
        int[] result = new int[N];
        System.arraycopy(vec, 0, result, 0, N);
        int k = low;
        while (k < high) {
            result[k + 1] = vec[k];
            ++k;
        }
        result[low] = value;
        return result;
    }

    public int getResetWorker(int s) {
        int i = 0;
        while (i < N && this.getMachine(i) < s) {
            ++i;
        }
        return i;
    }

    public int getResetMachine(int j) {
        int s = j;
        while (s > 0 && (this.getMachStatus(s) == 1 || this.getBuffer(s - 1) == 0 || this.getNumAtAmachine(s) > 1)) {
            --s;
        }
        return s;
    }

    @Override
    public BBPhBufSt clone() {
        return new BBPhBufSt(this.getMachines(), this.getPhases(), this.getBuffers());
    }

    String sp(int i, int N) {
        return N < 10 ? "" : (i < N ? "," : "");
    }

    @Override
    public String label() {
        String stg = "";
        int i = 0;
        while (i < N) {
            stg = String.valueOf(stg) + (this.getMachine(i) + 1) + this.sp(i, N);
            ++i;
        }
        stg = String.valueOf(stg) + "/";
        i = 0;
        while (i < N) {
            stg = String.valueOf(stg) + this.getPhase(i) + this.sp(i, N);
            ++i;
        }
        if (M > 1) {
            stg = String.valueOf(stg) + "/";
        }
        int j = 0;
        while (j < M - 1) {
            stg = String.valueOf(stg) + this.getBuffer(j) + this.sp(j, M - 1);
            ++j;
        }
        return stg;
    }

    @Override
    public String description() {
        String stg = "Machines: (";
        int i = 0;
        while (i < N) {
            stg = String.valueOf(stg) + (this.getMachine(i) + 1) + (i < N - 1 ? "," : "");
            ++i;
        }
        stg = String.valueOf(stg) + ") Phases: (";
        i = 0;
        while (i < N) {
            stg = String.valueOf(stg) + this.getPhase(i) + (i < N - 1 ? "," : "");
            ++i;
        }
        stg = String.valueOf(stg) + ") Buffer Units: (";
        int j = 0;
        while (j < M - 1) {
            stg = String.valueOf(stg) + this.getBuffer(j) + (j < M - 2 ? "," : "");
            ++j;
        }
        stg = String.valueOf(stg) + "), Blocked Wks: (";
        i = 0;
        while (i < N) {
            stg = String.valueOf(stg) + (this.getPhase(i) == 0 ? String.valueOf(i + 1) : "");
            ++i;
        }
        stg = String.valueOf(stg) + ")";
        return stg;
    }

    public static final BBPhBuf getModel() {
        return model;
    }

    static final void setModel(BBPhBuf newModel) {
        model = newModel;
    }
}

