function test_symplURV
% Function for testing the routine DGHURV. Random matrices of all
% orders m = 1:100 are used and the relative errors are checked.

%
%   Contributor:
%   V. Sima, Oct. 2009.
%
%   Revisions:
%   M. Voigt, Jul. 2013.
%   V. Sima, June 2014.
%

disp(' ')
disp('Random tests of the routine DGHURV')
disp(' ')

Details = 0;  % Set it to 1 for printing failure messages.

count = 0;
max_err = 0.0;
tole = sqrt( eps );
tol  = 10*tole;

job0   = 0;  job1   = 1;
cmpq10 = 0;  cmpq11 = 1;  cmpq12 = 2;
cmpq20 = 0;  cmpq21 = 1;  cmpq22 = 2;
cmpu10 = 0;  cmpu11 = 1;  cmpu12 = 2;
cmpu20 = 0;  cmpu21 = 1;  cmpu22 = 2;

% Check default values.

m = 4;  n = 2*m;
%
B = rand( m );  FG = rand( m, m+1 );
%
F = triu( FG(:,2:end) );  G = tril( FG(:,1:m) );
%
J = [ zeros( m ) eye( m ); -eye( m ) zeros( m ) ];
Z = rand( n );
H = [ B F+triu( F, 1 )'; G+tril( G, -1 )' -B' ];
%
[ Alphar,   Alphai,   Beta,   To,   Zo,   Ho,  Q1r, Q2r, U11r, U12r, U21r, U22r ] = ...
                            symplURV( Z, H, job1, cmpq11, cmpq21, cmpu11, cmpu21 );
[ Alphar1,  Alphai1,  Beta1,  To1,  Zo1,  Ho1, Q11, Q21 ] = ...
                            symplURV( Z, H, job1, cmpq11, cmpq21, cmpu11 );
[ Alphar2,  Alphai2,  Beta2,  To2,  Zo2,  Ho2, Q12, Q22 ] = ...
                            symplURV( Z, H, job1, cmpq11, cmpq21 );
[ Alphar3,  Alphai3,  Beta3,  To3,  Zo3,  Ho3, Q13 ] = ...
                            symplURV( Z, H, job1, cmpq11 );
[ Alphar4,  Alphai4,  Beta4,  To4,  Zo4,  Ho4 ] = ...
                            symplURV( Z, H, job1, cmpq10, cmpq20, cmpu10, cmpu20 );
[ Alphar5,  Alphai5,  Beta5,  To5,  Zo5,  Ho5 ] = ...
                            symplURV( Z, H, job1, cmpq10, cmpq20, cmpu10 );
[ Alphar6,  Alphai6,  Beta6,  To6,  Zo6,  Ho6 ] = ...
                            symplURV( Z, H, job1, cmpq10, cmpq20 );
[ Alphar7,  Alphai7,  Beta7,  To7,  Zo7,  Ho7 ] = ...
                            symplURV( Z, H, job1, cmpq10 );
[ Alphar8,  Alphai8,  Beta8,  To8,  Zo8,  Ho8 ] = ...
                            symplURV( Z, H, job1 );
[ Alphar9,  Alphai9,  Beta9,  To9,  Zo9 ] = ...
                            symplURV( Z, H, job1 );
[ Alphar10, Alphai10, Beta10, To10 ] = ...
                            symplURV( Z, H, job1 );
[ Alphar11, Alphai11, Beta11 ] = ...
                            symplURV( Z, H, job1 );
[ Alphar12, Alphai12, Beta12 ] = ...
                            symplURV( Z, H, job0 );
[ Alphar13, Alphai13, Beta13 ] = ...
                            symplURV( Z, H );
%
err = max( [ norm( Alphar - Alphar1  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai1  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta1    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar2  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai2  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta2    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar3  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai3  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta3    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar4  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai4  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta4    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar5  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai5  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta5    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar6  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai6  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta6    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar7  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai7  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta7    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar8  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai8  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta8    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar9  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai9  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta9    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar10 )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai10 )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta10   )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar11 )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai11 )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta11   )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar12 )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai12 )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta12   )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar13 )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai13 )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta13   )/max( 1, norm( Beta   ) ) ] );
%
err = max( [ norm( To  - To1,  1 )/max( 1, norm( To,  1 ) ), ...
             norm( Zo  - Zo1,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Ho  - Ho1,  1 )/max( 1, norm( Ho,  1 ) ), ...
             norm( To  - To2,  1 )/max( 1, norm( To,  1 ) ), ...
             norm( Zo  - Zo2,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Ho  - Ho2,  1 )/max( 1, norm( Ho,  1 ) ), ...
             norm( To  - To3,  1 )/max( 1, norm( To,  1 ) ), ...
             norm( Zo  - Zo3,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Ho  - Ho3,  1 )/max( 1, norm( Ho,  1 ) ), ...
             norm( To  - To4,  1 )/max( 1, norm( To,  1 ) ), ...
             norm( Zo  - Zo4,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Ho  - Ho4,  1 )/max( 1, norm( Ho,  1 ) ), ...
             norm( To  - To5,  1 )/max( 1, norm( To,  1 ) ), ...
             norm( Zo  - Zo5,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Ho  - Ho5,  1 )/max( 1, norm( Ho,  1 ) ), ...
             norm( To  - To6,  1 )/max( 1, norm( To,  1 ) ), ...
             norm( Zo  - Zo6,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Ho  - Ho6,  1 )/max( 1, norm( Ho,  1 ) ), ...
             norm( To  - To7,  1 )/max( 1, norm( To,  1 ) ), ...
             norm( Zo  - Zo7,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Ho  - Ho7,  1 )/max( 1, norm( Ho,  1 ) ), ...
             norm( To  - To8,  1 )/max( 1, norm( To,  1 ) ), ...
             norm( Zo  - Zo8,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Ho  - Ho8,  1 )/max( 1, norm( Ho,  1 ) ), ...
             norm( To  - To9,  1 )/max( 1, norm( To,  1 ) ), ...
             norm( Zo  - Zo9,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( To  - To10, 1 )/max( 1, norm( To,  1 ) ), ...
             err ] );
if err ~= 0, 
    disp( 'Check default values:' )
    if err > tol,  
        disp( 'Failed 1' ),  
    else
        disp( 'The most accurate tests (err = 0) are not satisfied' ) 
        disp( [ 'But err = ', num2str( err ) ] )
    end
    disp( ' ' ) 
end
%
% Check default values and functionality for comp* = 2.
%
Q01I  = eye( n );  Q02I  = eye( n );  
U011I = eye( m );  U012I = zeros( m );
U021I = eye( m );  U022I = zeros( m );
Q01   = Q1r;       Q02   = Q2r;       % try orthogonal (symplectic) matrices 
U011  = U11r;      U012  = U12r;      % generated before, to square them.
U021  = U21r;      U022  = U22r;  
Q01g  = rand( n ); Q02g  = rand( n ); % try also general matrices.
U011g = rand( m ); U012g = rand( m );  
U021g = rand( m ); U022g = rand( m ); 
%
[ Alphar1, Alphai1,  Beta1,  To1,  Zo1,  Ho1, Q111, Q211, U111, U121, U211, U221 ] = ...
                            symplURV( Z, H, job1, cmpq12, Q01I, cmpq22, Q02I, ...
                                            cmpu12, U011I, U012I, cmpu22, U021I, U022I );
[ Alphar2, Alphai2,  Beta2,  To2,  Zo2,  Ho2, Q112, Q212, U112, U122, U212, U222 ] = ...
                            symplURV( Z, H, job1, cmpq12, Q01, cmpq22, Q02, ...
                                            cmpu12, U011, U012, cmpu22, U021, U022 );
[ Alphar3, Alphai3,  Beta3,  To3,  Zo3,  Ho3, Q113, Q213, U113, U123, U213, U223 ] = ...
                            symplURV( Z, H, job1, cmpq12, Q01g, cmpq22, Q02g, ...
                                            cmpu12, U011g, U012g, cmpu22, U021g, U022g );
err = max( [ norm( Alphar - Alphar1  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai1  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta1    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar2  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai2  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta2    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar3  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai3  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta3    )/max( 1, norm( Beta   ) ) ] );
err = max( [ norm( To  - To1,  1 )/max( 1, norm( To,  1 ) ), ...
             norm( Zo  - Zo1,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Ho  - Ho1,  1 )/max( 1, norm( Ho,  1 ) ), ...
             norm( To  - To2,  1 )/max( 1, norm( To,  1 ) ), ...
             norm( Zo  - Zo2,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Ho  - Ho2,  1 )/max( 1, norm( Ho,  1 ) ), ...
             norm( To  - To3,  1 )/max( 1, norm( To,  1 ) ), ...
             norm( Zo  - Zo3,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Ho  - Ho3,  1 )/max( 1, norm( Ho,  1 ) ), ...
             err ] );
err = max( [ norm( Q111 - Q1r,  1 )/norm( Q1r,  1 ), ...
             norm( Q211 - Q2r,  1 )/norm( Q2r,  1 ), ...
             norm( U111 - U11r, 1 )/norm( U11r, 1 ), ...
             norm( U121 - U12r, 1 )/norm( U12r, 1 ), ...
             norm( U211 - U21r, 1 )/norm( U21r, 1 ), ...
             norm( U221 - U22r, 1 )/norm( U22r, 1 ), ...
             err ] );
%
if err ~= 0, 
    disp( 'Check default values:' )
    if err > tol,  
        disp( 'Failed 2' ),  
    else
        disp( 'The most accurate tests (err = 0) are not satisfied' ) 
        disp( [ 'But err = ', num2str( err ) ] )
    end
    disp( ' ' ) 
end
%
err = max( [ norm( Q112 - Q1r^2,  1 )/norm( Q1r^2,  1 ), ...
             norm( Q212 - Q2r^2,  1 )/norm( Q2r^2,  1 ), ...
             norm( U112 - U11r*U11r + U12r*U12r, 1 )/norm( U11r*U11r - U12r*U12r, 1 ), ...
             norm( U122 - U11r*U12r - U12r*U11r, 1 )/norm( U11r*U12r + U12r*U11r, 1 ), ...
             norm( U212 - U21r*U21r + U22r*U22r, 1 )/norm( U21r*U21r - U22r*U22r, 1 ), ...
             norm( U222 - U21r*U22r - U22r*U21r, 1 )/norm( U21r*U22r + U22r*U21r, 1 ), ...
             err ] );
%
err = max( [ norm( Q113 - Q01g*Q1r,  1 )/norm( Q01g*Q1r,  1 ), ...
             norm( Q213 - Q02g*Q2r,  1 )/norm( Q02g*Q2r,  1 ), ...
             norm( U113 - U011g*U11r + U012g*U12r, 1 )/norm( U011g*U11r - U012g*U12r, 1 ), ...
             norm( U123 - U011g*U12r - U012g*U11r, 1 )/norm( U011g*U12r + U012g*U11r, 1 ), ...
             norm( U213 - U021g*U21r + U022g*U22r, 1 )/norm( U021g*U21r - U022g*U22r, 1 ), ...
             norm( U223 - U021g*U22r - U022g*U21r, 1 )/norm( U021g*U22r + U022g*U21r, 1 ), ...
             err ] );
%
if err > tol, 
    disp( 'Check initialization of transformation matrices:' )
    disp( 'Failed 3' ),  
    disp( ' ' ) 
end
%
failures = 0;
%
% Check functionality.
%
% Using rand.
%
for k = 1 : 5,
    for m = 0 : 100,
        n = 2*m;
        B = rand( m );  FG = rand( m, m+1 );
        %
        F = triu( FG(:,2:end) );  G = tril( FG(:,1:m) );
        %
        J = [ zeros( m ) eye( m ); -eye( m ) zeros( m ) ];
        Z = rand( n );
        T = J*Z'*J';
        H = [ B F+triu( F, 1 )'; G+tril( G, -1 )' -B' ];
        %
        evm = eig( H, T*Z );
        if isreal( evm ),
            evp = evm( evm > 0 );
        else
            evp = union( evm( evm > 0 ), evm( imag( evm ) > 0 ) );
        end
        %
        for job = 0 : 1,
            count = count + 1;
            [ Alphar, Alphai, Beta, To, Zo, Ho, Q1, Q2, U11, U12, U21, U22 ] = ...
                               symplURV( Z, H, job, cmpq11, cmpq21, cmpu11, cmpu21 );
            err = max( [ norm( tril( To(1:n,1:m), -1 ), 1 ), norm( triu( To(m+1:n,m+1:n), 1 ), 1 ), ...
                         norm( tril( Zo(1:m,1:m), -1 ), 1 ), norm( triu( Zo(m+1:n,m+1:n), 1 ), 1 ), ...
                         norm( tril( Ho(1:n,1:m), -1 ), 1 ), norm( triu( Ho(m+1:n,m+1:n), 2 ), 1 ), ...
                         norm( Zo(m+1:n,1:m) - Z(m+1:n,1:m), 1 ) ] );
            if err > 0,
                if Details == 1,  disp( 'Failed 4' ),  end
                failures = failures + 1;
            end
            Zo(m+1:n,1:m) = zeros( m );
            if numel( Beta ) == n+1,
                ev = ( Alphar + Alphai*1i )./Beta(1:m).*Beta(n+1).^Beta(m+1:n);
            else
                ev = ( Alphar + Alphai*1i )./Beta;
            end
            err = norm( ev - cmpoles( ev, evp ) )/max( 1, norm( evp ) );
            if err > tol,  
                if Details == 1,  disp( 'Failed 5' ),  end
                failures = failures + 1;
            else
                max_err = max( max_err, err );
            end
            %
            errm = max( [ norm( To - Q1'*T*[ U11, U12; -U12, U11 ], 1 )/max( norm( To, 1 ), 1 ), ...
                          norm( Zo - [ U21, U22; -U22, U21 ]'*Z*Q2, 1 )/max( norm( Zo, 1 ), 1 ), ...
                          norm( Ho -                      Q1'*H*Q2, 1 )/max( norm( Ho, 1 ), 1 ) ] );
            if errm > tol,
                if Details == 1,  disp( 'Failed 6' ),  end
                failures = failures + 1;
            else
                max_err = max( max_err, errm );
            end
        end
    end
end
%
% Using randn.
%
for k = 1 : 5,
    for m = 0 : 100,
        n = 2*m;
        B = randn( m );  FG = randn( m, m+1 );
        %
        F = triu( FG(:,2:end) );  G = tril( FG(:,1:m) );
        %
        J = [ zeros( m ) eye( m ); -eye( m ) zeros( m ) ];
        Z = randn( n );
        T = J*Z'*J';
        H = [ B F+triu( F, 1 )'; G+tril( G, -1 )' -B' ];
        %
        evm = eig( H, T*Z );
        if isreal( evm ),
            evp = evm( evm > 0 );
        else
            evp = union( evm( evm > 0 ), evm( imag( evm ) > 0 ) );
        end
        %
        for job = 0 : 1,
            count = count + 1;
            [ Alphar, Alphai, Beta, To, Zo, Ho, Q1, Q2, U11, U12, U21, U22 ] = ...
                               symplURV( Z, H, job, cmpq11, cmpq21, cmpu11, cmpu21 );
            err = max( [ norm( tril( To(1:n,1:m), -1 ), 1 ), norm( triu( To(m+1:n,m+1:n), 1 ), 1 ), ...
                         norm( tril( Zo(1:m,1:m), -1 ), 1 ), norm( triu( Zo(m+1:n,m+1:n), 1 ), 1 ), ...
                         norm( tril( Ho(1:n,1:m), -1 ), 1 ), norm( triu( Ho(m+1:n,m+1:n), 2 ), 1 ), ...
                         norm( Zo(m+1:n,1:m) - Z(m+1:n,1:m), 1 ) ] );
            if err > 0,
                if Details == 1,  disp( 'Failed 7' ),  end
                failures = failures + 1;
            end
            Zo(m+1:n,1:m) = zeros( m );
            if numel( Beta ) == n+1,
                ev = ( Alphar + Alphai*1i )./Beta(1:m).*Beta(n+1).^Beta(m+1:n);
            else
                ev = ( Alphar + Alphai*1i )./Beta;
            end
            err = norm( ev - cmpoles( ev, evp ) )/max( 1, norm( evp ) );
            if err > tol,  
                if Details == 1,  disp( 'Failed 8' ),  end
                failures = failures + 1;
            else
                max_err = max( max_err, err );
            end
            %
            errm = max( [ norm( To - Q1'*T*[ U11, U12; -U12, U11 ], 1 )/max( norm( To, 1 ), 1 ), ...
                          norm( Zo - [ U21, U22; -U22, U21 ]'*Z*Q2, 1 )/max( norm( Zo, 1 ), 1 ), ...
                          norm( Ho -                      Q1'*H*Q2, 1 )/max( norm( Ho, 1 ), 1 ) ] );
            if errm > tol,
                if Details == 1,  disp( 'Failed 9' ),  end
                failures = failures + 1;
            else
                max_err = max( max_err, errm );
            end
        end
    end
end

if max_err < tol,
   disp( [ 'DGHURV :    passed  -- maximum relative error max_err = ', num2str( max_err ) ] )
   disp( [ '            Number of problems solved                 = ', num2str( count   ) ] )
   disp( ' ' )
else
   disp( [ 'DGHURV :    failed  -- maximum relative error max_err = ', num2str( max_err ) ] )
   disp( [ '            Number of problems solved                 = ', num2str( count   ) ] )
end

if failures > 0,  
   disp( [ 'Number of failed tests                                = ', ...
                        num2str( failures ) ] )
   disp( ' ' )
end        
