function test_skewHamil2feig
% Function for testing the routine DGHFST. Random matrices of all
% orders m = 1:100 are used and the relative errors are checked.

%
%   Contributor:
%   V. Sima, Oct. 2009.
%
%   Revisions:
%   V. Sima, Jul. 2012.
%   M. Voigt, Jul. 2013.
%

disp(' ')
disp('Random tests of the routine DGHFST')
disp(' ')

Details = 0;  % Set it to 1 for printing failure messages.

count = 0;
max_err = 0.0;
tol  = 100*eps^( 2/3 );
tole = sqrt( eps );

job0  = 0;  job1  = 1;
cmpq0 = 0;  cmpq1 = 1;  cmpqm = -1;
cmpu0 = 0;  cmpu1 = 1;  cmpu2 =  2;

% Check default values.

m = 4;  n = 2*m;
%
Z = rand( n );
B = rand( m );  FG = rand( m, m+1 );
%
[ Alphar,  Alphai,  Beta,  Zo,  Bo,  Fo,  Q, U1, U2 ] = ...
                              skewHamil2feig( Z, B, FG, job1, cmpq1, cmpu1 );
[ Alphar1, Alphai1, Beta1, Zo1, Bo1, Fo1, Q1 ] = ...
                              skewHamil2feig( Z, B, FG, job1, cmpq1 );
[ Alphar2, Alphai2, Beta2, Zo2, Bo2, Fo2 ] = ...
                              skewHamil2feig( Z, B, FG, job1, cmpq0, cmpu0 );
[ Alphar3, Alphai3, Beta3, Zo3, Bo3, Fo3 ] = ...
                              skewHamil2feig( Z, B, FG, job1, cmpq0 );
[ Alphar4, Alphai4, Beta4, Zo4, Bo4, Fo4 ] = ...
                              skewHamil2feig( Z, B, FG, job1 );
[ Alphar5, Alphai5, Beta5, Zo5, Bo5 ] = ...
                              skewHamil2feig( Z, B, FG, job1 );
[ Alphar6, Alphai6, Beta6, Zo6 ] = ...
                              skewHamil2feig( Z, B, FG, job1 );
[ Alphar7, Alphai7, Beta7 ] = skewHamil2feig( Z, B, FG, job1 );
[ Alphar8, Alphai8, Beta8 ] = skewHamil2feig( Z, B, FG, job0 );
[ Alphar9, Alphai9, Beta9 ] = skewHamil2feig( Z, B, FG );
%
err = max( [ norm( Alphar - Alphar1  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai1  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta1    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar2  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai2  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta2    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar3  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai3  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta3    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar4  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai4  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta4    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar5  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai5  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta5    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar6  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai6  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta6    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar7  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai7  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta7    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar8  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai8  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta8    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar9  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai9  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta9    )/max( 1, norm( Beta   ) ) ] );
%
err = max( [ norm( Zo  - Zo1,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Bo  - Bo1,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Fo  - Fo1,  1 )/max( 1, norm( Fo,  1 ) ), ...
             norm( Zo  - Zo2,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Bo  - Bo2,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Fo  - Fo2,  1 )/max( 1, norm( Fo,  1 ) ), ...
             norm( Zo  - Zo3,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Bo  - Bo3,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Fo  - Fo3,  1 )/max( 1, norm( Fo,  1 ) ), ...
             norm( Zo  - Zo4,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Bo  - Bo4,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Fo  - Fo4,  1 )/max( 1, norm( Fo,  1 ) ), ...
             norm( Zo  - Zo5,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Bo  - Bo5,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Zo  - Zo6,  1 )/max( 1, norm( Zo,  1 ) ), ...
             err ] );
erq = norm( Q1 - Q )/n;
if err ~= 0 || erq > eps, 
   disp( 'Check default values:' )
   if err > tol || erq > tole,  
      disp( 'Failed 1' ),  return
   else
      disp( 'The most accurate tests (err = 0, erq <= eps) are not satisfied' ) 
      disp( [ 'But err = ', num2str( err), ' and erq = ', num2str( erq) ] )
   end
   disp( ' ' ) 
end
%
% Check the reduction for compq = -1.
%
[ Alphara,  Alphaia,  Betaa,  Zoa,  Boa,  Foa,  Qa, U1a, U2a ] = ...
                              skewHamil2feig( Z, B, FG, job1, cmpqm, cmpu1 );
[ Alpharb,  Alphaib,  Betab,  Zob,  Bob,  Fob,  Qb, U1b, U2b ] = ...
                              skewHamil2feig( Z, B, FG, job0, cmpqm, cmpu1 );
err = max( [ norm( Alphar - Alphara  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphaia  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Betaa    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alpharb  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphaib  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Betab    )/max( 1, norm( Beta   ) ), ...
             norm( Qa     - Qb,    1 )/max( 1, norm( Qa,  1 ) ) ] );
ZQa = Z*Qa;  ZQb = Z*Qb;
erq = max( [ norm( tril( ZQa(:,1:m),      -1 ), 1 ), ...
             norm( triu( ZQa(m+1:n,m+1:n), 1 ), 1 ), ...
             norm( ZQa - ZQb, 1 ) ]/norm( ZQa, 1 ) );
if err ~= 0 || erq > eps, 
   disp( 'Check default values:' )
   if err > tol || erq > tole,  
      disp( 'Failed 2' ),  return
   else
      disp( 'The most accurate tests (err = 0, erq <= eps) are not satisfied' ) 
      disp( [ 'But err = ', num2str( err), ' and erq = ', num2str( erq) ] )
   end
   disp( ' ' ) 
end
%
% Check default values and functionality for compu = 2.
%
U01I = eye( m );   U02I = zeros( m ); % try orthogonal symplectic matrices 
U01  = U1;         U02  = U2;         % generated before, to square them.
U01g = rand( m );  U02g = rand( m );  % try also general matrices.
%
[ Alphar1, Alphai1, Beta1, Zo1, Bo1, Fo1, Q11, U11, U21 ] = ...
                              skewHamil2feig( Z, B, FG, job1, cmpq1, ...
                                              cmpu2, U01I, U02I );
[ Alphar2, Alphai2, Beta2, Zo2, Bo2, Fo2, Q12, U12, U22 ] = ...
                              skewHamil2feig( Z, B, FG, job1, cmpq1, ...
                                              cmpu2, U01, U02 );
[ Alphar3, Alphai3, Beta3, Zo3, Bo3, Fo3, Q13, U13, U23 ] = ...
                              skewHamil2feig( Z, B, FG, job1, cmpq1, ...
                                              cmpu2, U01g, U02g );
err = max( [ norm( Alphar - Alphar1  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai1  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta1    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar2  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai2  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta2    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar3  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai3  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta3    )/max( 1, norm( Beta   ) ) ] );
err = max( [ norm( Zo  - Zo1,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Bo  - Bo1,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Fo  - Fo1,  1 )/max( 1, norm( Fo,  1 ) ), ...
             norm( Zo  - Zo2,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Bo  - Bo2,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Fo  - Fo2,  1 )/max( 1, norm( Fo,  1 ) ), ...
             norm( Zo  - Zo3,  1 )/max( 1, norm( Zo,  1 ) ), ...
             norm( Bo  - Bo3,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Fo  - Fo3,  1 )/max( 1, norm( Fo,  1 ) ), ...
             err ] );
err = max( [ norm( Q11 - Q,  1 )/norm( Q,  1 ), ...
             norm( Q12 - Q,  1 )/norm( Q,  1 ), ...
             norm( Q13 - Q,  1 )/norm( Q,  1 ), ...
             norm( U11 - U1, 1 )/norm( U1, 1 ), ...
             norm( U21 - U2, 1 )/norm( U2, 1 ), ...
             err ] );
%
if err ~= 0, 
   disp( 'Check default values:' )
   if err > tol,  
      disp( 'Failed 3' ),  
   else
      disp( 'The most accurate tests (err = 0) are not satisfied' ) 
      disp( [ 'But err = ', num2str( err ) ] )
   end
   disp( ' ' ) 
end
%
err = max( [ norm( U12 - U01*U01 + U02*U02, 1 )/norm( U01*U01 - U02*U02, 1 ), ...
             norm( U22 - U01*U02 - U02*U01, 1 )/norm( U01*U02 + U02*U01, 1 ), ...
             err ] );
%
err = max( [ norm( U13 - U01g*U1 + U02g*U2, 1 )/norm( U01g*U1 - U02g*U2, 1 ), ...
             norm( U23 - U02g*U1 - U01g*U2, 1 )/norm( U02g*U1 + U01g*U2, 1 ), ...
             err ] );
%
if err > tol, 
    disp( 'Check initialization of transformation matrices:' )
    disp( 'Failed 4' ),  
    disp( ' ' ) 
end
%
clear Alphar* Alphai* Beta* Zo* Bo* Fo* Q Q1* Qa Qb U1* U2* ZQ* U0*
%
failures = 0;
%
% Check functionality.
%
% Using rand.
%
for k = 1 : 5,
   for m = 0 : 100,
      n = 2*m;
      Z = rand( n );  B = rand( m );  FG = rand( m, m+1 );
      %
      F = triu( FG(:,2:end), 1 );  G = tril( FG(:,1:m), -1 );
      %
      T = [ B F-F'; G-G' B' ];
      J = [ zeros( m ) eye( m ); -eye( m ) zeros( m ) ];
      %
      evm = eig( T, J*Z'*J'*Z );
      %
      for job = 0 : 1,
         count = count + 1;
         [ Alphar, Alphai, Beta, Zo, Bo, Fo, Q, U1, U2 ] = ...
                            skewHamil2feig( Z, B, FG, job, cmpq1, cmpu1 );
         %
         % Check that Zo(m+1:n,1:m) is unchanged.
         % Check eigenvalues and the structured Schur form. 
         %
         erz = norm( Zo(m+1:n,1:m) - Z(m+1:n,1:m), 1 );
         Zo(m+1:n,1:m) = zeros( m );
         ev  = ( Alphar + Alphai*1i )./Beta;
         ev2 = [ ev; ev];
         err = norm( evm - cmpoles( evm, ev2 ) )/max( 1, norm( evm ) );
         if erz > 0 || err > tol,
            if Details == 1,  disp( 'Failed 5' ),  end
            failures = failures + 1;
         else
            max_err = max( max_err, err );
         end
         Fot = triu( Fo, 1 );
         %
         To = [ Bo Fot-Fot'; zeros( m ) Bo' ];
         errm = max( [ norm( Zo - [ U1 U2; -U2 U1 ]'*Z*Q, 1 )/max( norm( Zo, 1 ), 1 ), ...
                       norm( To - J*Q'*J'*T*Q, 1 )/max( norm( To, 1 ), 1 ) ] );
         %
         % Check that Zo(1:m,1:m) is upper triangular, Zo(m+1:n,m+1:n) is lower
         % triangular, and the diagonal and the first subdiagonal of FG are
         % unchanged.
         %
         erz = max( [ norm( tril( Zo(  1:m,  1:m), -1 ), 1 ), ...
                      norm( triu( Zo(m+1:n,m+1:n),  1 ), 1 ), ...
                      norm( diag( FG(:,2:m+1) ) - diag( Fo ), 1 ), ...
                      norm( diag( FG(:,2:m+1), -1 ) - ...
                            diag( Fo, -1 ), 1 ) ] );
         if erz > 0 || errm > tol,  
            if Details == 1,  disp( 'Failed 6' ),  end
            failures = failures + 1;
         else
            max_err = max( max_err, errm );
         end
      end
   end
end
%
% Using randn.
%
for k = 1 : 5,
   for m = 0 : 100,
      n = 2*m;
      Z = randn( n );  B = randn( m );  FG = randn( m, m+1 );
      %
      F = triu( FG(:,2:end), 1 );  G = tril( FG(:,1:m), -1 );
      %
      T = [ B F-F'; G-G' B' ];
      J = [ zeros( m ) eye( m ); -eye( m ) zeros( m ) ];
      %
      evm = eig( T, J*Z'*J'*Z );
      %
      for job = 0 : 1,
         count = count + 1;
         [ Alphar, Alphai, Beta, Zo, Bo, Fo, Q, U1, U2 ] = ...
                            skewHamil2feig( Z, B, FG, job, cmpq1, cmpu1 );
         %
         % Check that Zo(m+1:n,1:m) is unchanged.
         % Check eigenvalues and the structured Schur form. 
         %
         erz = norm( Zo(m+1:n,1:m) - Z(m+1:n,1:m), 1 );
         Zo(m+1:n,1:m) = zeros( m );
         ev  = ( Alphar + Alphai*1i )./Beta;
         ev2 = [ ev; ev];
         err = norm( evm - cmpoles( evm, ev2 ) )/max( 1, norm( evm ) );
         if erz > 0 || err > tol,  
            if Details == 1,  disp( 'Failed 7' ),  end
            failures = failures + 1;
         else
            max_err = max( max_err, err );
         end
         Fot = triu( Fo, 1 );
         %
         To = [ Bo Fot-Fot'; zeros( m ) Bo' ];
         errm = max( [ norm( Zo - [ U1 U2; -U2 U1 ]'*Z*Q, 1 )/max( norm( Zo, 1 ), 1 ), ...
                       norm( To - J*Q'*J'*T*Q, 1 )/max( norm( To, 1 ), 1 ) ] );
         %
         % Check that Zo(1:m,1:m) is upper triangular, Zo(m+1:n,m+1:n) is lower
         % triangular, and the diagonal and the first subdiagonal of FG are
         % unchanged.
         %
         erz = max( [ norm( tril( Zo(  1:m,  1:m), -1 ), 1 ), ...
                      norm( triu( Zo(m+1:n,m+1:n),  1 ), 1 ), ...
                      norm( diag( FG(:,2:m+1) ) - diag( Fo ), 1 ), ...
                      norm( diag( FG(:,2:m+1), -1 ) - ...
                            diag( Fo, -1 ), 1 ) ] );
         if erz > 0 || errm > tol,  
            if Details == 1,  disp( 'Failed 8' ),  end
            failures = failures + 1;
         else
            max_err = max( max_err, errm );
         end
      end
   end
end

if max_err < tole,
   disp( [ 'DGHFST :    passed  -- maximum relative error max_err = ', num2str( max_err ) ] )
   disp( [ '            Number of problems solved                 = ', num2str( count   ) ] )
   disp( ' ' )
else
   disp( [ 'DGHFST :    failed  -- maximum relative error max_err = ', num2str( max_err ) ] )
   disp( [ '            Number of problems solved                 = ', num2str( count   ) ] )
end 

if failures > 0,  
   disp( [ 'Number of failed tests                                = ', ...
                        num2str( failures ) ] )
   disp( ' ' )
end
