
# Use TINYXML_ADDITIONAL_INCLUDE_DIRS to customize search.

GET_FILENAME_COMPONENT(FIRST_THIRD_PARTY_INCLUDE ${CMAKE_SOURCE_DIR}/ThirdParty ABSOLUTE)
GET_FILENAME_COMPONENT(SECOND_THIRD_PARTY_INCLUDE ${CMAKE_SOURCE_DIR}/../ThirdParty ABSOLUTE)

FIND_PATH(TINYXML_BASE tinyxml/tinyxml.h 
			${TINYXML_ADDITIONAL_INCLUDE_DIRS}
			/usr/include /usr/local/include 
			${FIRST_THIRD_PARTY_INCLUDE} ${SECOND_THIRD_PARTY_INCLUDE} )

IF (TINYXML_BASE)
  SET(TINYXML_FOUND TRUE)
ENDIF (TINYXML_BASE)

#FILE(TO_CMAKE_PATH ${TINYXML_BASE}/lib TINYXMLM_LIB_DIR)
#FILE(TO_CMAKE_PATH ${TINYXML_BASE}/tinyxml TINYXML_SRC_DIR)
#FILE(TO_CMAKE_PATH ${TINYXML_BASE}/tinyxml TINYXML_INCLUDE_DIR)

SET (TINYXML_LIB_DIR ${TINYXML_BASE}/lib )
SET (TINYXML_SRC_DIR ${TINYXML_BASE}/tinyxml)
SET (TINYXML_INCLUDE_DIR ${TINYXML_BASE}/tinyxml)

MARK_AS_ADVANCED(TINYXML_BASE)

IF (TINYXML_FOUND)
  IF (NOT TINYXML_FIND_QUIETLY)
     MESSAGE(STATUS "Found TinyXML: ${TINYXML_INCLUDE_DIR}")
  ENDIF (NOT TINYXML_FIND_QUIETLY)
ELSE(TINYXML_FOUND)
  IF (TINYXML_FIND_REQUIRED)
     MESSAGE(FATAL_ERROR "Could not find TinyXML")
  ENDIF (TINYXML_FIND_REQUIRED)
ENDIF (TINYXML_FOUND)
