
SET(FFTW_SEARCH_PATHS 
	${CMAKE_SOURCE_DIR}/ThirdParty/fftw-3.2.2/
	${CMAKE_SOURCE_DIR}/ThirdParty/fftw-3.2.2/lib/
	${CMAKE_SOURCE_DIR}/../ThirdParty/fftw-3.2.2/
	${CMAKE_SOURCE_DIR}/../ThirdParty/fftw-3.2.2/lib/
    ${CMAKE_SOURCE_DIR}/ThirdParty/build/dist/lib
    ${CMAKE_SOURCE_DIR}/../ThirdParty/build/dist/lib )

FIND_LIBRARY(FFTW_LIB NAMES fftw3 PATHS ${FFTW_SEARCH_PATHS} ENV LD_LIBRARY_PATH)

SET(FFTW_FOUND FALSE)
IF (FFTW_LIB)
  SET(FFTW_FOUND TRUE)
  MARK_AS_ADVANCED(FFTW_LIB)
ENDIF (FFTW_LIB)

IF (FFTW_FOUND)
  IF (NOT FFTW_LIB_FIND_QUIETLY)
     MESSAGE(STATUS "Found FFTW")
     GET_FILENAME_COMPONENT(FFTW_PATH ${FFTW_LIB} PATH CACHE)
     SET(FFTW_INCLUDE_DIR ${FFTW_PATH}/../include CACHE FILEPATH "FFTW include directory.")
     MARK_AS_ADVANCED(FFTW_PATH)
     MARK_AS_ADVANCED(FFTW_INCLUDE_DIR)
  ENDIF (NOT FFTW_LIB_FIND_QUIETLY)
ELSE(FFTW_FOUND)
  IF (FFTW_LIB_FIND_REQUIRED)
     MESSAGE(FATAL_ERROR "Could not find FFTW")
  ENDIF (FFTW_LIB_FIND_REQUIRED)
ENDIF (FFTW_FOUND)
