#!/bin/csh
#-----------------------------------------------
#          file:  ex_proto.pl 
#
#   Extract prototypes of void functions from 
#   C source files in argument list.  Write
#   these prototypes to standard out.
#
#   8/7/96  -- KAR 
#-----------------------------------------------

awk '
BEGIN  {  iflag = 0 }
/void/ {  
		 iflag = 1
                 val = $0
                 next; 
}
/\)/ {           
                 if ( iflag )
                 {
                   val = val "\n" $0 ";"
                   printf("%s\n\n", val)
                   iflag = 0
                   next
                 }
                 else 
                 {
                   next
                 }
    }
    {            if ( iflag )
                 {
                   val = val "\n" $0
                   next
                 }
                 else 
                   next
    }
' $*

