nmin := -201  : #Change as necessary

vals := Array( nmin .. -1 , 1 .. 2 ) :

#-----

libname := libname , "." :
Digits  := sdsf + 2 :

#-----

for n from nmin to -1 by 1 do

  x   := S_root( n , Digits , false ) :

  mx1 := nearestBinaryFloat( x ) :
  g1  := double_calc_S( n , toFraction( mx1 ) , Digits ) :

  if ( g1 > 0 ) then
    mx2 := stepBinaryFloat( mx1 , -1 ) :
  else
    mx2 := stepBinaryFloat( mx1 ,  1 ) :
  end if :

  x1 := evalf( toFraction( mx1 ) ) :
  x2 := evalf( toFraction( mx2 ) ) :

  g2 := double_calc_S( n , toFraction( mx2 ) , Digits ) :

  #-----

  if ( abs( g1 ) <= abs( g2 ) ) then

    vals[n,1] := transfer( mx1 ) :
    vals[n,2] := transfer( nearestBinaryFloat( g1 ) ) :

  else

    vals[n,1] := transfer( mx2 ) :
    vals[n,2] := transfer( nearestBinaryFloat( g2 ) ) :

  end if :

  printf( "%d %d %d \n" , n , vals[n,1] , vals[n,2] ) :

  #-----

end do :

unassign( 'n' ) :

#-----

f := fopen( "in_gamma_precomp.dat" , WRITE ) :

with( StringTools ) :

fprintf( f , FormatTime( "Timestamp: %c \n" ) ) :
fprintf( f , "This data file was generated by maple code 'in_gamma_precomp.mpl' \n" ) :
fprintf( f , "If you edit it you will get exactly what you deserve. \n \n" ) :

for n from nmin to -1 by 1 do
  fprintf( f , "%d  %d  %d\n" , n , vals[n,1] , vals[n,2] ) :
end do :

close( f ) :

#-----

#End of file 'in_gamma_precomp.mpl'