n0     := -25    :
n1     :=  25    :
x_min  :=  0     :
x_max  :=  100   : 
xsteps :=  1000  :

#-----

libname := libname , "." :
Digits  := sdsf + 2 : 
xstep   := ( x_max - x_min ) / xsteps :

#-----

f := fopen( "in_gamma_test.dat" , WRITE ) :

with( StringTools ) :

fprintf( f , FormatTime( "!Timestamp: %c \n" ) ) :
fprintf( f , "This data file was generated by maple code 'in_gamma_test.mpl' \n" ) :
fprintf( f , "If you edit it you will get exactly what you deserve. \n \n" ) :

#-----

fprintf( f , "%d , %d  <--- n0 , n1\n" , n0 , n1 ) :
fprintf( f , "%d %20.15f , %20.15f <--- xsteps , x_min , x_max\n\n" , xsteps , x_min , x_max ) :

x := x_min :

for j from 0 by 1 to xsteps do

  printf( "%d\n" , j ) :

  xb := nearestBinaryFloat( x ) :

  fprintf( f , "%d  (%20.15f)  <--- x \n" , transfer( xb ) , evalf( toFraction( xb ) ) ) :

  for n from n0 to n1 by 1 do

    Sx := double_calc_S( n , toFraction( xb ) , Digits ) :
    
    fprintf( f , "%d \n" , transfer( nearestBinaryFloat( Sx ) ) ) :

  end do :

  fprintf( f , "\n" ) :
  FileTools[Flush]( f ) :

  x := x + xstep :

end do :

#-----

close( f ) :

#End of file in_gamma_test.mpl