#include <iostream>
#include <iomanip>
using namespace std;

#include "MpIeee.hh"
#include "CMpIeee.hh"
#include "ArithmosIO.hh"

/* wavelet/wavelet.c
 * 
 * Copyright (C) 2004 Ivo Alxneit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include <stdlib.h>
#include <gsl/gsl_errno.h>
#include <gsl/gsl_wavelet.h>

gsl_wavelet *
gsl_wavelet_alloc (const gsl_wavelet_type * T, size_t k)
{
  int  status;

  gsl_wavelet *w = (gsl_wavelet *) malloc (sizeof (gsl_wavelet));

  if (w == NULL)
    {
      GSL_ERROR_VAL ("failed to allocate space for wavelet struct",
                     GSL_ENOMEM, 0);
    };

  w->type = T;

  status = (T->init) (&(w->h1), &(w->g1), &(w->h2), &(w->g2),
                      &(w->nc), &(w->offset), k);

  if (status)
    {
      free (w);
      GSL_ERROR_VAL ("invalid wavelet member", GSL_EINVAL, 0);
    }

  return w;
}

void
gsl_wavelet_free (gsl_wavelet * w)
{
  free (w);
}

const char *
gsl_wavelet_name (const gsl_wavelet * w)
{
  return w->type->name;
}


/* Let's not export this for now (BJG) */
#if 0
void
gsl_wavelet_print (const gsl_wavelet * w)
{
  size_t n = w->nc;
  size_t i;

  {cout<<"Wavelet type: "<< w->type->name<<"\n";}

  {cout<<" h1("<<
     0<<"):"<<setiosflags((ios::fixed & ios::floatfield))<<setw(12)<<setprecision(8)<< w->h1[0];
cout.precision(6);cout.fill(' ');cout.width(0);cout.setf(ios::dec,ios::basefield);
cout<<resetiosflags((ios::fixed & ios::floatfield))<<"   g1("<< 0<<"):"<<setiosflags((ios::fixed & ios::floatfield))<<setw(12)<<setprecision(8)<< w->g1[0];
cout.precision(6);cout.fill(' ');cout.width(0);cout.setf(ios::dec,ios::basefield);
cout<<resetiosflags((ios::fixed & ios::floatfield))<<"       h2("<< 0<<"):"<<setiosflags((ios::fixed & ios::floatfield))<<setw(12)<<setprecision(8)<< w->h2[0];
cout.precision(6);cout.fill(' ');cout.width(0);cout.setf(ios::dec,ios::basefield);
cout<<resetiosflags((ios::fixed & ios::floatfield))<<"   g2("<< 0<<"):"<<setiosflags((ios::fixed & ios::floatfield))<<setw(12)<<setprecision(8)<< w->g2[0];
cout.precision(6);cout.fill(' ');cout.width(0);cout.setf(ios::dec,ios::basefield);
cout<<resetiosflags((ios::fixed & ios::floatfield))<<"\n";}

  for (i = 1; i < (n < 10 ? n : 10); i++)
    {
      {cout<<" h1("<<
         i<<"):"<<setiosflags((ios::fixed & ios::floatfield))<<setw(12)<<setprecision(8)<< w->h1[i];
cout.precision(6);cout.fill(' ');cout.width(0);cout.setf(ios::dec,ios::basefield);
cout<<resetiosflags((ios::fixed & ios::floatfield))<<"   g1("<< i<<"):"<<setiosflags((ios::fixed & ios::floatfield))<<setw(12)<<setprecision(8)<< w->g1[i];
cout.precision(6);cout.fill(' ');cout.width(0);cout.setf(ios::dec,ios::basefield);
cout<<resetiosflags((ios::fixed & ios::floatfield))<<"       h2("<< i<<"):"<<setiosflags((ios::fixed & ios::floatfield))<<setw(12)<<setprecision(8)<< w->h2[i];
cout.precision(6);cout.fill(' ');cout.width(0);cout.setf(ios::dec,ios::basefield);
cout<<resetiosflags((ios::fixed & ios::floatfield))<<"   g2("<< i<<"):"<<setiosflags((ios::fixed & ios::floatfield))<<setw(12)<<setprecision(8)<< w->g2[i];
cout.precision(6);cout.fill(' ');cout.width(0);cout.setf(ios::dec,ios::basefield);
cout<<resetiosflags((ios::fixed & ios::floatfield))<<"\n";}
    }

  for (; i < n; i++)
    {
      {cout<<"h1("<<
         i<<"):"<<setiosflags((ios::fixed & ios::floatfield))<<setw(12)<<setprecision(8)<< w->h1[i];
cout.precision(6);cout.fill(' ');cout.width(0);cout.setf(ios::dec,ios::basefield);
cout<<resetiosflags((ios::fixed & ios::floatfield))<<"  g1("<< i<<"):"<<setiosflags((ios::fixed & ios::floatfield))<<setw(12)<<setprecision(8)<< w->g1[i];
cout.precision(6);cout.fill(' ');cout.width(0);cout.setf(ios::dec,ios::basefield);
cout<<resetiosflags((ios::fixed & ios::floatfield))<<"      h2("<< i<<"):"<<setiosflags((ios::fixed & ios::floatfield))<<setw(12)<<setprecision(8)<< w->h2[i];
cout.precision(6);cout.fill(' ');cout.width(0);cout.setf(ios::dec,ios::basefield);
cout<<resetiosflags((ios::fixed & ios::floatfield))<<"  g2("<< i<<"):"<<setiosflags((ios::fixed & ios::floatfield))<<setw(12)<<setprecision(8)<< w->g2[i];
cout.precision(6);cout.fill(' ');cout.width(0);cout.setf(ios::dec,ios::basefield);
cout<<resetiosflags((ios::fixed & ios::floatfield))<<"\n";}
    }
}
#endif

gsl_wavelet_workspace *
gsl_wavelet_workspace_alloc (size_t n)
{
  gsl_wavelet_workspace *work;

  if (n == 0)
    {
      GSL_ERROR_VAL ("length n must be positive integer", GSL_EDOM, 0);
    }

  work = (gsl_wavelet_workspace *) malloc (sizeof (gsl_wavelet_workspace));

  if (work == NULL)
    {
      GSL_ERROR_VAL ("failed to allocate struct", GSL_ENOMEM, 0);
    }

  work->n = n;
  work->scratch = (MpIeee*) malloc (n * sizeof (MpIeee));

  if (work->scratch == NULL)
    {
      /* error in constructor, prevent memory leak */
      free (work);
      GSL_ERROR_VAL ("failed to allocate scratch space", GSL_ENOMEM, 0);
    }

  return work;
}

void
gsl_wavelet_workspace_free (gsl_wavelet_workspace * work)
{
  /* release scratch space */
  free (work->scratch);
  work->scratch = NULL;
  free (work);
}
