      INTEGER             nc
      PARAMETER           (nc = 27)
*
      REAL*16             c(nc)
*
*-----------------------------------------------------------------------
*     Coefficients for the asymptotic series of psi(x), for x
*     in (cutoff, INF).  See Abramowitz and Stegen, NBS Handbook #55,
*     p. 259, 6.3.18 (1964).  These can be generated in Maple V5.1 by
*
*         Digits := 75:
*         with(numtheory):
*         bprint := proc(m)
*                  printf("     X      %+.50e,\n", B(2*m)/(2*m))
*              end:
*         for k from 1 to 27 do bprint(k) od:
*
*     and then substituting the Maple exponent letter e with a Fortran
*     precision-specific letter if needed.
*
*     Because of the Fortran limit of 19 continuation lines, we must
*     split this initializer into two parts.
*-----------------------------------------------------------------------
*
      DATA (c(i), i = 1,19) /
     X      +8.33333333333333333333333333333333333333333333333333q-02,
     X      -8.33333333333333333333333333333333333333333333333333q-03,
     X      +3.96825396825396825396825396825396825396825396825397q-03,
     X      -4.16666666666666666666666666666666666666666666666667q-03,
     X      +7.57575757575757575757575757575757575757575757575758q-03,
     X      -2.10927960927960927960927960927960927960927960927961q-02,
     X      +8.33333333333333333333333333333333333333333333333333q-02,
     X      -4.43259803921568627450980392156862745098039215686275q-01,
     X      +3.05395433027011974380395433027011974380395433027012q+00,
     X      -2.64562121212121212121212121212121212121212121212121q+01,
     X      +2.81460144927536231884057971014492753623188405797101q+02,
     X      -3.60751054639804639804639804639804639804639804639805q+03,
     X      +5.48275833333333333333333333333333333333333333333333q+04,
     X      -9.74936823850574712643678160919540229885057471264368q+05,
     X      +2.00526957966880789461434622724945305590466880789461q+07,
     X      -4.72384867721629901960784313725490196078431372549020q+08,
     X      +1.26357247959166666666666666666666666666666666666667q+10,
     X      -3.80879311252453688115530220793378688115530220793379q+11,
     X      +1.28508504993050833333333333333333333333333333333333q+13 /
      DATA (c(i), i = 20,27) /
     X      -4.82414483548501703715816703621581670362158167036216q+14,
     X      +2.00403106565162527381084216632389389864472920951326q+16,
     X      -9.16774360319533077569927536231884057971014492753623q+17,
     X      +4.59798883436565034904379432624113475177304964539007q+19,
     X      -2.51804719214510956970890233202255261078790490555196q+21,
     X      +1.50017334921539287337114401515151515151515151515152q+23,
     X      -9.68995788746359406564979428946540880503144654088050q+24,
     X      +6.76458823792928209909452423017984776756706581267985q+26 /
