.TH QIRAN 3 "30 June 2000" "Version 1.00"
.\" WARNING: This file was produced automatically from file common/qiran.f
.\" by fortran-to-man-page.awk on Sun Dec 31 09:02:22 MST 2000.
.\" Any manual changes will be lost if this file is regenerated!
.SH NAME
qiran \- Quadruple-precision pseudo-random integer in (x..y)
.\"=====================================================================
.SH SYNOPSIS
Fortran (77, 90, 95, HPF):
.RS
.B f77
.I "[ flags ] file(s) .\|.\|. -L/usr/local/lib -lgjl"
.RS
.nf
.B "REAL*16 FUNCTION qiran(x,y)"
.B "REAL*16             x,           y"
.fi
.RE
.RE
C (K&R, 89, 99), C++ (98):
.RS
.B cc
.I "[ flags ] -I/usr/local/include file(s) .\|.\|. -L/usr/local/lib -lgjl"
.br
Use
.RS
.B "#include <gampsi.h>"
.RE
to get this prototype:
.RS
.B "fortran_quadruple_precision qiran(const fortran_quadruple_precision * x_,"
.B "                                  const fortran_quadruple_precision * y_);"
.RE
.RE
.PP
NB: The definition of C/C++ data types
.B fortran_
.IR xxx ,
and the mapping of Fortran external names to C/C++ external names,
is handled by the C/C++ header file.  That way, the same function
or subroutine name can be used in C, C++, and Fortran code,
independent of compiler conventions for mangling of external
names in these programming languages.
.PP
Last code modification: 30-Jun-2000
.\"=====================================================================
.SH DESCRIPTION
Return a pseudo-random integer value, represented in quadruple
precision, in the range (\fBx\fP\&.\|.\fBy\fP\&), excluding endpoint \fBy\fP\&, where \fBx\fP\& >= \fBy\fP\&
(a relation that is NOT checked).
.PP
The underlying pseudo-random number generator is dran(), which
produces about 58 random bits.
.PP
The range of representable integers is 0 .\|. (2**p - 1), where p
is the number of bits in the significand of a
quadruple-precision number.
.PP
In IEEE 754 quadruple-precision arithmetic, p = 113,
corresponding to the range
0 .\|. 10384593717069655257060992658440192 (about 0 .\|. 1.04e+34).
.\"=====================================================================
.SH "SEE ALSO"
.BR airan (3),
.BR diran (3).
.\"=====================================================================
.SH AUTHORS
The algorithms and code are described in detail in
the paper
.RS
.I "Algorithm xxx: Quadruple-Precision Gamma(x) and psi(x) Functions for Real Arguments"
.RE
in ACM Transactions on Mathematical Software,
Volume ??, Number ??, Pages ????--???? and
????--????, 2001, by
.RS
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 110 LCB
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP, \fCbeebe@computer.org\fP
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
.fi
.RE
and
.RS
.nf
James S. Ball
University of Utah
Department of Physics
Salt Lake City, UT 84112-0830
USA
Tel: +1 801 581 8397
FAX: +1 801 581 6256
Email: \fCball@physics.utah.edu\fP
WWW URL: \fChttp://www.physics.utah.edu/people/faculty/ball.html\fP
.fi
.RE
.\"==============================[The End]==============================
.\"=====================================================================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
