c*************************************************************************
c                           CSIS3 Ver 1.0                                 *
c                                                                        *
c            Sparse SVD via eigensystem of A'A hermitian matrix          *
c                      using Subspace Iteration                          *
c                                                                        *
c                                                                        *
c*************************************************************************
c                                                                        *
c                         (C) copyright 1994                             *
c                          Michael W. Berry                              *
c                          Sowmini Varadhan                              *
c                         All rights reserved                            *
c                                                                        *
c           Permission to copy all or part of any of this                *
c           software is only granted upon approval from                  *
c                    Michael W. Berry,                                   *
c                    Dept. of Computer Science,                          *
c                    University of Tennessee,  107 Ayres Hall,           *
c                    Knoxville, TN,  37996-1301                          *
c                    (berry@cs.utk.edu)                                  *
c                                                                        *
c*************************************************************************
c

c
      program csis3
c
c.... this sample program uses ritzit to compute singular triplets of a via
c.... the equivalent hermitian eigenvalue problem
c....
c....  b = A'A , and A is m (nrow) by n (ncol)  (nrow>>ncol),
c....
c.... so that {u,sqrt(lambda),v} is a singular triplet of A.
c.... (A' = conjugate-transpose of A)
c....
c.... user supplied routines: copa,copb
c....
c.... copa(     x,y) takes an n-vector x and should return a*x in y.
c.... copb(ncol,x,y) takes an n-vector x and should return b*x in y.
c....
c.... user should replace calls to etime with an appropriate call to
c.... an instrinsic timing routine that returns elapsed user time
c....
c.... nsig specifies maximum number of singular triplets desired
c.... vectors specifies whether or not vectors are desired on output
c....
	integer nsig, nmax, nzmax

c.... Parameter definitions: modifying these also necessitates 
c.... modifications in critzit (of nsig), and op.f (nmax and nzmax)

      parameter(nsig=500)
      parameter(nmax=1000,nzmax=10000)
c....
      complex*8   value(nzmax), work(nsig), tau(nsig-1)
      integer   pointr(nmax), rowind(nzmax)
      common /matrixa/ ncol,nrow,value,pointr,rowind
c
c------------------------------------------------------------
c
      real*4 
     1       d(nsig),f(nsig),rq(nsig), cx(nmax),
     2       s(nsig),eps,xnorm, tmp1, tmp2, work2(nmax)
c
      real    time, t0, tmp(2), etime
c
c------------------------------------------------------------
c
c ----- harwell-boeing collection data structure
c
c------------------------------------------------------------
c
      integer  nrow, ncol, prevvalues, npp
      integer  nnzero, nrhs, results, matrix, p, em, em2, inf
      complex*8 x(nmax, nsig), b(nsig, nsig), w(nmax, nsig),
     1            u(nmax), cx2(nmax)
c
c
      character title*72, key*8, type*3, ptrfmt*16, indfmt*16,
     1 valfmt*20, rhsfmt*20
c
      character*30 name
      logical vectors, rstrt
c
c---------------------
c
      external intros,copb,copa

	integer input, i, lda, n, numextra, km, ivec, j, imem, vec
        integer nprev
	complex cdotc
c
      common /output/ inf
      common /count/ mxvcount
      integer mxvcount
c
      input=1
      matrix=7
      results=2
      inf=5
      prevvalues = 24
c
c     open files for input/output
c
      open (matrix,file='matrix')
      open (results,file='csio3')
      open (input,file='csii3')
      open (inf,file='csio.stats')
      write(inf,9994)
 
9994  format('-----------------------------------------------',/
     *       'intermediate output parms:',//
     *       'm := current degree of chebyshev polynomial',/
     *       's := next iteration step                   ',/
     *       'g := number of accepted eigenvalues  of b  ',/
     *       'h := number of accepted eigenvectors of b  ',/
     *       'f := vector of errors for eigenpairs of b  ',/
     *       '-----------------------------------------------',/
     *       '       m       s       g       h        f',/
     *       '-----------------------------------------------'/)

c
      read (matrix,10) title, key,
     1   type, nrow, ncol, nnzero, nrhs, ptrfmt, indfmt, valfmt, rhsfmt

 10   format (a72, a8 // a3, 11x, 4i14 / 2a16, 2a20)
c
c leave if matrix too big ----
c
	if (ncol .ge. nmax .or. nnzero .gt. nzmax) then
		write(*,*) ' sorry, your matrix is too big '
		stop
		endif
c
c read data...
c
      read (matrix,ptrfmt) (pointr (i), i = 1, ncol+1)
      read (matrix,indfmt) (rowind (i), i = 1, nnzero)
      read (matrix,valfmt) (value (i), i = 1, nnzero) 
c
c define last element of pointr in case it is not.  
c
	pointr(ncol+1) = nnzero + 1
c
      lda = nmax
      n=ncol
c
      read (input,*) name,em,numextra,km,eps,vectors, rstrt
c
c     name     := dataset name
c     em       := number of desired triplets
c 
c                 If rstrt is set to TRUE, then this is the number of
c                 _additional_ triplets, since the previous run.
c
c                 If rstrt is set to FALSE, then this the first em
c                 triplets are calculated.
c                   
c     numextra := additional vectors to carry
c     km       := maximum number of iterations
c     eps      := tolerance for accepting singular vectors
c     vectors  := output singular vectors (boolean)
c     rstrt    := TRUE,  use previous singular vectors information
c                 FALSE, no such info exists.
c     
c
      if (rstrt) then
         vec=30
c
c vec is the file containing the previously calculated singular vectors
c This file is written into at the end of the program, to be read in
c later if a restart is desired.
c
c prevvalues is the file containing previously calculated singular 
c values, and the control quantities. 
c
         open(vec,file='csiov3',form='unformatted')
         open (prevvalues,file='csio3.prev', form='unformatted')
	 km = - km
c
c npp is the size of the subspace used in the last run.
c
      read(prevvalues)npp , nprev
      read(prevvalues)(cx(i), i=1,npp)
      read(prevvalues)(d(i), i=1,npp)
      read(prevvalues)(f(i), i=1,npp)

         do i = 1, npp
           rq(i) = d(i)
         enddo

         do j = 1, nprev
          read(vec) (u(i),i=1,nrow)
          read(vec) (x(i,j),i=1,n)
         enddo
c 
c we don't need vec and prevvalues any more for the rest of the program...
c
	
	close(vec)
        close(prevvalues)
      else
          nprev = 0
      endif

      p = em + numextra + nprev
      em2=em + nprev

c
      t0 = etime(tmp(1))
      call critzit(lda,n,p,km,eps,copb,intros,em,x,d,u,w,b,f,cx,rq,s,
     *            imem, work, tau, work2, nprev)
      time = etime(tmp(1))-t0
c
      write(results,2000) n,km,em2,em,p,imem,vectors,eps,
     *              title,name,nrow,ncol,n
c
c
c  prevvalues is the file that will keep calculated singular
c  values, and the control quantities.  This file will contain, in order:
c         p  the size of cx/d/rq/f used
c         em the number of converged values
c        cx(*)
c         d(*)
c         f(*)
c
      open (prevvalues,file='csio3.prev', form='unformatted')
      write(prevvalues) p, em
      write(prevvalues)(cx(i), i=1,p)
      write(prevvalues)(d(i), i=1,p)
      write(prevvalues)(f(i), i=1,p)

      if(vectors) then
c 
c write out singular vectors:
c
         ivec=3
         open(ivec,file='csiov3',form='unformatted')
      endif
c
      t0 = etime(tmp(1))
c
      do 35 j = 1, em2
         call copb(n,x(1,j),cx2)
         tmp1=cdotc(n,x(1,j),1,cx2,1)
         call caxpy(n,cmplx(-tmp1),x(1,j),1,cx2,1)
         tmp1=sqrt(tmp1)
         xnorm=sqrt(cdotc(n,cx2,1,cx2,1))
c
c........multiply by matrix a to get (scaled) left s-vector
c
         call copa(x(1,j),u)
         tmp2=1.0e0/tmp1
         call cscal(nrow,cmplx(tmp2),u,1)
         xnorm=xnorm*tmp2
         f(j)=xnorm
         d(j)=tmp1
         if(vectors) write(ivec) (u(i),i=1,nrow)
         if(vectors) write(ivec) (x(i,j),i=1,n)
35    continue
c
      time = time + etime(tmp(1))-t0
c
      write(results,9998) time
      write(results,9999)mxvcount,(i,d(i),f(i),i = 1,em2)

	 
c
      stop
c
c*************************************************************************
c      format statements to be used for writing to output files.
c*************************************************************************
9998  format(/1x,'...... sisvd execution time=',1pe10.2)
9999  format(1x,'...... '
     *   /1x,'...... ',16x,' mxv  =',i12
     *   /1x,'...... '
     *   /1x,'...... ',4x,'computed singular values',2x,
     *    '(','residual norms',')'
     *   /1x,'...... '
     *   /(1x,'...... ',i3,3x,1pe22.14,2x,'(',1pe11.2,')'))
2000  format(
     *    1x,'... '
     *   /1x,'... solve the [a^ta]   eigenproblem'
     *   /1x,'... no. of equations          =',i10
     *   /1x,'... max. no. of iterations    =',i10
     *   /1x,'... no. of desired eigenpairs =',i10
     *   /1x,'... no. of approx. eigenpairs =',i10
     *   /1x,'... initial subspace dim.     =',i10
     *   /1x,'... memory required (bytes)   =',i10
     *   /1x,'... want s-vectors?   [t/f]   =',l10
     *   /1x,'... tolerance                 =',1pe10.2
     *   //1x,a50
     *   / 1x,a50
     *   /1x,'... no. of documents (rows)   = ',i8
     *   /1x,'... no. of terms     (cols)   = ',i8
     *   /1x,'... order of matrix b         = ',i8
     *   /1x,'... ')
c
      end
c************************************************************************
c
      subroutine intros(ks,kg,kh,f,m)
c
c     intros is a subroutine used to obtain
c     information or exert control during execution.  intros is called
c     with parameters (ks,kg,kh,f,m), where ks is the number
c     of the next iteration step, kg is the number of already
c     accepted eigenvectors, kh is the number of already accepted
c     eigenvalues, and f is the array of error quantities for
c     vectors of x.  an element of f has the value 4.0
c     until the corresponding eigenvalue has been accepted.
c     m is the degree of the current chebyshev polynomial.
c
      integer kg,kh,inf,m,ks,l
      real*4 f(1)
      common /output/ inf
      l = kh + 1
      write(inf,10) m,ks,kg,kh,f(1)
      if(l.ge.2) write(inf,11) (f(i),i=2,l)
   10 format(/4i8,e15.6)
   11 format( 32x,e15.6)
      return
      end
c
c************************************************************************
      subroutine critzit(nm,n,kp,km,eps,copb,inf,kem,x,d,u,w,b,f,cx,
     *                  rq,s,imem, work, tau, work2, nprev)
c

        parameter(nsig=500)

      integer i,j,k,l,m,n,ig,ii,ik,ip,kg,kh,km,kp,ks,kz,l1,m1,nm,kem,
     *        kz1,kz2,jp,imem, info, ilen,  nprev
      real*4 d(kp),f(kp), cx(kp),rq(kp), ureal(nsig), work2(n)
      real*4 e,s(kp),t,e1,e2,xk,ee2,eps,xkm,xks,xm1
      complex*8 x(nm, kp), w(nm, kp), b(kp, kp), work(4*kp), tau(kp-1)
      complex*8 csqrt,cdotc,  u(nm), compt

	external copb
c
c     calls user subroutines copb,inf
c     calls LAPACK routines: chetrd, cungtr, csteqr
c     calls BLAS routines  : cgemm, cgemv, caxpy, cdotc
c
c     this subroutine is a translation of the algol procedure ritzit,
c     num. math. 16, 205-223(1970) by Rutishauser.
c     Handbook for Auto. Comp., Vol.ii-Linear Algebra, 284-302(1971).
c
c     This subroutine determines the absolutely largest eigenvalues
c     and corresponding eigenvectors of a complex hermitian matrix by
c     simultaneous iteration.
c
c     on input:
c
c        nm must be set to the row dimension of the two-dimensional
c          array parameter x as declared in the calling program
c          dimension statement;
c
c        n is the order of the matrix a (matrix b for svd problem);
c
c        kp is the number of simultaneous iteration vectors;
c
c        km is the maximum number of iteration steps to be performed.
c          if starting values for the iteration vectors are available,
c          km should be prefixed with a minus sign;
c
c        eps is the tolerance for accepting eigenvectors;
c
c        copb is the name of the subroutine that defines the matrix B.
c          copb is called with parameters (n,u,w) and must compute
c          w=bu without altering u for svd problem;
c
c        inf is the name of the subroutine that may be used to obtain
c          information or exert control during execution.  inf is called
c          with parameters (ks,kg,kh,f,km,kem), where ks is the number
c          of the next iteration step, kg is the number of already
c          accepted eigenvectors, kh is the number of already accepted
c          eigenvalues, and f is the array of error quantities for
c          the vectors of x.  an element of f has the value 4.0
c          until the corresponding eigenvalue has been accepted;
c
c        kem is the number of eigenvalues and corresponding
c          eigenvectors desired.  kem must be less than kp;
c
c        x contains, if km is negative, the starting values for
c          the iteration vectors.
c
c     nprev number of previously calculated  vectors 
c
c     on output:
c
c        km is reset to the magnitude of its input value;
c
c        kem is reset to the number of eigenvalues and eigenvectors
c          actually accepted within the limit of km steps;
c
c        imem is set to the approximate number of bytes needed for
c          this invocation.
c
c        x contains in its first kem columns orthonormal eigenvectors
c          of a corresponding to the eigenvalues in d.  the remaining
c          columns contain approximations to further eigenvectors;
c
c        d contains in its first kem positions the absolutely largest
c          eigenvalues of a (b).  the remaining positions contain
c          approximations to smaller eigenvalues;
c
c        u, w, b, f, cx, s, and rq are temporary storage arrays.
c        work, tau, work2 are complex arrays, needed for the LAPACK
c        equivalents of EISPACK routines used in sis2.f from SVDPACK.
c
c     questions and comments should be directed to B. S. Garbow,
c     Modernizations  by M. W. Berry, Univ. of Tennessee, 1991.
c     Promotion to Complex case by S. Varadhan, Univ. of Tennessee, 1994.
c
c     ------------------------------------------------------------------
c
c.....get auxillary memory count (8-byte words)
c     (assume nm=n for counts)
c

c   for the complex variables:
      imem = kp + 2*n + n*kp + kp*kp + n*kp + (kp-1)

c   multiply this by 2 (accounting for real, and imaginary parts):
      imem = 2 * imem
 
c   the rest of the real auxillary vars:  
      imem = imem + 4*kp + 2*n + nsig

c   use 4 byte words for single precision:
      imem = 4*imem
c
      ee2 = 1.0e0 + 1.0e-1 * eps
      e = 0.0e0
      kg =nprev 
      kh =nprev 
      kz = 1367
      kz1 = 0
      kz2 = 0
      ks = 0
      m = 1
      kem = kem+nprev

c
           do 30 l = nprev+1, kp
              f(l) = 4.0e0
              cx(l) = 0.0e0
              rq(l) = 0.0e0
   30      continue
c
      if (km .lt. 0) go to 60
c     :::::::::: generate random initial iteration vectors ::::::::::
      do 50 l = nprev+1, kp
c
         do 40 j = 1, n
            kz = mod(3125*kz,65536)
            x(j,l) = cmplx(kz-32768)
   40    continue
c
   50 continue
c
   60 km = iabs(km)
      l1 = nprev+1
c
c initialize b(1:nprev, 1:nprev) to I. 
c
      do jset=1, nprev
       do iset = 1, nprev
        b(iset,jset) = cmplx(0.0)
       enddo
      enddo

      do iset = 1, nprev
        b(iset, iset) = cmplx(1.0)
      enddo

      ii = 1
      go to 905
   65 ig = nprev+1
      ip = kp - 1
c     :::::::::: jacobi step modified ::::::::::
   70 do 90 k = ig, kp
         call copb(n,x(1,k),w(1,1))

c
         do 85 j = 1, n
   85    x(j,k) = w(j,1)
c
   90 continue
c
      l1 = ig 
      ii = 2
      go to 905
  100 if (ks .gt. 0) go to 130
c     :::::::::: measures against unhappy choice of
c                initial vectors ::::::::::
      do 120 k = nprev+1, kp
         if (b(k,k) .ne. 0.0e0) go to 120
c
         do 110 j = 1, n
            kz = mod(3125*kz,65536)
            x(j,k) = cmplx(kz-32768)
  110    continue
c
         ks = 1
  120 continue
c
      if (ks .ne. 1) go to 130
      l1 = nprev + 1
      ii = 3
      go to 905
c
  130 do 150 k = ig, kp
c
         do 145 l = k, kp
             compt = cmplx(0.0e0)
c
            do 140 i = l, kp
  140       compt = compt  + conjg(b(i,k)) * b(i,l)
c     :::::::::: negate matrix to reverse eigenvalue ordering ::::::::::
            b(l,k) =  - compt
  145    continue
c
  150 continue
c     ::::: chetrd, cungtr, csteqr  are members of lapack package :::::
      j = kp - kg

      call chetrd('L',j,b(ig,ig),kp,d(ig),ureal,tau,work,kp,info)
      call cungtr('L', j, b(ig,ig), kp, tau, work, kp, info)
      call csteqr('V',j,d(ig),ureal,b(ig,ig),kp, work2, ii)


c
      do 190 k = ig, kp
       d(k) = sqrt(amax1(-d(k),0.0e0))
190   continue

c
c
      call cgemm('n','n',n,kp-ig+1,kp-ig+1,cmplx(1.0),x(1,ig),nm,
     *           b(ig,ig),kp,cmplx(0.0),w(1,ig),nm)
c
c
      do 210 k = ig, kp
         do 210 j = 1, n
  210    x(j,k) = w(j,k)
c
      ks = ks + 1
      xks = float(ks)
      if (d(kp) .gt. e) e = d(kp)
c     :::::::::: randomization ::::::::::
      if (kz1 .ge. 3) go to 225
c
      do 220 j = 1, n
         kz = mod(3125*kz,65536)
         x(j,kp) = cmplx(kz-32768)
  220 continue
c
      l1 = kp
      ii = 4
      go to 905
c     :::::::::: compute control quantities cx ::::::::::
  225 do 270 k = ig, ip
         t = (d(k) - e) * (d(k) + e)
         if (t .gt. 0.0e0) go to 240
         cx(k) = 0.0e0
         go to 270
  240    if (e .ne. 0.0e0) go to 260
         cx(k) = 1.0e3 + alog(d(k))
         go to 270
  260    cx(k) = alog((d(k)+sqrt(t))/e)
  270 continue
c
c     :::::::::: acceptance test for eigenvalues including adjustment
c                of kem and kh such that d(kem) .gt. e, d(kh) .gt. e,
c                and d(kem) does not oscillate strongly ::::::::::
      do 300 k = ig, kem
         if (d(k) .le. e .or.
     x       (kz1 .gt. 1 .and. d(k) .le. 9.99e-1 * rq(k))) go to 320
  300 continue
c
      go to 340
  320 kem = k - 1
  340 if (kem .eq. 0) go to 900
  350 k = kh + 1
      if (d(k) .eq. 0.0e0 .or. d(k) .gt. ee2 * rq(k)) go to 360
      kh = k
      go to 350
  360 if (d(k) .le. e) kh = k - 1
      k = k - 1
      if (k .gt. kem) go to 360
c     :::::::::: acceptance test for eigenvectors ::::::::::
      l = kg
      e2 = 0.0e0
c
      do 560 k = ig, ip
         if (k .ne. l + 1) go to 430
c     :::::::::: check for nested eigenvalues ::::::::::
         l = k
         l1 = k
         if (k .eq. ip) go to 410
         ik = k + 1
         s(1) = 5.0e-1 / xks
         t = 1.0e0 / float(ks*m)
c
         do 400 j = ik, ip
            if (cx(j) * (cx(j) + s(1)) + t.le. ( cx(j-1) * cx(j-1)))
     x         go to 410
            l = j
  400    continue
c
  410    if (l .le. kh) go to 430
         l = l1 - 1
         go to 570
  430    call copb(n,x(1,k),w(1,1))
         s(1) = 0.0e0
c
         do 480 j = 1, l
            if (abs(d(j)-d(k)) .ge. 1.0e-2 * d(k)) go to 480
            t = 0.0e0
c
            do 460 i = 1, n
  460       compt = compt + (w(i,1)) * (x(i,j))
c
            do 470 i = 1, n
  470       w(i,1) = w(i,1) - compt * x(i,j)
c
            s(1) = s(1) + conjg(compt) * compt
  480    continue
c
         t = 0.0e0
c
         do 490 i = 1, n
  490    t = t + conjg(w(i,1)) * w(i,1)
c
         if (s(1) .ne. 0.0e0) go to 510
         t = 1.0e0
         go to 520
  510    t = sqrt(t/(s(1)+t))
  520    if (t .gt. e2) e2 = t
         if (k .ne. l) go to 560
c     :::::::::: test for acceptance of group of eigenvectors ::::::::::
         if (l .ge. kem .and.
     x       d(kem) * f(kem) .lt. eps * (d(kem) - e)) kg = kem
         if (e2 .ge. f(l)) go to 555
c
         do 550 j = l1, l
  550    f(j) = e2
c
  555    if (l .le. kem .and. d(l) * f(l) .lt. eps * (d(l) - e)) kg = l
         ig = kg + 1
  560 continue
c     :::::::::: adjust m ::::::::::
  570 if (e .gt. 4.0e-2 * d(1)) go to 590
      m = 1
      k = 1
      go to 600
  590 e2 = 2.0e0 / e
      e1 = 5.1e-1 * e2
      k = 2 * max0(int(4.0e0/cx(1)),1)
      if (m .gt. k) m = k
c     :::::::::: reduce kem if convergence would be too slow ::::::::::
  600 xkm = float(km)
      if (f(kem) .eq. 0.0e0 .or. xks .ge. 9.0e-1 * xkm) go to 660
      xk = float(k)
      s(1) = xk * cx(kem)
      if (s(1) .ge. 5.0e-2) go to 640
      t = 5.0e-1 * s(1) * cx(kem)
      go to 650
  640 t = cx(kem) + alog(5.0e-1*(1.0e0+exp(-2.0e0*s(1)))) / xk
  650 s(1) = alog(d(kem)*f(kem)/(eps*(d(kem)-e))) / t
      if ((xkm - xks) * xkm .lt. s(1) * xks) kem = kem - 1
  660 call inf(ks,kg,kh,f,m)
c
      if (kg .ge. kem .or. ks .ge. km) go to 900
c
      do 670 k = ig, ip
  670 rq(k) = d(k)

c
  680 if (ks + m .le. km) go to 700
      kz2 = -1
      if (m .gt. 1) m = 2 * ((km - ks + 1) / 2)
  700 m1 = m
c     :::::::::: shortcut last intermediate block if all error
c                quantities f are sufficiently small ::::::::::
      if (l .lt. kem) go to 750
      s(1) = d(kem) * f(kem) / (eps * (d(kem) - e))
      t = s(1) * s(1) - 1.0e0
      if (t .le. 0.0e0) go to 70
      s(1) = alog(s(1)+sqrt(t)) / (cx(kem) - cx(kh+1))
      m1 = 2 * int(5.0e-1*s(1)+1.01e0)
      if (m1 .le. m) go to 740
      m1 = m
      go to 750
  740 kz2 = -1
  750 xm1 = float(m1)
c     :::::::::: chebyshev iteration ::::::::::
      if (m .ne. 1) go to 790
c
      do 780 k = ig, kp
         call copb(n,x(1,k),w(1,1))
c
         do 775 i = 1, n
  775    x(i,k) = w(i,1)
c
  780 continue
c
      go to 860
c     :::::::::: degree .ne. one ::::::::::
c
  790 do 850 k = ig, kp
         call copb(n,x(1,k),w(1,1))
c
         do 810 i = 1, n
  810    u(i) = e1 * w(i,1)
c
         call copb(n,u(1),w(1,1))
c
         do 820 i = 1, n
  820    x(i,k) = e2 * w(i,1) - x(i,k)
c
         if (m1 .lt. 4) go to 850
c
         do 840 j = 4, m1, 2
            call copb(n,x(1,k),w(1,1))
c
            do 830 i = 1, n
  830       u(i) = e2 * w(i,1) - u(i)
c
            call copb(n,u,w(1,1))
c
            do 835 i = 1, n
  835       x(i,k) = e2 * w(i,1) - x(i,k)
c
  840    continue
c
  850 continue
c
  860 l1 = ig
      ii = 5
      go to 905
c     :::::::::: discounting the error quantities f ::::::::::
  870 if (kg .eq. kh) go to 895
      if (m .ne. 1) go to 885
c
      do 880 k = ig, kh
  880 f(k) = f(k) * (d(kh+1) / d(k))
c
      go to 895
  885 t = exp(-xm1*cx(kh+1))
c
      do 890 k = ig, kh
         s(1) = exp(-xm1*(cx(k)-cx(kh+1)))
         f(k) = s(1) * f(k) * (1.0e0 + t * t) /
     x          (1.0e0 + (s(1) * t) ** 2)
  890 continue
c
  895 ks = ks + m1
      kz2 = kz2 - m1
c     :::::::::: possible repetition of intermediate steps ::::::::::
      if (kz2 .ge. 0) go to 680
      kz1 = kz1 + 1
      kz2 = 2 * kz1
      m = 2 * m
      go to 70
  900 kem = kg
c     :::::::::: solve eigenvalue problem of projection
c                of matrix a (matrix b for svd problem) ::::::::::
      l1 = nprev+1
      ii = 6
c     :::::::::: in-line procedure for extending orthonormalization
c                to all kp columns of x ::::::::::
c 
c         Deflation: first l1-1 columns are already orthonormalized.
c          
c      :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  905 jp = kp
      if (ii .eq. 6) jp = kp - 1

      do 915 i = 1, jp
	 do 906 k = l1, jp
  906    b(k,i) = cmplx(0.0)
c
         ik = l1
         if (i .lt. l1) go to 909
c
	 ik = i + 1
c
c
         b(i,i)=csqrt(cdotc(n,x(1,i),1,x(1,i),1))
c
         compt = cmplx(0.0e0)
         if (b(i,i) .ne. cmplx(0.)) t = 1/sqrt(conjg(b(i,i)) * b(i,i))
c
         call cscal(n,cmplx(t),x(1,i),1)
c
  909    continue
c
         ilen=jp-ik+1
c   
c
            call cgemv('c',n,ilen,cmplx(1.0),x(1,ik),nm,
     *              x(1,i),1,cmplx(0.0),b(ik,i),1)

c
c    b(ik:ik+ilen-1,i) = conjg(b(ik:ik+ilen-1,i); for the complex case!
c
	   do ill = ik, ik+ilen-1
            b(ill,i) = conjg(b(ill,i))
	   enddo

            do 912 k=ik,jp
               call caxpy(n,-b(k,i),x(1,i),1,x(1,k),1)
912      continue
c
  915 continue
c :::::::::::::::::::: end inline procedure.
c
      go to (65,100,70,225,870,920), ii
c
  920 do 921 k = 1, ip
         do 921 i = k, ip
  921    b(i,k) = cmplx(0.0e0)
c
      do 930 k = 1, ip
         call copb(n,x(1,k),w(1,1))
c
         do 925 i = 1, k
            do 922 l = 1, n
  922       b(k,i) = b(k,i) - conjg(x(l,i)) * w(l,1)
c
  925    continue
c
  930 continue
c
      call chetrd('L', ip, b, kp, d, ureal, tau, work, kp, info)
      call cungtr('L', ip, b, kp,  tau, work, kp, info)
      call csteqr('V',ip,d,ureal,b,kp, work2, ii)

c     :::::::::: reordering of eigenvalues and eigenvectors according
c                to the magnitudes of the former ::::::::::
      do 934 i = 1, ip
         if (i .eq. ip) go to 933
         k = i
         t = d(i)
         ii = i + 1
c
         do 931 j = ii, ip
            if (abs(d(j)) .le. abs(t)) go to 931
            k = j
            t = d(j)
  931    continue
c
         if (k .eq. i) go to 933
         d(k) = d(i)
         d(i) = t
c
         do 932 j = 1, ip
            compt = b(j,i)
            b(j,i) = b(j,k)
            b(j,k) = compt
  932    continue
c
  933    d(i) = -d(i)
  934 continue
c
c
      call cgemm('n','n',n,ip,ip,cmplx(1.0),x,nm,b,kp,cmplx(0.0),w,nm)
c
      do 950 i = 1, ip
         do 950 j = 1, n
  950    x(j,i) = w(j,i)
c
      d(kp) = e
      return
c     :::::::::: last card of critzit ::::::::::
	end


