c**********************************************************************
c                                                                     *
c                      (C) copyright 1994                             *
c                       Michael W. Berry                              *
c                       Sowmini Varadhan                              *
c                      All rights reserved                            *
c                                                                     *
c        Permission to copy all or part of any of this                *
c        software is only granted upon approval from                  *
c        Michael W. Berry, Dept. of Computer Science                  *
c        University of Tennessee,  107 Ayres Hall,                    *
c        Knoxville, TN,  37996-1301 (berry@cs.utk.edu)                *
c                                                                     *
c  This file contains sample user-supplied routines for Matrix-Vector *
c  multiplication to be used in association with Critzit.             *
c  The routines provided here assume that the matrix is stored        *
c  in the Harwell-Boeing Format                                       *
c                                                                     *
c**********************************************************************


	subroutine copb(n, x, y)
c
c.....multiplication of matrix b by a vector x , where
c
c     b =   a'a, where a is nrow by ncol (nrow >> ncol)
c
c     hence, b  is of order n:=ncol (y stores product vector)
c

	implicit none

	integer nmax, nzmax
      parameter(nmax=1000,nzmax=10000)
      complex*8    value(nzmax)
      integer pointr(nmax), rowind(nzmax), ncol, nrow
      common /matrixa/ ncol,nrow,value,pointr,rowind
c
      common /count/ mxvcount
      integer n,mxvcount
      complex*8 x(1), y(n), ztemp(nmax)
c
c---------------------
c
	integer i, j
      mxvcount=mxvcount+2
c
      do 55 i=1,ncol
         y(i)= cmplx(0.0e+0)
55    continue
c
      do 85 i=1,nmax
         ztemp(i)=cmplx(0.0e+0)
85    continue
c
c.....multiply by sparse c
c
      do 15 i=1,ncol
c
         do 10 j=pointr(i),pointr(i+1)-1
            ztemp(rowind(j))=ztemp(rowind(j))+value(j)*x(i)
10       continue
c
15    continue
c
c.....multiply by sparse c'
c

      do 25 i =1,ncol
c
         do 20 j=pointr(i),pointr(i+1)-1
            y(i)=y(i)+conjg(value(j))*ztemp(rowind(j))
20       continue
25    continue
c
      return
      end
c
      subroutine copa (x, y)
c
c.....multiplication of matrix a by vector x , where
c
c     a is nrow by ncol (nrow >> ncol)
c
c     (y stores product vector)
c
      parameter(nmax=1000,nzmax=10000)
      complex*8    value(nzmax)
      integer pointr(nmax), rowind(nzmax)
      common /matrixa/ ncol,nrow,value,pointr,rowind
c
      common /count/ mxvcount
      integer mxvcount
      complex*8 x(1), y(1)
c
c---------------------
c
      mxvcount=mxvcount+1
c
      do 55 i=1,nrow
         y(i)=cmplx(0.0)
55    continue
c
      do 15 i=1,ncol
c
         do 10 j=pointr(i),pointr(i+1)-1
            y(rowind(j))=y(rowind(j))+value(j)*x(i)
10    continue
c
15    continue
c
      return
      end
