
/***********************************************************************
 Copyright (C) 1994 by the Regents of the University of Michigan.

 User agrees to reproduce said copyright notice on all copies of the software
 made by the recipient.  

 All Rights Reserved. Permission is hereby granted for the recipient to make
 copies and use this software for its own internal purposes only. Recipient of
 this software may re-distribute this software outside of their own 
 institution. Permission to market this software commercially, to include this
 product as part of a commercial product, or to make a derivative work for
 commercial purposes, is explicitly prohibited.  All other uses are also
 prohibited unless authorized in writing by the Regents of the University of
 Michigan.

 This software is offered without warranty. The Regents of the University of
 Michigan disclaim all warranties, express or implied, including but not
 limited to the implied warranties of merchantability and fitness for any
 particular purpose. In no event shall the Regents of the University of
 Michigan be liable for loss or damage of any kind, including but not limited
 to incidental, indirect, consequential, or special damages. 
***********************************************************************/
/* for xgen */

#include "sldoc.h"

extern char **keys;
extern struct gams *gamlist;
extern struct routine *r;

extern int Nrtn, Nkeys, Ngams;

/* writes out names in range based on starting letter,eg AA-DC*/

showroutines(char *com)
{
    char start,end;
    char starte,ende;  /*2nd letter of routine */
    char buf[8];
    int i,k,j;

/* parse command */
    start= *com;
    starte= com[1];
    end= com[2];
    ende= com[3];

    i=j= 0;
/* get 1st routine starting with 2 letters starting range */
    if(starte=='_') starte= 127;
    while( r[i].name[0] <start) i++;
    while( r[i].name[0] ==start && r[i].name[1] <starte) i++;

/* get 1st routine starting with 2 letters ending range */
    if(ende=='_') ende= 126;
    while( r[j].name[0] < end) j++;
    while( r[j].name[0] ==end && r[j].name[1] < ende) j++;

    for( k=i; k<=j; k++)
    {
        bzero(buf,8);
        strncpy(buf,r[k].name,6);
        puts(buf);
    }
}

int rtntoi(char *namin6)
{
    int i;
    char buf[RTNLN+2];

    for(i=0; i< Nrtn; i++)
        if( !strncmp(r[i].name,namin6,RTNLN)) break;
    if(i==Nrtn) 
    {
	bzero( buf, RTNLN +2);
	bcopy(namin6,buf,RTNLN+1);
        printf("rtntoi: unknown routine %s\n",buf);
	return(-1);
    }
    return(i);
}

int getroutine(FILE *fp,char *namin6,char c,FILE *out)
{
    int i,j,numlines;
    char buf[CDLN+9];

    if( (i= rtntoi(namin6)) == -1) return(-1);
    SEEKRTN( fp,i )

    if(c=='R') numlines= r[i].k.srclines + r[i].g.doclines;
    else  numlines= r[i].g.doclines;
    if(!out) out= stdout;

    for(j=0; j< numlines ; j++)
    {
       fgets(buf,CDLN+8,fp);
       fputs(buf,out);
    }
    if(c=='N')
    {
        printf("\nType b to Begin; CLOSE Window to Return.");
        j=getchar();
    }
    return(i);
}

#define LNLN 72

putcat(int i,int trim,FILE *out)
{
        int n;
	char p[BFSZ];

	if( !out ) out= stdout;

        bzero(p,BFSZ);
	sprintf( p,"%s.%s",gamlist[i].gam,gamlist[i].describe);

/* cut off parenthetical references */
	if( trim )
	    for(n=0; p[n]; n++) if( p[n]=='(' ){ p[n]='\0';break;}

	if( (n=strlen(p)) >= LNLN) linechop(p,n,out);
	else puts(p);
}

linechop(char *p,int n,FILE *out)
{
    int i,k,m,j,ii;
    int bottom,last,b[16],dashck;
    char sv;

    if( !out ) out= stdout;

/* assumes nonblank starting str of <=4 */

    for(i=4;i<n; i++)
	if(p[i] != ' ')break;
	
/* find all blanks,hyphens after start */
    for(j=0,k=i+1;k<n; k++)
	if(p[k]==' '|| p[k]=='-') b[j++]= k;
	
/* find 1st good cutting place */
    last= j-1;
    dashck=0;
    for(m= last; m > -1; m--)
	if( b[m] < LNLN )
	{
	    k= b[m];
	    if(p[k]=='-')dashck=1;
	    else p[k]='\n';
	    sv= p[k+1];
	    p[k+1]='\0';
	    fputs(p,out);
	    if(dashck){fputc('\n',out);dashck=0;}
	    p[k+1]= sv;
	    break;
	}

/*remainder */
/* preface them with indent as long as start+8 on 1st */
    bottom =m;
    ii= i+8;
    for(k= last; k > bottom; k--)
	if( b[k]-b[bottom] < LNLN-ii && n- b[bottom] > LNLN-ii)
	{
	    m= b[k];
	    if(p[m]=='-')dashck=1;
	    else p[m]='\n';
	    sv= p[m+1];
	    p[m+1]='\0';
	    for(j=0;j<ii;j++)fputc(' ',out);
	    fputs( p+ b[bottom]+1,out);
	    if(dashck){fputc('\n',out);dashck=0;}
	    p[m+1]= sv;
	    bottom= k;
	    k= last+1;
	}
    for(j=0;j<ii;j++)fputc(' ',out);
    puts(p+b[bottom]+1);
    return;
}

keytoi(char *t)
{
    int i,m;

    m=strlen(t);
    for(i=0;i<Nkeys;i++)
	if(!strncmp(t,keys[i],m)) break;

    if(i==Nkeys) fprintf(stdout,"unknown key:%s\n",t);
    return(i);
}

getkey(char *input)
{
#ifdef _AIX
    char *p,*po;
#else
    char *p,*po, *index();
#endif
    char **rdphrases();
    void stowkey();
    int kount,match,i,j,k,m,jj,failed;
    int compar();
    short ink[10];

/* grab keywords(s) from command line argument */
/* convert them to indexes, order the indexes from least up */

    m= strlen(input);
    if(m <=0)
    {
        printf("No\nKey\nword\n"); return;
    }
    keys= rdphrases(KYWDS,"keys",sizeof(char *),stowkey,&Nkeys);

    kount=0;
    po=p=input;
    while(( p=index(p,',')) || isupper(po[0]) || isdigit(po[0]))
    {
	if(p) *p='\0';
	else
	{
	    m=strlen(po);
	    po[m+1]='\0';
	}
	if(kount > MXKEY-1)
	{
            printf("No\nMatch\n"); return;
	}
        ink[kount++]= keytoi(po);

/* if index failed to find a , exit loop */
	if(p) po= ++p;
	else break;
    }
    qsort(ink, kount, sizeof(short), compar);

/* compare set input against all known ones */

    failed=1;
    for(i=0; i< Nrtn; i++)
    {
	for(match=j=0;j<kount;j++)
	{
	    jj= 0;
	    while( (k= fetcher( r[i].k.n,r[i].k.start,&jj)) != -1)
	        if(ink[j]==k ) { match++; break; }
	}
		 
/* if input is subset of some routine's key set */
	if(match==kount) 
	{
	    putto_x(i,0);
	    failed= 0;
	}
    }
    if(failed) printf("No\nMatch\n");
}

int getcat( char *mycat, int (*putout)(), char *s, int *fndgam)
{
    int i,j,tote,jj,foundgam,pchr,gg;
    char *g;
    short bf[1024];

    foundgam= 0;
    pchr= 1;
    for(tote=i=0; i<Ngams; i++)
    {
/* if entry is start of gams on list get routines for them */
       g= gamlist[i].gam;
       if( *g==*mycat && strstr(g,mycat) )
       {
	   foundgam= 1;
	   for(j=0; j<Nrtn; j++)
	   {
	       jj= 0;
	       while( (gg= fetcher(r[j].g.n,r[j].g.start,&jj)) != -1)
		   if( gg == i)
		   {
                        if (!tote && s) puts(s); /* error mss */
			bf[tote++]= j;
		   }
	   }
       }
    }
    sortnames(bf,tote);
    for(i=0; i<tote; i++) pchr= (*putout)((int)bf[i],1);
    if(!pchr){ putchar('\n'); pchr=1; }
    *fndgam= foundgam;
    return(tote);
}

putto_x(int j,int d)
{
    char buf[RTNLN+2];

    bzero(buf,RTNLN+2);
    strncpy(buf,r[j].name,RTNLN);
    puts(buf);
}

getcat_x( char *mycat )
{
    int foundgam,tote;

    tote= getcat( mycat,putto_x,NULL,&foundgam);
    if(!foundgam)
    {
	 printf("A\nSubCategory\nNot\nSpecified\n");
	 return;
    }
    if(!tote)
	 printf("Look\nDown a\nLevel\n");
}

/* find all subsets of the category then check each */
int mchkcat(char *s)
{
   int i,gotg,n;
   char *g;
    
   gotg= -1;
   n= strlen(s);
   for(i=0; i<Ngams; i++)
   {
      g= gamlist[i].gam;
      if( *g==*s && strstr(g,s) )
      {
	  if(strlen(g)==n)
	     gotg= 0;
	  if( chkcat(i) ) return(1);
      }
   }
   return(gotg);
}

/* find at least one ref to the gams in the routines */
int chkcat(int i)
{
   int j,gg,jj;
   
   for(j=0; j<Nrtn; j++)
   {
       jj= 0;
       while( (gg= fetcher(r[j].g.n,r[j].g.start,&jj)) != -1)
	   if( gg == i) return(1);
   }
   return(0);
}

int listcat(char *so,int num, FILE *out )
{
    int i,t;
    char *g, bj,o;

    if( !out ) out= stdout;

    o= so[0];
    switch(o){
      case '\0':
	for(i=0; i< Ngams; i++)
	{
	    g= gamlist[i].gam;
	    if( strlen(g)==1 ) for(bj= 'A'; bj<='Z' ;bj++)
	            if( g[0]==bj && mchkcat(g)>0 ) putcat(i,1,out);
	}
        return(1);

      case 1:
/* only count gams with slatec routines somwhere underneath */
	for(t=i=0; i< Ngams; i++)
	{
	    g= gamlist[i].gam;
	    if(mchkcat(g)>0) t++;
	}
	return(t);

      case 2:
/* only displays gams with slatec routines */
	for(i=0; i< Ngams; i++)
	{
	    g= gamlist[i].gam;
	    if(mchkcat(g)>0) putcat(i,0,out);
	}
	return(1);

      default:
      return( listsubcat( so,num,out ));
    }
}

/* only displays gams with slatec routines */
/* that start with so */
/* -2 : string starts no known gam */
/* -1 : string starts known gam  but no routines found for it */
/*  0 : string starts known gam  with rutines but no subcats w/ routines
	found for it */
/*  2 : string starts known gam  and routines found */

/* num == number of levels to descend 1,2,3,etc  0=all */

int listsubcat( char *so,int num, FILE *out)
{
      int gotg,n,t,i,m,s;
      char *g;

      gotg= -2;
      n= strlen(so);
      for(s=t=i=0; i<Ngams; i++)
      {
         g= gamlist[i].gam;
         if( *g==*so && strstr(g,so) )
         {
/* found in total gams list */
	     if( (m=strlen(g))==n) gotg= -1;
	     if(num)
	     {
	        if( m <= n+num && mchkcat(g) )
		{ 
		    if( m != n ) s++;
		    t++;
		    putcat(i,0,out);
		}
	     }
             else
	     {
	        if( mchkcat(g) )
		{ 
		    if( m != n ) s++;
		    t++;
		    putcat(i,0,out);
		}
	     }
         }
      }
      if(s) return(2);
      if(t) return(0);
      return(gotg);
}

showkeys()
{
    int i;
    for(i=0; i<Nkeys; i++ ) puts(keys[i]);
}
