
/***********************************************************************
 Copyright (C) 1994 by the Regents of the University of Michigan.

 User agrees to reproduce said copyright notice on all copies of the software
 made by the recipient.  

 All Rights Reserved. Permission is hereby granted for the recipient to make
 copies and use this software for its own internal purposes only. Recipient of
 this software may re-distribute this software outside of their own 
 institution. Permission to market this software commercially, to include this
 product as part of a commercial product, or to make a derivative work for
 commercial purposes, is explicitly prohibited.  All other uses are also
 prohibited unless authorized in writing by the Regents of the University of
 Michigan.

 This software is offered without warranty. The Regents of the University of
 Michigan disclaim all warranties, express or implied, including but not
 limited to the implied warranties of merchantability and fitness for any
 particular purpose. In no event shall the Regents of the University of
 Michigan be liable for loss or damage of any kind, including but not limited
 to incidental, indirect, consequential, or special damages. 
***********************************************************************/
/* my implemtation of sladoc functionality --dmw */

#include "sldoc.h"

char **keys;
struct gams *gamlist;

extern struct routine *r;
extern unsigned short *Indices;

static int Currln= 0;
static int Pgsz= 21;
static FILE *Fp= 0;
static int Ngams2;
static int Ee;
static short Pgln;

int Nkeys, Ngams;
int Nrtn, Ndx; /* number of routines in library */
int totcalls= 0;

main(int argc,char **argv)
{
    char *fn, **rdphrases();
    int ret;
    char buf[BFSZ];
    char so[2];
    void stowkey(), stowgam();

    fn= DAF;
    Fp= fopen(fn,"r");
    if( !Fp )
    {
	 bzero( buf,BFSZ );
	 sprintf( buf,"fopen %s",fn );
	 perror(buf);
	 exit(-1);
    }
    Nrtn= rd_binfl(RTBL,&r,sizeof(struct routine));
    Ndx= rd_binfl(NDX,&Indices,sizeof(short));
    puts(
    " Welcome to SLATXT the SLATEC on-line documentation program\n");
    keys= rdphrases(KYWDS,"keys",sizeof(char *),stowkey,&Nkeys);
    gamlist= (struct gams *)rdphrases(GAMS,"gams",
			  sizeof(struct gams),stowgam,&Ngams);
    help();

    so[0]= 1;
    so[1]= '\0';
    Ngams2= listcat(so,0,0);

    while(1)
    {
	ret= txtcmd();
/* quitting */
	if( ret == -1 ) break;
/* successful cmnd */
	if( ret != 0  ) 
           puts("\n Ready for your command {x, k, c, l, v, or q}");
    }
    exit(0);
}

help()
{
static char *h[]=
    {" The first field of a command line is required, but",
     " the second field is optional.  For example, to view",
     " the main classification categories, just type 'l'.",
     " Other commands are:"," ",
     " x,abc  to extract the documentation by name, where",
     "           'abc' is a routine name",
     " k,...  to find routine names by keyword(s), where",
     "           '...' is a keyword or keyphrase",
     " c,xyz  to find routine names by classification category,",
     "           where 'xyz' is a classification category",
     " l,c    to list subcategories of a main category, where",
     "           'c' is a main classification category",
     " v,abc  to view the list of keywords or the classification",
     "           scheme, where 'abc' is K for the keywords or C",
     "           for the classification scheme",
     " q      to quit",NULL};

    char **th;

    th= h;
    while (*th) puts(*(th++));
    puts("\n Ready for your command");
}

view(char c, int e)
{
static char v1[]= "If you wish to view these,";
static char v2[]="     type  'b'          to browse through the list";
static char l[]= "     type  'f'          to have it written on file 'slalis'";
int n;
char buf[BFSZ];

    if( !e )
    {
        puts("\n Input C for classification scheme or K for keywords");
	gets(buf);
	c= buf[0];
    }
    switch(c){
        case 'K':
        case 'k':
	    n= Nkeys;
            printf("Keywords list    %d lines\n",n);
	    puts(v1); puts(v2);
            doc_choice(l);
            rdkeys_choice();
	    break;
        case 'C':
        case 'c':
            printf("Classification list    %d lines\n",Ngams);
	    puts(v1); puts(v2);
            doc_choice(l);
            rdgams_choice();
	    break;
        default:
	    printf(" Invalid command \n");
	    break;
     };
}

rdgams_choice()
{
char buf[BFSZ];
FILE *fp;
void pageg();
char so[2];
char *name;

/* choose reading mode */
    so[0]= 2;
    so[1]= '\0';
    gets(buf);
    switch(buf[0]){
        case 'B':
        case 'b':
	    browse(pageg);
	    break;
        case 'T':
        case 't':
            listcat(so,0,0);
	    break;
        case 'F':
        case 'f':
	    if(buf[1]==',') name= buf+2;
	    else name = "clalis";
	    fp= fopen( name,"a+" );
	    if(!fp) 
		printf("File %s cannot be created\n",name);
	    else
	    {
               listcat(so,0,fp);
	       fclose(fp);
	    }
	    break;
        default:
	    return;
     }
}
 
rdkeys_choice()
{
char buf[BFSZ];
FILE *fp;
void pagek();
int i;
char *name;

/* choose reading mode */
    gets(buf);
    switch(buf[0]){
        case 'B':
        case 'b':
	    browse(pagek);
	    break;
        case 'T':
        case 't':
	    for(i=0; i<Nkeys; i++ ) puts(keys[i]);
	    break;
        case 'F':
        case 'f':
	    if(buf[1]==',') name= buf+2;
	    else name = "slalis";
	    fp= fopen( name,"a+" );
	    if(!fp) 
		printf("File %s cannot be created\n",name);
	    else
	    {
	        for(i=0; i<Nkeys; i++ ) fputs(keys[i],fp);
	        fclose(fp);
	    }
	    break;
        default:
	    return;
     }
}

doc_choice(char *last)
{
  static char *doc[]= {
   "     type  't'          to have it written on your terminal",
   "     type  'f,filename' to have it written on file 'filename'"
   };
 static char brend[]=
 " If you do not wish to view these,\n     type anything else";

   puts(doc[0]);
   puts(doc[1]);
   puts(last);
   puts(brend);
}

seedoc(char *st, int er)
{
 static char *brw[]= {"\n If you wish to see the full documentation,",
   "     type  'b'          to browse through the documentation" };

  char buf[BFSZ], *fxname();
  int e, n, b, j;
  void pager();
  FILE *fp;

    if(!er)
    {
       puts(" Input a routine name for its purpose");
       gets(st);
     }

    if( (e= rtntoi(st))== -1)
    {
 	printf (" Routine name not found");
	return;
    }
    printf("  %s ... %d lines of documentation\n",
     fxname(e),r[e].g.doclines);
  
/*write purpose of routine */
    SEEKRTN( Fp,e )
    n= r[e].c.npurpose;
    b= r[e].c.purpose;
    for( j=0; j< b; j++) fgets(buf,CDLN+8,Fp);
    for( j=0; j< n; j++) {fgets(buf,CDLN+8,Fp);fputs(buf,stdout);}

/* instructions */
     puts(brw[0]); puts(brw[1]);
     sprintf(buf,
	 "     type  'f'       to have it written on file %s\n",st);
     doc_choice(buf);

/* choose reading mode */
    gets(buf);
    switch(buf[0]){
        case 'B':
        case 'b':
	    Ee =e;
	    browse(pager);
	    break;
        case 'T':
        case 't':
	    e= getroutine(Fp,st,'X',(FILE *)0);
	    break;
        case 'F':
        case 'f':
	    fp= fopen( st,"a+" );
	    if(!fp) 
		printf("File %s cannot be created\n",st);
	    else
		e= getroutine(Fp,st,'R',fp);
	    break;
        default:
	    return;
     }
}

browse( void (*page)() )
{

 static char *br2[]= {" The browsing commands are:",
 "     type  'p'            to display the current page", 
 "     type  'pd'           to display the next page",
 "     type  'pd {+-}[n]'   to display the {+-}[n]-th page down",
 "     type  'pu'           to display the preceeding page",
 "     type  'pu {+-}[n]'   to display the {+-}[n]-th page up",
 "     type  'spgsz'        to show the current page size",
 "     type  'spgsz [n]'    to set page size to [n] lines",
 "     type  'hd'           to display one-half page down (forward)",
 "     type  'hu'           to display one-half page up (backward)",
 "     type  'e'            to exit browsing mode",
 "     type  'q'            to quit browsing mode",NULL };

 static char *br3=
 "\n Enter your next browsing command {spgsz p pd pu hd hu e q}";

    char **br;
    char s[BFSZ];

    br= br2;
    while (*br) puts(*(br++));
    puts(br3);
    Currln= 0;
    Pgsz= 21;
    Pgln= -1;
    while(1) { gets(s); if (dobrowse(s,page)) break; }
}

void pager(int ii)
{
    int j,topln;
    char buf[CDLN+9];
    short numln;

    numln= r[Ee].k.srclines + r[Ee].g.doclines;
    topln= Currln + ii;
    if( topln > numln -Pgsz ) topln = numln -Pgsz;

    if( ii != Pgsz || Pgln == -1 )
    {
	SEEKRTN( Fp,Ee )
	Pgln= 0;
    }
    if( ii != Pgsz )
    {
	if( topln <0 ) topln= 0;
        for( j=0; j< topln; j++) 
	{
	    fgets(buf,CDLN+8,Fp);
	    Pgln++;
        }
    }
    for( j=0; j< Pgsz && Pgln < numln ; j++)
    {
       fgets(buf,CDLN+8,Fp);
       fputs(buf,stdout);
       Pgln++;
    }
    Currln= topln;
}

void pageg(int ii)
{
    int i,topln,t;
    char *g;

    topln= Currln + ii;
    if(topln>Ngams-Pgsz) topln= Ngams-Pgsz;
    if(topln<0) topln=0;
    for(t=0,i=topln; t< Pgsz && i< Ngams; i++)
    {
	g= gamlist[i].gam;
        if(mchkcat(g)>0){ t++; putcat(i,1,0);}
    }
    Currln = topln;
}

void pagek(int ii)
{
    int j,topln,end;

    topln= Currln + ii;
    if(topln>Nkeys-Pgsz) topln=Nkeys-Pgsz;
    if(topln<0) topln=0;
    end= Pgsz + topln;
    if( end > Nkeys ) end= Nkeys;
    for( j=topln; j< end; j++) puts(keys[j]);
    Currln= topln;
}

dobrowse( char *s, void (*page)() )
{
    int fd, i,ln ;
    char s2[16];

    fd= 0;
    switch(s[0]){
        case 'H':
        case 'h':
	    if( !strcmp( s,"hu" )) { (*page)(-Pgsz/2);fd= 1; }
	    if( !strcmp( s,"hd" )) { (*page)(Pgsz/2); fd= 1; }
	    if(!fd) goto err;
	    break;
        case 'P':
        case 'p':
	    switch( s[1] )
	    {
		case '\0':
		   (*page)(0); break;
		case 'd':
		case 'D':
		switch( s[2] )
		{
		    case '\0':
			(*page)(Pgsz); break;
		    case ' ':
			i= atoi(s+3); (*page)(i); break;
		    default:
			goto err;
		};
		break;
		case 'u':
		case 'U':
		switch( s[2] )
		{
		    case '\0':
			(*page)(-Pgsz); break;
		    case ' ':
			i= atoi(s+3); (*page)(-i); break;
		    default:
			goto err;
		};
		break;
		default:
		    goto err;
	    }
	    break;
        case 's':
        case 'S':
	    ln= strlen(s);
	    if(ln >15) goto err;
            for(i=0; i< ln+1; i++ ) s2[i]= toupper(s[i]);
	    if( !strcmp( s2,"SPGSZ" ))
	    {
 	       printf("\n The current value of PGSZ is: %d\n", Pgsz);
	       fd= 1;
	    }
	    if( !fd && !strncmp( s2,"SPGSZ",5 ))
	    {
		i= atoi( s2+6 );
/* 9999 arbitrary --biggest routine <2000 anything bigger prob.typo */
		if( i <1 || i > 9999 ) goto err;
		Pgsz= i;
	        printf("\n The new value of PGSZ is: %d\n", Pgsz);
	       fd= 1;
	    }
	    if(!fd) goto err;
	    break;
        case 'E':
        case 'e':
        case 'Q':
        case 'q':
	    return(1);
        default:
	    goto err;
    };
    return(0);
err:
    printf(" Invalid command : %s \n",s);
    return(0);
}

parsecmd( char *c, char *s1 )
{
    char buf[BFSZ];

    bzero( buf,BFSZ);
    gets(buf);

    switch(buf[0]){
      case 'x':
      case 'k':
      case 'c':
      case 'l':
      case 'v':
      case 'q':
      case 'X':
      case 'K':
      case 'C':
      case 'L':
      case 'V':
      case 'Q':
	break;
      default:
       puts(" Invalid Command");
       help();
       return(-1);
     }

/* interpreted as single letter command */
    if( buf[1] != ',' )
    {
	*c= buf[0];
	*s1= '\0';
        return(0);
    }

    sscanf(buf,"%c, %s\n",c,s1);

/* treated like single letter command */
    if( !isalpha(s1[0]) ) return(0);

    return(1);
}

txtcmd()
{
    int e;
    char str[BFSZ], c;

    e= parsecmd( &c, str );
    if( e == -1 ) return(0);
    switch(c){
        case 'C':		/* category */
        case 'c':		/* category */
            getcat_txt(str,e);
	    return(1);
        case 'K':
        case 'k':
            return( getkey_txt(str,e) );
        case 'L':
        case 'l':
	    listcat_txt(str,e);
	    return(1);
        case 'X':
        case 'x':
	    seedoc(str,e);
	    return(1);
        case 'Q':
        case 'q':
	    return(-1);
        case 'v':
	case 'V':
	    view(str[0],e);
	    return(1);
        default:
	    puts(" Impossible point in txtcmd");
	    break;
     }
}

int putinline(int j,int start)
{
      char name[RTNLN+2];
      static short cnt;

      if( start==0 )
      {
	  cnt= 0;
          return(0);
      }

      bzero(name,RTNLN+1);     
      bcopy( r[j].name,name,RTNLN);
      printf("%-8s",name);
      if( cnt++ >4)
      {
	  cnt=0;
	  putchar('\n');
	  return(1);
      }
      return(0);
}

int getkey_txt(char *s, int e)
{
   int ln, hit,i,j,jj,pchr;
   short kk;
   char *s2;
   static char k1[]="This keyword was found in the keyword phrase:";
   static char k2[]=
	 "The routine names associated with the keyword(s) are";

    if(!e)
    {
        puts(" Input keyword(s) for routine names");
	gets(s);
    }
    ln= strlen(s);
    if(!ln)
    {
	puts(" Keyword not found");
	help();
	return(0);
    }
/* convert to upper case */
    s2= calloc(ln+1,1);
    for(i=0; i< ln+1; i++ ) s2[i]= toupper(s[i]);

/* find all phrases it was in and get routines for each */
    for( hit=i=0; i< Nkeys; i++)
    {
	if( strstr(keys[i],s2) ) 
	{
           printf("\n %s\n    %s\n\n %s\n",k1,keys[i],k2);

  /* initialize count in putinline */
	   putinline(0,0);
           for( j=0; j< Nrtn; j++ )
	   {
	       jj= 0;
	       while( (kk= fetcher(r[j].k.n,r[j].k.start,&jj)) != -1)
		  if( kk==i) pchr= putinline( j,1 );
	   }
	   hit= 1;
	   if(!pchr) putchar('\n');
	}
     }
     if( !hit ) puts("\n Keyword not found");
     free(s2);
     return(1);
}

getcat_txt(char *mycat, int e)
{
    int tote,foundgam;
    int putinline();
    char buf[BFSZ];
    char *s;

    if( !e )
    {
       puts("\n Input classification category for routine names");
       gets(buf);
       mycat= buf;
    }
/* init putinline */
    putinline(0,0);

    s= "The routine names classified under the category are";
    tote= getcat( mycat,putinline,s,&foundgam);

    if(!foundgam )
    {
	 puts(" category not found");
	 return;
    }
    if( !tote )
    {
	 puts(" category not in library");
	 return;
    }
}

listcat_txt(char *s, int e)
{
    int ll;

    if (!e) puts(" The major categories are:\n");
  while(1)
  {
    ll= listcat(s,1,0);
    switch(ll){
      case -2:
      case -1:
        printf("\n %s : category does not exist in this library.\n",s);
        return;
      case 0:
        printf("\n There are no subcategories of: %s\n",s);
        return;
      case 1:
/* forces interpretation of any str as 1 letter category */
        puts("\n Input a MAJOR category you wish to explore");
	gets(s);
	if(strlen(s) > 1) s[1]= '\0';
	if( !s[0] ) return;
	break;
      case 2:
        puts("\n Type in the SUBCATEGORY you wish to explore, or <cr>");
	gets(s);
	if( !s[0] ) return;
	break;
     }
  }
}
