/***********************************************************************
 Copyright (C) 1994 by the Regents of the University of Michigan.

 User agrees to reproduce said copyright notice on all copies of the software
 made by the recipient.  

 All Rights Reserved. Permission is hereby granted for the recipient to make
 copies and use this software for its own internal purposes only. Recipient of
 this software may re-distribute this software outside of their own 
 institution. Permission to market this software commercially, to include this
 product as part of a commercial product, or to make a derivative work for
 commercial purposes, is explicitly prohibited.  All other uses are also
 prohibited unless authorized in writing by the Regents of the University of
 Michigan.

 This software is offered without warranty. The Regents of the University of
 Michigan disclaim all warranties, express or implied, including but not
 limited to the implied warranties of merchantability and fitness for any
 particular purpose. In no event shall the Regents of the University of
 Michigan be liable for loss or damage of any kind, including but not limited
 to incidental, indirect, consequential, or special damages. 
***********************************************************************/
#include "sldoc.h"

static short Base[64];

struct routine *r;
unsigned short *Indices;

extern int Ndx, Nrtn, Nkeys, Ngams;
extern struct gams *gamlist;
extern char **keys;
extern int totcalls;

/* fetch indexes from arcane data structure */

int fetcher(int n, int index, int *j)
{
    int i;

/* indicates last call got last index */

    if( *j == -1 ) return(-1);

/* case where 0 or 1 index for entry */
    if( n == 0 )
    {
	if( index == NOENTRY ) return(-1);
	else
	{
	    *j = -1;
	    return(index);
	}
    }

/* fetches indexes from unsigned short array */
/* value of *j determines where we start,usually 0 */
    if( *j < n )
    {
	i= (int)Indices[index + *j];
        (*j)++;
	return(i);
    }
    return(-1);
}

/* copy gams index into gams list */
stashgams( char *p, int j, int *jj ) 
{
    int k;

        rtnerrck( j, jj, MXGAMS);
	for( k=0 ; k< Ngams; k++ )
	   if( !strcmp( gamlist[k].gam,p ) )
	   {
	       Base[(*jj)++]= k;
	       break;
	   }
}

stasher( struct commn *p,int j,int jj)
{
    char *fxname();
    int compar();

    if(jj==0)
    {
	p->n= 0;
	p->start= NOENTRY;
    }
    if(jj==1)
    {
	p->n= 0;
	p->start= Base[0];
    }
    if(jj>1)
    {
	p->n= jj;
	p->start= Ndx;
        qsort(Base, jj, sizeof(short), compar);
        bcopy(Base,Indices+Ndx,sizeof(short)*jj);
	Ndx += jj;
    }
    fprintf(stderr,"stasher: %s %d %d\n",fxname(j),p->n,p->start);
}

char *fxname(int j)
{
    static char b[RTNLN+1];

    bzero(b,RTNLN+1);
    bcopy( r[j].name,b,RTNLN);
    return(b);
}

rtnerrck(int j, int *jj, int limit)
{
    char *buf, *fxname();
	 
    if( *jj >= limit )
    {
	buf= fxname(j);
        fprintf( stderr,"Too many keys gams calls for %s\n",buf);
        exit(1);
     }
}
/* copy phrase index into keyphrase list */
storecalls( char *p,int j, int *jj ) 
{
    int k;
    char *p1, *fxname();
	 
        rtnerrck( j, jj, MXCALL);

	if( !strcmp( "(NONE)",p ) ) return;
     
/* if cannot find called function, eg BLAS in slatec nothing entered */

	for( k= 0; k< Nrtn; k++ )
	{
	   p1= fxname(k);
	   if( !strcmp( p1,p ) )
	   {
	       Base[(*jj)++]= k;
	       totcalls++;
	       break;
	   }
	}
}

clrstore(short *p,int n)
{
    int k;
    for(k=0;k<n;k++) p[k]= Base[k]= -1;
}

/* copy phrase index into keyphrase list */
storekey( char *p,int j, int *jj ) 
{
    int k;
	 
        rtnerrck( j, jj, MXKEY);

	for( k= 0; k< Nkeys; k++ )
	   if( !strcmp( keys[k],p ) )
	   {
	       Base[(*jj)++]= k;
	       break;
	   }
}

int ncompar(short *s1,short *s2)
{
    return(strncmp(r[*s1].name, r[*s2].name,RTNLN));
}
