/***********************************************************************
 Copyright (C) 1994 by the Regents of the University of Michigan.

 User agrees to reproduce said copyright notice on all copies of the software
 made by the recipient.  

 All Rights Reserved. Permission is hereby granted for the recipient to make
 copies and use this software for its own internal purposes only. Recipient of
 this software may re-distribute this software outside of their own 
 institution. Permission to market this software commercially, to include this
 product as part of a commercial product, or to make a derivative work for
 commercial purposes, is explicitly prohibited.  All other uses are also
 prohibited unless authorized in writing by the Regents of the University of
 Michigan.

 This software is offered without warranty. The Regents of the University of
 Michigan disclaim all warranties, express or implied, including but not
 limited to the implied warranties of merchantability and fitness for any
 particular purpose. In no event shall the Regents of the University of
 Michigan be liable for loss or damage of any kind, including but not limited
 to incidental, indirect, consequential, or special damages. 
***********************************************************************/

/* PROGRAM to build files for sltc doc retrieval */
/* data structs for slatec documentation */

#include "sldoc.h"

char **keys;
struct gams *gamlist;

extern struct routine *r;
extern unsigned short *Indices;

int totcalls =0;
int Ndx= 0, Nrtn, Nkeys, Ngams;

/* strings found in SLATEC prologue */

static char kyend[]="C***";
static char begin[]="*DECK";
static char prbegin[]= "C***BEGIN PROLOGUE";
static char purpose[]= "C***PURPOSE";
static char library[]= "C***LIBRARY";
static char category[]="C***CATEGORY";
static char kywrd[]="C***KEYWORDS";
static char author[]=  "C***AUTHOR";
static char type[]=    "C***TYPE";
static char called[]="C***ROUTINES CALLED";
static char prend[]="C***END PROLOGUE";

main(int argc, char **argv)
{
    int scompar();
    char **rdphrases();
    unsigned short *indices;
    void stowkey(), stowgam();

/* if o[ption] set output every keyphrase found only -- use
   with sort -A and uniq to generate keyword list
*/
    if(argc>1)
    {
        if(argv[1][0]=='S')
	{
	    fdkeys(DAF);
            exit(0);
	}

        if(argv[1][0]=='L')
	{
	    Indices= calloc( 32*1024, sizeof(short));
	    Nrtn= rd_binfl(RTBL,&r,sizeof(struct routine));
	    Ndx= rd_binfl(NDX,&indices,sizeof(short));
	    bcopy(indices,Indices,Ndx *sizeof(short));
	    free(indices);
	    getcalls(DAF);
	    wr_binfl(Nrtn,r,RTBL,sizeof(struct routine));
	    wr_binfl(Ndx,Indices,NDX,sizeof(short));
	    printf("CALLS=%d\n",totcalls);
            exit(0);
	}
    }
    else
    {
	 Indices= calloc( 32*1024, sizeof(short));
         r= calloc( NRTN, sizeof(struct routine));
	 keys= rdphrases(KYWDS,"keys",sizeof(char *),stowkey,&Nkeys);
	 gamlist= (struct gams *)rdphrases(GAMS,"gams",
			  sizeof(struct gams),stowgam,&Ngams);
	 Nrtn= rddoc(DAF);
/* sort routines alphabetically */
         qsort( r, Nrtn, sizeof(struct routine), scompar);
	 wr_binfl(Nrtn,r,RTBL,sizeof(struct routine));
	 wr_binfl(Ndx,Indices,NDX,sizeof(short));
         exit(0);
    }
}

rddoc(char *f)
{

/* caution must be greater than 80 cols ! */
    char card[CDLN+9];
    FILE *fp;
    int i,j,jj,rdon,hit,g,start;
    int nbytes, total;
    int storekey(), stashgams();

    fp= fopen( f,"r");
    bzero( card,CDLN+9);
    rdon= hit= total= start=0;
    for(j= -1,i=0; fgets(card,CDLN+8,fp) ;i++)
    {
	nbytes=strlen(card);
	if( card[nbytes-1]=='\n' ) card[nbytes-1]='\0';
/* first line */
	if( !strncmp(begin,card,DCKLN) )
	{
	    if(j >-1) r[j].k.srclines= i -start -r[j].g.doclines;
	    start= i;
	    r[++j].a.rstart= total;
	    r[j].c.type= 0;
	    r[j].g.start= NOENTRY;
	    r[j].k.start= NOENTRY;
	    bcopy( card+DCKLN+1, r[j].name, RTNLN );
	    jj=0;
	}
/* get purpose for routine */
/* assumes purpose within 15 lines of top of routine */
	if( !strncmp(purpose,card,KYLN-1) )
	{
	    r[j].c.purpose = i-start;
	}
/* detect line after purpose line */
/* shoves no. of purpose lines in top 4 bits */
	if( !strncmp(library,card,KYLN-1))
	{
	    r[j].c.npurpose = i- start- r[j].c.purpose;
	}
/* get category index */
	if( !strncmp(category,card,KYLN) )
	{
	    g=0;
 	    rdstuff(card,KYLN,j,&g,stashgams);
            stasher( &r[j].g, j,g);
	}
/* get keyword indices */
	if( !strncmp(kywrd,card,KYLN) ) rdon= hit= 1;

/* detect line after last keyword line */
	if(rdon)
	{
	    if( !hit && !strncmp(author,card,KYLN-2))
	    {
		stasher(&r[j].k,j,jj);
	        rdon= 0;
	    }
	    else rdstuff( card,KYLN,j,&jj,storekey );
	    hit= 0;
	}
/* last line in prologue */
	if( !strncmp(prend,card,ENDLN) )
	{
	    r[j].g.doclines = i - start +1;
	}
	if( card[0]=='#') r[j].c.type= 1;
	total += nbytes;
    }
    r[j].k.srclines = i- start -1 -r[j].g.doclines +1;
    fclose(fp);
    return(j+1);
}

int rdstuff( char *card,int n,int j,int *jj, int (*store)() )
{
    char *p, *pend;
    int m;

/* read in keywords */
    p= card + n +1;
    while ( *p == ' ') p++;	
    while( isupper(p[0]) || isdigit(p[0]))
    {
	pend = strchr(p,',');
/* find end of keyword phrase */
	if(pend) *pend='\0';
	else
	{
	    m=strlen(p);
/* zap any trailing blabks */
	    while( p[--m] == ' ' ) ;
	    p[m+1]='\0';
	 }
	 (*store)(p,j,jj);
	 if(!pend) return;
         p= ++pend;
/* skip initial blanks */
	 while( p[0]==' ') p++;
     }
}

fdkeys(char *f)
{

    char card[CDLN+9];
    FILE *fp;
    int i,j,jj,rdon,hit,n;
    int prkey();

    fp= fopen( f,"r");
    bzero( card,CDLN+9);
    rdon= hit= 0;
    for(j= -1, i=0; fgets(card,CDLN+8,fp) ;i++)
    {
	n=strlen(card);
	if( card[n-1]=='\n' ) card[n-1]='\0';
	if( !strncmp(begin,card,DCKLN) ) ++j;
/* get keyword indices */
	if( !strncmp(kywrd,card,KYLN) ) {rdon=1;hit=1;}

/* detect line after last keyword line */
	if(rdon)
	{
	    if( !hit && !strncmp(kyend,card,KELN)) rdon= 0;
	    else rdstuff( card,KYLN,j,&jj,prkey );
	    hit= 0;
	}
    }
    fclose(fp);
}

prkey( char *p, int j, int *jj )
{
    printf("%s\n",p);
}

getcalls(char *f)
{
    char card[CDLN+9];
    FILE *fp;
    int i,j,jj,rdon,hit,n;
    int storecalls();

    fp= fopen( f,"r");
    bzero( card,CDLN+9);
    rdon= hit= 0;
    for(j=0; j<Nrtn ;j++)
    {
      SEEKRTN(fp,j)
      for(i=0; i< (int)(r[j].g.doclines) ;i++)
      {
        fgets(card,CDLN+8,fp) ;
	n=strlen(card);
	if( card[n-1]=='\n' ) card[n-1]='\0';
/* first line */
	if( !strncmp(begin,card,DCKLN) )
	{
	    jj=0;
	    r[j].c.start= NOENTRY;
	}
/* get routines called indices */
	if( !strncmp(called,card,CALLN) ) {rdon=1;hit=1;}

/* detect line after last called line */
	if(rdon)
	{
	    if( !hit && !strncmp(kyend,card,KELN))
	    {
		stasher(&r[j].c,j,jj);
	        rdon= 0;
		break;
	    }
	    else rdstuff( card,CALLN,j,&jj,storecalls );
	    hit= 0;
	}
      }
    }
    fclose(fp);
}
