      PROGRAM PSBLA2TIM
*
*  -- PBLAS testing driver (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*  Purpose
*  ========
*
*  PSBLA2TIM is the main timer program for the REAL
*  PBLAS Level 2 routines.
*
*  The program must be driven by a short data file.  An annotated
*  example of a data file can be obtained by deleting the first 3
*  characters from the following 48 lines:
*  'ScaLAPACK, Version 2.0, Level 2 PBLAS timer input file'
*  'Intel iPSC/860 hypercube, gamma model.'
*  'PSBLATIM2.SUMM'   output file name (if any)
*  6       device out
*  1               number of process grids (ordered pairs of P & Q)
*  2 2 1 4 2 3 8   values of P
*  2 2 4 1 3 2 1   values of Q
*  1.0E0           value of ALPHA
*  1.0E0           value of BETA
*  2               number of tests problems
*  'U' 'L'         values of UPLO
*  'N' 'T'         values of TRANS
*  'N' 'U'         values of DIAG
*  3  4            values of M
*  3  4            values of N
*  6 10            values of M_A
*  6 10            values of N_A
*  2  5            values of MB_A
*  2  5            values of NB_A
*  0  1            values of RSRC_A
*  0  0            values of CSRC_A
*  1  1            values of IA
*  1  1            values of JA
*  6 10            values of M_X
*  6 10            values of N_X
*  2  5            values of MB_X
*  2  5            values of NB_X
*  0  1            values of RSRC_X
*  0  0            values of CSRC_X
*  1  1            values of IX
*  1  1            values of JX
*  1  1            values of INCX
*  6 10            values of M_Y
*  6 10            values of N_Y
*  2  5            values of MB_Y
*  2  5            values of NB_Y
*  0  1            values of RSRC_Y
*  0  0            values of CSRC_Y
*  1  1            values of IY
*  1  1            values of JY
*  6  1            values of INCY
*  PSGEMV  T  put F for no test in the same column
*  PSSYMV  T  put F for no test in the same column
*  PSTRMV  T  put F for no test in the same column
*  PSTRSV  T  put F for no test in the same column
*  PSGER   T  put F for no test in the same column
*  PSSYR   T  put F for no test in the same column
*  PSSYR2  T  put F for no test in the same column
*
*  Internal Parameters
*  ===================
*
*  TOTMEM   INTEGER, default = 2000000
*           TOTMEM is a machine-specific parameter indicating the
*           maximum amount of available memory in bytes.
*           The user should customize TOTMEM to his platform.  Remember
*           to leave room in memory for the operating system, the BLACS
*           buffer, etc.  For example, on a system with 8 MB of memory
*           per process (e.g., one processor on an Intel iPSC/860), the
*           parameters we use are TOTMEM=6200000 (leaving 1.8 MB for OS,
*           code, BLACS buffer, etc).  However, for PVM, we usually set
*           TOTMEM = 2000000.  Some experimenting with the maximum value
*           of TOTMEM may be required.
*
*  INTGSZ   INTEGER, default = 4 bytes.
*  REALSZ   INTEGER, default = 4 bytes.
*           INTGSZ and REALSZ indicate the length in bytes on the
*           given platform for an integer and a single precision real.
*  MEM      REAL array, dimension ( TOTMEM / REALSZ )
*
*           All arrays used by SCALAPACK routines are allocated from
*           this array and referenced by pointers.  The integer IPA,
*           for example, is a pointer to the starting element of MEM for
*           the matrix A.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            MAXTESTS, MAXGRIDS, REALSZ, TOTMEM, MEMSIZ,
     $                   NSUBS
      PARAMETER          ( MAXTESTS = 20, MAXGRIDS = 20, REALSZ = 8,
     $                     TOTMEM = 2000000, NSUBS = 7,
     $                     MEMSIZ = TOTMEM / REALSZ )
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
*     ..
*     .. Local Scalars ..
      CHARACTER*1        AFORM, DIAG, TRANS, UPLO
      INTEGER            CSRCA, CSRCX, CSRCY, I, IAM, ICTXT, INCX,
     $                   INCY, IMIDPADA, IMIDPADX, IMIDPADY, IPREPADA,
     $                   IPREPADX, IPREPADY, IPOSTPADA, IPOSTPADX,
     $                   IPOSTPADY, IA, IASEED, IPA, IPX, IPY, IX,
     $                   IXSEED, IY, IYSEED, J, JA, JX, JY, K, M, MA,
     $                   MBA, MBX, MBY, MEMREQD, MPA, MPX, MPY, MX, MY,
     $                   MYCOL, MYROW, N, NA, NBA, NBX, NBY, NCOLA,
     $                   NGRIDS, NLX, NLY, NOUT, NPCOL, NPROCS, NPROW,
     $                   NQA, NQX, NQY, NROWA, NTESTS, NX, NY, RSRCA,
     $                   RSRCX, RSRCY
      REAL               ALPHA, BETA
      DOUBLE PRECISION   CFLOPS, NOPS, WFLOPS
*     ..
*     .. Local Arrays ..
      LOGICAL            LTEST( NSUBS ), YCHECK( NSUBS )
      CHARACTER*1        DIAGVAL( MAXTESTS ), TRANSVAL( MAXTESTS ),
     $                   UPLOVAL( MAXTESTS )
      CHARACTER*80       OUTFILE
      INTEGER            CSRCAVAL( MAXTESTS ), CSRCXVAL( MAXTESTS ),
     $                   CSRCYVAL( MAXTESTS ), DESCA( DLEN_ ),
     $                   DESCX( DLEN_ ), DESCY( DLEN_ ), IERR( 3 ),
     $                   INCXVAL( MAXTESTS ), INCYVAL( MAXTESTS ),
     $                   IAVAL( MAXTESTS ), IXVAL( MAXTESTS ),
     $                   IYVAL( MAXTESTS ), JAVAL( MAXTESTS ),
     $                   JXVAL( MAXTESTS ), JYVAL( MAXTESTS ),
     $                   MVAL( MAXTESTS ), MAVAL( MAXTESTS ),
     $                   MBAVAL( MAXTESTS ), MBXVAL( MAXTESTS ),
     $                   MBYVAL( MAXTESTS ), MXVAL( MAXTESTS ),
     $                   MYVAL( MAXTESTS ), NBAVAL( MAXTESTS ),
     $                   NBXVAL( MAXTESTS ), NBYVAL( MAXTESTS ),
     $                   NVAL( MAXTESTS ), NAVAL( MAXTESTS ),
     $                   NXVAL( MAXTESTS ), NYVAL( MAXTESTS ),
     $                   PVAL( MAXTESTS ), QVAL( MAXTESTS ),
     $                   RSRCAVAL( MAXTESTS ), RSRCXVAL( MAXTESTS ),
     $                   RSRCYVAL( MAXTESTS )
      REAL               MEM( MEMSIZ )
      DOUBLE PRECISION   CTIME( 1 ), WTIME( 1 )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_EXIT, BLACS_GET, BLACS_GRIDEXIT,
     $                   BLACS_GRIDINFO, BLACS_GRIDINIT, BLACS_PINFO,
     $                   BLACS_BARRIER, IGSUM2D, PBSMATGEN,
     $                   PSBLA2TIMINFO, MDESCCHK, VDESCCHK,
     $                   VDIMCHK, MDIMCHK, SLBOOT, SLCOMBINE, SLTIMER,
     $                   PSGEMV, PSSYMV, PSTRMV, PSTRSV,
     $                   PSGER, PSSYR, PSSYR2
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      DOUBLE PRECISION   PDOPBL2
      EXTERNAL           LSAME, PDOPBL2
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE
*     ..
*     .. Scalars in Common ..
      CHARACTER*7        SNAMES( NSUBS )
      LOGICAL            ABRTFLG
      INTEGER            INFO
*     ..
*     .. Common blocks ..
      COMMON             /SNAMEC/SNAMES
      COMMON             /INFOC/INFO
      COMMON             /PBERRORC/NOUT, ABRTFLG
*     ..
*     .. Data Statements ..
      DATA               SNAMES/'PSGEMV', 'PSSYMV', 'PSTRMV',
     $                   'PSTRSV', 'PSGER ', 'PSSYR',
     $                   'PSSYR2'/
      DATA               YCHECK/.TRUE., .TRUE., .FALSE., .FALSE.,
     $                   .TRUE., .FALSE., .TRUE./
*     ..
*     .. Executable Statements ..
*
*     Initialization
*
*     Set flag so that PBERROR won't abort on errors, so that the tester
*     will detect unsupported operations.
*
      ABRTFLG = .TRUE.
*
*     Seeds for random matrix generations.
*
      IASEED = 100
      IXSEED = 200
      IYSEED = 300
*
*     Get starting information
*
      CALL BLACS_PINFO( IAM, NPROCS )
      CALL PSBLA2TIMINFO( OUTFILE, NOUT, NTESTS, DIAGVAL, TRANSVAL,
     $                    UPLOVAL, MVAL, NVAL, MAVAL, NAVAL, MBAVAL,
     $                    NBAVAL, RSRCAVAL, CSRCAVAL, IAVAL, JAVAL,
     $                    MXVAL, NXVAL, MBXVAL, NBXVAL, RSRCXVAL,
     $                    CSRCXVAL, IXVAL, JXVAL, INCXVAL, MYVAL,
     $                    NYVAL, MBYVAL, NBYVAL, RSRCYVAL, CSRCYVAL,
     $                    IYVAL, JYVAL, INCYVAL, MAXTESTS, NGRIDS, PVAL,
     $                    MAXGRIDS, QVAL, MAXGRIDS, LTEST, IAM, NPROCS,
     $                    ALPHA, BETA, MEM )
*
      IF( IAM.EQ.0 )
     $   WRITE( NOUT, FMT = 9983 )
*
*     Loop over different process grids
*
      DO 60 I = 1, NGRIDS
*
         NPROW = PVAL( I )
         NPCOL = QVAL( I )
*
*        Make sure grid information is correct
*
         IERR( 1 ) = 0
         IF( NPROW.LT.1 ) THEN
            IF( IAM.EQ.0 )
     $         WRITE( NOUT, FMT = 9999 ) 'GRID SIZE', 'NPROW', NPROW
            IERR( 1 ) = 1
         ELSE IF( NPCOL.LT.1 ) THEN
            IF( IAM.EQ.0 )
     $         WRITE( NOUT, FMT = 9999 ) 'GRID SIZE', 'NPCOL', NPCOL
            IERR( 1 ) = 1
         ELSE IF( NPROW*NPCOL.GT.NPROCS ) THEN
            IF( IAM.EQ.0 )
     $         WRITE( NOUT, FMT = 9998 ) NPROW*NPCOL, NPROCS
            IERR( 1 ) = 1
         END IF
*
         IF( IERR( 1 ).GT.0 ) THEN
            IF( IAM.EQ.0 )
     $         WRITE( NOUT, FMT = 9997 ) 'GRID'
            GO TO 60
         END IF
*
*        Define process grid
*
         CALL BLACS_GET( -1, 0, ICTXT )
         CALL BLACS_GRIDINIT( ICTXT, 'Row-major', NPROW, NPCOL )
         CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*        Go to bottom of process grid loop if this case doesn't use my
*        process
*
         IF( MYROW.GE.NPROW .OR. MYCOL.GE.NPCOL )
     $      GO TO 60
*
*        Loop over number of tests
*
         DO 50 J = 1, NTESTS
*
*           Get the test parameters
*
            DIAG  = DIAGVAL( J )
            TRANS = TRANSVAL( J )
            UPLO  = UPLOVAL( J )
*
            M     = MVAL( J )
            N     = NVAL( J )
*
            MA    = MAVAL( J )
            NA    = NAVAL( J )
            MBA   = MBAVAL( J )
            NBA   = NBAVAL( J )
            RSRCA = RSRCAVAL( J )
            CSRCA = CSRCAVAL( J )
            IA    = IAVAL( J )
            JA    = JAVAL( J )
*
            MX    = MXVAL( J )
            NX    = NXVAL( J )
            MBX   = MBXVAL( J )
            NBX   = NBXVAL( J )
            RSRCX = RSRCXVAL( J )
            CSRCX = CSRCXVAL( J )
            IX    = IXVAL( J )
            JX    = JXVAL( J )
            INCX  = INCXVAL( J )
*
            MY    = MYVAL( J )
            NY    = NYVAL( J )
            MBY   = MBYVAL( J )
            NBY   = NBYVAL( J )
            RSRCY = RSRCYVAL( J )
            CSRCY = CSRCYVAL( J )
            IY    = IYVAL( J )
            JY    = JYVAL( J )
            INCY  = INCYVAL( J )
*
            IF( IAM.EQ.0 ) THEN
*
               WRITE( NOUT, FMT = * )
               WRITE( NOUT, FMT = 9996 ) J, NPROW, NPCOL
               WRITE( NOUT, FMT = * )
*
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9994 )
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9993 ) M, N, UPLO, TRANS, DIAG
*
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9992 )
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9991 ) IA, JA, MA, NA, MBA, NBA,
     $                                   RSRCA, CSRCA
*
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9990 )
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9989 ) IX, JX, MX, NX, MBX, NBX,
     $                                   RSRCX, CSRCX, INCX
*
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9988 )
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9989 ) IY, JY, MY, NY, MBY, NBY,
     $                                   RSRCY, CSRCY, INCY
*
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9980 )
*
            END IF
*
*           Check the validity of the input test parameters
*
            IF( .NOT.LSAME( UPLO, 'U' ).AND.
     $          .NOT.LSAME( UPLO, 'L' ) ) THEN
               IF( IAM.EQ.0 )
     $            WRITE( NOUT, FMT = 9997 ) 'UPLO'
               GO TO 40
            END IF
*
            IF( .NOT.LSAME( TRANS, 'N' ).AND.
     $          .NOT.LSAME( TRANS, 'T' ).AND.
     $          .NOT.LSAME( TRANS, 'C' ) ) THEN
               IF( IAM.EQ.0 )
     $            WRITE( NOUT, FMT = 9997 ) 'TRANS'
               GO TO 40
            END IF
*
            IF( .NOT.LSAME( DIAG , 'U' ).AND.
     $         .NOT.LSAME( DIAG , 'N' ) )THEN
               IF( IAM.EQ.0 )
     $            WRITE( NOUT, FMT = 9997 ) TRANS
               WRITE( NOUT, FMT = 9997 ) 'DIAG'
               GO TO 40
            END IF
*
*           Check and initialize the matrix descriptors
*
            CALL MDESCCHK( ICTXT, NOUT, 'A', DESCA, MA, NA, MBA, NBA,
     $                     RSRCA, CSRCA, MPA, NQA, IPREPADA, IMIDPADA,
     $                     IPOSTPADA, 0, 0, IERR( 1 ) )
            CALL VDESCCHK( ICTXT, NOUT, 'X', DESCX, MX, NX, MBX, NBX,
     $                     RSRCX, CSRCX, INCX, MPX, NQX, IPREPADX,
     $                     IMIDPADX, IPOSTPADX, 0, 0, IERR( 2 ) )
            CALL VDESCCHK( ICTXT, NOUT, 'Y', DESCY, MY, NY, MBY, NBY,
     $                     RSRCY, CSRCY, INCY, MPY, NQY, IPREPADY,
     $                     IMIDPADY, IPOSTPADY, 0, 0, IERR( 3 ) )
*
            IF( IERR( 1 ).GT.0 .OR. IERR( 2 ).GT.0 .OR.
     $          IERR( 3 ).GT.0 ) THEN
               GO TO 40
            END IF
*
*           Assign pointers into MEM for matrices corresponding to
*           the distributed matrices A, X and Y.
*
            IPA = 1
            IPX = IPA + DESCA( LLD_ )*NQA
            IPY = IPX + DESCX( LLD_ )*NQX
*
*           Check if sufficient memory.
*
            MEMREQD = IPY + DESCY( LLD_ )*NQY - 1
            IERR( 1 ) = 0
            IF( MEMREQD.GT.MEMSIZ ) THEN
               IF( IAM.EQ.0 )
     $            WRITE( NOUT, FMT = 9986 ) MEMREQD*REALSZ
               IERR( 1 ) = 1
            END IF
*
*           Check all processes for an error
*
            CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, 0 )
*
            IF( IERR( 1 ).GT.0 ) THEN
               IF( IAM.EQ.0 )
     $            WRITE( NOUT, FMT = 9987 )
               GO TO 40
            END IF
*
*           Loop over all PBLAS 2 routines
*
            DO 30 K = 1, NSUBS
*
*              Continue only if this subroutine has to be tested.
*
               IF( .NOT.LTEST( K ) )
     $            GO TO 30
*
*              Define the size of the operands
*
               IF( K.EQ.1 ) THEN
                  NROWA = M
                  NCOLA = N
                  IF( LSAME( TRANS, 'N' ) ) THEN
                     NLX = N
                     NLY = M
                  ELSE
                     NLX = M
                     NLY = N
                  END IF
               ELSE IF( K.EQ.5 ) THEN
                  NROWA = M
                  NCOLA = N
                  NLX = M
                  NLY = N
               ELSE
                  NROWA = N
                  NCOLA = N
                  NLX = N
                  NLY = N
               END IF
*
*              Check the validity of the operand sizes
*
               CALL MDIMCHK( ICTXT, NOUT, NROWA, NCOLA, 'A', IA, JA,
     $                       DESCA, IERR( 1 ) )
               CALL VDIMCHK( ICTXT, NOUT, NLX, 'X', IX, JX, DESCX,
     $                       INCX, IERR( 2 ) )
               CALL VDIMCHK( ICTXT, NOUT, NLY, 'Y', IY, JY, DESCY,
     $                       INCY, IERR( 3 ) )
*
               IF( IERR( 1 ).NE.0 .OR. IERR( 2 ).NE.0 .OR.
     $             IERR( 3 ).NE.0 ) THEN
                  GO TO 30
               END IF
*
*              Generate distributed matrices A, X and Y
*
               IF( K.EQ.2 .OR. K.EQ.6 .OR. K.EQ.7 ) THEN
                  AFORM = 'S'
               ELSE
                  AFORM = 'N'
               END IF
*
*              Avoid weakness of Matrix generator
*
               IF( LSAME( AFORM, 'S' ) .OR. LSAME( AFORM, 'H' ) ) THEN
                  IF( DESCA( M_ ).NE.DESCA( N_ ) .OR. IA.NE.JA ) THEN
                     IF( IAM.EQ.0 )
     $                  WRITE( NOUT, FMT = 9979 )
                     GO TO 30
                  END IF
               END IF
*
               CALL PBSMATGEN( ICTXT, AFORM, 'No diag', DESCA( M_ ),
     $                         DESCA( N_ ), DESCA( MB_ ), DESCA( NB_ ),
     $                         MEM( IPA ), DESCA( LLD_ ),
     $                         DESCA( RSRC_ ), DESCA( CSRC_ ), IASEED,
     $                         0, MPA, 0, NQA, MYROW, MYCOL, NPROW,
     $                         NPCOL )
*
               CALL PBSMATGEN( ICTXT, 'None', 'No diag', DESCX( M_ ),
     $                         DESCX( N_ ), DESCX( MB_ ), DESCX( NB_ ),
     $                         MEM( IPX ), DESCX( LLD_ ),
     $                         DESCX( RSRC_ ), DESCX( CSRC_ ), IXSEED,
     $                         0, MPX, 0, NQX, MYROW, MYCOL, NPROW,
     $                         NPCOL )
*
               IF( YCHECK( K ) ) THEN
                  CALL PBSMATGEN( ICTXT, 'None', 'No diag', DESCY( M_ ),
     $                            DESCY( N_ ), DESCY( MB_ ),
     $                            DESCY( NB_ ), MEM( IPY ),
     $                            DESCY( LLD_ ), DESCY( RSRC_ ),
     $                            DESCY( CSRC_ ), IYSEED, 0, MPY, 0,
     $                            NQY, MYROW, MYCOL, NPROW, NPCOL )
               END IF
*
               INFO = 0
               CALL SLBOOT()
               CALL BLACS_BARRIER( ICTXT, 'All' )
*
*              Call the Level 2 PBLAS routine
*
               IF( K.EQ.1 ) THEN
*
*                 Test PSGEMV
*
                  CALL SLTIMER( 1 )
                  CALL PSGEMV( TRANS, M, N, ALPHA, MEM( IPA ), IA, JA,
     $                         DESCA, MEM( IPX ), IX, JX, DESCX, INCX,
     $                         BETA, MEM( IPY ), IY, JY, DESCY, INCY )
                  CALL SLTIMER( 1 )
*
               ELSE IF( K.EQ.2 ) THEN
*
*                 Test PSSYMV
*
                  CALL SLTIMER( 1 )
                  CALL PSSYMV( UPLO, N, ALPHA, MEM( IPA ), IA, JA,
     $                         DESCA, MEM( IPX ), IX, JX, DESCX, INCX,
     $                         BETA, MEM( IPY ), IY, JY, DESCY, INCY )
                  CALL SLTIMER( 1 )
*
               ELSE IF( K.EQ.3 ) THEN
*
*                 Test PSTRMV
*
                  CALL SLTIMER( 1 )
                  CALL PSTRMV( UPLO, TRANS, DIAG, N, MEM( IPA ), IA, JA,
     $                         DESCA, MEM( IPX ), IX, JX, DESCX, INCX )
                  CALL SLTIMER( 1 )
*
               ELSE IF( K.EQ.4 ) THEN
*
*                 Test PSTRSV
*
                  CALL SLTIMER( 1 )
                  CALL PSTRSV( UPLO, TRANS, DIAG, N, MEM( IPA ), IA, JA,
     $                         DESCA, MEM( IPX ), IX, JX, DESCX, INCX )
                  CALL SLTIMER( 1 )
*
               ELSE IF( K.EQ.5 ) THEN
*
*                 Test PSGER
*
                  CALL SLTIMER( 1 )
                  CALL PSGER( M, N, ALPHA, MEM( IPX ), IX, JX, DESCX,
     $                        INCX, MEM( IPY ), IY, JY, DESCY, INCY,
     $                        MEM( IPA ), IA, JA, DESCA )
                  CALL SLTIMER( 1 )
*
               ELSE IF( K.EQ.6 ) THEN
*
*                 Test PSSYR
*
                  CALL SLTIMER( 1 )
                  CALL PSSYR( UPLO, N, ALPHA, MEM( IPX ), IX, JX, DESCX,
     $                         INCX, MEM( IPA ), IA, JA, DESCA )
                  CALL SLTIMER( 1 )
*
               ELSE IF( K.EQ.7 ) THEN
*
*                 Test PSSYR2
*
                  CALL SLTIMER( 1 )
                  CALL PSSYR2( UPLO, N, ALPHA, MEM( IPX ), IX, JX,
     $                         DESCX, INCX, MEM( IPY ), IY, JY, DESCY,
     $                         INCY, MEM( IPA ), IA, JA, DESCA )
                  CALL SLTIMER( 1 )
*
               END IF
*
*              Check if the operation has been performed.
*
               IF( INFO.NE.0 ) THEN
                  IF( IAM.EQ.0 )
     $               WRITE( NOUT, FMT = 9982 ) INFO
                  GO TO 30
               END IF
*
               CALL SLCOMBINE( ICTXT, 'All', '>', 'W', 1, 1, WTIME )
               CALL SLCOMBINE( ICTXT, 'All', '>', 'C', 1, 1, CTIME )
*
*              Only node 0 prints timing test result
*
               IF( IAM.EQ.0 ) THEN
*
*                 Calculate total flops
*
                  NOPS = PDOPBL2( SNAMES( K ), NROWA, NCOLA, 0, 0 )
*
*                 Print WALL time if machine supports it
*
                  IF( WTIME( 1 ).GT.0.0D+0 ) THEN
                     WFLOPS = NOPS / ( WTIME( 1 ) * 1.0D+6 )
                  ELSE
                     WFLOPS = 0.0D+0
                  END IF
*
*                 Print CPU time if machine supports it
*
                  IF( CTIME( 1 ).GT.0.0D+0 ) THEN
                     CFLOPS = NOPS / ( CTIME( 1 ) * 1.0D+6 )
                  ELSE
                     CFLOPS = 0.0D+0
                  END IF
*
                  WRITE( NOUT, FMT = 9981 ) SNAMES( K ), WTIME( 1 ),
     $                                      WFLOPS, CTIME( 1 ), CFLOPS
*
               END IF
*
   30       CONTINUE
*
   40       IF( IAM.EQ.0 ) THEN
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = * )
               WRITE( NOUT, FMT = 9985 ) J
            END IF
*
   50   CONTINUE
*
        CALL BLACS_GRIDEXIT( ICTXT )
*
   60 CONTINUE
*
*     Print results
*
      IF( IAM.EQ.0 ) THEN
         WRITE( NOUT, FMT = * )
         WRITE( NOUT, FMT = 9984 )
         WRITE( NOUT, FMT = * )
      END IF
*
      CALL BLACS_EXIT( 0 )
*
 9999 FORMAT( 'ILLEGAL ', A, ': ', A, ' = ', I10,
     $        ' should be at least 1' )
 9998 FORMAT( 'ILLEGAL GRID: NPROW*NPCOL = ', I4,
     $        '. It can be at most', I4 )
 9997 FORMAT( 'Bad ', A, ' parameters: going on to next test case.' )
 9996 FORMAT( 2X, 'Test number ', I2 , ' started on a ', I4, ' x ',
     $        I4, ' process grid.' )
 9995 FORMAT( 2X, '   ------------------------------------------------',
     $        '-------------------' )
 9994 FORMAT( 2X, '        M      N       UPLO       TRANS       DIAG' )
 9993 FORMAT( 5X,I6,1X,I6,9X,A1,11X,A1,10X,A1 )
 9992 FORMAT( 2X, '       IA     JA     MA     NA    MBA    NBA',
     $        ' RSRCA CSRCA' )
 9991 FORMAT( 5X,I6,1X,I6,1X,I6,1X,I6,1X,I6,1X,I6,1X,I5,1X,I5 )
 9990 FORMAT( 2X, '       IX     JX     MX     NX    MBX    NBX',
     $        ' RSRCX CSRCX   INCX' )
 9989 FORMAT( 5X,I6,1X,I6,1X,I6,1X,I6,1X,I6,1X,I6,1X,I5,1X,I5,1X,I6 )
 9988 FORMAT( 2X, '       IY     JY     MY     NY    MBY    NBY',
     $        ' RSRCY CSRCY   INCY' )
 9987 FORMAT( 'Not enough memory for this test: going on to',
     $        ' next test case.' )
 9986 FORMAT( 'Not enough memory. Need: ', I12 )
 9985 FORMAT( 2X, 'Test number ', I2, ' completed.' )
 9984 FORMAT( 2X, 'End of Tests.' )
 9983 FORMAT( 2X, 'Tests started.' )
 9982 FORMAT( 2X, '   ***** Operation not supported, error code: ',
     $        I5, ' *****' )
 9981 FORMAT( 2X, '   ', A, 2X, F13.3, 2X, F13.3, 2X, F13.3, 2X, F13.3 )
 9980 FORMAT( 2X, '            WALL time (s)    WALL Mflops ',
     $        '  CPU time (s)     CPU Mflops' )
 9979 FORMAT( 2X, '   ***** Test not supported yet: SKIPPED *****' )
*
      STOP
*
*     End of PSBLA2TIM
*
      END
      SUBROUTINE PSBLA2TIMINFO( SUMMRY, NOUT, NMAT, DIAGVAL, TRANSVAL,
     $                          UPLOVAL, MVAL, NVAL, MAVAL, NAVAL,
     $                          MBAVAL, NBAVAL, RSRCAVAL, CSRCAVAL,
     $                          IAVAL, JAVAL, MXVAL, NXVAL, MBXVAL,
     $                          NBXVAL, RSRCXVAL, CSRCXVAL, IXVAL,
     $                          JXVAL, INCXVAL, MYVAL, NYVAL, MBYVAL,
     $                          NBYVAL, RSRCYVAL, CSRCYVAL, IYVAL,
     $                          JYVAL, INCYVAL, LDVAL, NGRIDS, PVAL,
     $                          LDPVAL, QVAL, LDQVAL, LTEST, IAM,
     $                          NPROCS, ALPHA, BETA, WORK )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      CHARACTER*( * )    SUMMRY
      INTEGER            IAM, LDPVAL, LDQVAL, LDVAL, NGRIDS, NMAT, NOUT,
     $                   NPROCS
      REAL               ALPHA, BETA
*     ..
*     .. Array Arguments ..
      CHARACTER          DIAGVAL( LDVAL ), TRANSVAL( LDVAL ),
     $                   UPLOVAL( LDVAL )
      LOGICAL            LTEST( * )
      INTEGER            CSRCAVAL( LDVAL ), CSRCXVAL( LDVAL ),
     $                   CSRCYVAL( LDVAL ), IAVAL( LDVAL ),
     $                   INCXVAL( LDVAL ), INCYVAL( LDVAL ),
     $                   IXVAL( LDVAL ), IYVAL( LDVAL ), JAVAL( LDVAL ),
     $                   JXVAL( LDVAL ), JYVAL( LDVAL ), MVAL( LDVAL ),
     $                   MAVAL( LDVAL ), MBAVAL( LDVAL ),
     $                   MBXVAL( LDVAL ), MBYVAL( LDVAL ),
     $                   MXVAL( LDVAL ), MYVAL( LDVAL ), NAVAL( LDVAL ),
     $                   NBAVAL( LDVAL ), NBXVAL( LDVAL ),
     $                   NBYVAL( LDVAL ), NVAL( LDVAL ), NXVAL( LDVAL ),
     $                   NYVAL( LDVAL ), PVAL( LDPVAL ), QVAL( LDQVAL ),
     $                   RSRCAVAL( LDVAL ), RSRCXVAL( LDVAL ),
     $                   RSRCYVAL( LDVAL ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PSBLA2TIMINFO gets needed startup information for timing various
*  PBLAS 2 routines, and transmits it to all processes.
*
*  Arguments
*  =========
*
*  SUMMRY   (global output) CHARACTER*(*)
*           Name of output (summary) file (if any). Only defined for
*           process 0.
*
*  NOUT     (global output) INTEGER
*           The unit number for output file. NOUT = 6, ouput to screen,
*           NOUT = 0, output to stderr.  Only defined for process 0.
*
*  NMAT     (global output) INTEGER
*           The number of different test cases.
*
*  DIAGVAL  (global output) CHARACTER array, dimension (LDVAL)
*           The values of DIAG to run the code with.
*
*  TRANSVAL (global output) CHARACTER array, dimension (LDVAL)
*           The values of TRANS to run the code with.
*
*  UPLOVAL  (global output) CHARACTER array, dimension (LDVAL)
*           The values of UPLO to run the code with.
*
*  MVAL     (global output) INTEGER array, dimension (LDVAL)
*           The values of M to run the code with.
*
*  NVAL     (global output) INTEGER array, dimension (LDVAL)
*           The values of N to run the code with.
*
*  MAVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCA( M_ ) (number of rows in the
*           distributed matrix A) to run the code with.
*
*  NAVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCA( N_ ) (number of columns in
*           the distributed matrix A) to run the code with.
*
*  MBAVAL   (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCA( MB_ ) (row block sizes of the
*           distributed matrix A) to run the code with.
*
*  NBAVAL   (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCA( NB_ ) (column block sizes of
*           the distributed matrix A) to run the code with.
*
*  RSRCAVAL (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCA( RSRC_ ) (row process source of
*           the distributed matrix A) to run the code with.
*
*  CSRCAVAL (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCA( CSRC_ ) (column process source
*           of the distributed matrix A) to run the code with.
*
*  IAVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of IA (global row source index of the
*           matrix operand A) to run the code with.
*
*  JAVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of JA (global column source index of
*           the matrix operand A) to run the code with.
*
*  MXVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCX( M_ ) (number of rows in the
*           distributed matrix X) to run the code with.
*
*  NXVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCX( N_ ) (number of columns in
*           the distributed matrix X) to run the code with.
*
*  MBXVAL   (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCX( MB_ ) (row block sizes of the
*           distributed matrix X) to run the code with.
*
*  NBXVAL   (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCX( NB_ ) (column block sizes of
*           the distributed matrix X) to run the code with.
*
*  RSRCXVAL (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCX( RSRC_ ) (row process source of
*           the distributed matrix X) to run the code with.
*
*  CSRCXVAL (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCX( CSRC_ ) (column process source
*           of the distributed matrix X) to run the code with.
*
*  IXVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of IX (global row source index of the
*           vector operand X) to run the code with.
*
*  JXVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of JX (global column source index of
*           the vector operand X) to run the code with.
*
*  INCXVAL  (global output) INTEGER array, dimension (LDVAL)
*           The values of INCX (global increment of the vector
*           operand X(IX:,JX:) to run the code with.
*
*  MYVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCY( M_ ) (number of rows in the
*           distributed matrix Y) to run the code with.
*
*  NYVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCY( N_ ) (number of columns in
*           the distributed matrix Y) to run the code with.
*
*  MBYVAL   (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCY( MB_ ) (row block sizes of the
*           distributed matrix Y) to run the code with.
*
*  NBYVAL   (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCY( NB_ ) (column block sizes of
*           the distributed matrix Y) to run the code with.
*
*  RSRCYVAL (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCY( RSRC_ ) (row process source of
*           the distributed matrix Y) to run the code with.
*
*  CSRCYVAL (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCY( CSRC_ ) (column process source
*           of the distributed matrix Y) to run the code with.
*
*  IYVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of IY (global row source index of the
*           vector operand Y) to run the code with.
*
*  JYVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of JY (global column source index of
*           the vector operand Y) to run the code with.
*
*  INCYVAL  (global output) INTEGER array, dimension (LDVAL)
*           The values of INCY (global increment of the vector
*           operand Y(IY:,JY:) to run the code with.
*
*  LDVAL    (global output) INTEGER array, dimension (LDVAL)
*           The maximum number of different values that can be used for
*           DIAG, TRANS, UPLO, M, N, DESCA, IA, JA, DESCX, IX, JX, INCX,
*           DESCY, IY, JY, INCY. This is also the maximum number of
*           test cases.
*
*  NGRIDS   (global output) INTEGER
*           The number of different values that can be used for P & Q.
*
*  PVAL     (global output) INTEGER array, dimension (LDPVAL)
*           The values of P (number of process rows) to run the code
*           with.
*
*  LDPVAL   (global input) INTEGER
*           The maximum number of different values that can be used for
*           P, LDPVAL >= NGRIDS.
*
*  QVAL     (global output) INTEGER array, dimension (LDQVAL)
*           The values of Q (number of process columns) to run the code
*           with.
*
*  LDQVAL   (global input) INTEGER
*           The maximum number of different values that can be used for
*           Q, LDQVAL >= NGRIDS.
*
*  LTEST    (Global output) LOGICAL array, dimension (>= NSUBS = 7 )
*           If LTEST( i ) is .TRUE. on exit, the i-th PBLAS-2 routine
*           will be tested. See the input file for the ordering of the
*           routines.
*
*  IAM      (local input) INTEGER
*           My process number.
*
*  NPROCS   (global input) INTEGER
*           The total number of processes.
*
*  ALPHA    (global output) REAL
*           The value of ALPHA to be used in all the test cases.
*
*  BETA     (global output) REAL
*           The value of BETA to be used in all the test cases.
*
*  WORK     (local workspace) INTEGER array of dimension >=
*           MAX( 2, 2*NGRIDS+31*NMAT+NSUBS ) with NSUBS = 7. Used to
*           pack all input arrays in order to send info in one message.
*
* ======================================================================
*
* Note: For packing the information we assumed that the length in bytes
* ===== of an integer is equal to the length in bytes of a real single
*       precision.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            NIN, NSUBS
      PARAMETER          ( NIN = 11, NSUBS = 7 )
*     ..
*     .. Local Scalars ..
      CHARACTER*7        SNAMET
      CHARACTER*79       USRINFO
      LOGICAL            LTESTT
      INTEGER            I, ICTXT, J
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_ABORT, BLACS_GET, BLACS_GRIDEXIT,
     $                   BLACS_GRIDINIT, BLACS_SETUP, ICOPY, IGEBR2D,
     $                   IGEBS2D, SGEBR2D, SGEBS2D
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          CHAR, ICHAR, MAX, MIN
*     ..
*     .. Scalars in Common ..
      CHARACTER*7        SNAMES( NSUBS )
*     ..
*     .. Common blocks ..
      COMMON             /SNAMEC/SNAMES
*     ..
*     .. Executable Statements ..
*
*     Process 0 reads the input data, broadcasts to other processes and
*     writes needed information to NOUT
*
      IF( IAM.EQ.0 ) THEN
*
*        Open file and skip data file header
*
         OPEN( NIN, FILE='PSBLA2TIM.dat', STATUS='OLD' )
         READ( NIN, FMT = * ) SUMMRY
         SUMMRY = ' '
*
*        Read in user-supplied info about machine type, compiler, etc.
*
         READ( NIN, FMT = 9999 ) USRINFO
*
*        Read name and unit number for summary output file
*
         READ( NIN, FMT = * ) SUMMRY
         READ( NIN, FMT = * ) NOUT
         IF( NOUT.NE.0 .AND. NOUT.NE.6 )
     $      OPEN( NOUT, FILE = SUMMRY, STATUS = 'UNKNOWN' )
*
*        Read and check the parameter values for the tests.
*
*        Get number of grids
*
         READ( NIN, FMT = * ) NGRIDS
         IF( NGRIDS.LT.1 .OR. NGRIDS.GT.LDPVAL ) THEN
            WRITE( NOUT, FMT = 9998 ) 'Grids', LDPVAL
            GO TO 120
         ELSE IF( NGRIDS.GT.LDQVAL ) THEN
            WRITE( NOUT, FMT = 9998 ) 'Grids', LDQVAL
            GO TO 120
         END IF
*
*        Get values of P and Q
*
         READ( NIN, FMT = * ) ( PVAL( I ), I = 1, NGRIDS )
         READ( NIN, FMT = * ) ( QVAL( I ), I = 1, NGRIDS )
*
*        Read ALPHA, BETA
*
         READ( NIN, FMT = * ) ALPHA
         READ( NIN, FMT = * ) BETA
*
*        Read number of tests.
*
         READ( NIN, FMT = * ) NMAT
         IF( NMAT.LT.1 .OR. NMAT.GT.LDVAL ) THEN
            WRITE( NOUT, FMT = 9998 ) 'Tests', LDVAL
            GO TO 120
         ENDIF
*
*        Read in input data into arrays.
*
         READ( NIN, FMT = * ) ( UPLOVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( TRANSVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( DIAGVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( MVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( NVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( MAVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( NAVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( MBAVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( NBAVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( RSRCAVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( CSRCAVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( IAVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( JAVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( MXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( NXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( MBXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( NBXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( RSRCXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( CSRCXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( IXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( JXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( INCXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( MYVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( NYVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( MBYVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( NBYVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( RSRCYVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( CSRCYVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( IYVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( JYVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( INCYVAL( I ), I = 1, NMAT )
*
*        Read names of subroutines and flags which indicate
*        whether they are to be tested.
*
         DO 10 I = 1, NSUBS
            LTEST( I ) = .FALSE.
   10    CONTINUE
   20    CONTINUE
         READ( NIN, FMT = 9996, END = 50 ) SNAMET, LTESTT
         DO 30 I = 1, NSUBS
            IF( SNAMET.EQ.SNAMES( I ) )
     $         GO TO 40
   30    CONTINUE
*
         WRITE( NOUT, FMT = 9995 )SNAMET
         GO TO 120
*
   40    CONTINUE
         LTEST( I ) = LTESTT
         GO TO 20
*
   50    CONTINUE
*
*        Close input file
*
         CLOSE ( NIN )
*
*        For pvm only: if virtual machine not set up, allocate it and
*        spawn the correct number of processes.
*
         IF( NPROCS.LT.1 ) THEN
            NPROCS = 0
            DO 60 I = 1, NGRIDS
               NPROCS = MAX( NPROCS, PVAL( I )*QVAL( I ) )
   60       CONTINUE
            CALL BLACS_SETUP( IAM, NPROCS )
         END IF
*
*        Temporarily define blacs grid to include all processes so
*        information can be broadcast to all processes
*
         CALL BLACS_GET( -1, 0, ICTXT )
         CALL BLACS_GRIDINIT( ICTXT, 'Row-major', 1, NPROCS )
*
*        Pack information arrays and broadcast
*
         CALL SGEBS2D( ICTXT, 'All', ' ', 1, 1, ALPHA, 1 )
         CALL SGEBS2D( ICTXT, 'All', ' ', 1, 1, BETA, 1 )
*
         WORK( 1 ) = NGRIDS
         WORK( 2 ) = NMAT
         CALL IGEBS2D( ICTXT, 'All', ' ', 2, 1, WORK, 2 )
*
         I = 1
         DO 70 J = 1, NMAT
            WORK( I ) = ICHAR( DIAGVAL( J ) )
            WORK( I+1 ) = ICHAR( TRANSVAL( J ) )
            WORK( I+2 ) = ICHAR( UPLOVAL( J ) )
            I = I + 3
   70    CONTINUE
         CALL ICOPY( NGRIDS, PVAL, 1, WORK( I ), 1 )
         I = I + NGRIDS
         CALL ICOPY( NGRIDS, QVAL, 1, WORK( I ), 1 )
         I = I + NGRIDS
         CALL ICOPY( NMAT, MVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, NVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, MAVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, NAVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, MBAVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, NBAVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, RSRCAVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, CSRCAVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, IAVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, JAVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, MXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, NXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, MBXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, NBXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, RSRCXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, CSRCXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, IXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, JXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, INCXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, MYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, NYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, MBYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, NBYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, RSRCYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, CSRCYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, IYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, JYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, INCYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
*
         DO 80 J = 1, NSUBS
            IF( LTEST( J ) ) THEN
               WORK( I ) = 1
            ELSE
               WORK( I ) = 0
            END IF
            I = I + 1
   80    CONTINUE
         I = I - 1
         CALL IGEBS2D( ICTXT, 'All', ' ', I, 1, WORK, I )
*
*        regurgitate input
*
         WRITE( NOUT, FMT = 9999 )
     $               'ScaLAPACK Level-2 PBLAS timing program.'
         WRITE( NOUT, FMT = 9999 ) USRINFO
         WRITE( NOUT, FMT = * )
         WRITE( NOUT, FMT = 9999 )
     $               'Tests of the real single precision '//
     $               'Level-2 PBLAS'
         WRITE( NOUT, FMT = * )
         WRITE( NOUT, FMT = 9992 ) NMAT
         WRITE( NOUT, FMT = 9991 ) NGRIDS
         WRITE( NOUT, FMT = 9989 )
     $               'P', ( PVAL(I), I = 1, MIN(NGRIDS, 5) )
         IF( NGRIDS.GT.5 )
     $      WRITE( NOUT, FMT = 9990 ) ( PVAL(I), I = 6,
     $                                  MAX( 10, NGRIDS ) )
         IF( NGRIDS.GT.10 )
     $      WRITE( NOUT, FMT = 9990 ) ( PVAL(I), I = 11,
     $                                  MAX( 15, NGRIDS ) )
         IF( NGRIDS.GT.15 )
     $      WRITE( NOUT, FMT = 9990 ) ( PVAL(I), I = 16, NGRIDS )
         WRITE( NOUT, FMT = 9989 )
     $               'Q', ( QVAL(I), I = 1, MIN(NGRIDS, 5) )
         IF( NGRIDS.GT.5 )
     $      WRITE( NOUT, FMT = 9990 ) ( QVAL(I), I = 6,
     $                                  MAX( 10, NGRIDS ) )
         IF( NGRIDS.GT.10 )
     $      WRITE( NOUT, FMT = 9990 ) ( QVAL(I), I = 11,
     $                                  MAX( 15, NGRIDS ) )
         IF( NGRIDS.GT.15 )
     $      WRITE( NOUT, FMT = 9990 ) ( QVAL(I), I = 16, NGRIDS )
         WRITE( NOUT, FMT = 9994 ) ALPHA
         WRITE( NOUT, FMT = 9993 ) BETA
         IF( LTEST( 1 ) ) THEN
            WRITE( NOUT, FMT = 9988 ) SNAMES( 1 ), ' ... Yes'
         ELSE
            WRITE( NOUT, FMT = 9988 ) SNAMES( 1 ), ' ... No '
         END IF
         DO 90 I = 1, NSUBS
            IF( LTEST( I ) ) THEN
               WRITE( NOUT, FMT = 9987 ) SNAMES( I ), ' ... Yes'
            ELSE
               WRITE( NOUT, FMT = 9987 ) SNAMES( I ), ' ... No '
            END IF
   90    CONTINUE
         WRITE( NOUT, FMT = * )
*
      ELSE
*
*        If in pvm, must participate setting up virtual machine
*
         IF( NPROCS.LT.1 )
     $      CALL BLACS_SETUP( IAM, NPROCS )
*
*        Temporarily define blacs grid to include all processes so
*        information can be broadcast to all processes
*
         CALL BLACS_GET( -1, 0, ICTXT )
         CALL BLACS_GRIDINIT( ICTXT, 'Row-major', 1, NPROCS )
*
         CALL SGEBR2D( ICTXT, 'All', ' ', 1, 1, ALPHA, 1, 0, 0 )
         CALL SGEBR2D( ICTXT, 'All', ' ', 1, 1, BETA, 1, 0, 0 )
*
         CALL IGEBR2D( ICTXT, 'All', ' ', 2, 1, WORK, 2, 0, 0 )
         NGRIDS = WORK( 1 )
         NMAT   = WORK( 2 )
*
         I = 2*NGRIDS + 31*NMAT + NSUBS
         CALL IGEBR2D( ICTXT, 'All', ' ', I, 1, WORK, I, 0, 0 )
*
         I = 1
         DO 100 J = 1, NMAT
            DIAGVAL( J ) = CHAR( WORK( I ) )
            TRANSVAL( J ) = CHAR( WORK( I+1 ) )
            UPLOVAL( J ) = CHAR( WORK( I+2 ) )
            I = I + 3
  100    CONTINUE
         CALL ICOPY( NGRIDS, WORK( I ), 1, PVAL, 1 )
         I = I + NGRIDS
         CALL ICOPY( NGRIDS, WORK( I ), 1, QVAL, 1 )
         I = I + NGRIDS
         CALL ICOPY( NMAT, WORK( I ), 1, MVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, NVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, MAVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, NAVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, MBAVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, NBAVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, RSRCAVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, CSRCAVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, IAVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, JAVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, MXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, NXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, MBXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, NBXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, RSRCXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, CSRCXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, IXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, JXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, INCXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, MYVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, NYVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, MBYVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, NBYVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, RSRCYVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, CSRCYVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, IYVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, JYVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, INCYVAL, 1 )
         I = I + NMAT
*
         DO 110 J = 1, NSUBS
            IF( WORK( I ).EQ.1 ) THEN
               LTEST( J ) = .TRUE.
            ELSE
               LTEST( J ) = .FALSE.
            END IF
            I = I + 1
  110    CONTINUE
*
      END IF
*
      CALL BLACS_GRIDEXIT( ICTXT )
*
      RETURN
*
  120 WRITE( NOUT, FMT = 9997 )
      CLOSE( NIN )
      IF( NOUT.NE.6 .AND. NOUT.NE.0 )
     $   CLOSE( NOUT )
      CALL BLACS_ABORT( ICTXT, 1 )
*
      STOP
*
 9999 FORMAT( A )
 9998 FORMAT( ' Number of values of ',5A, ' is less than 1 or greater ',
     $        'than ', I2 )
 9997 FORMAT( ' Illegal input in file ',40A,'.  Aborting run.' )
 9996 FORMAT( A7, L2 )
 9995 FORMAT( '  Subprogram name ', A7, ' not recognized',
     $        /' ******* TESTS ABANDONED *******' )
 9994 FORMAT( 2X, 'Alpha                     : ', G16.6 )
 9993 FORMAT( 2X, 'Beta                      : ', G16.6 )
 9992 FORMAT( 2X, 'Number of Tests           : ', I6 )
 9991 FORMAT( 2X, 'Number of process grids   : ', I6 )
 9990 FORMAT( 2X, '                          : ', 5I6 )
 9989 FORMAT( 2X, A1, '                         : ', 5I6 )
 9988 FORMAT( 2X, 'Routines to be tested     :      ', A, A8 )
 9987 FORMAT( 2X, '                                 ', A, A8 )
*
*     End of PSBLA2TIMINFO
*
      END
